package com.ejianc.business.rent.enums;


import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum RentContractSyncTypeEnum {
    //合同
    租赁合同("租赁合同", "BT220303000000002"),
    //变更
    租赁合同变更("赁合同变更", "BT220303000000001"),
    //合同解除
    租赁合同解除("赁合同解除", "BTC220314000000001"),
    //合同冻结
    租赁合同冻结("租赁合同冻结", "BT220303000000003"),
    ;

    private final String name;
    private final String code;
    private static Map<String, RentContractSyncTypeEnum> enumMap = new HashMap();

    private RentContractSyncTypeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public static RentContractSyncTypeEnum getEnumByName(String billTypeName) {
        return (RentContractSyncTypeEnum)enumMap.get(billTypeName);
    }

    static {
        enumMap = (Map)EnumSet.allOf(RentContractSyncTypeEnum.class).stream().collect(Collectors.toMap(RentContractSyncTypeEnum::getName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
