package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.appearance.vo.PushAppearanceSubVO;
import com.ejianc.business.appearance.vo.PushAppearanceVO;
import com.ejianc.business.rent.bean.*;
import com.ejianc.business.rent.enums.EntranceRentFlagEnum;
import com.ejianc.business.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.rent.service.IRentAcceptanceService;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.service.IRentParameterDetailService;
import com.ejianc.business.rent.service.IRentParameterService;
import com.ejianc.business.rent.vo.EquipmentNewDateVO;
import com.ejianc.business.rent.vo.RentAcceptanceSubVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.util.*;

@Service("rentAcceptance")
public class RentAcceptanceBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IRentAcceptanceService rentAcceptanceService;
	@Autowired
	private IRentParameterService parameterService;
	private static final String BILL_TYPE_CODE = "BT220317000000015";//此处需要根据实际修改
	private final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/rentAcceptance/saveCheck";
	private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/rentAcceptance/deleteCheck";//未调整
	private final String OPERATE = "RENT-PROEQUIPMENT-ACCEPTANCE";
	@Autowired
	private IRentParameterDetailService parameterDetailService;
	@Autowired
	private IRentContractService contractService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IProSupplierApi proSupplierApi;
	@Autowired
	private IShareCooperateApi shareCooperateApi;
	@Autowired
	private IRentParameterDetailService rentParameterDetailService;
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		List<RentParameterEntity> parameterList = new ArrayList<>();
		RentAcceptanceEntity rentAcceptanceEntity = rentAcceptanceService.selectById(billId);
		List<RentAcceptanceSubEntity> acceptanceSubList = rentAcceptanceEntity.getRentAcceptanceSubList();
		RentContractEntity contractEntity = contractService.selectById(rentAcceptanceEntity.getContractId());

		for (RentAcceptanceSubEntity e : acceptanceSubList) {
			RentParameterEntity parameter = new RentParameterEntity();
			// 验收信息
			parameter.setContractId(rentAcceptanceEntity.getContractId());//合同id
			parameter.setContractName(rentAcceptanceEntity.getContractName()); // 合同名称
			parameter.setEngineeringId(rentAcceptanceEntity.getEngineeringId()); // 工程id
			parameter.setEngineeringName(rentAcceptanceEntity.getEngineeringName()); // 工程名称
			parameter.setSupplierId(rentAcceptanceEntity.getSupplierId()); // 供应商id
			parameter.setSupplierName(rentAcceptanceEntity.getSupplierName()); // 供应商名称
			parameter.setProjectId(rentAcceptanceEntity.getProjectId()); // 项目id
			parameter.setProjectCode(rentAcceptanceEntity.getProjectCode()); // 项目code
			parameter.setProjectName(rentAcceptanceEntity.getProjectName()); // 项目名称
			parameter.setAcceptanceId(rentAcceptanceEntity.getId()); // 验收单id
			parameter.setAcceptanceDate(rentAcceptanceEntity.getAcceptanceDate()); // 验收日期
			parameter.setSourceId(rentAcceptanceEntity.getId()); // 来源id
			// 合同信息
			parameter.setOrgId(contractEntity.getOrgId()); // 组织id
			parameter.setOrgName(contractEntity.getOrgName()); // 组织名称
			parameter.setParentOrgId(contractEntity.getParentOrgId());
			parameter.setParentOrgCode(contractEntity.getParentOrgCode());
			parameter.setParentOrgName(contractEntity.getParentOrgName());
			parameter.setRentHarborType(contractEntity.getRentHarborType().equals("内租") ? 1:2);
			// 设备信息
			parameter.setFactoryCode(e.getFactoryCode()); // 设备出厂编码
			parameter.setCategoryId(e.getCategoryId()); // 设备类别id
			parameter.setCategoryName(e.getCategoryName()); // 设备类别名称
			parameter.setSpec(e.getSpecs()); // 规格型号
			parameter.setUnitName(e.getUnitName()); // 计量单位

			parameter.setStartDate(rentAcceptanceEntity.getAcceptanceDate());

			parameter.setPlanIntoDate(e.getPlanIntoDate()); // 计划进厂日期
			parameter.setPlanOutDate(e.getPlanOutDate()); // 计划出厂日期
			parameter.setProductionManufactor(e.getProductionManufactor()); // 生产厂家
			parameter.setMemo(e.getMemo()); // 备注
			parameter.setEquipmentCode(e.getEquipmentCode()); // 设备编号
			parameter.setEquipmentId(e.getEquipmentId()); // 设备id
			parameter.setName(e.getName()); // 设备id
			parameter.setNum(e.getNum());
			parameter.setRentNum(e.getNum()); // 租赁数量
			parameter.setRentTypeId(e.getRentTypeId()); // 租赁方式id
			parameter.setRentTypeName(e.getRentTypeName()); // 租赁方式名称
			parameter.setAcceptanceDetailId(e.getId()); // 验收单明细id
			parameter.setEquipmentName(e.getName()); // 设备名称
			parameter.setPrice(e.getPrice()); // 有税单价
			parameter.setNotTaxPrice(e.getNotTaxPrice()); // 无税单价
			if(EntranceRentFlagEnum.是.getCode().equals(rentAcceptanceEntity.getEntranceRentFlag())){
				parameter.setMeterRentDate(e.getMeterRentDate()); // 计租日期
				parameter.setEquipmentState(RentEquipmentStateEnum.启用.getCode());
			}else {
				parameter.setMeterRentDate(null); // 计租日期
				parameter.setEquipmentState(RentEquipmentStateEnum.待启用.getCode());
			}
			parameter.setOperationDate(new Date()); // 操作日期
			parameter.setQuantitiesNum(e.getQuantitiesNum() == null ? BigDecimal.ZERO : e.getQuantitiesNum());
//			parameter.setEquipmentCost(); // 设备费用

			RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
			detailEntity.setEquipmentState(RentEquipmentStateEnum.启用.getCode());
			if(EntranceRentFlagEnum.是.getCode().equals(rentAcceptanceEntity.getEntranceRentFlag())){
				detailEntity.setOperationDate(e.getMeterRentDate());
			}else {
				detailEntity.setOperationDate(null);
			}
			detailEntity.setSourceId(rentAcceptanceEntity.getId());
			detailEntity.setSourceType(RentParameterTypeEnum.验收单.getCode());
			List<RentParameterDetailEntity> detailEntityList = new ArrayList<>();
			detailEntityList.add(detailEntity);

			parameter.setRentParameterDetailList(detailEntityList);
			parameterList.add(parameter);
		}
		logger.info("处理台账主表数据：{}", JSONObject.toJSONString(parameterList));
		parameterService.saveOrUpdateBatch(parameterList);
		List<RentParameterDetailEntity> addParameterDetailList = new ArrayList<>();
		for (RentParameterEntity entity : parameterList) {
			List<RentParameterDetailEntity> detailEntityList = entity.getRentParameterDetailList();
			for (RentParameterDetailEntity detailEntity : detailEntityList) {
				detailEntity.setParameterId(entity.getId());
			}
			addParameterDetailList.addAll(detailEntityList);
		}
		logger.info("处理台账子表数据：{}", JSONObject.toJSONString(addParameterDetailList));
		parameterDetailService.saveOrUpdateBatch(addParameterDetailList);

		//推送供方验收单处理
		rentAcceptanceEntity.setCheckState(1);
//		PushAppearanceVO supplierPushCheckVO = BeanMapper.map(rentAcceptanceEntity, PushAppearanceVO.class);
//		List<PushAppearanceSubVO> pushAppearanceSubVOList = BeanMapper.mapList(rentAcceptanceEntity.getRentAcceptanceSubList(),PushAppearanceSubVO.class);
//		supplierPushCheckVO.setRentAcceptanceDetailList(pushAppearanceSubVOList);
//		supplierPushCheckVO.setSourceId(rentAcceptanceEntity.getId());
//		List<PushAppearanceSubVO> checkDetailList = supplierPushCheckVO.getRentAcceptanceDetailList();
//		for (PushAppearanceSubVO supplierPushCheckDetailVO : checkDetailList){
//			supplierPushCheckDetailVO.setSourceId(rentAcceptanceEntity.getId());
//			supplierPushCheckDetailVO.setSourceDetailId(supplierPushCheckDetailVO.getId());
//			supplierPushCheckDetailVO.setId(null);
//		}
		//设置单据当前系统信息
//		CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
//		if (!ejcCloudSystemCode.isSuccess()) {
//			logger.error("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
//		}
//		else {
//			//设置当前系统ID
//			supplierPushCheckVO.setSystemId(ejcCloudSystemCode.getData());
//			String dataInfo = JSONObject.toJSONString(supplierPushCheckVO);
//			logger.info("dataInfo:"+dataInfo);
//			//查询该单据是否支持协同分享，则向供方协同服务推送该单据
//			CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
//			if (!cooperateResp.isSuccess()) {
//				logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", BILL_TYPE_CODE, cooperateResp.getMsg());
//			}
//			else {
//				boolean b = rentAcceptanceService.pushBillToSupCenter(dataInfo, rentAcceptanceEntity.getSupplierId(),
//						rentAcceptanceEntity.getId(), BILL_TYPE_CODE, cooperateResp.getData(), PUSH_SAVE_URL);
//				if (!b) {
//					logger.error("推送供方失败！单据信息：{}", dataInfo);
//				}
//				else {
//					rentAcceptanceEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
//				}
//			}
//		}

		rentAcceptanceService.updateById(rentAcceptanceEntity);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentAcceptanceEntity entity =rentAcceptanceService.selectById(billId);
////		EquipmentNewDateVO equipmentNewDateVO =parameterService.selectAbandonDate(entity.getContractId(),entity.getAcceptanceDate());
////		if(equipmentNewDateVO != null){
////			if(!entity.getId().equals(equipmentNewDateVO.getId())){
////				return CommonResponse.error("弃审失败:请先弃审设备" + equipmentNewDateVO.getType() + "单据在弃审本单据");
////			}
////		}


        QueryParam queryParamp = new QueryParam();
        queryParamp.getParams().put("sourceId", new Parameter(QueryParam.EQ, entity.getId()));
        queryParamp.getOrderMap().put("createTime", QueryParam.DESC);
        List<RentParameterEntity> parameterEntities = parameterService.queryList(queryParamp, false);
//		List<RentAcceptanceSubEntity> subEntityList = entity.getRentAcceptanceSubList();
        for(RentParameterEntity parameterEntity:parameterEntities) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("parameterId", new Parameter(QueryParam.EQ, parameterEntity.getId()));
            queryParam.getOrderMap().put("createTime", QueryParam.DESC);
            List<RentParameterDetailEntity> detailEntityList = rentParameterDetailService.queryList(queryParam, false);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailEntityList)) {
                RentParameterDetailEntity detailEntity = detailEntityList.get(0);
                if(detailEntityList.size()>1&&!billId.equals(detailEntity.getSourceId())){
                    return CommonResponse.error("弃审失败:该单据已存在下游单据或已做租金计算，请检查");
                }
            }
        }

//		if(BillPushStatusEnum.推送成功.getStatus().equals(entity.getBillPushFlag())){
//			//推送供方
//			//对单据进行加锁
//			CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
//			if (!ejcCloudSystemCode.isSuccess()) {
//				throw new BusinessException("获取当前系统编码失败！");
//			}
//			Map<String,Object> map = new HashMap<>();
//			map.put("sourceId",billId);
//			map.put("systemId",ejcCloudSystemCode.getData());
//			String dataInfo = JSONObject.toJSONString(map);
//			Boolean updateSupplierStatus = rentAcceptanceService.updateSupplierStatus(billId, dataInfo,PUSH_DELETE_URL,RequestMethod.POST,
//					entity.getSupplierId().toString(),OPERATE,BILL_TYPE_CODE);
//			if (!updateSupplierStatus){
//				throw new BusinessException("单据推送失败！");
//			}
//			entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
//			rentAcceptanceService.saveOrUpdate(entity,false);
//		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentAcceptanceEntity entity =rentAcceptanceService.selectById(billId);
		parameterService.deleteAcceptanceId(entity.getId());

		return CommonResponse.success();
	}

}
