package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.rent.bean.*;
import com.ejianc.business.rent.mapper.RentContractRecordMapper;
import com.ejianc.business.rent.mapper.RentContractRelieveMapper;
import com.ejianc.business.rent.service.*;
import com.ejianc.business.rent.vo.RentContractVO;
import com.ejianc.business.rent.vo.RentDayDetailedVO;
import com.ejianc.business.rent.vo.RentMonthDetailedVO;
import com.ejianc.business.rent.vo.RentQuantitiesDetailedVO;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.enums.RentTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 租赁合同解除
 * 
 * @author generator
 * 
 */
@Service("rentContractRelieveService")
public class RentContractRelieveServiceImpl extends BaseServiceImpl<RentContractRelieveMapper, RentContractRelieveEntity> implements IRentContractRelieveService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentSettlementService rentSettlementService;
    @Autowired
    private IRentSettlementRentalService rentSettlementRentalService;
    @Autowired
    private IRentSettlementDayService rentSettlementDayService;
    @Autowired
    private IRentSettlementMonthService rentSettlementMonthService;
    @Autowired
    private IRentSettlementQuantitiesService rentSettlementQuantitiesService;
    @Autowired
    private IRentContractService rentContractService;
    @Value("${common.env.base-host}")
    private String baseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private RentContractRelieveMapper relieveService;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IRentRentalDayService rentRentalDayService;
    @Autowired
    private IRentRentalMonthService rentRentalMonthService;
    @Autowired
    private IRentRentalQuantitiesService rentRentalQuantitiesService;
    /**
     * 转换目标成本VO
     * @param entity
     * @return
     */
    @Override
    public ExecutionVO targetCost(RentContractRelieveEntity entity) {
        // 计算所有结算累计结算金额
        LambdaQueryWrapper<RentSettlementEntity> wrapper = new LambdaQueryWrapper<RentSettlementEntity>();
        wrapper.eq(RentSettlementEntity::getContractId, entity.getContractId());
        wrapper.in(RentSettlementEntity::getBillState, Arrays.asList(1,3));
        List<RentSettlementEntity> settleList = rentSettlementService.list(wrapper);

        BigDecimal totalSettleTaxMny = settleList.stream().filter(e -> e.getSettlementTaxMny() != null).map(RentSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = settleList.stream().filter(e -> e.getSettlementMny() != null).map(RentSettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 查询合同
        RentContractEntity contractEntity = rentContractService.getById(entity.getContractId());

        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getCode());
        totalVO.setBillType("BTC220314000000001");
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.设备租赁合同.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setContractId(entity.getContractId());
        totalVO.setOrgId(entity.getCompanyId());
        totalVO.setMoney(ComputeUtil.safeSub(totalSettleMny, contractEntity.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub(totalSettleTaxMny, contractEntity.getContractTaxMny()));
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }
        totalVO.setLinkUrl(frontendBaseHost + "ejc-proequipment-frontend/#/leaseContractContractRelieveCard?id=" + entity.getId());

        executionVO.setTotalVO(totalVO);

        //子表赋值
        executionVO.setDetailList(numDetailExecution(contractEntity, settleList));
        logger.info("目标成本推送数据---设备租赁合同解除---->{}", JSONObject.toJSONString(executionVO));
        return executionVO;

    }

    private List<DetailExecutionVO> numDetailExecution(RentContractEntity contractEntity, List<RentSettlementEntity> list) {
        List<DetailExecutionVO> detailList = new ArrayList<>();
        Boolean dayDataFlag = CollectionUtils.isNotEmpty(contractEntity.getRentDayDetailedList()) ? true : false;
        Boolean monthDataFlag = CollectionUtils.isNotEmpty(contractEntity.getRentMonthDetailedList()) ? true : false;
        Boolean quantitiesDataFlag = CollectionUtils.isNotEmpty(contractEntity.getRentQuantitiesDetailedList()) ? true : false;

        //日租数据
        Map<Long, List<RentSettlementDayEntity>> settlementDayMap = new HashMap<>();
        Map<Long, List<RentRentalDayEntity>> rentalDayMap = new HashMap<>();
        //月租数据
        Map<Long, List<RentSettlementMonthEntity>> settlementMonthMap = new HashMap<>();
        Map<Long, List<RentRentalMonthEntity>> rentalMonthMap = new HashMap<>();
        //工程量租数据
        Map<Long, List<RentSettlementQuantitiesEntity>> settlementQuantitiesMap = new HashMap<>();
        Map<Long, List<RentRentalQuantitiesEntity>> rentalQuantitiesMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list)) {
            List<Long> settlementIdList = list.stream().map(RentSettlementEntity::getId).collect(Collectors.toList());

            // 结算单 -- 日租
            if (dayDataFlag){
                LambdaQueryWrapper<RentSettlementDayEntity> settlementDayQueryWrapper = new LambdaQueryWrapper<>();
                settlementDayQueryWrapper.in(RentSettlementDayEntity::getSettlementId, settlementIdList);
                List<RentSettlementDayEntity> settlementDayList = rentSettlementDayService.list(settlementDayQueryWrapper);
                //根据设备id汇总结算单日租金额
                if (CollectionUtils.isNotEmpty(settlementDayList)) {
                    settlementDayMap = settlementDayList.stream().filter(t -> null != t.getEquipmentId()).collect(Collectors.groupingBy(RentSettlementDayEntity::getEquipmentId));
                }
            }
            // 结算单 -- 月租
            if (monthDataFlag){
                LambdaQueryWrapper<RentSettlementMonthEntity> settlementMonthQueryWrapper = new LambdaQueryWrapper<>();
                settlementMonthQueryWrapper.in(RentSettlementMonthEntity::getSettlementId, settlementIdList);
                List<RentSettlementMonthEntity> settlementMonthList = rentSettlementMonthService.list(settlementMonthQueryWrapper);
                //根据设备id汇总结算单月租金额
                if (CollectionUtils.isNotEmpty(settlementMonthList)) {
                    settlementMonthMap = settlementMonthList.stream().filter(t -> null != t.getEquipmentId()).collect(Collectors.groupingBy(RentSettlementMonthEntity::getEquipmentId));
                }
            }
            // 结算单 -- 工程量租
            if (quantitiesDataFlag){
                LambdaQueryWrapper<RentSettlementQuantitiesEntity> settlementQuantitiesQueryWrapper = new LambdaQueryWrapper<>();
                settlementQuantitiesQueryWrapper.in(RentSettlementQuantitiesEntity::getSettlementId, settlementIdList);
                List<RentSettlementQuantitiesEntity> settlementQuantitiesList = rentSettlementQuantitiesService.list(settlementQuantitiesQueryWrapper);
                //根据设备id汇总结算单工程量租金额
                if (CollectionUtils.isNotEmpty(settlementQuantitiesList)) {
                    settlementQuantitiesMap = settlementQuantitiesList.stream().filter(t -> null != t.getEquipmentId()).collect(Collectors.groupingBy(RentSettlementQuantitiesEntity::getEquipmentId));
                }
            }

            //根据结算单查询 租金计算
            LambdaQueryWrapper<RentSettlementRentalEntity> rentSettlementRentalQueryWrapper = new LambdaQueryWrapper<>();
            rentSettlementRentalQueryWrapper.in(RentSettlementRentalEntity::getSettlementId, settlementIdList);
            List<RentSettlementRentalEntity> rentSettlementRentalList = rentSettlementRentalService.list(rentSettlementRentalQueryWrapper);
            if (CollectionUtils.isNotEmpty(rentSettlementRentalList)) {
                // 租金计算 -- 日租
                if (dayDataFlag){
                    LambdaQueryWrapper<RentRentalDayEntity> rentRentalDayWrapper = new LambdaQueryWrapper<>();
                    rentRentalDayWrapper.in(RentRentalDayEntity::getRentalId, rentSettlementRentalList.stream().map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList()));
                    List<RentRentalDayEntity> rentRentalDayList = rentRentalDayService.list(rentRentalDayWrapper);
                    //根据设备id汇总租金计算单日租的金额
                    if (CollectionUtils.isNotEmpty(rentRentalDayList)) {
                        rentalDayMap = rentRentalDayList.stream().filter(t -> t.getEquipmentId() != null).collect(Collectors.groupingBy(RentRentalDayEntity::getEquipmentId));
                    }
                }
                // 租金计算 -- 月租
                if (monthDataFlag){
                    LambdaQueryWrapper<RentRentalMonthEntity> rentRentalMonthWrapper = new LambdaQueryWrapper<>();
                    rentRentalMonthWrapper.in(RentRentalMonthEntity::getRentalId, rentSettlementRentalList.stream().map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList()));
                    List<RentRentalMonthEntity> rentRentalMonthList = rentRentalMonthService.list(rentRentalMonthWrapper);
                    //根据设备id汇总租金计算单月租的金额
                    if (CollectionUtils.isNotEmpty(rentRentalMonthList)) {
                        rentalMonthMap = rentRentalMonthList.stream().filter(t -> t.getEquipmentId() != null).collect(Collectors.groupingBy(RentRentalMonthEntity::getEquipmentId));
                    }
                }
                // 租金计算 -- 工程量租
                if (quantitiesDataFlag){
                    LambdaQueryWrapper<RentRentalQuantitiesEntity> rentRentalQuantitiesWrapper = new LambdaQueryWrapper<>();
                    rentRentalQuantitiesWrapper.in(RentRentalQuantitiesEntity::getRentalId, rentSettlementRentalList.stream().map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList()));
                    List<RentRentalQuantitiesEntity> rentRentalQuantitiesList = rentRentalQuantitiesService.list(rentRentalQuantitiesWrapper);
                    //根据设备id汇总租金计算单工程量的金额
                    if (CollectionUtils.isNotEmpty(rentRentalQuantitiesList)) {
                        rentalQuantitiesMap = rentRentalQuantitiesList.stream().filter(t -> t.getEquipmentId() != null).collect(Collectors.groupingBy(RentRentalQuantitiesEntity::getEquipmentId));
                    }
                }
            }
        }

        BigDecimal sumMny;
        BigDecimal sumTaxMny;
        BigDecimal quantitiesNum;
        //合同日租
        if (CollectionUtils.isNotEmpty(contractEntity.getRentDayDetailedList())) {
            for (RentDayDetailedEntity rentDayDetailedEntity : contractEntity.getRentDayDetailedList()) {
                sumMny = BigDecimal.ZERO;
                sumTaxMny = BigDecimal.ZERO;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                //来源
                detailExecutionVO.setSourceId(rentDayDetailedEntity.getId());
                detailExecutionVO.setSourceBillId(rentDayDetailedEntity.getPid());
                detailExecutionVO.setContractId(contractEntity.getId());

                //设备分类
                detailExecutionVO.setCategoryId(rentDayDetailedEntity.getCategoryId());
                detailExecutionVO.setCategoryName(rentDayDetailedEntity.getCategoryName());

                //设备档案
                detailExecutionVO.setCategoryFlag(false);
                detailExecutionVO.setDocId(rentDayDetailedEntity.getEquipmentId());
                detailExecutionVO.setCode(rentDayDetailedEntity.getEquipmentCode());
                detailExecutionVO.setName(rentDayDetailedEntity.getName());

                detailExecutionVO.setCategoryContainFlag(false);
                detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());
                //单位
                detailExecutionVO.setUnitName(rentDayDetailedEntity.getUnitName());
                //规格
                detailExecutionVO.setSpec(rentDayDetailedEntity.getSpec());
                //月租单价
                detailExecutionVO.setPrice(rentDayDetailedEntity.getDayRentPrice());
                detailExecutionVO.setTaxPrice(rentDayDetailedEntity.getDayRentNotTaxPrice());
                //数量
                detailExecutionVO.setNum(new BigDecimal(rentDayDetailedEntity.getRentNum()));

                //本期结算金额
                //结算日租金额汇总
                if (settlementDayMap.containsKey(rentDayDetailedEntity.getEquipmentId())) {
                    sumMny = settlementDayMap.get(rentDayDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getDayMny()).map(RentSettlementDayEntity::getDayMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = settlementDayMap.get(rentDayDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getDayTaxMny()).map(RentSettlementDayEntity::getDayTaxMny).reduce(sumTaxMny, BigDecimal::add);
                }
                //租金计算日租金额汇总
                if (rentalDayMap.containsKey(rentDayDetailedEntity.getEquipmentId())) {
                    sumMny = rentalDayMap.get(rentDayDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getRentDayMny()).map(RentRentalDayEntity::getRentDayMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = rentalDayMap.get(rentDayDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getRentDayTaxMny()).map(RentRentalDayEntity::getRentDayTaxMny).reduce(sumTaxMny, BigDecimal::add);
                }
                detailExecutionVO.setMoney(ComputeUtil.safeSub(sumMny, rentDayDetailedEntity.getRentMny()));
                detailExecutionVO.setTaxMoney(ComputeUtil.safeSub(sumTaxMny, rentDayDetailedEntity.getRentTaxMny()));

                detailList.add(detailExecutionVO);
            }
        }
        //合同月租
        if (CollectionUtils.isNotEmpty(contractEntity.getRentMonthDetailedList())) {
            for (RentMonthDetailedEntity rentMonthDetailedEntity : contractEntity.getRentMonthDetailedList()) {
                sumMny = BigDecimal.ZERO;
                sumTaxMny = BigDecimal.ZERO;

                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                //来源
                detailExecutionVO.setSourceId(rentMonthDetailedEntity.getId());
                detailExecutionVO.setSourceBillId(rentMonthDetailedEntity.getPid());
                detailExecutionVO.setContractId(contractEntity.getId());

                //设备分类
                detailExecutionVO.setCategoryId(rentMonthDetailedEntity.getCategoryId());
                detailExecutionVO.setCategoryName(rentMonthDetailedEntity.getCategoryName());

                //设备档案
                detailExecutionVO.setCategoryFlag(false);
                detailExecutionVO.setDocId(rentMonthDetailedEntity.getEquipmentId());
                detailExecutionVO.setCode(rentMonthDetailedEntity.getEquipmentCode());
                detailExecutionVO.setName(rentMonthDetailedEntity.getName());

                detailExecutionVO.setCategoryContainFlag(false);
                detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());
                //单位
                detailExecutionVO.setUnitName(rentMonthDetailedEntity.getUnitName());
                //规格
                detailExecutionVO.setSpec(rentMonthDetailedEntity.getSpec());
                //月租单价
                detailExecutionVO.setPrice(rentMonthDetailedEntity.getMonthRentPrice());
                detailExecutionVO.setTaxPrice(rentMonthDetailedEntity.getMonthRentNotTaxPrice());
                //数量
                detailExecutionVO.setNum(new BigDecimal(rentMonthDetailedEntity.getRentNum()));
                //本期结算金额
                //结算月租金额汇总
                if (settlementMonthMap.containsKey(rentMonthDetailedEntity.getEquipmentId())) {
                    sumMny = settlementMonthMap.get(rentMonthDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getMonthMny()).map(RentSettlementMonthEntity::getMonthMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = settlementMonthMap.get(rentMonthDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getMonthTaxMny()).map(RentSettlementMonthEntity::getMonthTaxMny).reduce(sumTaxMny, BigDecimal::add);
                }
                //租金计算月租金额汇总
                if (rentalMonthMap.containsKey(rentMonthDetailedEntity.getEquipmentId())) {
                    sumMny = rentalMonthMap.get(rentMonthDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getRentMonthMny()).map(RentRentalMonthEntity::getRentMonthMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = rentalMonthMap.get(rentMonthDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getRentMonthTaxMny()).map(RentRentalMonthEntity::getRentMonthTaxMny).reduce(sumTaxMny, BigDecimal::add);
                }
                detailExecutionVO.setMoney(ComputeUtil.safeSub(sumMny, rentMonthDetailedEntity.getRentMny()));
                detailExecutionVO.setTaxMoney(ComputeUtil.safeSub(sumTaxMny, rentMonthDetailedEntity.getRentTaxMny()));

                detailList.add(detailExecutionVO);
            }
        }
        //合同工程量租
        if (CollectionUtils.isNotEmpty(contractEntity.getRentQuantitiesDetailedList())) {
            for (RentQuantitiesDetailedEntity rentQuantitiesDetailedEntity : contractEntity.getRentQuantitiesDetailedList()) {
                sumMny = BigDecimal.ZERO;
                sumTaxMny = BigDecimal.ZERO;
                quantitiesNum = BigDecimal.ZERO;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                //来源
                detailExecutionVO.setSourceId(rentQuantitiesDetailedEntity.getId());
                detailExecutionVO.setSourceBillId(rentQuantitiesDetailedEntity.getPid());
                detailExecutionVO.setContractId(contractEntity.getId());

                //设备分类
                detailExecutionVO.setCategoryId(rentQuantitiesDetailedEntity.getCategoryId());
                detailExecutionVO.setCategoryName(rentQuantitiesDetailedEntity.getCategoryName());

                //设备档案
                detailExecutionVO.setCategoryFlag(false);
                detailExecutionVO.setDocId(rentQuantitiesDetailedEntity.getEquipmentId());
                detailExecutionVO.setCode(rentQuantitiesDetailedEntity.getEquipmentCode());
                detailExecutionVO.setName(rentQuantitiesDetailedEntity.getName());

                detailExecutionVO.setCategoryContainFlag(false);
                detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());
                //单位
                detailExecutionVO.setUnitName(rentQuantitiesDetailedEntity.getUnitName());
                //规格
                detailExecutionVO.setSpec(rentQuantitiesDetailedEntity.getSpec());
                //月租单价
                detailExecutionVO.setPrice(rentQuantitiesDetailedEntity.getQuantitiesPrice());
                detailExecutionVO.setTaxPrice(rentQuantitiesDetailedEntity.getNotTaxQuantitiesPrice());
                //数量
                detailExecutionVO.setNum(new BigDecimal(rentQuantitiesDetailedEntity.getRentNum()));
                //本期结算金额
                //结算工程量租金额汇总
                if (settlementQuantitiesMap.containsKey(rentQuantitiesDetailedEntity.getEquipmentId())) {
                    sumMny = settlementQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getQuantitiesMny()).map(RentSettlementQuantitiesEntity::getQuantitiesMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = settlementQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getQuantitiesTaxMny()).map(RentSettlementQuantitiesEntity::getQuantitiesTaxMny).reduce(sumTaxMny, BigDecimal::add);
                    quantitiesNum = settlementQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getQuantitiesNum()).map(RentSettlementQuantitiesEntity::getQuantitiesNum).reduce(quantitiesNum, BigDecimal::add);
                }
                //租金计算工程量租金额汇总
                if (rentalQuantitiesMap.containsKey(rentQuantitiesDetailedEntity.getEquipmentId())) {
                    sumMny = rentalQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getRentQuantitiesMny()).map(RentRentalQuantitiesEntity::getRentQuantitiesMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = rentalQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getRentQuantitiesTaxMny()).map(RentRentalQuantitiesEntity::getRentQuantitiesTaxMny).reduce(sumTaxMny, BigDecimal::add);
                    quantitiesNum = rentalQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getQuantitiesNum()).map(RentRentalQuantitiesEntity::getQuantitiesNum).reduce(quantitiesNum, BigDecimal::add);
                }
                detailExecutionVO.setMoney(ComputeUtil.safeSub(sumMny, rentQuantitiesDetailedEntity.getRentMny()));
                detailExecutionVO.setTaxMoney(ComputeUtil.safeSub(sumTaxMny, rentQuantitiesDetailedEntity.getRentTaxMny()));
                //工程量
                detailExecutionVO.setQuantityNum(ComputeUtil.safeSub(quantitiesNum, rentQuantitiesDetailedEntity.getQuantitiesNum()));

                detailList.add(detailExecutionVO);
            }
        }

        //设备分类编码信息赋值
        //根据分类ID查询物料分类信息
        if (CollectionUtils.isNotEmpty(detailList)){
            List<Long> categoryIdList = detailList.stream().map(DetailExecutionVO::getCategoryId).collect(Collectors.toList());
            List<MaterialCategoryVO> categoryVOList = materialApi.queryCategoryListByIds(categoryIdList).getData();
            if (CollectionUtils.isNotEmpty(categoryVOList)){
                Map<Long, MaterialCategoryVO> categoryMap = categoryVOList.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
                for (DetailExecutionVO detailExecutionVO : detailList) {
                    if (null != categoryMap.get(detailExecutionVO.getCategoryId())){
                        detailExecutionVO.setCategoryInnerCode(categoryMap.get(detailExecutionVO.getCategoryId()).getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryMap.get(detailExecutionVO.getCategoryId()).getCode());
                    }
                }
            }
        }
        return detailList;
    }


    @Override
    public void delById(Long id) {
        relieveService.delById(id);
    }
}
