package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.ac.enums.PerformanceStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.rent.bean.*;
import com.ejianc.business.rent.mapper.RentSettlementMapper;
import com.ejianc.business.rent.service.*;
import com.ejianc.business.rent.vo.*;
import com.ejianc.business.settle.vo.CostPriceApiVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.enums.RentTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.business.temporary.userecord.bean.TemporaryUseRecordSubEntity;
import com.ejianc.business.temporary.userecord.service.ITemporaryUseRecordSubService;
import com.ejianc.business.utils.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 设备租赁结算主表
 * 
 * @author generator
 * 
 */
@Service("rentSettlementService")
public class RentSettlementServiceImpl extends BaseServiceImpl<RentSettlementMapper, RentSettlementEntity> implements IRentSettlementService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDutyApi dutyApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    //参数控制
    private static final String CHECK_PARAM_CODE_GC = "P-5kO0W220";//合同金额控结算金额-过程
    private static final String CHECK_PARAM_CODE_ZZ = "P-Zez9060156";//合同金额控结算金额-最终
    private static final String PRICE_PARAM_CODE = "P-3lt4470215";//目标价格控制
    @Autowired
    private IOrgApi iOrgApi;


    private static final String BILL_CODE = "RENT_SETTLE";//此处需要根据实际修改

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRentContractService rentContractService;//租赁合同
    @Autowired
    private IRentRentalService rentRentalService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ITemporaryUseRecordSubService temporaryUseRecordSubService;//临时使用记录明细
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IRentSettlementFragmentaryService rentSettlementFragmentaryService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Value("${common.env.base-host}")
    private String baseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private RentSettlementMapper rentSettlementMapper;
    @Autowired
    private IRentSettlementRentalService rentSettlementRentalService;
    @Autowired
    private IRentSettlementDayService rentSettlementDayService;
    @Autowired
    private IRentSettlementMonthService rentSettlementMonthService;
    @Autowired
    private IRentSettlementQuantitiesService rentSettlementQuantitiesService;
    @Autowired
    private IRentRentalDayService rentRentalDayService;
    @Autowired
    private IRentRentalMonthService rentRentalMonthService;
    @Autowired
    private IRentRentalQuantitiesService rentRentalQuantitiesService;


    private final String  OPERATE= "RENT_SETTLE_JS";

    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/rentSettlement/saveRentSettlement";
    private final String DEL_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/rentSettlement/deleteRentSettlement";
    private static final String BILL_TYPE = "EJCBT202204000006";
    private String getBaseHost(){
        return StringUtils.isNotBlank(BASE_HOST_FRONTEND) && !("null").equals(BASE_HOST_FRONTEND) ? BASE_HOST_FRONTEND : baseHost;
    }

    @Override
    public RentSettlementVO saveOrUpdate(RentSettlementVO saveOrUpdateVO) {
        RentSettlementEntity entity = BeanMapper.map(saveOrUpdateVO, RentSettlementEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setRelationFlag("0");//关联状态初始化
            entity.setProportionFlag("0");//分摊状态初始化
            //保存初始化签章，签字状态
            entity.setSignStatus(0);
            entity.setSignatureStatus(0);
            entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        }
        if (null!=entity.getContractId() && this.queryExist(entity.getContractId(),entity.getId())){
            throw new BusinessException("该合同下有未生效的结算单！");
        }
        List<RentSettlementFragmentaryEntity> rentSettlementFragmentaryList = entity.getRentSettlementFragmentaryList();
        if(CollectionUtils.isNotEmpty(rentSettlementFragmentaryList)){
            List<Long> addLong = new ArrayList<>();//引用id
            List<Long> delLong = new ArrayList<>();//释放id
            for (RentSettlementFragmentaryEntity fragmentaryEntity : rentSettlementFragmentaryList) {
                if("del".equals(fragmentaryEntity.getRowState())){
                    delLong.add(fragmentaryEntity.getSourceId());
                }else {
                    addLong.add(fragmentaryEntity.getSourceId());
                }
            }
            updateSettleFlag(addLong,true);
            updateSettleFlag(delLong,false);
        }
        super.saveOrUpdate(entity, false);
        //推送目标成本
        this.pushSettlementTargetCost(entity.getId());

        //推送实际成本
        saveCost(entity,0);
        RentSettlementVO vo = BeanMapper.map(entity, RentSettlementVO.class);
        return vo;
    }
    public void updateSettleFlag( List<Long> ids,Boolean flag){
        if(CollectionUtils.isEmpty(ids)){
            return;
        }
        LambdaQueryWrapper<TemporaryUseRecordSubEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(TemporaryUseRecordSubEntity::getPid,ids);
        List<TemporaryUseRecordSubEntity> list = temporaryUseRecordSubService.list(wrapper);
        List<Long> collect = list.stream().map(item -> item.getId()).collect(Collectors.toList());
        if(flag){
            logger.info("结算--临时记录id--{}",JSONObject.toJSONString(ids));
            temporaryUseRecordSubService.updateSettleFlag(collect,1); //是否被结算(0-否，1-是)
        }else {
            logger.info("释放--临时记录id--{}",JSONObject.toJSONString(ids));
            temporaryUseRecordSubService.updateSettleFlag(collect,0); //是否被结算(0-否，1-是)
        }

    }
//删除
    @Override
    public void delete(List<Long> settleIds) {
        LambdaQueryWrapper<RentSettlementFragmentaryEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(RentSettlementFragmentaryEntity::getSettlementId,settleIds);
        List<RentSettlementFragmentaryEntity> list = rentSettlementFragmentaryService.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            List<Long> delIds = list.stream().map(RentSettlementFragmentaryEntity::getSourceId).collect(Collectors.toList());
            updateSettleFlag(delIds,false);
        }
        super.removeByIds(settleIds,false);
    }

    @Override
    public void delById(Long id) {
        Boolean flag = rentSettlementMapper.delById(id);
        if (Boolean.FALSE.equals(flag)) {
            throw new BusinessException("删除失败!");
        }
    }

    @Override
    public CommonResponse<String> pushSettlementTargetCost(Long id) {
        RentSettlementEntity entity = selectById(id);
        logger.info("推送目标成本开始");
        CommonResponse<String> response = executionApi.aggPush(this.settlementTargetCost(entity, true));
        if (!response.isSuccess()){
            logger.error("推送目标成本失败: , {}", response.getMsg());
            throw new BusinessException(response.getMsg());
        }
        return CommonResponse.success("目标成本推送成功");
    }

    @Override
    public ParamsCheckVO costPriceParams(CostPriceApiVO materialPriceHistoryApiVO,String priceParam,String nodeName) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        List<CostPriceApiVO> detailList = materialPriceHistoryApiVO.getCostPriceApiVOList();
        Long orgId = materialPriceHistoryApiVO.getOrgId();

        if(null==orgId){
            logger.info("orgId为空");
            return paramsCheckVO;
        }

//        String name  = MaterialCostPriceCheckTypeEnum.getEnumByCode(priceCheckType).getDescription();

        //查询比例
        logger.info("priceParam"+priceParam);
        logger.info("nodeName"+nodeName);
        CommonResponse<List<BillParamVO>> maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(priceParam,orgId);
        if(!maxParamByCode.isSuccess() && null == maxParamByCode.getData()){
            logger.info(maxParamByCode.getMsg());
            return paramsCheckVO;
        }
        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        List<Long> materialIds = detailList.stream().map(CostPriceApiVO::getMaterialId).collect(Collectors.toList());

        //获取目标成本价格
        CommonResponse<Map<Long, BigDecimal>> dutyRes = dutyApi.queryPriceByRentDocIds(materialPriceHistoryApiVO.getProjectId(),DocTypeEnum.设备档案.getCode(),materialIds);
        if(null==dutyRes){
            logger.info("获取目标成本价格为空");
            return paramsCheckVO;
        }
        Map<Long, BigDecimal> dutyMap = dutyRes.getData();
        if(null==dutyMap){
            logger.info("获取目标成本价格map为空");
            return paramsCheckVO;
        }
        if(CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOCost = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOCost.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                for (CostPriceApiVO detailVO: detailList) {//遍历明细
                    BigDecimal maxPrice = dutyMap.get(detailVO.getMaterialId())==null?BigDecimal.ZERO:dutyMap.get(detailVO.getMaterialId()).setScale(4, BigDecimal.ROUND_HALF_UP);//获取目标成本价格
                    BigDecimal price = detailVO.getPrice()==null?BigDecimal.ZERO:detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//物资单价
                    BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                    logger.info("测试数据:maxPrice"+maxPrice);
                    logger.info("测试数据:price"+price);
                    logger.info("测试数据:roleValueMax"+roleValueMax);
                    logger.info("测试数据:maxPriceParam"+maxPriceParam);
                    logger.info("测试数据:maxPriceParam"+maxPriceParam);
                    if (price.compareTo(maxPriceParam) >0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                        paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                        paramsCheckDsVO.setWarnName(nodeName+"单价大于目标成本单价");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(nodeName+"单价：").append(price)
                                .append("，目标成本单价:(").append(maxPrice)
                                .append("),目标成本单价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                .append("，超出：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOSMax.add(paramsCheckDsVO);
                    }
                }
                paramsCheckVOCost.setDataSource(checkDsVOSMax);
                paramsCheckVOS.add(paramsCheckVOCost);
            }
        }
        /*添加参数控制区域---*/
        String[] paramsArr = {"alert", "warn", "none"};
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArr) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else{
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    @Override
    public ExecutionVO settlementTargetCost(RentSettlementEntity entity, boolean detailListFlag) {
        List<DetailExecutionVO> detailList = new ArrayList<>();
        ExecutionVO executionVO = new ExecutionVO();
        //主表赋值
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getBillCode());
        totalVO.setBussinessType(BussinessTypeEnum.设备租赁结算单.getCode());
        totalVO.setBillCategory(BillCategoryEnum.结算.getCode());
        totalVO.setContractId(entity.getContractId());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        totalVO.setMoney(entity.getSettlementMny());
        totalVO.setTaxMoney(entity.getSettlementTaxMny());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setLinkUrl(getBaseHost() + "ejc-proequipment-frontend/#/rentSettleList/rentSettleCard?id=" + entity.getId());
        executionVO.setTotalVO(totalVO);

        if (detailListFlag){
            //获取租金计算子表
            List<RentSettlementRentalEntity> rentSettlementRentalList = entity.getRentSettlementRentalList();
            if (CollectionUtils.isNotEmpty(rentSettlementRentalList)){
                List<Long> rentalIdList = rentSettlementRentalList.stream().map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList());
                for (Long rentalId : rentalIdList) {
                    RentRentalEntity rentRentalEntity = rentRentalService.selectById(rentalId);
                    //租金计算日租
                    List<RentRentalDayEntity> rentalDayList = rentRentalEntity.getRentRentalDayList();
                    if (CollectionUtils.isNotEmpty(rentalDayList)){
                        for (RentRentalDayEntity rentRentalDayEntity : rentalDayList) {
                            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                            //来源
                            detailExecutionVO.setSourceId(rentRentalDayEntity.getId() == null ? IdWorker.getId() :rentRentalDayEntity.getId());
                            detailExecutionVO.setSourceBillId(entity.getId());
                            //分类
                            detailExecutionVO.setCategoryId(rentRentalDayEntity.getCategoryId());
                            detailExecutionVO.setCategoryName(rentRentalDayEntity.getCategoryName());
                            //设备档案
                            detailExecutionVO.setCategoryFlag(false);
                            detailExecutionVO.setDocId(rentRentalDayEntity.getEquipmentId());
                            detailExecutionVO.setCode(rentRentalDayEntity.getEquipmentCode());
                            detailExecutionVO.setName(rentRentalDayEntity.getEquipmentName());

                            detailExecutionVO.setCategoryContainFlag(false);
                            detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());

                            //单位
                            detailExecutionVO.setUnitName(rentRentalDayEntity.getUnitName());

                            detailExecutionVO.setNum(new BigDecimal(rentRentalDayEntity.getRentNum()));
                            detailExecutionVO.setSpec(rentRentalDayEntity.getSpec());
                            detailExecutionVO.setMoney(rentRentalDayEntity.getRentDayMny());
                            detailExecutionVO.setTaxMoney(rentRentalDayEntity.getRentDayTaxMny());
                            detailExecutionVO.setPrice(rentRentalDayEntity.getDayRentNotTaxPrice());
                            detailExecutionVO.setTaxPrice(rentRentalDayEntity.getDayRentPrice());
                            detailExecutionVO.setTaxRate(rentRentalDayEntity.getTax());

                            detailExecutionVO.setContractId(entity.getContractId());
                            detailExecutionVO.setRentType(RentTypeEnum.日租.getCode());
                            detailList.add(detailExecutionVO);
                        }
                    }
                    //租金计算月租
                    List<RentRentalMonthEntity> rentalMonthList = rentRentalEntity.getRentRentalMonthList();
                    if (CollectionUtils.isNotEmpty(rentalMonthList)){
                        for (RentRentalMonthEntity rentRentalMonthEntity : rentalMonthList) {
                            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                            //来源
                            detailExecutionVO.setSourceId(rentRentalMonthEntity.getId() == null ? IdWorker.getId() :rentRentalMonthEntity.getId());
                            detailExecutionVO.setSourceBillId(entity.getId());
                            //分类
                            detailExecutionVO.setCategoryId(rentRentalMonthEntity.getCategoryId());
                            detailExecutionVO.setCategoryName(rentRentalMonthEntity.getCategoryName());
                            //设备档案
                            detailExecutionVO.setCategoryFlag(false);
                            detailExecutionVO.setDocId(rentRentalMonthEntity.getEquipmentId());
                            detailExecutionVO.setCode(rentRentalMonthEntity.getEquipmentCode());
                            detailExecutionVO.setName(rentRentalMonthEntity.getEquipmentName());

                            detailExecutionVO.setCategoryContainFlag(false);
                            detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());

                            //单位
                            detailExecutionVO.setUnitName(rentRentalMonthEntity.getUnitName());

                            detailExecutionVO.setNum(new BigDecimal(rentRentalMonthEntity.getRentNum()));
                            detailExecutionVO.setSpec(rentRentalMonthEntity.getSpec());
                            detailExecutionVO.setMoney(rentRentalMonthEntity.getRentMonthMny());
                            detailExecutionVO.setTaxMoney(rentRentalMonthEntity.getRentMonthTaxMny());
                            detailExecutionVO.setPrice(rentRentalMonthEntity.getMonthRentNotTaxPrice());
                            detailExecutionVO.setTaxPrice(rentRentalMonthEntity.getMonthRentPrice());
                            detailExecutionVO.setTaxRate(rentRentalMonthEntity.getTax());

                            detailExecutionVO.setContractId(entity.getContractId());
                            detailExecutionVO.setRentType(RentTypeEnum.月租.getCode());
                            detailList.add(detailExecutionVO);
                        }
                    }
                    //租金计算工程量租
                    List<RentRentalQuantitiesEntity> rentalQuantitiesList = rentRentalEntity.getRentRentalQuantitiesList();
                    if (CollectionUtils.isNotEmpty(rentalQuantitiesList)){
                        for (RentRentalQuantitiesEntity rentRentalQuantitiesEntity : rentalQuantitiesList) {
                            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                            //来源
                            detailExecutionVO.setSourceId(rentRentalQuantitiesEntity.getId() == null ? IdWorker.getId() :rentRentalQuantitiesEntity.getId());
                            detailExecutionVO.setSourceBillId(entity.getId());
                            //分类
                            detailExecutionVO.setCategoryId(rentRentalQuantitiesEntity.getCategoryId());
                            detailExecutionVO.setCategoryName(rentRentalQuantitiesEntity.getCategoryName());
                            //设备档案
                            detailExecutionVO.setCategoryFlag(false);
                            detailExecutionVO.setDocId(rentRentalQuantitiesEntity.getEquipmentId());
                            detailExecutionVO.setCode(rentRentalQuantitiesEntity.getEquipmentCode());
                            detailExecutionVO.setName(rentRentalQuantitiesEntity.getEquipmentName());

                            detailExecutionVO.setCategoryContainFlag(false);
                            detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());

                            //单位
                            detailExecutionVO.setUnitName(rentRentalQuantitiesEntity.getUnitName());

                            detailExecutionVO.setNum(new BigDecimal(rentRentalQuantitiesEntity.getRentNum()));
                            detailExecutionVO.setSpec(rentRentalQuantitiesEntity.getSpec());
                            detailExecutionVO.setMoney(rentRentalQuantitiesEntity.getRentQuantitiesMny());
                            detailExecutionVO.setTaxMoney(rentRentalQuantitiesEntity.getRentQuantitiesTaxMny());
                            detailExecutionVO.setPrice(rentRentalQuantitiesEntity.getNotTaxQuantitiesPrice());
                            detailExecutionVO.setTaxPrice(rentRentalQuantitiesEntity.getQuantitiesPrice());
                            detailExecutionVO.setTaxRate(rentRentalQuantitiesEntity.getTax());

                            detailExecutionVO.setContractId(entity.getContractId());
                            detailExecutionVO.setRentType(RentTypeEnum.工程量租.getCode());
                            detailList.add(detailExecutionVO);
                        }
                    }
                }
            }

            //日租明细
            List<RentSettlementDayEntity> rentSettlementDayList = entity.getRentSettlementDayList();
            if (rentSettlementDayList!=null){
                for (RentSettlementDayEntity rentDayEntity : rentSettlementDayList) {
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    //来源
                    detailExecutionVO.setSourceId(rentDayEntity.getId() == null ? IdWorker.getId() :rentDayEntity.getId());
                    detailExecutionVO.setSourceBillId(entity.getId());
                    //分类
                    detailExecutionVO.setCategoryId(rentDayEntity.getEquipmentTypeId());
                    detailExecutionVO.setCategoryName(rentDayEntity.getEquipmentTypeName());
                    //设备档案
                    detailExecutionVO.setCategoryFlag(false);
                    detailExecutionVO.setDocId(rentDayEntity.getEquipmentId());
                    detailExecutionVO.setCode(rentDayEntity.getEquipmentCode());
                    detailExecutionVO.setName(rentDayEntity.getEquipmentName());

                    detailExecutionVO.setCategoryContainFlag(false);
                    detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());

                    //单位
                    detailExecutionVO.setUnitId(rentDayEntity.getUnitId());
                    detailExecutionVO.setUnitName(rentDayEntity.getUnit());

                    detailExecutionVO.setNum(rentDayEntity.getDayNum());
                    detailExecutionVO.setSpec(rentDayEntity.getSpec());
                    detailExecutionVO.setMoney(rentDayEntity.getDayMny());
                    detailExecutionVO.setTaxMoney(rentDayEntity.getDayTaxMny());
                    detailExecutionVO.setPrice(rentDayEntity.getDayPrice());
                    detailExecutionVO.setTaxPrice(rentDayEntity.getDayTaxPrice());
                    detailExecutionVO.setTaxRate(rentDayEntity.getDayTaxRate());

                    detailExecutionVO.setContractId(entity.getContractId());
                    detailExecutionVO.setRentType(RentTypeEnum.日租.getCode());
                    detailList.add(detailExecutionVO);
                }
            }
            //月租明细
            List<RentSettlementMonthEntity> rentSettlementMonthList = entity.getRentSettlementMonthList();
            if (rentSettlementMonthList!=null){
                for (RentSettlementMonthEntity rentMonthEntity : rentSettlementMonthList) {
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    //来源
                    detailExecutionVO.setSourceId(rentMonthEntity.getId() == null ? IdWorker.getId() :rentMonthEntity.getId());
                    detailExecutionVO.setSourceBillId(entity.getId());
                    //分类
                    detailExecutionVO.setCategoryId(rentMonthEntity.getEquipmentTypeId());
                    detailExecutionVO.setCategoryName(rentMonthEntity.getEquipmentTypeName());
                    //设备档案
                    detailExecutionVO.setCategoryFlag(false);
                    detailExecutionVO.setDocId(rentMonthEntity.getEquipmentId());
                    detailExecutionVO.setCode(rentMonthEntity.getEquipmentCode());
                    detailExecutionVO.setName(rentMonthEntity.getEquipmentName());

                    detailExecutionVO.setCategoryContainFlag(false);
                    detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());

                    //单位
                    detailExecutionVO.setUnitId(rentMonthEntity.getUnitId());
                    detailExecutionVO.setUnitName(rentMonthEntity.getUnit());

                    detailExecutionVO.setNum(rentMonthEntity.getMonthNum());
                    detailExecutionVO.setSpec(rentMonthEntity.getSpec());
                    detailExecutionVO.setMoney(rentMonthEntity.getMonthMny());
                    detailExecutionVO.setTaxMoney(rentMonthEntity.getMonthTaxMny());
                    detailExecutionVO.setPrice(rentMonthEntity.getMonthPrice());
                    detailExecutionVO.setTaxPrice(rentMonthEntity.getMonthTaxPrice());
                    detailExecutionVO.setTaxRate(rentMonthEntity.getMonthTaxRate());

                    detailExecutionVO.setContractId(entity.getContractId());
                    detailExecutionVO.setRentType(RentTypeEnum.月租.getCode());
                    detailList.add(detailExecutionVO);

                }
            }
            //工程量租明细
            List<RentSettlementQuantitiesEntity> rentSettlementQuantitiesList = entity.getRentSettlementQuantitiesList();
            if (rentSettlementQuantitiesList!=null){
                for (RentSettlementQuantitiesEntity rentQuantitiesEntity : rentSettlementQuantitiesList) {
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    //来源
                    detailExecutionVO.setSourceId(rentQuantitiesEntity.getId() == null ? IdWorker.getId() :rentQuantitiesEntity.getId());
                    detailExecutionVO.setSourceBillId(entity.getId());
                    //分类
                    detailExecutionVO.setCategoryId(rentQuantitiesEntity.getEquipmentTypeId());
                    detailExecutionVO.setCategoryName(rentQuantitiesEntity.getEquipmentTypeName());
                    //设备档案
                    detailExecutionVO.setCategoryFlag(false);
                    detailExecutionVO.setDocId(rentQuantitiesEntity.getEquipmentId());
                    detailExecutionVO.setCode(rentQuantitiesEntity.getEquipmentCode());
                    detailExecutionVO.setName(rentQuantitiesEntity.getEquipmentName());

                    detailExecutionVO.setCategoryContainFlag(false);
                    detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());

                    //单位
                    detailExecutionVO.setUnitId(rentQuantitiesEntity.getUnitId());
                    detailExecutionVO.setUnitName(rentQuantitiesEntity.getUnit());

                    detailExecutionVO.setNum(rentQuantitiesEntity.getQuantitiesNum());
                    detailExecutionVO.setSpec(rentQuantitiesEntity.getSpec());
                    detailExecutionVO.setMoney(rentQuantitiesEntity.getQuantitiesMny());
                    detailExecutionVO.setTaxMoney(rentQuantitiesEntity.getQuantitiesTaxMny());
                    detailExecutionVO.setPrice(rentQuantitiesEntity.getQuantitiesPrice());
                    detailExecutionVO.setTaxPrice(rentQuantitiesEntity.getQuantitiesTaxPrice());
                    detailExecutionVO.setTaxRate(rentQuantitiesEntity.getQuantitiesTaxRate());

                    detailExecutionVO.setContractId(entity.getContractId());
                    detailExecutionVO.setRentType(RentTypeEnum.工程量租.getCode());
                    detailList.add(detailExecutionVO);
                }
            }
            //设备分类编码信息赋值
            //根据分类ID查询物料分类信息
            if (CollectionUtils.isNotEmpty(detailList)){
                List<Long> categoryIdList = detailList.stream().map(DetailExecutionVO::getCategoryId).collect(Collectors.toList());
                List<MaterialCategoryVO> categoryVOList = materialApi.queryCategoryListByIds(categoryIdList).getData();
                if (CollectionUtils.isNotEmpty(categoryVOList)){
                    Map<Long, MaterialCategoryVO> categoryMap = categoryVOList.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
                    for (DetailExecutionVO detailExecutionVO : detailList) {
                        if (null != categoryMap.get(detailExecutionVO.getCategoryId())){
                            detailExecutionVO.setCategoryInnerCode(categoryMap.get(detailExecutionVO.getCategoryId()).getInnerCode());
                            detailExecutionVO.setCategoryCode(categoryMap.get(detailExecutionVO.getCategoryId()).getCode());
                        }
                    }
                }
            }
            executionVO.setDetailList(detailList);
        }
        logger.info("目标成本推送数据---设备租赁结算保存、删除---->{}", JSONObject.toJSONString(executionVO));
        return executionVO;
    }

    /*是否有为生效的结算单*/
    @Override
    public boolean queryExist(Long contractId,Long id){
        LambdaQueryWrapper<RentSettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RentSettlementEntity::getContractId, contractId);
        wrapper.notIn(RentSettlementEntity::getBillState, 1,3);//未生效条件
        if(id!=null){
            wrapper.ne(RentSettlementEntity::getId, id);
        }
        List<RentSettlementEntity> list = super.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){//有数据表示有未生效的结算单
            return true;
        }
        return false;
    }

    /*获取最近一次含本期结算金额和结算日期 结算次数*/
    @Override
    public CommonResponse<Map> getDateMny(Long contractId) {
        Map<String, Object> map = new HashMap<>();
        BigDecimal currentTaxMny = BigDecimal.ZERO; // 结算金额
        BigDecimal currentMny = BigDecimal.ZERO; // 结算金额(无税)
        String sTDate  = null;
        LambdaQueryWrapper<RentSettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.orderByDesc(RentSettlementEntity::getCreateTime);
        wrapper.in(RentSettlementEntity::getBillState, 1,3);//防止修改时获取本单据的数据
        wrapper.eq(RentSettlementEntity::getDr, 0);
        wrapper.eq(RentSettlementEntity::getContractId, contractId);
        List<RentSettlementEntity> list = super.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            sTDate = DateFormatUtil.formatDate("yyyy-MM-dd", list.get(0).getSettlementDate());
            currentTaxMny = list.stream().filter(e -> null != e.getSettlementTaxMny()).map(RentSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentMny = list.stream().filter(e -> null != e.getSettlementMny()).map(RentSettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        map.put("currentTaxMny",currentTaxMny);
        map.put("currentMny",currentMny);
        map.put("sTDate",sTDate);
        map.put("settlementNum",list.size());
        return CommonResponse.success("获取金额和时间成功！",map);
    }

    /*推送供方*/
    @Override
    public boolean pushBillToSupCenter(RentSettlementEntity entity) {
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = BILL_TYPE + "::" + entity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送计量单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        entity.setSystemId(ejcCloudSystemCode.getData());

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            SupRentSettlementVO supRentSettlementVO = BeanMapper.map(entity, SupRentSettlementVO.class);
            List<SupRentSettlementDayVO> supRentSettlementDayVOS = BeanMapper.mapList(entity.getRentSettlementDayList(), SupRentSettlementDayVO.class);
            List<SupRentSettlementMonthVO> supRentSettlementMonthVOS = BeanMapper.mapList(entity.getRentSettlementMonthList(), SupRentSettlementMonthVO.class);
            List<SupRentSettlementQuantitiesVO> supRentSettlementQuantitiesVOS = BeanMapper.mapList(entity.getRentSettlementQuantitiesList(), SupRentSettlementQuantitiesVO.class);
            List<SupRentSettlementRentalVO> supRentSettlementRentalVOS = BeanMapper.mapList(entity.getRentSettlementRentalList(), SupRentSettlementRentalVO.class);
            List<SupRentSettlementFeeVO> supSettlementFeeVOS = BeanMapper.mapList(entity.getRentSettlementFeeList(), SupRentSettlementFeeVO.class);
            supRentSettlementVO.setRentSettlementDayList(supRentSettlementDayVOS);
            supRentSettlementVO.setRentSettlementMonthList(supRentSettlementMonthVOS);
            supRentSettlementVO.setRentSettlementRentalList(supRentSettlementRentalVOS);
            supRentSettlementVO.setRentSettlementQuantitiesList(supRentSettlementQuantitiesVOS);
            supRentSettlementVO.setRentSettlementFeeList(supSettlementFeeVOS);
            paramMap.put("transData", JSONObject.toJSONString(supRentSettlementVO));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, "projectMangerSign", null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
                List<Long> fileIds = new ArrayList<>();
                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                //当前单据携带有附件信息
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                logger.info("向供应商-{}推送附件参数-{}", entity.getSupplierId(), JSONObject.toJSONString(files));
                logger.info("向供应商-{}推送计量单据参数-{}", entity.getSupplierId(), JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        entity.getSupplierId().toString(),
                        files);
//                syncFlag = CommonUtils.checkCommonResponse(syncReqResp, logger);
                if (syncReqResp.isSuccess()) {
                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        logger.error("供方id-{}处理推送订单单据id-{}失败, {}", entity.getSupplierId(), entity.getId(), billPushResp.getMsg());
                    }
                } else {
                    logger.error("发送请求推送订单单据id-{}给供方id-{}失败, {}", entity.getId(), entity.getSupplierId(), syncReqResp.getMsg());
                }
            } else {
                logger.error("获取订单单据id-{}对应附件信息失败, {}", entity.getId(), fileResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("推送订单单据id-{}给供方id-{} 异常，", entity.getId(), entity.getSupplierId(), e);
//            throw e;
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }

    /*
     * 撤回推送供方
     *  */
    @Override
    public CommonResponse<String> updatePushBill(RentSettlementEntity entity) {
        boolean locked = false;
        Jedis jedis = jedisPool.getResource();
        String key = BILL_TYPE + "::" + entity.getId().toString();
        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return CommonResponse.error("推送供方异常!");
        }
        //设置当前系统ID
        entity.setSystemId(ejcCloudSystemCode.getData());
        entity.setSignStatus(0);
        baseMapper.updateById(entity);
        logger.info("修改签字信息：{}", JSONObject.toJSONString(entity));
        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return CommonResponse.error("单据作废失败，单据锁获取失败!");
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("id", entity.getId().toString());
            paramMap.put("systemId", entity.getSystemId());
            logger.info("单据id-{}弃审，通知供方-{}单据作废!", entity.getSupplierId(), entity.getId());
            //推送单据到指定的供方
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(DEL_BILL_SERVER_URL,
                    RequestMethod.POST,
                    JSONObject.toJSONString(paramMap),
                    entity.getSupplierId().toString());

            if (syncReqResp.isSuccess()) {
                CommonResponse<String> supHandleResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    return supHandleResp;
                } else {
                    logger.error("供方-{}处理作废单据id-{}作废失败, {}", entity.getSupplierId(), entity.getId(), supHandleResp.getMsg());
                    throw new BusinessException(supHandleResp.getMsg());
                }
            } else {
                logger.error("发送请求通知供方-{} 单据id-{}作废失败, {}", entity.getSupplierId(), entity.getId(), syncReqResp.getMsg());
                throw new BusinessException(syncReqResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("通知供方单据id-{}作废异常，", entity.getId(), e);
            throw new BusinessException("推送供方异常!");
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
    }
    /*供方签字确认*/
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;

        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        RentSettlementEntity settlementEntity = super.selectById(billId);
        //设置供方签字信息
        settlementEntity.setSupOperateTime(supOperateTime);
        settlementEntity.setSupOperatorName(supOperatorName);
        settlementEntity.setSupOperatorPhone(supOperatorPhone);
        settlementEntity.setSupOperatorUserCode(supOperatorUserCode);

        String key = BILL_TYPE + "::" + settlementEntity.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据id-{}签字信息回写加锁失败！", settlementEntity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字信息回写加锁失败";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, BILL_TYPE, authority, settlementEntity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            settlementEntity.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态 签字状态：0-未签字 1-已签字
            // 乙方已签字状态即待甲方签字
            settlementEntity.setSignStatus(1);
            //更新单据
            super.saveOrUpdate(settlementEntity, false);

//            //向单据制单人和经办人推送该消息
//            String msgSendResult = sendMsg(checkEntity, "供方已签字提醒", "结算单据[" + settleEntity.getBillCode() + "]供方已签字完成");
//            if (null != msgSendResult) {
//                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(settleEntity.getCreateUserId(), settleEntity.getEmployeeId()),
//                        settleEntity.getId(), msgSendResult);
//            }

        } catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", settlementEntity.getId(), e);
            msg = "单据签字信息回写失败！";
            throw e;
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }

    /*提交推送结算池*/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean pushSettleToPool(RentSettlementVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始-----"+JSONObject.toJSONString(vo));
            // 对象自动转换
            BeanConvertorUtil.convert(vo, spv);
            logger.info("结算单对象 -> 结算池对象自动转换结束，下面开始手动转换");

            // 个别字段需要手动封装
            convertSettleVOToSettlePoolVO(vo, spv);
            spv.setBillCodeUrl("/ejc-proequipment-frontend/#/rentSettleList/rentSettleCard?id=" + vo.getId());
            logger.info("推送参数----"+JSONObject.toJSONString(spv));
            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(spv);
            logger.info("结算单推送结算池结束---"+JSONObject.toJSONString(res));
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单推送结算池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送结算池失败！结算单id-{}，{}",vo.getId(), res.getMsg());
                throw new BusinessException("结算单弃审推送结算池失败!");
            }
        } catch (Exception e) {
            logger.error("结算单推送结算池失败！结算单id-{}", vo.getId(), e);
            throw new BusinessException("结算单推送结算池异常!");
        }
        return flag;
    }

    /*弃审删除结算池*/
// 从结算池中删除数据
    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            logger.info("结算单弃审推送结算池开始,结算单id-{}",id);
            CommonResponse<SettlePoolVO> res = settlePoolApi.deleteSettle(spv);
            logger.info("结算单推送结算池结束---"+JSONObject.toJSONString(res));
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单弃审推送结算池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送结算池失败！结算单id-{}，{}",id, res.getMsg());
                throw new BusinessException("结算单弃审推送结算池失败!");
            }
        }catch (Exception e){
            logger.error("结算单弃审推送结算池失败！结算单id-{}", id, e);
            throw new BusinessException("结算单弃审推送结算池异常!");
        }
        return flag;
    }


    // 将SettlementVO转换成settlePoolVO
    private void convertSettleVOToSettlePoolVO(RentSettlementVO vo, SettlePoolVO spv) {
        if (null == vo || null == spv) {
            logger.error("将结算单推送至结算池失败！原因：结算单对象为空或结算池对象为空，结算单对象 -> 结算池对象无法转换！");
            return;
        }
        logger.info("结算单对象 -> 结算池对象手动转换开始");
        //单据类似  单据状态
        spv.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        spv.setId(vo.getId());
        spv.setSourceType(SettleSourceTypeEnum.设备租入结算.getCode());
        spv.setSettlePropertyName("支出");
        spv.setSettleProperty(0);//属性类别，0支出，1收入
        spv.setSourceId(vo.getId());//结算单id
        spv.setCreateUserCode(vo.getCreateUserCode());//结算创建者账号
        spv.setCreateTime(vo.getCreateTime());//结算创建时间
        spv.setUpdateUserCode(vo.getUpdateUserCode());//结算修改者账号
        spv.setUpdateTime(vo.getUpdateTime());//结算修改时间
        spv.setContractFlag(0);// 是否有合同：1-是，0-否
        spv.setHandleType(0);
        if(vo.getContractId()!=null){//有合同需要推送的字段
            spv.setContractFlag(1);// 是否有合同：1-是，0-否
            //查询合同
            RentContractEntity contractEntity = rentContractService.selectById(vo.getContractId());
            spv.setContractType(ContractTypeEnum.设备租赁.getTypeCode());
            spv.setSupplementFlag(contractEntity.getSupplementFlag());//是否补充写协议
            spv.setMaiContractId(contractEntity.getMainContractId());//原合同id
            spv.setMaiContractName(contractEntity.getMainContractName());//原合同name
            spv.setMaiContractCode(contractEntity.getMainContractCode());//原合同code
//            spv.setContractCode(contractEntity.getContractCode());//合同编码
            spv.setPartyaId(contractEntity.getPartyId());//甲方id
            spv.setPartyaName(contractEntity.getPartyName());//甲方name
            spv.setSignDate(contractEntity.getSignedDate());//签订日期
            spv.setLastTaxMny(ComputeUtil.safeSub(vo.getCurrentSettlementTaxMny(),vo.getSettlementTaxMny()));//截止本期已结算金额（含税，不含本期）
            spv.setLastMny(ComputeUtil.safeSub(vo.getCurrentSettlementMny(),vo.getSettlementMny()));//截止本期已结算金额(无税，不含本期)
            spv.setLastTax(ComputeUtil.safeSub(spv.getLastTaxMny(),spv.getLastMny()));//截止本期税额（不含本期）
        }
        logger.info("结算单对象 -> 结算池对象手动转换完成，下面开始推送至结算池");
    }
    /**
     * 计算差值
     * @param a 变量a
     * @param b 变量b
     * @return 差值的绝对值，当其中一个变量为null时 或 计算出来的差值为null时 返回null
     */
    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }

    /**
     * 转换目标成本VO
     * @param entity
     * @return
     */
    @Override
    public ExecutionVO targetCost(RentSettlementEntity entity) {
        // 查询结算单
        LambdaQueryWrapper<RentSettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RentSettlementEntity::getContractId, entity.getContractId());
        wrapper.in(RentSettlementEntity::getBillState, Arrays.asList(1,3));
        List<RentSettlementEntity> settleList = this.list(wrapper);
        // 计算所有结算累计结算金额
        BigDecimal totalSettleTaxMny = settleList.stream().filter(e -> e.getSettlementTaxMny() != null).map(RentSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = settleList.stream().filter(e -> e.getSettlementMny() != null).map(RentSettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 查询合同
        RentContractEntity contractEntity = rentContractService.getById(entity.getContractId());

        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getBillCode());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setBillCategory(BillCategoryEnum.结算.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.设备租赁结算单.getCode());
        totalVO.setContractId(entity.getContractId());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        totalVO.setMoney(ComputeUtil.safeSub(totalSettleMny, contractEntity.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub(totalSettleTaxMny, contractEntity.getContractTaxMny()));
        totalVO.setLinkUrl(getBaseHost() + "ejc-proequipment-frontend/#/rentSettleList/rentSettleCard?id=" + entity.getId());

        executionVO.setTotalVO(totalVO);
        //子表赋值
        executionVO.setDetailList(numDetailExecution(contractEntity, settleList));
        logger.info("目标成本推送数据---设备租赁合同最终结算---->{}", JSONObject.toJSONString(executionVO));
        return executionVO;

    }

    private List<DetailExecutionVO> numDetailExecution(RentContractEntity contractEntity, List<RentSettlementEntity> list) {
        List<DetailExecutionVO> detailList = new ArrayList<>();
        Boolean dayDataFlag = CollectionUtils.isNotEmpty(contractEntity.getRentDayDetailedList()) ? true : false;
        Boolean monthDataFlag = CollectionUtils.isNotEmpty(contractEntity.getRentMonthDetailedList()) ? true : false;
        Boolean quantitiesDataFlag = CollectionUtils.isNotEmpty(contractEntity.getRentQuantitiesDetailedList()) ? true : false;

        //日租数据
        Map<Long, List<RentSettlementDayEntity>> settlementDayMap = new HashMap<>();
        Map<Long, List<RentRentalDayEntity>> rentalDayMap = new HashMap<>();
        //月租数据
        Map<Long, List<RentSettlementMonthEntity>> settlementMonthMap = new HashMap<>();
        Map<Long, List<RentRentalMonthEntity>> rentalMonthMap = new HashMap<>();
        //工程量租数据
        Map<Long, List<RentSettlementQuantitiesEntity>> settlementQuantitiesMap = new HashMap<>();
        Map<Long, List<RentRentalQuantitiesEntity>> rentalQuantitiesMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list)) {
            List<Long> settlementIdList = list.stream().map(RentSettlementEntity::getId).collect(Collectors.toList());

            // 结算单 -- 日租
            if (dayDataFlag){
                LambdaQueryWrapper<RentSettlementDayEntity> settlementDayQueryWrapper = new LambdaQueryWrapper<>();
                settlementDayQueryWrapper.in(RentSettlementDayEntity::getSettlementId, settlementIdList);
                List<RentSettlementDayEntity> settlementDayList = rentSettlementDayService.list(settlementDayQueryWrapper);
                //根据设备id汇总结算单日租金额
                if (CollectionUtils.isNotEmpty(settlementDayList)) {
                    settlementDayMap = settlementDayList.stream().filter(t -> null != t.getEquipmentId()).collect(Collectors.groupingBy(RentSettlementDayEntity::getEquipmentId));
                }
            }
            // 结算单 -- 月租
            if (monthDataFlag){
                LambdaQueryWrapper<RentSettlementMonthEntity> settlementMonthQueryWrapper = new LambdaQueryWrapper<>();
                settlementMonthQueryWrapper.in(RentSettlementMonthEntity::getSettlementId, settlementIdList);
                List<RentSettlementMonthEntity> settlementMonthList = rentSettlementMonthService.list(settlementMonthQueryWrapper);
                //根据设备id汇总结算单月租金额
                if (CollectionUtils.isNotEmpty(settlementMonthList)) {
                    settlementMonthMap = settlementMonthList.stream().filter(t -> null != t.getEquipmentId()).collect(Collectors.groupingBy(RentSettlementMonthEntity::getEquipmentId));
                }
            }
            // 结算单 -- 工程量租
            if (quantitiesDataFlag){
                LambdaQueryWrapper<RentSettlementQuantitiesEntity> settlementQuantitiesQueryWrapper = new LambdaQueryWrapper<>();
                settlementQuantitiesQueryWrapper.in(RentSettlementQuantitiesEntity::getSettlementId, settlementIdList);
                List<RentSettlementQuantitiesEntity> settlementQuantitiesList = rentSettlementQuantitiesService.list(settlementQuantitiesQueryWrapper);
                //根据设备id汇总结算单工程量租金额
                if (CollectionUtils.isNotEmpty(settlementQuantitiesList)) {
                    settlementQuantitiesMap = settlementQuantitiesList.stream().filter(t -> null != t.getEquipmentId()).collect(Collectors.groupingBy(RentSettlementQuantitiesEntity::getEquipmentId));
                }
            }

            //根据结算单查询 租金计算
            LambdaQueryWrapper<RentSettlementRentalEntity> rentSettlementRentalQueryWrapper = new LambdaQueryWrapper<>();
            rentSettlementRentalQueryWrapper.in(RentSettlementRentalEntity::getSettlementId, settlementIdList);
            List<RentSettlementRentalEntity> rentSettlementRentalList = rentSettlementRentalService.list(rentSettlementRentalQueryWrapper);
            if (CollectionUtils.isNotEmpty(rentSettlementRentalList)) {
                // 租金计算 -- 日租
                if (dayDataFlag){
                    LambdaQueryWrapper<RentRentalDayEntity> rentRentalDayWrapper = new LambdaQueryWrapper<>();
                    rentRentalDayWrapper.in(RentRentalDayEntity::getRentalId, rentSettlementRentalList.stream().map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList()));
                    List<RentRentalDayEntity> rentRentalDayList = rentRentalDayService.list(rentRentalDayWrapper);
                    //根据设备id汇总租金计算单日租的金额
                    if (CollectionUtils.isNotEmpty(rentRentalDayList)) {
                        rentalDayMap = rentRentalDayList.stream().filter(t -> t.getEquipmentId() != null).collect(Collectors.groupingBy(RentRentalDayEntity::getEquipmentId));
                    }
                }
                // 租金计算 -- 月租
                if (monthDataFlag){
                    LambdaQueryWrapper<RentRentalMonthEntity> rentRentalMonthWrapper = new LambdaQueryWrapper<>();
                    rentRentalMonthWrapper.in(RentRentalMonthEntity::getRentalId, rentSettlementRentalList.stream().map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList()));
                    List<RentRentalMonthEntity> rentRentalMonthList = rentRentalMonthService.list(rentRentalMonthWrapper);
                    //根据设备id汇总租金计算单月租的金额
                    if (CollectionUtils.isNotEmpty(rentRentalMonthList)) {
                        rentalMonthMap = rentRentalMonthList.stream().filter(t -> t.getEquipmentId() != null).collect(Collectors.groupingBy(RentRentalMonthEntity::getEquipmentId));
                    }
                }
                // 租金计算 -- 工程量租
                if (quantitiesDataFlag){
                    LambdaQueryWrapper<RentRentalQuantitiesEntity> rentRentalQuantitiesWrapper = new LambdaQueryWrapper<>();
                    rentRentalQuantitiesWrapper.in(RentRentalQuantitiesEntity::getRentalId, rentSettlementRentalList.stream().map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList()));
                    List<RentRentalQuantitiesEntity> rentRentalQuantitiesList = rentRentalQuantitiesService.list(rentRentalQuantitiesWrapper);
                    //根据设备id汇总租金计算单工程量的金额
                    if (CollectionUtils.isNotEmpty(rentRentalQuantitiesList)) {
                        rentalQuantitiesMap = rentRentalQuantitiesList.stream().filter(t -> t.getEquipmentId() != null).collect(Collectors.groupingBy(RentRentalQuantitiesEntity::getEquipmentId));
                    }
                }
            }
        }

        BigDecimal sumMny;
        BigDecimal sumTaxMny;
        BigDecimal quantitiesNum;
        //合同日租
        if (CollectionUtils.isNotEmpty(contractEntity.getRentDayDetailedList())) {
            for (RentDayDetailedEntity rentDayDetailedEntity : contractEntity.getRentDayDetailedList()) {
                sumMny = BigDecimal.ZERO;
                sumTaxMny = BigDecimal.ZERO;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                //来源
                detailExecutionVO.setSourceId(rentDayDetailedEntity.getId());
                detailExecutionVO.setSourceBillId(rentDayDetailedEntity.getPid());

                //设备分类
                detailExecutionVO.setCategoryId(rentDayDetailedEntity.getCategoryId());
                detailExecutionVO.setCategoryName(rentDayDetailedEntity.getCategoryName());

                //设备档案
                detailExecutionVO.setCategoryFlag(false);
                detailExecutionVO.setDocId(rentDayDetailedEntity.getEquipmentId());
                detailExecutionVO.setCode(rentDayDetailedEntity.getEquipmentCode());
                detailExecutionVO.setName(rentDayDetailedEntity.getName());

                detailExecutionVO.setCategoryContainFlag(false);
                detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());
                //单位
                detailExecutionVO.setUnitName(rentDayDetailedEntity.getUnitName());
                //规格
                detailExecutionVO.setSpec(rentDayDetailedEntity.getSpec());
                //月租单价
                detailExecutionVO.setPrice(rentDayDetailedEntity.getDayRentPrice());
                detailExecutionVO.setTaxPrice(rentDayDetailedEntity.getDayRentNotTaxPrice());
                //数量
                detailExecutionVO.setNum(new BigDecimal(rentDayDetailedEntity.getRentNum()));

                //本期结算金额
                //结算日租金额汇总
                if (settlementDayMap.containsKey(rentDayDetailedEntity.getEquipmentId())) {
                    sumMny = settlementDayMap.get(rentDayDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getDayMny()).map(RentSettlementDayEntity::getDayMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = settlementDayMap.get(rentDayDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getDayTaxMny()).map(RentSettlementDayEntity::getDayTaxMny).reduce(sumTaxMny, BigDecimal::add);
                }
                //租金计算日租金额汇总
                if (rentalDayMap.containsKey(rentDayDetailedEntity.getEquipmentId())) {
                    sumMny = rentalDayMap.get(rentDayDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getRentDayMny()).map(RentRentalDayEntity::getRentDayMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = rentalDayMap.get(rentDayDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getRentDayTaxMny()).map(RentRentalDayEntity::getRentDayTaxMny).reduce(sumTaxMny, BigDecimal::add);
                }
                detailExecutionVO.setMoney(ComputeUtil.safeSub(sumMny, rentDayDetailedEntity.getRentMny()));
                detailExecutionVO.setTaxMoney(ComputeUtil.safeSub(sumTaxMny, rentDayDetailedEntity.getRentTaxMny()));

                detailList.add(detailExecutionVO);
            }
        }
        //合同月租
        if (CollectionUtils.isNotEmpty(contractEntity.getRentMonthDetailedList())) {
            for (RentMonthDetailedEntity rentMonthDetailedEntity : contractEntity.getRentMonthDetailedList()) {
                sumMny = BigDecimal.ZERO;
                sumTaxMny = BigDecimal.ZERO;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                //来源
                detailExecutionVO.setSourceId(rentMonthDetailedEntity.getId());
                detailExecutionVO.setSourceBillId(rentMonthDetailedEntity.getPid());

                //设备分类
                detailExecutionVO.setCategoryId(rentMonthDetailedEntity.getCategoryId());
                detailExecutionVO.setCategoryName(rentMonthDetailedEntity.getCategoryName());

                //设备档案
                detailExecutionVO.setCategoryFlag(false);
                detailExecutionVO.setDocId(rentMonthDetailedEntity.getEquipmentId());
                detailExecutionVO.setCode(rentMonthDetailedEntity.getEquipmentCode());
                detailExecutionVO.setName(rentMonthDetailedEntity.getName());

                detailExecutionVO.setCategoryContainFlag(false);
                detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());
                //单位
                detailExecutionVO.setUnitName(rentMonthDetailedEntity.getUnitName());
                //规格
                detailExecutionVO.setSpec(rentMonthDetailedEntity.getSpec());
                //月租单价
                detailExecutionVO.setPrice(rentMonthDetailedEntity.getMonthRentPrice());
                detailExecutionVO.setTaxPrice(rentMonthDetailedEntity.getMonthRentNotTaxPrice());
                //数量
                detailExecutionVO.setNum(new BigDecimal(rentMonthDetailedEntity.getRentNum()));
                //本期结算金额
                //结算月租金额汇总
                if (settlementMonthMap.containsKey(rentMonthDetailedEntity.getEquipmentId())) {
                    sumMny = settlementMonthMap.get(rentMonthDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getMonthMny()).map(RentSettlementMonthEntity::getMonthMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = settlementMonthMap.get(rentMonthDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getMonthTaxMny()).map(RentSettlementMonthEntity::getMonthTaxMny).reduce(sumTaxMny, BigDecimal::add);
                }
                //租金计算月租金额汇总
                if (rentalMonthMap.containsKey(rentMonthDetailedEntity.getEquipmentId())) {
                    sumMny = rentalMonthMap.get(rentMonthDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getRentMonthMny()).map(RentRentalMonthEntity::getRentMonthMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = rentalMonthMap.get(rentMonthDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getRentMonthTaxMny()).map(RentRentalMonthEntity::getRentMonthTaxMny).reduce(sumTaxMny, BigDecimal::add);
                }
                detailExecutionVO.setMoney(ComputeUtil.safeSub(sumMny, rentMonthDetailedEntity.getRentMny()));
                detailExecutionVO.setTaxMoney(ComputeUtil.safeSub(sumTaxMny, rentMonthDetailedEntity.getRentTaxMny()));

                detailList.add(detailExecutionVO);
            }
        }
        //合同工程量租
        if (CollectionUtils.isNotEmpty(contractEntity.getRentQuantitiesDetailedList())) {
            for (RentQuantitiesDetailedEntity rentQuantitiesDetailedEntity : contractEntity.getRentQuantitiesDetailedList()) {
                sumMny = BigDecimal.ZERO;
                sumTaxMny = BigDecimal.ZERO;
                quantitiesNum = BigDecimal.ZERO;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                //来源
                detailExecutionVO.setSourceId(rentQuantitiesDetailedEntity.getId());
                detailExecutionVO.setSourceBillId(rentQuantitiesDetailedEntity.getPid());

                //设备分类
                detailExecutionVO.setCategoryId(rentQuantitiesDetailedEntity.getCategoryId());
                detailExecutionVO.setCategoryName(rentQuantitiesDetailedEntity.getCategoryName());

                //设备档案
                detailExecutionVO.setCategoryFlag(false);
                detailExecutionVO.setDocId(rentQuantitiesDetailedEntity.getEquipmentId());
                detailExecutionVO.setCode(rentQuantitiesDetailedEntity.getEquipmentCode());
                detailExecutionVO.setName(rentQuantitiesDetailedEntity.getName());

                detailExecutionVO.setCategoryContainFlag(false);
                detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());
                //单位
                detailExecutionVO.setUnitName(rentQuantitiesDetailedEntity.getUnitName());
                //规格
                detailExecutionVO.setSpec(rentQuantitiesDetailedEntity.getSpec());
                //月租单价
                detailExecutionVO.setPrice(rentQuantitiesDetailedEntity.getQuantitiesPrice());
                detailExecutionVO.setTaxPrice(rentQuantitiesDetailedEntity.getNotTaxQuantitiesPrice());
                //数量
                detailExecutionVO.setNum(new BigDecimal(rentQuantitiesDetailedEntity.getRentNum()));
                //本期结算金额
                //结算工程量租金额汇总
                if (settlementQuantitiesMap.containsKey(rentQuantitiesDetailedEntity.getEquipmentId())) {
                    sumMny = settlementQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getQuantitiesMny()).map(RentSettlementQuantitiesEntity::getQuantitiesMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = settlementQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getQuantitiesTaxMny()).map(RentSettlementQuantitiesEntity::getQuantitiesTaxMny).reduce(sumTaxMny, BigDecimal::add);
                    quantitiesNum = settlementQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getQuantitiesNum()).map(RentSettlementQuantitiesEntity::getQuantitiesNum).reduce(quantitiesNum, BigDecimal::add);
                }
                //租金计算工程量租金额汇总
                if (rentalQuantitiesMap.containsKey(rentQuantitiesDetailedEntity.getEquipmentId())) {
                    sumMny = rentalQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getRentQuantitiesMny()).map(RentRentalQuantitiesEntity::getRentQuantitiesMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = rentalQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getRentQuantitiesTaxMny()).map(RentRentalQuantitiesEntity::getRentQuantitiesTaxMny).reduce(sumTaxMny, BigDecimal::add);
                    quantitiesNum = rentalQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId()).stream().filter(e -> null != e.getQuantitiesNum()).map(RentRentalQuantitiesEntity::getQuantitiesNum).reduce(quantitiesNum, BigDecimal::add);
                }
                detailExecutionVO.setMoney(ComputeUtil.safeSub(sumMny, rentQuantitiesDetailedEntity.getRentMny()));
                detailExecutionVO.setTaxMoney(ComputeUtil.safeSub(sumTaxMny, rentQuantitiesDetailedEntity.getRentTaxMny()));
                //工程量
                detailExecutionVO.setQuantityNum(ComputeUtil.safeSub(quantitiesNum, rentQuantitiesDetailedEntity.getQuantitiesNum()));

                detailList.add(detailExecutionVO);
            }
        }

        //设备分类编码信息赋值
        //根据分类ID查询物料分类信息
        if (CollectionUtils.isNotEmpty(detailList)){
            List<Long> categoryIdList = detailList.stream().map(DetailExecutionVO::getCategoryId).collect(Collectors.toList());
            List<MaterialCategoryVO> categoryVOList = materialApi.queryCategoryListByIds(categoryIdList).getData();
            if (CollectionUtils.isNotEmpty(categoryVOList)){
                Map<Long, MaterialCategoryVO> categoryMap = categoryVOList.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
                for (DetailExecutionVO detailExecutionVO : detailList) {
                    if (null != categoryMap.get(detailExecutionVO.getCategoryId())){
                        detailExecutionVO.setCategoryInnerCode(categoryMap.get(detailExecutionVO.getCategoryId()).getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryMap.get(detailExecutionVO.getCategoryId()).getCode());
                    }
                }
            }
        }
        return detailList;
    }

    //关联保存
    @Override
    public CommonResponse<RentSettlementVO> pushCost(RentSettlementVO vo) {
        RentSettlementEntity entity = baseMapper.selectById(vo.getId());
        if (CollectionUtils.isNotEmpty(vo.getRentSettlementRentalList())) {
            List<RentSettlementRentalEntity> rentalEntities = BeanMapper.mapList(vo.getRentSettlementRentalList(), RentSettlementRentalEntity.class);
            entity.setRentSettlementRentalList(rentalEntities);
        }
        if (CollectionUtils.isNotEmpty(vo.getRentSettlementDayList())) {
            List<RentSettlementDayEntity> dayEntities = BeanMapper.mapList(vo.getRentSettlementDayList(), RentSettlementDayEntity.class);
            entity.setRentSettlementDayList(dayEntities);
        }
        if (CollectionUtils.isNotEmpty(vo.getRentSettlementMonthList())) {
            List<RentSettlementMonthEntity> monthEntities = BeanMapper.mapList(vo.getRentSettlementMonthList(), RentSettlementMonthEntity.class);
            entity.setRentSettlementMonthList(monthEntities);
        }
        if (CollectionUtils.isNotEmpty(vo.getRentSettlementQuantitiesList())) {
            List<RentSettlementQuantitiesEntity> quantitiesEntities = BeanMapper.mapList(vo.getRentSettlementQuantitiesList(), RentSettlementQuantitiesEntity.class);
            entity.setRentSettlementQuantitiesList(quantitiesEntities);
        }
        if (CollectionUtils.isNotEmpty(vo.getRentSettlementFeeList())) {
            List<RentSettlementFeeEntity> feeEntities = BeanMapper.mapList(vo.getRentSettlementFeeList(), RentSettlementFeeEntity.class);
            entity.setRentSettlementFeeList(feeEntities);
        }
        if (CollectionUtils.isNotEmpty(vo.getRentSettlementFragmentaryList())) {
            List<RentSettlementFragmentaryEntity> fragmentaryEntities = BeanMapper.mapList(vo.getRentSettlementFragmentaryList(), RentSettlementFragmentaryEntity.class);
            entity.setRentSettlementFragmentaryList(fragmentaryEntities);
        }
        super.saveOrUpdate(entity, false);
        //推送数据
        this.costPush(entity);
        return CommonResponse.success(BeanMapper.map(entity, RentSettlementVO.class));
    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void costPush(RentSettlementEntity entity) {
        logger.info("开始costPush");
        List<RentSettlementFragmentaryEntity> fragmentaryList = entity.getRentSettlementFragmentaryList();
        List<RentSettlementDayEntity> dayList = entity.getRentSettlementDayList();
        List<RentSettlementMonthEntity> monthList = entity.getRentSettlementMonthList();
        List<RentSettlementQuantitiesEntity> quantitiesList = entity.getRentSettlementQuantitiesList();
        List<RentSettlementFeeEntity> feeList = entity.getRentSettlementFeeList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(fragmentaryList)) {
            for (RentSettlementFragmentaryEntity detailEntity : fragmentaryList) {
                if (null == detailEntity.getSubjectIdFragmentary() || null == detailEntity.getWbsIdFragmentary()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(dayList)) {
            for (RentSettlementDayEntity detailEntity : dayList) {
                if (null == detailEntity.getSubjectId() || null == detailEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(monthList)) {
            for (RentSettlementMonthEntity detailEntity : monthList) {
                if (null == detailEntity.getSubjectId() || null == detailEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(quantitiesList)) {
            for (RentSettlementQuantitiesEntity detailEntity : quantitiesList) {
                if (null == detailEntity.getSubjectId() || null == detailEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeList)) {
            for (RentSettlementFeeEntity detailEntity : feeList) {
                if (null == detailEntity.getSubjectId() || null == detailEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }

        if (ListUtil.isEmpty(feeList) && ListUtil.isEmpty(dayList) && ListUtil.isEmpty(monthList) && ListUtil.isEmpty(quantitiesList) && ListUtil.isEmpty(fragmentaryList)) {
            newRelationFlag = "0";
        }

        //先删后增
        saveCost(entity,1);
        //更新是否关联
        entity.setRelationFlag(newRelationFlag);
        LambdaUpdateWrapper<RentSettlementEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(RentSettlementEntity::getId, entity.getId());
        updateWrapper.set(RentSettlementEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);
    }

    @Override
    public List<RentRentalEntity> queryRental(Long contractId, String settleDate) {
        return baseMapper.queryRental(contractId,settleDate);
    }
    /*
    * 合同金额控结算金额*/
    @Override
    public List<ParamsCheckVO> checkParamsMnyList(RentContractEntity rentContractEntity, RentSettlementVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        if (null!=rentContractEntity.getPurchaseType() && 2 == rentContractEntity.getPurchaseType()) {
            // 集采合同直接赋值为不控制
            return paramsCheckVOList;
        }
        String CHECK_PARAM_CODE = "";
        switch (vo.getSettlementType()){//结算类型，0-过程,1-最终
            case 0:CHECK_PARAM_CODE= CHECK_PARAM_CODE_GC;break;
            case 1:CHECK_PARAM_CODE= CHECK_PARAM_CODE_ZZ;break;
        }
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("结算金额控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    String orgName = datum.getOrgName();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BillParamVO billParamVO = datum;
                    BigDecimal totalSettleTaxMny = null==vo.getCurrentSettlementTaxMny()?BigDecimal.ZERO:vo.getCurrentSettlementTaxMny();
                    BigDecimal settleTaxMny = null==vo.getSettlementTaxMny()?BigDecimal.ZERO:vo.getSettlementTaxMny();
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(rentContractEntity.getContractTaxMny(), roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    if (totalSettleTaxMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(orgName);
                        paramsCheckDsVO.setWarnItem("合同超结");
                        paramsCheckDsVO.setWarnName("累计结算金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次结算金额：").append(settleTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计结算金额：").append(totalSettleTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalSettleTaxMny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }
/*
* 单据参数管控*/
    @Override
    public ParamsCheckVO checkParams(RentSettlementVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*参数控制区域*/
        if (null!=vo.getProjectId()&&null!=vo.getOrgId()){
            paramsCheckVOS.addAll(this.costProjectCheckParams(vo));
        }
        //----start有合同预警域
        if(vo.getContractId()!=null) {
            RentContractEntity rentContractEntity = rentContractService.selectById(vo.getContractId());
            paramsCheckVOS.addAll(this.checkParamsMnyList(rentContractEntity,vo));//金额 --组织分别控制
        }

        //目标成本控制
        RentSettlementEntity rentSettlementEntity = BeanMapper.map(vo, RentSettlementEntity.class);
        if(rentSettlementEntity.getId() == null){
            rentSettlementEntity.setId(IdWorker.getId());
        }

        ExecutionVO executionVO = settlementTargetCost(rentSettlementEntity,true);
        logger.error("设备租赁结算目标成本控制推送传参：" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO tarRes = response.getData();
        if(null!=tarRes){
            paramsCheckVOS.add(tarRes);
        }

        //--成本科目-目标成本控制
        CostCtrlVO costCtrlVO = this.sjCost(vo);
        if(null!=costCtrlVO){
            CommonResponse<ParamsCheckVO> costResponse = executionApi.ctrlCost(costCtrlVO);
            ParamsCheckVO costRes = costResponse.getData();
            if(null!=costRes){
                paramsCheckVOS.add(costRes);
            }
        }

        //目标成本价格控制
        ParamsCheckVO costParams = this.costPriceCheckParams(vo);
        if(costParams!=null){
            paramsCheckVOS.add(costParams);
        }


        //------end有合同预警域
        /*--end---参数控制区域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
    public List<ParamsCheckVO> costProjectCheckParams(RentSettlementVO vo) {
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<Boolean> booleanCommonResponse = dutyApi.queryDutyByProjectId(vo.getProjectId());
        if (!booleanCommonResponse.isSuccess()){
            throw new BusinessException("网络异常，请联系管理员！");
        }
        logger.info("项目目标成本控制 booleanCommonResponse："+booleanCommonResponse);

        //P-ilUA850193
        if(!booleanCommonResponse.getData()){
            CommonResponse<List<BillParamVO>> billParamByCodeAndOrgId = paramConfigApi.getBillParamByCodeAndOrgId("P-ilUA850193", vo.getOrgId());
            logger.info("billParamByCodeAndOrgId:"+billParamByCodeAndOrgId);
            if (billParamByCodeAndOrgId.isSuccess() && null != billParamByCodeAndOrgId.getData()) {
                List<BillParamVO> data = billParamByCodeAndOrgId.getData();
                if(CollectionUtils.isNotEmpty(data)){
                    for (BillParamVO billParamByCode : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        String orgName = billParamByCode.getOrgName();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        paramsCheckVO.setWarnType(paramsArray[billParamByCode.getControlType()]);
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("无目标成本控结算");
                        paramsCheckDsVO.setOrgName(orgName);
                        paramsCheckDsVO.setWarnName("该项目没有编制目标责任成本");
                        paramsCheckDsVO.setContent("该项目没有编制目标责任成本，不允许保存结算单");
                        checkDsVOS.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            } else {
                logger.info(billParamByCodeAndOrgId.getMsg());
                throw new BusinessException("获取控制参数失败");
            }
        }
        return paramsCheckVOList;
    }

    /**
     * 目标价格控制
     * @param vo
     * @return
     */
    public ParamsCheckVO costPriceCheckParams(RentSettlementVO vo) {
        List<RentSettlementDayVO> rentSettlementDayList = vo.getRentSettlementDayList();
        List<RentSettlementMonthVO> rentSettlementMonthList = vo.getRentSettlementMonthList();
        List<RentSettlementQuantitiesVO> rentSettlementQuantitiesList = vo.getRentSettlementQuantitiesList();

        CostPriceApiVO materialPriceHistoryApiVO = new CostPriceApiVO();
        List<CostPriceApiVO> materialPriceHistoryApiVOS = new ArrayList<>();
        if(CollectionUtil.isNotEmpty(rentSettlementDayList)){
            for (RentSettlementDayVO detailVO : rentSettlementDayList) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getEquipmentId()!=null){
                    CostPriceApiVO priceHistoryApiVO = new CostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getEquipmentId());
                    priceHistoryApiVO.setMaterialName(detailVO.getEquipmentName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getDayPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getDayTaxPrice());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        if(CollectionUtil.isNotEmpty(rentSettlementMonthList)){
            for (RentSettlementMonthVO detailVO : rentSettlementMonthList) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getEquipmentId()!=null){
                    CostPriceApiVO priceHistoryApiVO = new CostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getEquipmentId());
                    priceHistoryApiVO.setMaterialName(detailVO.getEquipmentName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getMonthPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getMonthTaxPrice());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        if(CollectionUtil.isNotEmpty(rentSettlementQuantitiesList)){
            for (RentSettlementQuantitiesVO detailVO : rentSettlementQuantitiesList) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getEquipmentId()!=null){
                    CostPriceApiVO priceHistoryApiVO = new CostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getEquipmentId());
                    priceHistoryApiVO.setMaterialName(detailVO.getEquipmentName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getQuantitiesPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getQuantitiesTaxPrice());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setProjectId(vo.getProjectId());
        materialPriceHistoryApiVO.setCostPriceApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = this.costPriceParams(materialPriceHistoryApiVO,PRICE_PARAM_CODE,SourceTypeEnum.设备租赁结算.getTypeName());
        return  paramsCheckVO;
    }

    /**
     *成本科目目标成本控制
     *
     */
    public CostCtrlVO sjCost(RentSettlementVO vo){
        List<RentSettlementDayVO> rentSettlementDayList = vo.getRentSettlementDayList();
        List<RentSettlementMonthVO> rentSettlementMonthList = vo.getRentSettlementMonthList();
        List<RentSettlementQuantitiesVO> rentSettlementQuantitiesList = vo.getRentSettlementQuantitiesList();
        List<RentSettlementFeeVO> rentSettlementFeeVOList = vo.getRentSettlementFeeList();
        List<RentSettlementFragmentaryVO> rentSettlementFragmentaryList = vo.getRentSettlementFragmentaryList();
        Map<Long,CostCtrlDetailVO> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(rentSettlementDayList)) {
            for(RentSettlementDayVO settlementFeeVO:rentSettlementDayList){
                if(!"del".equals(settlementFeeVO.getRowState()) && null!=settlementFeeVO.getSubjectId()){
                    BigDecimal detailMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getDayMny());
                    BigDecimal detailTaxMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getDayTaxMny());
                    if(map.containsKey(settlementFeeVO.getSubjectId())){
                        CostCtrlDetailVO costCtrlDetailVO = map.get(settlementFeeVO.getSubjectId());
                        BigDecimal mny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getMny());
                        BigDecimal taxMny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getTaxMny());
                        costCtrlDetailVO.setMny(mny.add(detailMny));
                        costCtrlDetailVO.setTaxMny(taxMny.add(detailTaxMny));
                    }else{
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(settlementFeeVO.getSubjectId());
                        costCtrlDetailVO.setMny(detailMny);
                        costCtrlDetailVO.setTaxMny(detailTaxMny);
                        map.put(settlementFeeVO.getSubjectId(),costCtrlDetailVO);
                    }
                }
            }
        }
        if(CollectionUtils.isNotEmpty(rentSettlementMonthList)) {
            for (RentSettlementMonthVO settlementFeeVO : rentSettlementMonthList) {
                if(!"del".equals(settlementFeeVO.getRowState()) && null != settlementFeeVO.getSubjectId()) {
                    BigDecimal detailMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getMonthMny());
                    BigDecimal detailTaxMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getMonthTaxMny());
                    if (map.containsKey(settlementFeeVO.getSubjectId())) {
                        CostCtrlDetailVO costCtrlDetailVO = map.get(settlementFeeVO.getSubjectId());
                        BigDecimal mny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getMny());
                        BigDecimal taxMny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getTaxMny());
                        costCtrlDetailVO.setMny(mny.add(detailMny));
                        costCtrlDetailVO.setTaxMny(taxMny.add(detailTaxMny));
                    } else {
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(settlementFeeVO.getSubjectId());
                        costCtrlDetailVO.setMny(detailMny);
                        costCtrlDetailVO.setTaxMny(detailTaxMny);
                        map.put(settlementFeeVO.getSubjectId(), costCtrlDetailVO);
                    }
                }
            }
        }
        if(CollectionUtils.isNotEmpty(rentSettlementQuantitiesList)) {
            for (RentSettlementQuantitiesVO settlementFeeVO : rentSettlementQuantitiesList) {
                if (!"del".equals(settlementFeeVO.getRowState()) && null != settlementFeeVO.getSubjectId()) {
                    BigDecimal detailMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getQuantitiesMny());
                    BigDecimal detailTaxMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getQuantitiesTaxMny());
                    if (map.containsKey(settlementFeeVO.getSubjectId())) {
                        CostCtrlDetailVO costCtrlDetailVO = map.get(settlementFeeVO.getSubjectId());
                        BigDecimal mny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getMny());
                        BigDecimal taxMny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getTaxMny());
                        costCtrlDetailVO.setMny(mny.add(detailMny));
                        costCtrlDetailVO.setTaxMny(taxMny.add(detailTaxMny));
                    } else {
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(settlementFeeVO.getSubjectId());
                        costCtrlDetailVO.setMny(detailMny);
                        costCtrlDetailVO.setTaxMny(detailTaxMny);
                        map.put(settlementFeeVO.getSubjectId(), costCtrlDetailVO);
                    }
                }
            }
        }
        if(CollectionUtils.isNotEmpty(rentSettlementFeeVOList)) {
            for (RentSettlementFeeVO settlementFeeVO : rentSettlementFeeVOList) {
                if (!"del".equals(settlementFeeVO.getRowState()) && null != settlementFeeVO.getSubjectId()) {
                    BigDecimal detailMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getFeeMny());
                    BigDecimal detailTaxMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getFeeTaxMny());
                    if (map.containsKey(settlementFeeVO.getSubjectId())) {
                        CostCtrlDetailVO costCtrlDetailVO = map.get(settlementFeeVO.getSubjectId());
                        BigDecimal mny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getMny());
                        BigDecimal taxMny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getTaxMny());
                        costCtrlDetailVO.setMny(mny.add(detailMny));
                        costCtrlDetailVO.setTaxMny(taxMny.add(detailTaxMny));
                    } else {
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(settlementFeeVO.getSubjectId());
                        costCtrlDetailVO.setMny(detailMny);
                        costCtrlDetailVO.setTaxMny(detailTaxMny);
                        map.put(settlementFeeVO.getSubjectId(), costCtrlDetailVO);
                    }
                }
            }
        }
        if(CollectionUtils.isNotEmpty(rentSettlementFragmentaryList)) {
            for (RentSettlementFragmentaryVO settlementFeeVO : rentSettlementFragmentaryList) {
                if (!"del".equals(settlementFeeVO.getRowState()) && null != settlementFeeVO.getSubjectIdFragmentary()) {
                    BigDecimal detailMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getFragmentaryMny());
                    BigDecimal detailTaxMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getFragmentaryTaxMny());
                    if (map.containsKey(settlementFeeVO.getSubjectIdFragmentary())) {
                        CostCtrlDetailVO costCtrlDetailVO = map.get(settlementFeeVO.getSubjectIdFragmentary());
                        BigDecimal mny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getMny());
                        BigDecimal taxMny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getTaxMny());
                        costCtrlDetailVO.setMny(mny.add(detailMny));
                        costCtrlDetailVO.setTaxMny(taxMny.add(detailTaxMny));
                    } else {
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(settlementFeeVO.getSubjectIdFragmentary());
                        costCtrlDetailVO.setMny(detailMny);
                        costCtrlDetailVO.setTaxMny(detailTaxMny);
                        map.put(settlementFeeVO.getSubjectIdFragmentary(), costCtrlDetailVO);
                    }
                }
            }
        }
        if(null!=map && !map.isEmpty()){
            CostCtrlVO ctrlVO = new CostCtrlVO();
            if(null!=vo.getId()){
                ctrlVO.setSourceId(vo.getId());
            }
            ctrlVO.setOrgId(vo.getOrgId());
            ctrlVO.setProjectId(vo.getProjectId());
            ctrlVO.setDetailList(new ArrayList<>(map.values()));
            return ctrlVO;
        }
        return null;
    }

    private void saveCost(RentSettlementEntity entity,Integer effectiveStatus) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<RentSettlementFragmentaryEntity> fragmentaryList = entity.getRentSettlementFragmentaryList();
        List<RentSettlementDayEntity> dayList = entity.getRentSettlementDayList();
        List<RentSettlementMonthEntity> monthList = entity.getRentSettlementMonthList();
        List<RentSettlementQuantitiesEntity> quantitiesList = entity.getRentSettlementQuantitiesList();
        List<RentSettlementFeeEntity> feeList = entity.getRentSettlementFeeList();

        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(fragmentaryList)) {
            for (RentSettlementFragmentaryEntity detailEntity : fragmentaryList) {
                CostDetailVO costDetailVO = BeanMapper.map(detailEntity, CostDetailVO.class);
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getFragmentaryTaxMny());
                costDetailVO.setHappenMny(detailEntity.getFragmentaryMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_FRAGMENTARY");
                costDetailVO.setWbsId(detailEntity.getWbsIdFragmentary());
                costDetailVO.setWbsCode(detailEntity.getWbsCodeFragmentary());
                costDetailVO.setWbsName(detailEntity.getWbsNameFragmentary());
                costDetailVO.setSubjectId(detailEntity.getSubjectIdFragmentary());
                costDetailVO.setSubjectCode(detailEntity.getSubjectCodeFragmentary());
                costDetailVO.setSubjectName(detailEntity.getSubjectNameFragmentary());
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(dayList)) {
            for (RentSettlementDayEntity detailEntity : dayList) {
                CostDetailVO costDetailVO = BeanMapper.map(detailEntity, CostDetailVO.class);
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getDayTaxMny());
                costDetailVO.setHappenMny(detailEntity.getDayMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_DAY");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(monthList)) {
            for (RentSettlementMonthEntity detailEntity : monthList) {
                CostDetailVO costDetailVO = BeanMapper.map(detailEntity, CostDetailVO.class);
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getMonthTaxMny());
                costDetailVO.setHappenMny(detailEntity.getMonthMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_MONTH");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(quantitiesList)) {
            for (RentSettlementQuantitiesEntity detailEntity : quantitiesList) {
                CostDetailVO costDetailVO = BeanMapper.map(detailEntity, CostDetailVO.class);
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getQuantitiesTaxMny());
                costDetailVO.setHappenMny(detailEntity.getQuantitiesMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_QUANTITIES");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeList)) {
            for (RentSettlementFeeEntity detailEntity : feeList) {
                CostDetailVO costDetailVO = BeanMapper.map(detailEntity, CostDetailVO.class);
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getFeeTaxMny());
                costDetailVO.setHappenMny(detailEntity.getFeeMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_FEE");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(costDetailVOList)) {
            for (CostDetailVO costDetailVO : costDetailVOList) {
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.设备租赁结算.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-proequipment-frontend/#/rentSettleList/rentSettleCard?id=" + entity.getId());
                costDetailVO.setSourceId(entity.getId());
                costDetailVO.setHappenDate(entity.getSettlementDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setId(null);
                costDetailVO.setSourceType("TEMP_EQ_JS");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("设备租赁结算推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
    
    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        RentSettlementEntity entity = selectById(id);
        // 最终结算推送目标成本
        if (entity.getSettlementType()!=null&&entity.getSettlementType()==1){
            logger.info("推送目标成本开始");
            CommonResponse<String> response = executionApi.aggPush(targetCost(entity));
            logger.info("推送目标成本入参：" + JSONObject.toJSONString(targetCost(entity)));
            if (!response.isSuccess()){
                logger.error("推送目标成本失败: , {}", response.getMsg());
                throw new BusinessException(response.getMsg());
            }
        }
        return CommonResponse.success("目标成本推送成功");
    }

    @Override
    public RentSettleRecordVO queryDetailRecord(Long contractId) {
        RentSettleRecordVO settleRecordVO = new RentSettleRecordVO();

        RentContractEntity contract = rentContractService.selectById(contractId);
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getContractPerformanceState());

        QueryWrapper<RentSettlementEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
        listQuery.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        listQuery.orderByDesc("settlement_date");
        List<RentSettlementEntity> list = super.list(listQuery);
        List<RentSettlementVO>  rentSettlementVOS = BeanMapper.mapList(list, RentSettlementVO.class);
        settleRecordVO.setSettleList(rentSettlementVOS);

            //累计结算金额
        BigDecimal contractSettleMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list)){
            contractSettleMny = list.stream().map(RentSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        settleRecordVO.setContractSettleMny(contractSettleMny);

        if (BigDecimal.ZERO.compareTo(settleRecordVO.getContractTaxMny()) == 0) {
            settleRecordVO.setSettleRate(BigDecimal.ZERO);
        } else {
            settleRecordVO.setSettleRate((settleRecordVO.getContractSettleMny().multiply(BigDecimal.valueOf(100))).divide(settleRecordVO.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        return settleRecordVO;
    }

    // 结算审批通过后/撤回后更新合同池累计结算金额（含税、无税、税额），type：是审批通过还是撤回标识，"true"审批通过后，"false"撤回后
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateContractPoolSettle(RentSettlementVO vo, Boolean type) {
        if(null!=vo.getContractId()) {//有合同推送
            logger.info("ID为【" + vo.getContractId() + "】的合同 " + vo.getBillCode() + "结算" + (type ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），settleEntity={}, 过程（0）/最终（1）={}, type={}", vo, vo.getSettlementType(), type);
            //计算累计计算金额
            BigDecimal totalSettleTaxMny = BigDecimal.ZERO;         // 累计结算金额含税初始化
            BigDecimal totalSettleMny = BigDecimal.ZERO;            // 累计结算金额无税初始化
            BigDecimal totalSettleTax = BigDecimal.ZERO;            // 累计结算税额初始化
            if (type) {
                totalSettleTaxMny = vo.getCurrentSettlementTaxMny() == null ? BigDecimal.ZERO : vo.getCurrentSettlementTaxMny();
                totalSettleMny = vo.getCurrentSettlementMny() == null ? BigDecimal.ZERO : vo.getCurrentSettlementMny();
                totalSettleTax = ComputeUtil.safeSub(totalSettleTaxMny, totalSettleMny);
            } else {//撤回删除本次结算金额
                totalSettleTaxMny = ComputeUtil.safeSub(vo.getCurrentSettlementTaxMny(), vo.getSettlementTaxMny());
                totalSettleMny = ComputeUtil.safeSub(vo.getCurrentSettlementMny(), vo.getSettlementMny());
                totalSettleTax = ComputeUtil.safeSub(totalSettleTaxMny, totalSettleMny);
            }
            // 封装
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setSourceId(vo.getContractId());
            contractPoolVO.setTotalSettleTaxMny(totalSettleTaxMny);        // 含税
            contractPoolVO.setTotalSettleMny(totalSettleMny);                 // 无税
            contractPoolVO.setTotalSettleTax(totalSettleTax);     // 税额
            if (1 == vo.getSettlementType()) { // 结算类型，0-过程,1-最终
                if (type) {//通过
                    contractPoolVO.setFinishSettleDate(new Date());
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.已终止.getCode());//performanceStatus
                } else {
                    contractPoolVO.setFinishSettleDate(null);
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());//performanceStatus
                }
            }
            logger.info("ID为【" + vo.getContractId() + "】的合同 " + vo.getBillCode() + "结算" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），结束，更新合同池接口入参：{}", JSONObject.toJSONString(contractPoolVO));
            CommonResponse<ContractPoolVO> updateConPoolRes = contractPoolApi.saveOrUpdateContract(contractPoolVO);
            logger.info("ID为【" + vo.getContractId() + "】的合同 " + vo.getBillCode() + "结算" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），结束，更新合同池接口返回结果：{}", JSONObject.toJSONString(updateConPoolRes));
        }
    }



}
