package com.ejianc.business.temporary.settlement.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.temporary.settlement.bean.TemporarySettlementEntity;
import com.ejianc.business.temporary.settlement.service.ITemporarySettlementService;
import com.ejianc.business.temporary.userecord.bean.TemporaryUseRecordEntity;
import com.ejianc.business.temporary.userecord.service.ITemporaryUseRecordService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

@RestController
@RequestMapping("/api/temporarySettlement/")
public class TemporarySettlementApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ITemporarySettlementService service;

    /**
     * 根据 项目查询所有状态下的临时租赁结算的结算金额之和
     *
     * @param projectId  项目id
     * @return 查询结果
     */
    @ApiOperation("根据 项目查询所有状态下的临时租赁结算的结算金额之和")
    @RequestMapping(value = "/queryTemporarySettlementMny", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<JSONObject> queryTemporarySettlementMny(@RequestParam("projectId") Long projectId) {
        logger.info("项目查询所有状态下的临时租赁结算的结算金额之和，查询参数projectId:{}", projectId);
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        List<TemporarySettlementEntity> list = service.queryList(param, false);
        BigDecimal settleTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list)) {
            settleTaxMny = list.stream().filter(e -> null!=e.getSettlementTaxMny()).map(TemporarySettlementEntity::getSettlementTaxMny)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("settleTaxMny", settleTaxMny);
        logger.info("查询临时设备使用记录使用金额之和，查询结果:{}", jsonObject);
        return CommonResponse.success("查询成功", jsonObject);
    }
}
