package com.ejianc.business.order.service.impl;

import com.ejianc.business.order.bean.RentOrderEntity;
import com.ejianc.business.order.service.IRentOrderService;
import com.ejianc.business.proequipmentcorpout.order.api.IOutCorpOrderApi;
import com.ejianc.business.proequipmentcorpout.order.vo.OutOrderDetailVO;
import com.ejianc.business.proequipmentcorpout.order.vo.OutOrderVO;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.vo.RentContractVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

@Service("rentOrder") 
public class RentOrderBpmServiceImpl implements ICommonBusinessService {
	private final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private IRentOrderService rentOrderService;

	@Autowired
	private IRentContractService rentContractService;

	@Autowired
	private IOutCorpOrderApi outCorpOrderApi;

// 订单接收：/ejc-supbusiness-web/openapi/equipmentOrder/saveOrUpdate
//订单关闭：/ejc-supbusiness-web/openapi/equipmentOrder/updateOrderCloseFlag
//订单撤回：/ejc-supbusiness-web/openapi/equipmentOrder/deleteOrder
	private final String DEL_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/equipmentOrder/deleteOrder";

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		RentOrderEntity orderEntity = rentOrderService.selectById(billId);
		orderEntity.setCommitId(InvocationInfoProxy.getUserid());
		rentOrderService.saveOrUpdate(orderEntity,false);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		RentOrderEntity orderEntity = rentOrderService.selectById(billId);
		RentContractEntity rentContractEntity =rentContractService.getById(orderEntity.getContractId());
		logger.info("调用----{}",rentContractEntity.getRentHarborType());
		if(rentContractEntity.getRentHarborType() ==1){
			return toBillToCorpCenter(orderEntity,state,billTypeCode);
		}else{
			return toBillToSupCenter(orderEntity,state,billTypeCode);
		}
	}

	public CommonResponse<String> toBillToSupCenter(RentOrderEntity orderEntity, Integer state,String billTypeCode){
		//推送供方
		Boolean pushFlag = rentOrderService.pushBillToSupCenter(orderEntity,billTypeCode);
		logger.info("获取推送供方结果--"+pushFlag);
		if(pushFlag){
			//推送成功后处理逻辑
			if(BillStateEnum.COMMITED_STATE.getBillStateCode() == state){
				orderEntity.setCommitId(InvocationInfoProxy.getUserid());
			}
			orderEntity.setReceiveState(0);
			rentOrderService.saveOrUpdate(orderEntity,false);
		}else{
			return CommonResponse.error("推送供方失败");
		}
		return CommonResponse.success();

	}

	/**
	 * 推送设备公司
	 * @param orderEntity
	 * @param state
	 * @param billTypeCode
	 * @return
	 */
	public CommonResponse<String> toBillToCorpCenter(RentOrderEntity orderEntity, Integer state,String billTypeCode){
		//推送设备公司
		Boolean pushFlag = rentOrderService.pushBillToCorpCenter(orderEntity,billTypeCode);
		logger.info("获取推送设备公司结果--"+pushFlag);
		if(pushFlag){
			//推送成功后处理逻辑
			if(BillStateEnum.COMMITED_STATE.getBillStateCode() == state){
				orderEntity.setCommitId(InvocationInfoProxy.getUserid());
			}
			orderEntity.setReceiveState(0);
			
			rentOrderService.saveOrUpdate(orderEntity,false);
		}else{
			return CommonResponse.error("推送设备公司失败");
		}
		return CommonResponse.success();

	}
	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		RentOrderEntity orderEntity = rentOrderService.selectById(billId);
		if ("1".equals(orderEntity.getRentType()) || StringUtils.isBlank(orderEntity.getRentType())){
			OutOrderVO outOrderVO = BeanMapper.map(orderEntity,OutOrderVO.class);
			outOrderVO.setOutOrderDetailList(BeanMapper.mapList(outOrderVO.getOutOrderDetailList(), OutOrderDetailVO.class));
			outCorpOrderApi.deleteOrder(outOrderVO);
		}
		if(orderEntity.getReceiveState()==0){
			return CommonResponse.success();
		}else{
			return CommonResponse.error("该订单已被下游操作，不允许回退!");
		}

	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		RentOrderEntity orderEntity = rentOrderService.selectById(billId);
		if(orderEntity.getRentType().equals("1")){
			//return rentOrderService.updateToCorpCenter(orderEntity,billTypeCode,DEL_BILL_SERVER_URL);

		}else{
			return rentOrderService.updatePushBill(orderEntity,billTypeCode,DEL_BILL_SERVER_URL);
		}
		return CommonResponse.success();

	}

}
