package com.ejianc.business.pricelib.service.impl;

import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.pricelib.bean.RentPriceContractEntity;
import com.ejianc.business.pricelib.bean.RentPriceGuideDetailEntity;
import com.ejianc.business.pricelib.service.IRentPriceContractService;
import com.ejianc.business.pricelib.service.IRentPriceGuideDetailService;
import com.ejianc.business.pricelib.vo.RentPriceContractCollectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pricelib.mapper.RentPriceContractCollectMapper;
import com.ejianc.business.pricelib.bean.RentPriceContractCollectEntity;
import com.ejianc.business.pricelib.service.IRentPriceContractCollectService;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 设备租赁价格库-根据清单id汇总表
 * 
 * @author generator
 * 
 */
@Service("rentPriceContractCollectService")
public class RentPriceContractCollectServiceImpl extends BaseServiceImpl<RentPriceContractCollectMapper, RentPriceContractCollectEntity> implements IRentPriceContractCollectService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRentPriceContractService rentPriceContractService;
    @Autowired
    private IRentPriceGuideDetailService rentPriceGuideDetailService;


    /**
     * 保存价格库内容到历史表
     */
    @Override
    public void savePriceContractToHistoryByTiming() {
        logger.info("---历史价格init开始---");
        //1.先执行全删除操作
        logger.info("---数据全删除操作开始---");
        baseMapper.delPriceContractCollectAll();
        logger.info("---数据插入操作开始---");
        //2.执行数据插入
        //查询价格库中未被移出的数据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("outFlag", new Parameter(QueryParam.EQ, 0));
        queryParam.getParams().put("performanceStatus", new Parameter(QueryParam.IN, Arrays.asList(ContractPerformanceStateEnum.履约中.getStateCode(), ContractPerformanceStateEnum.已终止.getStateCode(), ContractPerformanceStateEnum.已冻结.getStateCode(), ContractPerformanceStateEnum.已结束.getStateCode())));
        List<RentPriceContractEntity> priceContractList = rentPriceContractService.queryList(queryParam);
        if (CollectionUtils.isEmpty(priceContractList)){
            return;
        }
        List<RentPriceContractCollectEntity> priceContractCollectList = new ArrayList<>();

        // 按照档案Id分组
        // 按照档案id + 租赁类型分组
        Map<Long, Map<Integer, List<RentPriceContractEntity>>> priceContractMap = priceContractList.stream()
                .collect(Collectors.groupingBy(RentPriceContractEntity::getDocId, Collectors.groupingBy(RentPriceContractEntity::getRentType)));
        // 汇总信息
        for (Map.Entry<Long, Map<Integer, List<RentPriceContractEntity>>> entry : priceContractMap.entrySet()) {

            Map<Integer, List<RentPriceContractEntity>> rentPriceContractEntityDocMap = entry.getValue();
            for (Map.Entry<Integer, List<RentPriceContractEntity>> rentTypeEntry : rentPriceContractEntityDocMap.entrySet()) {
                List<RentPriceContractEntity> value = rentTypeEntry.getValue();
                List<BigDecimal> priceList = value.stream().map(RentPriceContractEntity::getContractPrice).collect(Collectors.toList());
                List<BigDecimal> taxPriceList = value.stream().map(RentPriceContractEntity::getContractTaxPrice).collect(Collectors.toList());

                RentPriceContractEntity priceContract = value.get(0);
                if (priceContract == null) continue;
                // 合同最高价(无税)
                BigDecimal maxPrice = Collections.max(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
                // 合同最低价(无税)
                BigDecimal minPrice = Collections.min(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
                String priceArea = minPrice + "-" + maxPrice; // 合同价格区间（无税）
                // 合同最高价（含税）
                BigDecimal taxMaxPrice = Collections.max(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
                // 合同最低价（含税）
                BigDecimal taxMinPrice = Collections.min(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
                String taxPriceArea = taxMinPrice + "-" + taxMaxPrice; // 合同价格区间（含税）

                // 基础字段赋值
                RentPriceContractCollectEntity rentPriceContractCollectEntity;
                rentPriceContractCollectEntity = new RentPriceContractCollectEntity();
                rentPriceContractCollectEntity.setDocId(priceContract.getDocId());
                rentPriceContractCollectEntity.setDocCode(priceContract.getDocCode());
                rentPriceContractCollectEntity.setDocName(priceContract.getDocName());
                rentPriceContractCollectEntity.setDocCategoryId(priceContract.getDocCategoryId());
                rentPriceContractCollectEntity.setDocCategoryName(priceContract.getDocCategoryName());
                rentPriceContractCollectEntity.setDocInnerCode(priceContract.getDocInnerCode());
                rentPriceContractCollectEntity.setUnitId(priceContract.getUnitId());
                rentPriceContractCollectEntity.setUnitName(priceContract.getUnitName());
                rentPriceContractCollectEntity.setPriceTypeName(priceContract.getPriceTypeName());
                rentPriceContractCollectEntity.setEquipmentHeight(priceContract.getEquipmentHeight());
                rentPriceContractCollectEntity.setRentType(priceContract.getRentType());
                rentPriceContractCollectEntity.setContractMaxPrice(maxPrice);
                rentPriceContractCollectEntity.setContractMinPrice(minPrice);
                rentPriceContractCollectEntity.setContractPriceArea(priceArea);
                rentPriceContractCollectEntity.setContractTaxMaxPrice(taxMaxPrice);
                rentPriceContractCollectEntity.setContractTaxMinPrice(taxMinPrice);
                rentPriceContractCollectEntity.setContractTaxPriceArea(taxPriceArea);
                priceContractCollectList.add(rentPriceContractCollectEntity);
            }

        }

        logger.info("保存数据大小{}条",priceContractCollectList.size());
        super.saveOrUpdateBatch(priceContractCollectList);
        logger.info("---数据插入操作结束---");
    }

    /**
     * 根据档案id查询多个合同清单历史价格 和  指导价
     * @param docIds
     * @return
     */
    @Override
    public List<RentPriceContractCollectVO> getPriceContractByDocIds(List<Long> docIds, Integer rentType) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("docId", new Parameter(QueryParam.IN, docIds));
        queryParam.getParams().put("rentType", new Parameter(QueryParam.EQ, rentType));
        List<RentPriceContractCollectVO> priceContractCollectVOList = BeanMapper.mapList(super.queryList(queryParam), RentPriceContractCollectVO.class);
        //设置指导价
        List<RentPriceContractCollectVO> guideDetailList = this.getGuidePriceAreaByDocIds(docIds);
        if (CollectionUtils.isNotEmpty(guideDetailList)){
            Map<Long, RentPriceContractCollectVO> guidePriceMap = guideDetailList.stream().collect(Collectors.toMap(RentPriceContractCollectVO::getDocId, Function.identity(), (key1, key2) -> key2));
            if (CollectionUtils.isNotEmpty(priceContractCollectVOList)){
                for (RentPriceContractCollectVO rentPriceContractCollectVO : priceContractCollectVOList) {
                    if (guidePriceMap.containsKey(rentPriceContractCollectVO.getDocId())){
                        rentPriceContractCollectVO.setGuidePriceArea(guidePriceMap.get(rentPriceContractCollectVO.getDocId()).getGuidePriceArea());
                        rentPriceContractCollectVO.setGuideTaxPriceArea(guidePriceMap.get(rentPriceContractCollectVO.getDocId()).getGuideTaxPriceArea());
                        guidePriceMap.remove(rentPriceContractCollectVO.getDocId());
                    }
                }
            }
            if (guidePriceMap != null){
                guidePriceMap.keySet().stream().forEach(key -> {
                    RentPriceContractCollectVO rentPriceContractCollectVO = new RentPriceContractCollectVO();
                    rentPriceContractCollectVO.setDocId(guidePriceMap.get(key).getDocId());
                    rentPriceContractCollectVO.setGuidePriceArea(guidePriceMap.get(key).getGuidePriceArea());
                    rentPriceContractCollectVO.setGuideTaxPriceArea(guidePriceMap.get(key).getGuideTaxPriceArea());
                    priceContractCollectVOList.add(rentPriceContractCollectVO);
                });
            }
        }
        return priceContractCollectVOList;
    }

    @Override
    public List<RentPriceContractCollectVO> getGuidePriceAreaByDocIds(List<Long> docIds) {
        List<RentPriceGuideDetailEntity> list = rentPriceGuideDetailService.queryPriceGuideDetailByDocIds(docIds);
        List<RentPriceContractCollectVO> PriceContractCollectVOList = new ArrayList<>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(list)){
            for (RentPriceGuideDetailEntity guide : list) {
                RentPriceContractCollectVO rentPriceContractCollectVO = new RentPriceContractCollectVO();
                BigDecimal min = guide.getMinPrice() == null ? BigDecimal.ZERO : guide.getMinPrice();
                BigDecimal max = guide.getMaxPrice() == null ? BigDecimal.ZERO : guide.getMaxPrice();
                min = min.divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
                max = max.divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
                rentPriceContractCollectVO.setGuidePriceArea(min + "-" + max);
                min = guide.getMinTaxPrice() == null ? BigDecimal.ZERO : guide.getMinTaxPrice();
                max = guide.getMaxTaxPrice() == null ? BigDecimal.ZERO : guide.getMaxTaxPrice();
                min = min.divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
                max = max.divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
                rentPriceContractCollectVO.setGuideTaxPriceArea(min + "-" + max);
                rentPriceContractCollectVO.setDocId(guide.getDocId());
                PriceContractCollectVOList.add(rentPriceContractCollectVO);
            }
        }
        return PriceContractCollectVOList;
    }
}
