package com.ejianc.business.rent.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 租赁合同变更日租明细
 *
 * @author generator
 *
 */
@TableName("ejc_proequipment_rent_change_day_detailed")
public class RentChangeDayDetailedEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 设备名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="day_factory_code")
    private String dayFactoryCode; // 设备出厂编号
    @TableField(value="category_id")
    private Long categoryId; // 设备类别id
    @TableField(value="category_name")
    private String categoryName; // 设备类别名称
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="unit_name")
    private String unitName; // 单位
    @TableField(value="day_rent_price")
    private BigDecimal dayRentPrice; // 日租单价
    @TableField(value="stop_rent_price")
    private BigDecimal stopRentPrice; // 停租单价
    @TableField(value="rent_num")
    private Integer rentNum; // 租赁数量
    @TableField(value="tax")
    private BigDecimal tax; // 税率
    @TableField(value="day_rent_not_tax_price")
    private BigDecimal dayRentNotTaxPrice; // 日租单价(无税)
    @TableField(value="stop_rent_not_tax_price")
    private BigDecimal stopRentNotTaxPrice; // 停租单价(无税)
    @TableField(value="plan_into_date")
    private Date planIntoDate; // 计划进程日期
    @TableField(value="plan_out_date")
    private Date planOutDate; // 计划出场日期
    @TableField(value="production_manufactor")
    private String productionManufactor; // 生产厂家
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="equipment_code")
    private String equipmentCode; // 设备编号
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="change_id")
    private Long changeId; // 变更id
    @TableField(value="src_tbl_id")
    private Long srcTblId; // 来源子表主键
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 含税金额
    @TableField(value="before_day_rent_price")
    private BigDecimal beforeDayRentPrice; // 变更前日租单价
    @TableField(value="before_stop_rent_price")
    private BigDecimal beforeStopRentPrice; // 变更前停租单价
    @TableField(value="before_rent_num")
    private Integer beforeRentNum; // 租赁数量
    @TableField(value="before_tax")
    private BigDecimal beforeTax; // 变更前税率

    @TableField(value="equipment_id")//设备id
    private Long equipmentId;

    @TableField(value="source_id")
    private Long sourceId;
    @TableField(value="contrast_flag")
    private Boolean contrastFlag;
    @TableField(value="rent_day")
    private BigDecimal rentDay; // 租赁天数
    @TableField(value="rent_mny")
    private BigDecimal rentMny; // 租赁金额(无税)
    @TableField(value="rent_tax_mny")
    private BigDecimal rentTaxMny; // 租赁金额(含税)
    @TableField(value="tax_money")
    private BigDecimal taxMoney; // 税额
    @TableField(value="change_type")
    private String changeType; // 变更类型
    @TableField(value="target_unit_tax_price")
    private BigDecimal targetUnitTaxPrice; //定标单价

    @TableField(value="history_price_area")
    private String historyPriceArea;//历史价格区间（无税）
    @TableField(value="history_tax_price_area")
    private String historyTaxPriceArea;//历史价格区间（含税）
    @TableField(value="guide_price_area")
    private String guidePriceArea; // 公司指导价区间（无税）
    @TableField(value="guide_tax_price_area")
    private String guideTaxPriceArea; // 公司指导价区间（含税）
    @TableField(value="flag_oil")
    private Integer flagOil; // 是否含油 (1:是，0：否)
    @TableField(value="flag_operation")
    private Integer flagOperation; // 是否含操作手(1:是，0：否)
    @TableField(value="detail_measurement_rules")
    private String detailMeasurementRules;//计量规则

    @TableField(value="job_content")
    private String jobContent;//工作内容

    public String getDetailMeasurementRules() {
        return detailMeasurementRules;
    }

    public void setDetailMeasurementRules(String detailMeasurementRules) {
        this.detailMeasurementRules = detailMeasurementRules;
    }

    public String getJobContent() {
        return jobContent;
    }

    public void setJobContent(String jobContent) {
        this.jobContent = jobContent;
    }
    public Integer getFlagOil() {
        return flagOil;
    }

    public void setFlagOil(Integer flagOil) {
        this.flagOil = flagOil;
    }

    public Integer getFlagOperation() {
        return flagOperation;
    }

    public void setFlagOperation(Integer flagOperation) {
        this.flagOperation = flagOperation;
    }

    public BigDecimal getTargetUnitTaxPrice() {
        return targetUnitTaxPrice;
    }

    public void setTargetUnitTaxPrice(BigDecimal targetUnitTaxPrice) {
        this.targetUnitTaxPrice = targetUnitTaxPrice;
    }
    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public BigDecimal getRentDay() {
        return rentDay;
    }

    public void setRentDay(BigDecimal rentDay) {
        this.rentDay = rentDay;
    }

    public BigDecimal getRentMny() {
        return rentMny;
    }

    public void setRentMny(BigDecimal rentMny) {
        this.rentMny = rentMny;
    }

    public BigDecimal getRentTaxMny() {
        return rentTaxMny;
    }

    public void setRentTaxMny(BigDecimal rentTaxMny) {
        this.rentTaxMny = rentTaxMny;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getDayFactoryCode() {
        return dayFactoryCode;
    }

    public void setDayFactoryCode(String dayFactoryCode) {
        this.dayFactoryCode = dayFactoryCode;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getDayRentPrice() {
        return dayRentPrice;
    }

    public void setDayRentPrice(BigDecimal dayRentPrice) {
        this.dayRentPrice = dayRentPrice;
    }
    public BigDecimal getStopRentPrice() {
        return stopRentPrice;
    }

    public void setStopRentPrice(BigDecimal stopRentPrice) {
        this.stopRentPrice = stopRentPrice;
    }
    public Integer getRentNum() {
        return rentNum;
    }

    public void setRentNum(Integer rentNum) {
        this.rentNum = rentNum;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public BigDecimal getDayRentNotTaxPrice() {
        return dayRentNotTaxPrice;
    }

    public void setDayRentNotTaxPrice(BigDecimal dayRentNotTaxPrice) {
        this.dayRentNotTaxPrice = dayRentNotTaxPrice;
    }
    public BigDecimal getStopRentNotTaxPrice() {
        return stopRentNotTaxPrice;
    }

    public void setStopRentNotTaxPrice(BigDecimal stopRentNotTaxPrice) {
        this.stopRentNotTaxPrice = stopRentNotTaxPrice;
    }
    public Date getPlanIntoDate() {
        return planIntoDate;
    }

    public void setPlanIntoDate(Date planIntoDate) {
        this.planIntoDate = planIntoDate;
    }
    public Date getPlanOutDate() {
        return planOutDate;
    }

    public void setPlanOutDate(Date planOutDate) {
        this.planOutDate = planOutDate;
    }
    public String getProductionManufactor() {
        return productionManufactor;
    }

    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Long getSrcTblId() {
        return srcTblId;
    }

    public void setSrcTblId(Long srcTblId) {
        this.srcTblId = srcTblId;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getBeforeDayRentPrice() {
        return beforeDayRentPrice;
    }

    public void setBeforeDayRentPrice(BigDecimal beforeDayRentPrice) {
        this.beforeDayRentPrice = beforeDayRentPrice;
    }
    public BigDecimal getBeforeStopRentPrice() {
        return beforeStopRentPrice;
    }

    public void setBeforeStopRentPrice(BigDecimal beforeStopRentPrice) {
        this.beforeStopRentPrice = beforeStopRentPrice;
    }
    public Integer getBeforeRentNum() {
        return beforeRentNum;
    }

    public void setBeforeRentNum(Integer beforeRentNum) {
        this.beforeRentNum = beforeRentNum;
    }
    public BigDecimal getBeforeTax() {
        return beforeTax;
    }

    public void setBeforeTax(BigDecimal beforeTax) {
        this.beforeTax = beforeTax;
    }

    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Boolean getContrastFlag() {
        return contrastFlag;
    }

    public void setContrastFlag(Boolean contrastFlag) {
        this.contrastFlag = contrastFlag;
    }

    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }
}
