package com.ejianc.business.rent.controller;

import java.io.Serializable;

import com.ejianc.business.rent.bean.RentChangeTotalPlanSubEntity;
import com.ejianc.business.rent.bean.RentTotalPlanEntity;
import com.ejianc.business.rent.service.IRentTotalPlanService;
import com.ejianc.business.rent.vo.RentChangeTotalPlanSubVO;
import com.ejianc.business.rent.vo.RentTotalPlanSubVO;
import com.ejianc.business.rent.vo.RentTotalPlanVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.rent.bean.RentChangeTotalPlanEntity;
import com.ejianc.business.rent.service.IRentChangeTotalPlanService;
import com.ejianc.business.rent.vo.RentChangeTotalPlanVO;

/**
 * 租赁设备总计划便更主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rentChangeTotalPlan")
public class RentChangeTotalPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IRentChangeTotalPlanService service;

    @Autowired
    private IRentTotalPlanService totalPlanService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentChangeTotalPlanVO> saveOrUpdate(@RequestBody RentChangeTotalPlanVO saveOrUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！",service.insertOrUpdate(saveOrUpdateVO,false));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentChangeTotalPlanVO> queryDetail(Long id) {
    	return CommonResponse.success("查询详情数据成功！",service.queryDetail(id));
    }
    /**
     * 变更历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryChangeHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RentChangeTotalPlanVO>> queryChangeHistory(@RequestParam Long id) {
        List<RentChangeTotalPlanVO> vo = service.queryChangeHistory(id);
        return CommonResponse.success(vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentChangeTotalPlanVO> vos) {

        if(vos.size() ==1){

            RentChangeTotalPlanVO vo =vos.get(0);
            RentChangeTotalPlanEntity totalPlanEntity =service.selectById(vo.getId());
            if(totalPlanEntity.getChangeStatus().equals(1)){
                service.delete(totalPlanEntity);
            }
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RentChangeTotalPlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<RentChangeTotalPlanEntity> page = service.queryPage(param,false);
        IPage<RentChangeTotalPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentChangeTotalPlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<RentChangeTotalPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("RentChangeTotalPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRentChangeTotalPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentChangeTotalPlanVO>> refRentChangeTotalPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<RentChangeTotalPlanEntity> page = service.queryPage(param,false);
        IPage<RentChangeTotalPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentChangeTotalPlanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description queryDetail 查询详情
     * @param planId
     */
    @RequestMapping(value = "/queryPlanDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentTotalPlanVO> queryPlanDetail(Long planId) {
        RentTotalPlanEntity entity = totalPlanService.selectById(planId);
        RentTotalPlanVO vo = BeanMapper.map(entity, RentTotalPlanVO.class);
        vo.setPlanMny(entity.getTemporaryAmount());
        vo.setMemo(null);
        vo.setPlanCode(entity.getCode());
        BigDecimal totalAmount = new BigDecimal(0);

        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entity.getTotalPlanSubList())){
            for (RentTotalPlanSubVO sub :vo.getTotalPlanSubList()){
                sub.setSubDetailId(sub.getId());
                totalAmount = totalAmount.add(sub.getTemporaryAmount());
                vo.setBaseMny(totalAmount);
            }
            vo.setTotalPlanSubList(TreeNodeBUtil.buildTree(vo.getTotalPlanSubList()));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody RentChangeTotalPlanVO totalPlanVO) {
        return CommonResponse.success("参数校验成功！", service.targetCostCtrl(totalPlanVO));
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("参数校验成功！", service.viewTargetCostCtrlInfo(id));
    }
}
