package com.ejianc.business.rent.controller;

import java.io.Serializable;

import com.ejianc.business.pricelib.service.IRentPriceContractCollectService;
import com.ejianc.business.pricelib.vo.RentPriceContractCollectVO;
import com.ejianc.business.rent.bean.RentEquipmentPlanSubEntity;
import com.ejianc.business.rent.service.IRentEquipmentPlanSubService;
import com.ejianc.business.rent.vo.RentEquipmentPlanSubVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.business.rent.bean.RentEquipmentPlanEntity;
import com.ejianc.business.rent.service.IRentEquipmentPlanService;
import com.ejianc.business.rent.vo.RentEquipmentPlanVO;

/**
 * 租赁设备租赁计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rentEquipmentPlan")
public class RentEquipmentPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "RENT_EQUIPMENT_PLAN";//此处需要根据实际修改

    @Autowired
    private IRentEquipmentPlanService service;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRentEquipmentPlanSubService rentEquipmentPlanSubService;
    @Autowired
    private IRentPriceContractCollectService rentPriceContractCollectService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentEquipmentPlanVO> saveOrUpdate(@RequestBody RentEquipmentPlanVO saveOrUpdateVO) {
    	RentEquipmentPlanEntity entity = BeanMapper.map(saveOrUpdateVO, RentEquipmentPlanEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	RentEquipmentPlanVO vo = BeanMapper.map(entity, RentEquipmentPlanVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentEquipmentPlanVO> queryDetail(Long id) {
    	RentEquipmentPlanEntity entity = service.selectById(id);
    	RentEquipmentPlanVO vo = BeanMapper.map(entity, RentEquipmentPlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentEquipmentPlanVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (RentEquipmentPlanVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(RentEquipmentPlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RentEquipmentPlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });

        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("companyId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<RentEquipmentPlanEntity> page = service.queryPage(param,false);
        IPage<RentEquipmentPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentEquipmentPlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("code");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<RentEquipmentPlanEntity> list = service.queryList(param);
        List<RentEquipmentPlanVO> voList = new ArrayList<>();
        if(list.size()>0){
            voList = BeanMapper.mapList(list,RentEquipmentPlanVO.class);
            for (RentEquipmentPlanVO vo: voList){
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("rentEquipmentPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRentEquipmentPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentEquipmentPlanSubVO>> refRentEquipmentPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Long projectId = null;
        /** 租户隔离 */
        List<RentEquipmentPlanEntity> list = new ArrayList<>();

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            QueryParam params = new QueryParam();
            params.getParams().put("projectId",new Parameter(QueryParam.EQ,projectId));
            list =service.queryList(params);
            param.getParams().put("leafFlag",new Parameter(QueryParam.EQ,false));
            param.getParams().put("pid",new Parameter(QueryParam.IN,list.stream().map(RentEquipmentPlanEntity::getId).collect(Collectors.toList())));
        }

        IPage<RentEquipmentPlanSubEntity> page = rentEquipmentPlanSubService.queryPage(param,false);
        IPage<RentEquipmentPlanSubVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentEquipmentPlanSubVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRentPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentEquipmentPlanVO>> refRentPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                     String condition,
                                                     String searchObject,
                                                     String searchText) {
        QueryParam params = new QueryParam();
        params.setPageSize(pageSize);
        params.setPageIndex(pageNumber);
        params.setSearchText(searchText);
        params.setSearchObject(searchObject);
        /** 租户隔离 */
        Long projectId = null;
        Long orgId = null;
        Integer rentType = null;
        params.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            projectId = _con.getLong("projectId");
            orgId = _con.getLong("orgId");
            rentType = _con.getInteger("rentType");
        }
        params.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        params.getParams().put("biddingState", new Parameter(QueryParam.EQ, 1));
        if (rentType != null){
//            params.getComplexParams().add(getPageQueryParam(rentType));
            params.getParams().put("rentType", new Parameter(QueryParam.SQL, " (rent_type="+rentType+" or rent_type is null) "));
        }
        if (projectId != null) {
//            params.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            CommonResponse<List<Long>> projectResponse = projectPoolApi.queryProjectIdsByParentProjectId(projectId);
            if (!projectResponse.isSuccess()) {
                throw new BusinessException("查询项目信息失败！");
            }
            params.getParams().put("projectId", new Parameter(QueryParam.IN, projectResponse.getData()));
        }
        if (orgId !=null){
            CommonResponse<OrgVO> orgResp = iOrgApi.getOneById(orgId);
            OrgVO orgVO = orgResp.getData();
            /** 数据隔离，如果查询组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                params.getParams().put("companyId", new Parameter(QueryParam.EQ, orgId));
            }
            else {
                params.getParams().put("companyId", new Parameter(QueryParam.IN, iOrgApi
                        .findChildrenByParentIdWithoutProjectDept(orgId).getData().stream().map(OrgVO::getId)
                        .collect(Collectors.toList())));
            }
        }

        IPage<RentEquipmentPlanEntity> page = service.queryPage(params, false);
        IPage<RentEquipmentPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentEquipmentPlanVO.class));
        // 查询采购清单
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<RentEquipmentPlanVO> batPlanVOList = pageData.getRecords();
            for (RentEquipmentPlanVO rentEquipmentPlanVO : batPlanVOList){
                if(rentEquipmentPlanVO.getRentType() != null && rentEquipmentPlanVO.getRentType() == 0){
                    rentEquipmentPlanVO.setRentTypeName("日租");
                }
                if(rentEquipmentPlanVO.getRentType() != null && rentEquipmentPlanVO.getRentType() == 1){
                    rentEquipmentPlanVO.setRentTypeName("月租");
                }
                if(rentEquipmentPlanVO.getRentType() != null && rentEquipmentPlanVO.getRentType() == 2){
                    rentEquipmentPlanVO.setRentTypeName("工程量租");
                }

            }
            List<String> idList = batPlanVOList.stream().map(RentEquipmentPlanVO::getId).map(String::valueOf)
                    .collect(Collectors.toList());
            // 查询子表
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("pid", new Parameter(QueryParam.IN, idList));
            detailParam.getParams().put("equipment_id",new Parameter(QueryParam.NE,null));
            List<RentEquipmentPlanSubEntity> detailEntityList = rentEquipmentPlanSubService.queryList(detailParam);
            List<RentEquipmentPlanSubVO> detailVOList = BeanMapper.mapList(detailEntityList, RentEquipmentPlanSubVO.class);
            Map<Long, List<RentEquipmentPlanSubVO>> detailMap = new HashMap<>();
            List<RentEquipmentPlanSubVO> mapList;
            // 按照planID对子表结果分组
            for (RentEquipmentPlanSubVO vo : detailVOList) {
                if (detailMap.containsKey(vo.getPid())) {
                    detailMap.get(vo.getPid()).add(vo);
                }
                else {
                    mapList = new ArrayList<>();
                    mapList.add(vo);
                    detailMap.put(vo.getPid(), mapList);
                }
            }
            // 将采购计划清单添加到采购计划中
            batPlanVOList.forEach(batPlanVO -> {
                batPlanVO.setRentEquipmentPlanSubList(detailMap.get(batPlanVO.getId()));
            });
        }
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    public ComplexParam getPageQueryParam(Integer rentType) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("rentType", new Parameter(QueryParam.EQ, rentType));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("rentType", new Parameter(QueryParam.EQ, null));
        c1.getComplexParams().add(c3);
        return c1;
    }

    /**
     * @Description 参照-合同
     * @Return void
     */
    @RequestMapping(value = "/refRentEquipmentPlanContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentEquipmentPlanSubVO>> refRentEquipmentPlanContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                  String condition,
                                                                                          @RequestParam(required = false) String relyCondition,
                                                                                  String searchObject,
                                                                                  String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        List<RentEquipmentPlanEntity> list = new ArrayList<>();
        Long id = null;

        if (StringUtils.isNotEmpty(relyCondition)) {
            id = Long.parseLong(relyCondition.split("=")[1]);
        }
        logger.info("#############{}",id);

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(id != null){
            param.getParams().put("pid", new Parameter(QueryParam.EQ, id));
        }

        IPage<RentEquipmentPlanSubEntity> page = rentEquipmentPlanSubService.queryPage(param,false);
        IPage<RentEquipmentPlanSubVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentEquipmentPlanSubVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }


    /**
     * 单据管控
     * @return
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody RentEquipmentPlanVO vo) {
        ParamsCheckVO paramsCheckVO = service.checkParams(vo);
        return CommonResponse.success("参数校验成功！",paramsCheckVO );
    }
}
