package com.ejianc.business.rent.mapper;

import com.ejianc.business.rent.vo.EquipmentNewDateVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.rent.bean.RentParameterEntity;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 租赁设备台账
 * 
 * @author generator
 * 
 */
@Mapper
public interface RentParameterMapper extends BaseCrudMapper<RentParameterEntity> {
    /**
     * 验证最新日期
     * @param tenantId
     * @param contractId
     * @param myDate
     * @return
     */
    public List<EquipmentNewDateVO> queryNewDate(@Param("tenantId") Long tenantId, @Param("contractId") Long contractId, @Param("myDate") Date myDate);

    /**
     * 提供子表验证最新日期
     * @param tenantId
     * @param contractId
     * @return
     */
    public List<EquipmentNewDateVO> queryNewDateList(@Param("tenantId") Long tenantId, @Param("contractId") Long contractId);
}
