package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.rent.bean.RentTotalPlanEntity;
import com.ejianc.business.rent.service.IRentTotalPlanService;
import com.ejianc.business.rent.vo.RentEquipmentPlanVO;
import com.ejianc.business.rent.vo.RentPlanEnum;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.business.common.util.MathUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.rent.mapper.RentEquipmentPlanMapper;
import com.ejianc.business.rent.bean.RentEquipmentPlanEntity;
import com.ejianc.business.rent.service.IRentEquipmentPlanService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 租赁设备租赁计划
 *
 * @author generator
 *
 */
@Service("rentEquipmentPlanService")
public class RentEquipmentPlanServiceImpl extends BaseServiceImpl<RentEquipmentPlanMapper, RentEquipmentPlanEntity> implements IRentEquipmentPlanService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentTotalPlanService rentTotalPlanService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String PLAN_MNY_PARAM_CODE = "P-06b7t60241";//【总计划金额】控【批次计划金额】

    @Override
    public void updateBatPlanByQuoteType(List<String> idList, Integer planState) {
        if (StringUtils.isEmpty(RentPlanEnum.getDescriptionByStateCode(planState))) {
            throw new BusinessException("计划状态错误");
        }
        // 批量更改
        if (CollectionUtils.isNotEmpty(idList)) {
            List<RentEquipmentPlanEntity> entityList = (List<RentEquipmentPlanEntity>) super.listByIds(idList);
            if (CollectionUtils.isNotEmpty(entityList)) {
                for (RentEquipmentPlanEntity entity : entityList) {
                    // 采购完成不允许做其他操作
                    if (RentPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getBiddingState())) {
                        throw new BusinessException("采购计划编码【" + entity.getCode() + "】已采购完成！");
                    }
                    entity.setBiddingState(planState);
                }
                super.saveOrUpdateBatch(entityList);
            }
        }
    }

    /**
     * 参数控制
     * @param vo
     * @return
     */
    @Override
    public ParamsCheckVO checkParams(RentEquipmentPlanVO vo) {

        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        paramsCheckVOS.addAll(this.checkParamsByMasterPlanMny(vo));//总计划控制批次计划金额

        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }


    /**
     * 单据管控-批次计划金额大于总计划金额
     *
     * @return
     */
    public List<ParamsCheckVO> checkParamsByMasterPlanMny(RentEquipmentPlanVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();

        BigDecimal temporaryMoney = vo.getTemporaryAmount();//本次批次计划金额
        BigDecimal planTaxMny;//总计划金额
        BigDecimal totalMoney = temporaryMoney;//累计批次计划金额  默认赋值本次
        //查询总计划
        LambdaQueryWrapper<RentTotalPlanEntity> planLambda = new LambdaQueryWrapper<>();
        planLambda.eq(RentTotalPlanEntity::getProjectId, vo.getProjectId());
        planLambda.in(RentTotalPlanEntity::getBillState, 1, 3);
        planLambda.eq(RentTotalPlanEntity::getDr, 0);
        List<RentTotalPlanEntity> planList = rentTotalPlanService.list(planLambda);
        if (CollectionUtils.isNotEmpty(planList)) {
            planTaxMny = planList.stream().filter(e -> null != e.getTemporaryAmount()).map(RentTotalPlanEntity::getTemporaryAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        } else {
            return paramsCheckVOS;
        }
        //查询批次计划
        LambdaQueryWrapper<RentEquipmentPlanEntity> Lambda = new LambdaQueryWrapper<>();
        Lambda.eq(RentEquipmentPlanEntity::getProjectId, vo.getProjectId());
        Lambda.in(RentEquipmentPlanEntity::getBillState, 1, 3);
        List<RentEquipmentPlanEntity> list = super.list(Lambda);//查询项目下所有批次计划
        if (CollectionUtils.isNotEmpty(list)) {
            for (RentEquipmentPlanEntity batchPlanEntity : list) {
                totalMoney = MathUtil.safeAdd(totalMoney, batchPlanEntity.getTemporaryAmount());
            }
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PLAN_MNY_PARAM_CODE, vo.getOrgId());

        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("总计划金额控制批次计划金额信息返回："+ JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(planTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("批次计划金额超总计划金额");
                        paramsCheckDsVO.setWarnName("累计批次计划金额大于总计划金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次批次计划金额：").append(temporaryMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计批次计划金额：").append(totalMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，总计划金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalMoney, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        }
        else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOS;
    }
}
