package com.ejianc.business.settle.controller.api;

import com.ejianc.business.settle.mapper.SettleMapper;
import com.ejianc.business.settle.vo.SourceBliVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping
public class SettleApiController {
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SettleMapper settleMapper;

    /**
     * 设备管理：
     * 1、累计单据数量：查该供应商在本下项目生效的  设备租赁验收单、设备租赁结算单数量
     * 2、协同单据数量：查该供应商在本下项目生效的  设备租赁验收单（订单）、设备租赁结算单数量（已签字）；
     * 3、比例：协同单据数量/累计单据数量；
     * @param supplierId
     * @param dateIn
     * @return
     */
    @GetMapping(value = "/api/settle/getSourceBliVO")
    @ResponseBody
    CommonResponse<SourceBliVO> getSourceBliVO(@RequestParam(value = "supplierId") Long supplierId, @RequestParam(value = "dateIn",required = false) String dateIn){
        List<Long> orgIds =
                iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        SourceBliVO vo= settleMapper.getSourceBliVO(supplierId,orgIds,dateIn);
        return CommonResponse.success("查询成功", vo);
    }
}
