package com.ejianc.business.temporary.settlement.service;

import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.temporary.settlement.vo.TemporarySettlementVO;
import com.ejianc.business.temporary.userecord.vo.TemporaryUseRecordVO;
import com.ejianc.business.userecord.bean.UseRecordEntity;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.temporary.settlement.bean.TemporarySettlementEntity;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 临时设备结算主表
 *
 * @author generator
 *
 */
public interface ITemporarySettlementService extends IBaseService<TemporarySettlementEntity> {
    TemporarySettlementVO saveOrUpdate(TemporarySettlementVO saveOrUpdateVO);
    void delete(List<TemporarySettlementVO> vos);
    CommonResponse<Map> getDateMny(Long contractId);
    boolean pushSettleToPool(TemporarySettlementVO vo);
    boolean delSettleFromPool(Long id);
    ExecutionVO targetCost(TemporarySettlementEntity temporarySettlementEntity);
    CommonResponse<TemporarySettlementVO> pushCost(TemporarySettlementVO temporarySettlementVO);
    void costPush(TemporarySettlementEntity temporarySettlementVO);
    boolean pushBillToSupCenter(TemporarySettlementEntity entity, String billTypeCode);
    CommonResponse<String> updatePushBill(TemporarySettlementEntity entity, String billTypeCode);
    String updateBillSupSignSyncInfo(HttpServletRequest request);
    CommonResponse<String> pushTargetCost(Long id);
    /*
     * 参数控制合并方法*/
    ParamsCheckVO checkParams(TemporarySettlementVO vo);
    /*
     * 单次临时设备租赁结算金额控制*/
    List<ParamsCheckVO> checkParamsMny(TemporarySettlementVO vo);
    /*
     * 单个供应商临时设备租赁金额控制*/
    List<ParamsCheckVO> checkParamsSupplierMny(TemporarySettlementVO vo);
    /*
     * 【施工合同金额】控【无合同结算、零星机械金额】*/
    List<ParamsCheckVO> checkParamsConstruction(TemporarySettlementVO vo);

    CommonResponse<String> pushSettleToCost(TemporarySettlementVO temporarySettlementVO);

    ExecutionVO settleCost(TemporarySettlementVO settleVO, String linkUrl);
}
