/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.rent.bean.RentChangeTotalPlanEntity;
import com.ejianc.business.rent.bean.RentChangeTotalPlanSubEntity;
import com.ejianc.business.rent.bean.RentTotalPlanEntity;
import com.ejianc.business.rent.mapper.RentChangeTotalPlanMapper;
import com.ejianc.business.rent.service.IRentChangeTotalPlanService;
import com.ejianc.business.rent.service.IRentChangeTotalPlanSubService;
import com.ejianc.business.rent.service.IRentTotalPlanService;
import com.ejianc.business.rent.vo.RentChangeTotalPlanSubVO;
import com.ejianc.business.rent.vo.RentChangeTotalPlanVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="rentChangeTotalPlanService")
public class RentChangeTotalPlanServiceImpl
extends BaseServiceImpl<RentChangeTotalPlanMapper, RentChangeTotalPlanEntity>
implements IRentChangeTotalPlanService {
    @Autowired
    private IRentChangeTotalPlanSubService rentChangeTotalPlanSubService;
    @Autowired
    private IRentTotalPlanService rentTotalPlanService;
    @Autowired
    private IRentTotalPlanService totalPlanService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IRentChangeTotalPlanService service;

    @Override
    public RentChangeTotalPlanVO insertOrUpdate(RentChangeTotalPlanVO saveOrUpdateVO, Boolean isControl) {
        RentChangeTotalPlanEntity entity = (RentChangeTotalPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, RentChangeTotalPlanEntity.class));
        if (!isControl.booleanValue()) {
            if (entity.getId() == null || entity.getId() == 0L) {
                for (RentChangeTotalPlanSubEntity sub : entity.getTotalPlanSubList()) {
                    sub.setId(null);
                    sub.setRowState("add");
                }
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            this.service.saveOrUpdates(entity);
        }
        RentChangeTotalPlanVO vo = (RentChangeTotalPlanVO)BeanMapper.map((Object)((Object)entity), RentChangeTotalPlanVO.class);
        if (!isControl.booleanValue()) {
            vo.setTotalPlanSubList(TreeNodeBUtil.buildTree((List)vo.getTotalPlanSubList()));
        }
        if (null == vo.getId() && isControl.booleanValue()) {
            vo.setId(Long.valueOf(IdWorker.getId()));
            List totalPlanSubList = vo.getTotalPlanSubList();
            for (RentChangeTotalPlanSubVO rentTotalPlanSubVO : totalPlanSubList) {
                if (rentTotalPlanSubVO.getId() != null) continue;
                rentTotalPlanSubVO.setId(Long.valueOf(IdWorker.getId()));
            }
        }
        return vo;
    }

    @Override
    public RentChangeTotalPlanVO queryDetail(Long id) {
        RentChangeTotalPlanEntity entity = (RentChangeTotalPlanEntity)((Object)this.service.selectById(id));
        RentChangeTotalPlanVO vo = (RentChangeTotalPlanVO)BeanMapper.map((Object)((Object)entity), RentChangeTotalPlanVO.class);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entity.getTotalPlanSubList())) {
            vo.setTotalPlanSubList(TreeNodeBUtil.buildTree((List)vo.getTotalPlanSubList()));
        }
        return vo;
    }

    @Override
    public List<RentChangeTotalPlanVO> queryChangeHistory(Long id) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        List changeEntities = ((RentChangeTotalPlanMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"total_id", (Object)id)).in((Object)"bill_state", billStatus)).orderByDesc((Object)"change_date"));
        if (null != changeEntities && changeEntities.size() > 0) {
            List changeVos = BeanMapper.mapList((Iterable)changeEntities, RentChangeTotalPlanVO.class);
            for (RentChangeTotalPlanVO cvo : changeVos) {
                String historyBillCode = cvo.getCode() + "-" + cvo.getChangeVersion();
                cvo.setHistoryBillCode(historyBillCode);
            }
            return changeVos;
        }
        return null;
    }

    @Override
    @Transactional
    public void saveOrUpdates(RentChangeTotalPlanEntity entity) {
        ExecutionVO executionVO1;
        if (CollectionUtils.isNotEmpty(entity.getTotalPlanSubList())) {
            this.saveOrUpdateChild(entity);
        }
        long changeId = entity.getId() == null ? IdWorker.getId() : entity.getId();
        RentTotalPlanEntity rentTotalPlanEntity = (RentTotalPlanEntity)((Object)this.totalPlanService.selectById(entity.getTotalId()));
        rentTotalPlanEntity.setChangingMny(entity.getChangingMny());
        rentTotalPlanEntity.setChangeCode(entity.getCode());
        rentTotalPlanEntity.setChangeId(changeId);
        rentTotalPlanEntity.setChangeStatus(2);
        rentTotalPlanEntity.setBeforeChangeMny(rentTotalPlanEntity.getTemporaryAmount());
        this.totalPlanService.saveOrUpdate((Object)rentTotalPlanEntity);
        if (entity.getId() == null) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            QueryWrapper wrapper = new QueryWrapper();
            ((QueryWrapper)wrapper.eq((Object)"total_id", (Object)entity.getTotalId())).orderByDesc((Object)"create_time");
            List list = super.list((Wrapper)wrapper);
            executionVO1 = list.size() > 0 ? this.targetCost((RentChangeTotalPlanEntity)((Object)list.get(0)), null) : this.rentTotalPlanService.targetCost(rentTotalPlanEntity);
            totalExecutionVOList.add(executionVO1.getTotalVO());
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("\u5220\u9664\u65e7\u76ee\u6807\u6210\u672c\u5931\u8d25\uff01");
            }
        }
        entity.setId(changeId);
        this.saveOrUpdate((Object)entity, false);
        executionVO1 = this.targetCost(entity, null);
        CommonResponse response = this.executionApi.aggPush(executionVO1);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25\uff01");
        }
    }

    @Override
    public ExecutionVO targetCost(RentChangeTotalPlanEntity entity, Long lastSourceId) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getCode());
        totalVO.setBillType("BTC220309000000002");
        totalVO.setBussinessType(BussinessTypeEnum.\u8bbe\u5907\u603b\u8ba1\u5212.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u8ba1\u5212.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        totalVO.setLinkUrl(frontendBaseHost + "ejc-proequipment-frontend/#/totalPlan/totalChangeCard?id=" + entity.getId());
        totalVO.setBillDate(entity.getOrganizationDate().toString());
        totalVO.setLastSourceId(lastSourceId);
        BigDecimal checkMoney = BigDecimal.ZERO;
        BigDecimal checkTaxMoney = BigDecimal.ZERO;
        for (RentChangeTotalPlanSubEntity rentTotalPlanSubEntity : entity.getTotalPlanSubList()) {
            checkMoney = checkMoney.add(rentTotalPlanSubEntity.getTemporaryAmount());
            checkTaxMoney = checkTaxMoney.add(rentTotalPlanSubEntity.getTemporaryAmount());
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(rentTotalPlanSubEntity.getId());
            detailExecutionVO.setSourceBillId(entity.getId());
            detailExecutionVO.setCategoryId(rentTotalPlanSubEntity.getEquipmentTypeId());
            detailExecutionVO.setCategoryName(rentTotalPlanSubEntity.getEquipmentTypeName());
            detailExecutionVO.setCode(rentTotalPlanSubEntity.getEquipmentCode());
            detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
            if (rentTotalPlanSubEntity.getEquipmentId() == null) {
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                detailExecutionVO.setDocId(rentTotalPlanSubEntity.getEquipmentTypeId());
            } else {
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocId(rentTotalPlanSubEntity.getEquipmentId());
            }
            detailExecutionVO.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
            detailExecutionVO.setName(rentTotalPlanSubEntity.getEquipmentName());
            detailExecutionVO.setUnitName(rentTotalPlanSubEntity.getMeteringUnit());
            detailExecutionVO.setSpec(rentTotalPlanSubEntity.getSpecs());
            detailExecutionVO.setNum(rentTotalPlanSubEntity.getPlanTotal());
            detailExecutionVO.setMoney(rentTotalPlanSubEntity.getTemporaryAmount());
            detailExecutionVO.setTaxMoney(rentTotalPlanSubEntity.getTemporaryAmount());
            detailList.add(detailExecutionVO);
        }
        totalVO.setMoney(checkMoney);
        totalVO.setTaxMoney(checkTaxMoney);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public void delete(RentChangeTotalPlanEntity entity) {
        RentChangeTotalPlanEntity rentChangeTotalPlanEntity = (RentChangeTotalPlanEntity)((Object)this.service.selectById(entity.getId()));
        RentTotalPlanEntity rentTotalPlanEntity = (RentTotalPlanEntity)((Object)this.rentTotalPlanService.selectById(entity.getTotalId()));
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        ExecutionVO executionVO = this.targetCost(rentChangeTotalPlanEntity, null);
        totalExecutionVOList.add(executionVO.getTotalVO());
        this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
        CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        ExecutionVO executionVO1 = this.rentTotalPlanService.targetCost(rentTotalPlanEntity);
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO1));
        CommonResponse response1 = this.executionApi.aggPush(executionVO1);
        if (!response1.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        this.removeById((Serializable)((Object)entity));
        RentTotalPlanEntity planEntity = (RentTotalPlanEntity)((Object)this.totalPlanService.selectById(entity.getTotalId()));
        planEntity.setChangeStatus(1);
        this.totalPlanService.saveOrUpdate((Object)planEntity);
    }

    @Transactional
    public void saveOrUpdateChild(RentChangeTotalPlanEntity entity) {
        List<RentChangeTotalPlanSubEntity> listbs = entity.getTotalPlanSubList();
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        for (RentChangeTotalPlanSubEntity cdEntity : listbs) {
            if (cdEntity.getParentId() != 999L) continue;
            idMap.put(cdEntity.getDocCategoryId(), cdEntity.getId());
        }
        for (RentChangeTotalPlanSubEntity cdEntity : listbs) {
            if (!cdEntity.getParentId().equals(999L)) {
                Long parentId = (Long)idMap.get(cdEntity.getDocCategoryId());
                cdEntity.setParentId(parentId != null ? parentId : entity.getProjectId());
                cdEntity.setTid(cdEntity.getId());
                continue;
            }
            cdEntity.setTid(cdEntity.getId());
        }
        this.rentChangeTotalPlanSubService.saveOrUpdateBatch(listbs, listbs.size(), false);
    }

    @Override
    public ParamsCheckVO targetCostCtrl(RentChangeTotalPlanVO totalPlanVO) {
        RentChangeTotalPlanVO contractVO1 = this.insertOrUpdate(totalPlanVO, true);
        Long lastSourceId = null;
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"total_id", (Object)totalPlanVO.getTotalId())).orderByDesc((Object)"create_time");
        List list = super.list((Wrapper)wrapper);
        RentTotalPlanEntity rentTotalPlanEntity = (RentTotalPlanEntity)((Object)this.rentTotalPlanService.selectById(totalPlanVO.getTotalId()));
        lastSourceId = list.size() > 0 ? ((RentChangeTotalPlanEntity)((Object)list.get(0))).getId() : rentTotalPlanEntity.getId();
        ExecutionVO executionVO = this.targetCost((RentChangeTotalPlanEntity)((Object)BeanMapper.map((Object)contractVO1, RentChangeTotalPlanEntity.class)), lastSourceId);
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO data = (ParamsCheckVO)response.getData();
        if (CollectionUtils.isEmpty((Collection)data.getDataSource())) {
            data.setWarnType("none");
        }
        return data;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        RentChangeTotalPlanVO contractVO = this.queryDetail(id);
        ExecutionVO executionVO = this.targetCost((RentChangeTotalPlanEntity)((Object)BeanMapper.map((Object)contractVO, RentChangeTotalPlanEntity.class)), null);
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO data = (ParamsCheckVO)response.getData();
        if (CollectionUtils.isEmpty((Collection)data.getDataSource())) {
            data.setWarnType("none");
        }
        return data;
    }
}

