/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.bean.RentSettlementEntity;
import com.ejianc.business.rent.bean.RentSettlementRentalEntity;
import com.ejianc.business.rent.enums.RentalSettlementStateEnum;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.service.IRentRentalService;
import com.ejianc.business.rent.service.IRentSettlementService;
import com.ejianc.business.rent.vo.RentSettlementVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rentSettlement")
public class RentSettlementBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IRentSettlementService service;
    @Autowired
    private IRentContractService contractService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IRentRentalService rentRentalService;
    @Autowired
    private ICostDetailApi costDetailApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null) {
            RentContractEntity contractEntity = (RentContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            if (ContractPerformanceStateEnum.\u5df2\u51bb\u7ed3.getStateCode().equals(contractEntity.getContractPerformanceState()) || ContractPerformanceStateEnum.\u5df2\u4f5c\u5e9f.getStateCode().equals(contractEntity.getContractPerformanceState())) {
                throw new BusinessException("\u5408\u540c{" + contractEntity.getContractName() + "},\u72b6\u6001\u4e3a\uff1a" + ContractPerformanceStateEnum.getByStateCode((String)contractEntity.getContractPerformanceState()).getStateName() + "\u4e0d\u53ef\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null) {
            RentContractEntity contractEntity = (RentContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            if (ContractPerformanceStateEnum.\u5df2\u51bb\u7ed3.getStateCode().equals(contractEntity.getContractPerformanceState()) || ContractPerformanceStateEnum.\u5df2\u4f5c\u5e9f.getStateCode().equals(contractEntity.getContractPerformanceState())) {
                throw new BusinessException("\u5408\u540c{" + contractEntity.getContractName() + "},\u72b6\u6001\u4e3a\uff1a" + ContractPerformanceStateEnum.getByStateCode((String)contractEntity.getContractPerformanceState()).getStateName() + "\u4e0d\u53ef\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null) {
            RentContractEntity contractEntity = (RentContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            if (ContractPerformanceStateEnum.\u5df2\u51bb\u7ed3.getStateCode().equals(contractEntity.getContractPerformanceState()) || ContractPerformanceStateEnum.\u5df2\u4f5c\u5e9f.getStateCode().equals(contractEntity.getContractPerformanceState())) {
                throw new BusinessException("\u5408\u540c{" + contractEntity.getContractName() + "},\u72b6\u6001\u4e3a\uff1a" + ContractPerformanceStateEnum.getByStateCode((String)contractEntity.getContractPerformanceState()).getStateName() + "\u4e0d\u53ef\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(state)) {
            boolean pool;
            this.logger.info("\u5ba1\u6279\u901a\u8fc7\u4e1a\u52a1\u5f00\u59cb\uff01");
            RentSettlementEntity entity = (RentSettlementEntity)((Object)this.service.selectById(billId));
            RentSettlementVO settlementVO = (RentSettlementVO)BeanMapper.map((Object)((Object)entity), RentSettlementVO.class);
            if (entity.getContractId() != null && entity.getSettlementType() == 1) {
                RentContractEntity rentContractEntity = (RentContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
                rentContractEntity.setContractPerformanceState(ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode());
                this.contractService.saveOrUpdate((Object)rentContractEntity);
                this.logger.info("\u4fee\u6539\u5408\u540c\u72b6\u6001\uff01" + JSONObject.toJSONString((Object)((Object)rentContractEntity)));
            }
            this.service.updateContractPoolSettle(settlementVO, true);
            if (CollectionUtils.isNotEmpty(entity.getRentSettlementRentalList())) {
                List<RentSettlementRentalEntity> rentalList = entity.getRentSettlementRentalList();
                List<Long> ids = rentalList.stream().filter(t -> t.getSourceId() != null).map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList());
                this.rentRentalService.updateRentalSettlementState(ids, RentalSettlementStateEnum.\u5df2\u7ed3\u7b97.getCode());
            }
            if (entity.getSettlementType() != null && entity.getSettlementType() == 1) {
                this.logger.info("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5f00\u59cb");
                CommonResponse response = this.executionApi.aggPush(this.service.targetCost(entity));
                this.logger.info("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)this.service.targetCost(entity)));
                if (!response.isSuccess()) {
                    this.logger.error("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5931\u8d25: , {}", (Object)response.getMsg());
                    throw new BusinessException(response.getMsg());
                }
            }
            if (!(pool = this.service.pushSettleToPool(settlementVO))) {
                throw new BusinessException("\u63a8\u9001\u7ed3\u7b97\u5931\u8d25");
            }
            this.logger.info("\u63a8\u9001\u6210\u672c---");
            this.service.costPush(entity);
            boolean pushFlag = this.service.pushBillToSupCenter(entity);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushFlag);
            if (!pushFlag) {
                entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            } else {
                entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            }
            this.service.saveOrUpdate((Object)entity, false);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        RentSettlementEntity entity = (RentSettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getSignStatus() == 1) {
            throw new BusinessException("\u5df2\u7b7e\u5b57\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        if (entity.getContractId() != null) {
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(RentSettlementEntity::getContractId, (Object)entity.getContractId());
            lambda.orderByDesc(BaseEntity::getCreateTime);
            List list = this.service.list((Wrapper)lambda);
            RentSettlementEntity settlementEntity = (RentSettlementEntity)((Object)list.get(0));
            if (!entity.getId().equals(settlementEntity.getId())) {
                throw new BusinessException("\u53ea\u80fd\u64a4\u56de\u6700\u65b0\u7684\u7ed3\u7b97\u5355\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        boolean pool;
        RentSettlementEntity entity = (RentSettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null && entity.getSettlementType() == 1) {
            RentContractEntity contractEntity = (RentContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            contractEntity.setContractPerformanceState(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
            this.contractService.saveOrUpdate((Object)contractEntity);
            this.logger.info("\u4fee\u6539\u5408\u540c\u72b6\u6001\uff01" + JSONObject.toJSONString((Object)((Object)contractEntity)));
        }
        this.service.updateContractPoolSettle((RentSettlementVO)BeanMapper.map((Object)((Object)entity), RentSettlementVO.class), false);
        if (CollectionUtils.isNotEmpty(entity.getRentSettlementRentalList())) {
            List<RentSettlementRentalEntity> rentalList = entity.getRentSettlementRentalList();
            List<Long> ids = rentalList.stream().filter(t -> t.getSourceId() != null).map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList());
            this.rentRentalService.updateRentalSettlementState(ids, RentalSettlementStateEnum.\u672a\u7ed3\u7b97.getCode());
        }
        if (entity.getSettlementType() != null && entity.getSettlementType() == 1) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            ExecutionVO executionVO = this.service.targetCost(entity);
            totalExecutionVOList.add(executionVO.getTotalVO());
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            this.logger.info("\u5220\u9664\u76ee\u6807\u6210\u672c\u7ed3\u679c" + JSONObject.toJSONString((Object)response));
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u5220\u9664\u5931\u8d25\uff01");
            }
        }
        if (!(pool = this.service.delSettleFromPool(billId))) {
            throw new BusinessException("\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01");
        }
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse<String> commonResponse = this.service.updatePushBill(entity);
            this.logger.info("\u4f9b\u65b9\u7ed3\u679c" + JSONObject.toJSONString(commonResponse));
            if (!commonResponse.isSuccess()) {
                throw new BusinessException(commonResponse.getMsg());
            }
        }
        CommonResponse costResponse = this.costDetailApi.updateCostDetail(entity.getId(), Integer.valueOf(0));
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)costResponse));
        if (!costResponse.isSuccess()) {
            throw new BusinessException(costResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(RentSettlementEntity::getRelationFlag, (Object)"0");
        updateWrapper.set(RentSettlementEntity::getBillPushFlag, (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }
}

