package com.ejianc.business.ac.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.ac.bean.*;
import com.ejianc.business.ac.enums.BillTypeEnum;
import com.ejianc.business.ac.enums.ChangeStatusEnum;
import com.ejianc.business.ac.enums.ChangeTypeEnum;
import com.ejianc.business.ac.enums.DraftTypeEnum;
import com.ejianc.business.ac.mapper.ChangeMapper;
import com.ejianc.business.ac.service.*;
import com.ejianc.business.ac.utils.TreeNodeBUtil;
import com.ejianc.business.ac.vo.*;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.rent.enums.SignatureStatusEnum;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 安拆合同变更主实体
 * 
 * @author generator
 * 
 */
@Service("changeService")
public class ChangeServiceImpl extends BaseServiceImpl<ChangeMapper, ChangeEntity> implements IChangeService{

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IChangeService changeService;

    @Autowired
    private IRecordService recordService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractClauseService contractClauseService;
    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    private IContractPaymentService contractPaymentService;

    @Autowired
    private ChangeMapper changeMapper;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IParamCheckApi paramCheckApi;

    @Value("${common.env.base-host}")
    private String BASE_HOST;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IParamConfigApi paramConfigApi;

    private static final String CHECK_PARAM_CODE = "P-r5n4tW71";//变更金额控制
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IChangeAsyncService changeAsyncService;

    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886"; // 水印参数

    private final String CONTRACT_FILE_SOURCE_TYPE = "subContractFile";
    private final String CONTRACT_ATTACH_SOURCE_TYPE = "subContractBill";

    private static final String BILL_TYPE = "EJCBT202204000008";//合同单据编码

    private static final String CHANGE_BILL_TYPE = "EJCBT202204000010";//变更合同单据编码


    //合同单据编码
    private final String LABORSUB_Bill_CODE = "EJCBT202204000008";
    //合同记录单据编码
    private final String LABORSUB_RECORD_Bill_CODE = "EJCBT202207000037";

    private String getBaseHost(){
        return StringUtils.isNotBlank(BASE_HOST_FRONTEND) && !("null").equals(BASE_HOST_FRONTEND) ? BASE_HOST_FRONTEND : BASE_HOST;
    }

    /**
     * @Description saveOrUpdate 查询当前合同下变更列表
     * @param id
     */
    @Override
    public ChangeVO queryDetailRecord(Long id) {
        ContractEntity contractEntity = contractService.selectById(id);
        ChangeVO changeVO = new ChangeVO();
        changeVO.setId(id);
        changeVO.setBaseTaxMny(contractEntity.getBaseTaxMny() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMny());
        //现合同金额（含税）
        changeVO.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());

        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, id));
        param.getParams().put("performance_status", new Parameter(QueryParam.EQ, ContractPerformanceStateEnum.履约中.getStateCode()));
        param.getOrderMap().put("change_date", QueryParam.DESC);
        param.getOrderMap().put("create_time", QueryParam.DESC);
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(change_mny) as sumChangeMoney, count(*) as changeNum");
        resp = super.getMap(wrapper);

        //设置变更详情
        changeVO.setChangeList(BeanMapper.mapList(queryList(param), ChangeVO.class));
        BigDecimal sumChangeMoney = null != resp.get("sumChangeMoney") ? new BigDecimal(resp.get("sumChangeMoney").toString()) : BigDecimal.ZERO;
        BigDecimal changeAmtRate = BigDecimal.ZERO;
        if (null != contractEntity.getBaseTaxMny() && contractEntity.getBaseTaxMny().compareTo(BigDecimal.ZERO) > 0 ){
            changeAmtRate = (sumChangeMoney.divide(contractEntity.getBaseTaxMny(),8, ROUND_HALF_DOWN)).multiply(new BigDecimal(100));
        }

        changeVO.setAllChangeMny(sumChangeMoney);
        Long changeNum = (Long) resp.get("changeNum");
        changeVO.setChangeNum(changeNum != null ? Integer.valueOf(String.valueOf(changeNum)) : 0);
        changeVO.setChangeMnyRate(changeAmtRate);
        //区分是否主合同的变更合同
        changeVO.setSupplementFlag(contractEntity.getSupplementFlag());
        changeVO.setAddType(contractEntity.getAddType());
        changeVO.setContractType(contractEntity.getContractType());

        //判断能否新增变更
        if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureStatus())
                && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState())
                || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))
                && (!(ContractPerformanceStateEnum.已作废.getStateCode().equals(contractEntity.getPerformanceStatus()) || ContractPerformanceStateEnum.已冻结.getStateCode().equals(contractEntity.getPerformanceStatus())))){
            changeVO.setEditFlag(this.editChangeFlag(id));
        }else {
            changeVO.setEditFlag(false);
        }
        return changeVO;
    }

    /**
     * 查询能否变更
     * @param contractId
     * @return
     */
    @Override
    public Boolean editChangeFlag(Long contractId) {
         /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
            自由态也不能新增
         */
        LambdaQueryWrapper<ChangeEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ChangeEntity::getContractId, contractId);
        lambda.and(l -> l.ne(ChangeEntity::getSignatureStatus, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(ChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        List<ChangeEntity> changeList = super.list(lambda);
        if (changeList.size() > 0){
            return false;
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ChangeVO insertOrUpdate(ChangeVO changeVO) {
        //获取主合同当前合同文件Id
        ContractEntity contract = contractService.selectById(changeVO.getContractId());
        //将主合同原合同文件从attachId中删除，否改文件会被该写到变更合同中
        if(CollectionUtils.isNotEmpty(changeVO.getAttachIds()) &&  null != contract.getContractFileId()) {
            changeVO.getAttachIds().remove(contract.getContractFileId());
        }

        ChangeEntity changeEntity = BeanMapper.map(changeVO, ChangeEntity.class);

        //变更合同只能存在一条未生效的
        //查询语句，主合同id一致，且变更id不同，单据状态不为已通过或已提交的，或签章状态不为已签章的
        LambdaQueryWrapper<ChangeEntity> lambdachange = Wrappers.<ChangeEntity>lambdaQuery();
        lambdachange.eq(ChangeEntity::getContractId,changeVO.getContractId());
        if(changeVO.getId() != null) {
            lambdachange.ne(ChangeEntity::getId,changeVO.getId());
        }
        lambdachange.and(l -> l.ne(ChangeEntity::getSignatureStatus, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(ChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }

        if (changeEntity.getId() == null){
            changeEntity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
            changeEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            changeEntity.setPerformanceStatus(ContractPerformanceStateEnum.未签订.getStateCode());
            if(changeEntity.getChangeVersion() < 10){
                changeEntity.setBillCode(changeEntity.getBillCode() + "-1-0" + changeEntity.getChangeVersion());
            }else{
                changeEntity.setBillCode(changeEntity.getBillCode() + "-1-" + changeEntity.getChangeVersion());
            }
        }
        //保存前清空主键和父主键，重新生成
        List<ChangeDetailEntity> beforeDetails = changeEntity.getDetailList();
        if(CollectionUtils.isNotEmpty(beforeDetails)){
            Map<String, Long> idMap = new HashMap<>();
            for(ChangeDetailEntity detail : beforeDetails){
                if(null == changeVO.getId() || null == detail.getId()) {
                    detail.setId(IdWorker.getId());
                }
                idMap.put(detail.getTid(), detail.getId());
                detail.setParentId(null);
            }
            for (ChangeDetailEntity detail : beforeDetails) {
                if (StringUtils.isNotEmpty(detail.getTpid())) {
                    detail.setParentId(idMap.get(detail.getTpid()));
                }
            }
        }
//        if (changeEntity.getChangeFilingStatus() != null
//                && FilingStatusEnum.已归档.getTypeCode().equals(changeEntity.getChangeFilingStatus())) {
            changeEntity.setFilingRef(0);
//        }
        //目标成本删除之前数据
        //判断是否是第一次变更
        if (changeVO.getId() == null) {
            QueryWrapper<ChangeEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("contract_id", changeVO.getContractId()).eq("dr",0).orderByDesc("create_time");
            List<ChangeEntity> list = changeService.list(wrapper);
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            ExecutionVO executionVO1;
            //判断是否有过变更
            if (list.size() > 0) {
                ChangeEntity changeEntity1 = list.get(0);
                String changeLinkUrl = getBaseHost()+"ejc-proequipment-frontend/#/otherSubList/changeCard?id="+changeEntity1.getId()+"&cardType=otherSubCard";
                executionVO1 = contractService.targetCost(BeanMapper.map(changeEntity1, ContractVO.class),changeLinkUrl ,changeEntity1.getContractType());
            }
            else {
                ContractEntity contractEntity = contractService.selectById(changeVO.getContractId());
                String linkUrl = getBaseHost()+"ejc-proequipment-frontend/#/otherSubList/card?id="+contractEntity.getId()+"&cardType=otherSubDirectCard";
                executionVO1 = contractService.targetCost(BeanMapper.map(contractEntity, ContractVO.class),linkUrl,contractEntity.getContractType());
            }
            //目标成本推送
            totalExecutionVOList.add(executionVO1.getTotalVO());
            logger.info("目标成本推送数据" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
            }
        }

        super.saveOrUpdate(changeEntity, false);
        //变更信息回写主合同
        saveWriteContract(changeEntity);

        //目标成本推送
        String changeLinkUrl = getBaseHost()+"ejc-proequipment-frontend/#/otherSubList/changeCard?id="+changeEntity.getId()+"&cardType=otherSubCard";
        ExecutionVO executionVO = contractService.targetCost(BeanMapper.map(changeEntity, ContractVO.class),changeLinkUrl, changeEntity.getContractType());
        logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("目标成本推送失败," + response.getMsg());
        }


        return queryDetail(changeEntity.getId());
    }

    /**
     * 保存回写合同
     * @param changeEntity
     */
    private void saveWriteContract(ChangeEntity changeEntity){
        /*
            回写主合同，两个金额六个变更
         */
        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(ContractEntity::getChangeId, changeEntity.getId());
        if (null != changeEntity.getChangeMny() && null != changeEntity.getChangeTax()){
            updateWrapper.set(ContractEntity::getChangingMny, changeEntity.getChangeMny().subtract(changeEntity.getChangeTax()));
        }
        updateWrapper.set(ContractEntity::getChangingTaxMny, changeEntity.getChangeMny());

        updateWrapper.set(ContractEntity::getChangeCode, changeEntity.getBillCode());
        updateWrapper.set(ContractEntity::getChangeVersion, changeEntity.getChangeVersion());
        updateWrapper.set(ContractEntity::getChangeStatus, ChangeStatusEnum.变更中.getCode());
        updateWrapper.set(ContractEntity::getChangeDate, changeEntity.getChangeDate());
        updateWrapper.set(ContractEntity::getChangeDraftType, changeEntity.getChangeDraftType());
        updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, Integer.valueOf(changeEntity.getSignatureStatus()));
        updateWrapper.set(ContractEntity::getChangeFileId, changeEntity.getChangeFileId());
        updateWrapper.set(ContractEntity::getChangeContractName, changeEntity.getContractName());

        updateWrapper.eq(ContractEntity::getId, changeEntity.getContractId());

        contractService.update(contractService.selectById(changeEntity.getContractId()), updateWrapper, false);
    }

    @Override
    public ChangeVO queryDetail(Long id) {
        Map<String, LinkedHashMap<String, String>> orderMap = new HashMap<>();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<>();
        orderParams.put("treeIndex", QueryParam.ASC);
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);

        ChangeEntity changeEntity = super.selectById(id, orderMap);
        ChangeVO changeVO = new ChangeVO();
        if (null != changeEntity){
            changeVO =  BeanMapper.map(changeEntity, ChangeVO.class);
        }

        List<Long> srcTblIdList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(changeVO.getDetailList())) {
            for (ChangeDetailVO detail : changeVO.getDetailList()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
                srcTblIdList.add(detail.getSrcTblId());
            }
            //判断清单是否被下游数据引用
//            List<ChangeDetailVO> usefulDetailList = selectUsefulByIds(changeVO.getDetailList().stream().map(ChangeDetailVO::getSrcTblId).collect(Collectors.toList()));
//
//            Map<Long, Integer> usefulDetailMap = new HashMap<>();
//            if (CollectionUtils.isNotEmpty(usefulDetailList)){
//                for (ChangeDetailVO c : usefulDetailList){
//                    usefulDetailMap.put(c.getSrcTblId(), c.getUseNum());
//                }
//            }
//            for (ChangeDetailVO c : changeVO.getDetailList()){
//                if (null != usefulDetailMap.get(c.getSrcTblId())){
//                    c.setUseNum(1);
//                }else {
//                    c.setUseNum(null);
//                }
//            }
            changeVO.setDetailList(TreeNodeBUtil.buildTree(changeVO.getDetailList()));
        }

        return changeVO;
    }

    /**
     * @Author yangst
     * @Description  新增根据合同主键查询变更合同需要的主合同字段
     * @param contractId
     */
    @Override
    public ChangeVO addConvertByConId(Long contractId, Long changeId) {
        Map<String, LinkedHashMap<String, String>> orderMap = new HashMap<>();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<>();
        orderParams.put("treeIndex", QueryParam.ASC);
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);
        ContractEntity contractEntity = contractService.selectById(contractId, orderMap);
        if(ChangeStatusEnum.变更中.getCode().equals(contractEntity.getChangeStatus()) && null == changeId) {
            return queryDetail(contractEntity.getChangeId());
        }
        ChangeVO changeVO = BeanMapper.map(contractEntity, ChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeChangeMny(contractEntity.getContractMny());
        changeVO.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        changeVO.setBeforeContractName(contractEntity.getContractName());
        changeVO.setChangeDraftType(DraftTypeEnum.上传合同.getCode().toString());
        changeVO.setContractId(contractId);
        changeVO.setChangeVersion(contractEntity.getChangeVersion() == null ? 1 : contractEntity.getChangeVersion()+ 1);
        changeVO.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setCommitDate(null);
        changeVO.setCommitUserCode(null);
        changeVO.setCommitUserName(null);
        changeVO.setEffectiveDate(null);
        changeVO.setChangeFileId(null);
        changeVO.setChangeFilePath(null);
        changeVO.setChangeFilingStatus(FilingStatusEnum.未归档.getTypeCode());
        //设置明细表字段
        resetSub(changeVO);

        return changeVO;
    }

    private void resetSub(ChangeVO changeVO) {
        //设置明细表字段
        List<ChangeDetailVO> changeDetailList = changeVO.getDetailList();
        if(CollectionUtils.isNotEmpty(changeDetailList)){
            List<Long> srcTblIdList = new ArrayList<>();
            changeDetailList.forEach(changeDetailVO ->{
                changeDetailVO.setSrcTblId(changeDetailVO.getId());
                changeDetailVO.setBeforeChangeNum(changeDetailVO.getDetailNum());
                changeDetailVO.setBeforeChangePrice(changeDetailVO.getDetailPrice());
                changeDetailVO.setBeforeChangeRate(changeDetailVO.getDetailTaxRate());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null ? changeDetailVO.getParentId().toString() : null);
                changeDetailVO.setRowState("edit");
                srcTblIdList.add(changeDetailVO.getSrcTblId());
            });

//            //判断清单是否被下游数据引用（零工登记，零工申请，分包计量，过程结算）
//            List<ChangeDetailVO> usefulDetailList = selectUsefulByIds(changeDetailList.stream().map(ChangeDetailVO::getSrcTblId).collect(Collectors.toList()));
//
//            LinkedHashMap<Long, Integer> usefulDetailMap = new LinkedHashMap<>();
//            if (CollectionUtils.isNotEmpty(usefulDetailList)){
//                for (ChangeDetailVO c : usefulDetailList){
//                    usefulDetailMap.put(c.getSrcTblId(), c.getUseNum());
//                }
//            }
//            for (ChangeDetailVO c : changeDetailList){
//                if (null != usefulDetailMap.get(c.getSrcTblId())){
//                    c.setUseNum(1);
//                }else {
//                    c.setUseNum(null);
//                }
//            }
        }
        changeVO.setDetailList(TreeNodeBUtil.buildTree(changeDetailList));
        //其他费用
        List<ChangeOtherCostVO> changeOtherCostVOList = changeVO.getOtherCostList();
        if(CollectionUtils.isNotEmpty(changeOtherCostVOList)){
            changeOtherCostVOList.forEach(changeOtherCostVO -> {
                changeOtherCostVO.setSrcTblId(changeOtherCostVO.getId());
                changeOtherCostVO.setBeforeChangeCostNum(changeOtherCostVO.getCostNum());
                changeOtherCostVO.setBeforeChangeCostPrice(changeOtherCostVO.getCostPrice());
                changeOtherCostVO.setBeforeChangeCostRate(changeOtherCostVO.getCostTaxRate());
                changeOtherCostVO.setRowState("edit");
            });
        }
        //清单
        List<ChangeClauseVO> changeClauseList = changeVO.getClauseList();
        if(CollectionUtils.isNotEmpty(changeClauseList)){
            changeClauseList.forEach(changeClauseVO ->{
                changeClauseVO.setRowState("add");
                changeClauseVO.setSrcTblId(changeClauseVO.getId());
                changeClauseVO.setBeforeClauseContent(changeClauseVO.getClauseContent());
            });
        }

        //付款阶段
        List<ChangePaymentVO> payList = changeVO.getPaymentList();
        if(CollectionUtils.isNotEmpty(payList)){
            payList.forEach(item ->{
                item.setRowState("add");
                item.setSrcTblId(item.getId());
                item.setBeforePaymentScale(item.getPaymentScale());
            });
        }
    }

    @Override
    public CommonResponse<String> deleteById(Long changeBillId) {
        ChangeEntity entity = super.selectById(changeBillId);
        //目标成本推送
        //删除数据
        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
        List<ContractEntity> contractEntityList = new ArrayList<>();
        ExecutionVO executionVO = contractService.targetCost(BeanMapper.map(entity, ContractVO.class),"",entity.getContractType());
        totalExecutionVOList.add(executionVO.getTotalVO());
        contractEntityList.add(contractService.selectById(entity.getContractId()));

        logger.info("目标成本删除数据" + JSON.toJSONString(totalExecutionVOList));
        CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()) {
            throw new BusinessException("目标成本推送失败," + response.getMsg());
        }
        //推送上一版数据
        for (ContractEntity contractEntity : contractEntityList) {
            //目标成本推送
            ExecutionVO executionVO1;
            List<ChangeEntity> contractChangeEntityList = changeService.list(new QueryWrapper<ChangeEntity>().eq("contract_id", contractEntity.getId()).eq("dr",0).orderByDesc("create_time"));
            if (contractChangeEntityList.size() > 1) {
                String changeLinkUrl = getBaseHost()+"ejc-proequipment-frontend/#/otherSubList/changeCard?id="+contractChangeEntityList.get(1).getId()+"&cardType=otherSubCard";
                executionVO1 = contractService.targetCost(BeanMapper.map(contractChangeEntityList.get(1), ContractVO.class),changeLinkUrl,contractChangeEntityList.get(1).getContractType());
            }
            else {
                String linkUrl = getBaseHost()+"ejc-proequipment-frontend/#/otherSubList/card?id="+contractEntity.getId()+"&cardType=otherSubDirectCard";
                executionVO1 = contractService.targetCost(BeanMapper.map(contractEntity, ContractVO.class),linkUrl,contractEntity.getContractType());
            }
            logger.info("目标成本推送数据" + JSON.toJSONString(executionVO1));
            CommonResponse<String> response1 = executionApi.aggPush(executionVO1);
            if (!response1.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response1.getMsg());
            }
        }
        //合同变更只有详情页有删除
        ContractEntity contractEntity = contractService.selectById(entity.getContractId());

        QueryWrapper<ChangeEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractEntity.getId());
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.ne("id", changeBillId);
        int count = super.count(query);

        contractEntity.setChangeVersion(contractEntity.getChangeVersion()-1);
        contractEntity.setChangeStatus(count > 0 ? ChangeStatusEnum.已变更.getCode() : ChangeStatusEnum.未变更.getCode());
        //修改变更中金额
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        contractEntity.setChangeCode(null);
        contractEntity.setChangeId(null);
        contractEntity.setChangeDate(null);
        contractEntity.setChangeDraftType(null);
        contractEntity.setChangeContractSignatureStatus(null);
        contractEntity.setChangeFileId(null);
        contractEntity.setChangeContractName(null);
        contractService.update(contractEntity, new QueryWrapper<ContractEntity>().eq("id",contractEntity.getId()),false);

        super.removeById(changeBillId,false);
        return CommonResponse.success("删除成功！");
    }

    /**
     * 查询变更对比
     * @param id
     * @param
     * @return
     */
    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        /*
            当前变更合同如果未提交，则和主合同对比
            如果提交，则和合同记录表对比
         */
        LinkedHashMap<String, String> orderByParams = new LinkedHashMap<>();
        orderByParams.put("treeIndex", QueryParam.ASC);
        Map<String, LinkedHashMap<String, String>> orders = new HashMap<>();
        orders.put("detailList", orderByParams);
        ChangeEntity changeEntity = super.selectById(id, orders);
        ChangeCompareVO changeCompareVO = BeanMapper.map(changeEntity, ChangeCompareVO.class);
        ContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());

        ChangeCompareVO beforeChangeVO = new ChangeCompareVO();
        Map<Long, ChangeDetailVO> beforeDetailMap = new HashMap<>();
        Map<Long, ChangeOtherCostVO> beforeFeeMap = new HashMap<>();
        Map<Long, ChangeClauseVO> beforeClauseMap = new HashMap<>();
        Map<Long, ChangePaymentVO> beforeStageMap = new HashMap<>();



        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(changeEntity.getBillState())) {
            //若变更单已审批通过，则查询最新的合同记录
            LambdaQueryWrapper<RecordEntity> lambda = Wrappers.<RecordEntity>lambdaQuery();
            lambda.eq(RecordEntity::getChangeId, id)
                    .eq(RecordEntity::getContractId, changeEntity.getContractId())
                    .orderByDesc(RecordEntity::getCreateTime);
            List<RecordEntity> recordList = recordService.list(lambda);
            if (recordList != null && recordList.size() > 0 && recordList.get(0) != null){
                beforeChangeVO = BeanMapper.map(recordList.get(0), ChangeCompareVO.class);
                //如果提交key为记录子表来源id
                beforeDetailMap = beforeChangeVO.getDetailList().stream().collect(Collectors
                        .toMap(ChangeDetailVO::getSrcTblId, detail -> detail, (v1, v2) -> v2));
                beforeFeeMap = beforeChangeVO.getOtherCostList().stream()
                        .collect(Collectors.toMap(ChangeOtherCostVO::getSrcTblId, fee -> fee, (v1, v2) -> v2));
                beforeClauseMap = beforeChangeVO.getClauseList().stream().collect(Collectors
                        .toMap(ChangeClauseVO::getSrcTblId, clause -> clause, (v1, v2) -> v2));
                beforeStageMap = beforeChangeVO.getPaymentList().stream()
                        .collect(Collectors.toMap(ChangePaymentVO::getSrcTblId, item -> item, (v1, v2) -> v2));
            }
        }else {
            beforeChangeVO = BeanMapper.map(contractEntity, ChangeCompareVO.class);
            //如果提交key为主合同子表id
            beforeDetailMap = beforeChangeVO.getDetailList().stream().collect(Collectors.toMap(ChangeDetailVO::getId, detail -> detail, (v1, v2) -> v2));
            beforeFeeMap = beforeChangeVO.getOtherCostList().stream().collect(Collectors.toMap(ChangeOtherCostVO::getId, fee -> fee, (v1, v2) -> v2));
            beforeClauseMap = beforeChangeVO.getClauseList().stream().collect(Collectors.toMap(ChangeClauseVO::getId, clause -> clause, (v1, v2) -> v2));
            beforeStageMap = beforeChangeVO.getPaymentList().stream().collect(Collectors.toMap(ChangePaymentVO::getId, item -> item, (v1, v2) -> v2));
        }

        Map<String, Object> returnMap = new HashMap<>();
//        if (changeCompareVO != null && beforeChangeVO != null){
//            //设置明细内容
//            if (CollectionUtils.isNotEmpty(changeCompareVO.getDetailList())) {
//                changeCompareVO.setDetailList(TreeNodeBUtil.buildTree(changeCompareVO.getDetailList().stream().filter(detail -> StringUtils.isNotBlank(detail.getChangeType())).collect(Collectors.toList())));
//            }
//
//            //设置其他花费内容
//            if (CollectionUtils.isNotEmpty(changeCompareVO.getOtherCostList())){
//                changeCompareVO.setOtherCostList(
//                        changeCompareVO.getOtherCostList().stream().filter(cost -> null != cost.getChangeType()).collect(Collectors.toList())
//                );
//            }
//
//            if (CollectionUtils.isNotEmpty(changeCompareVO.getClauseList())){
//                changeCompareVO.setClauseList(
//                        changeCompareVO.getClauseList().stream().filter(clause -> null == clause.getBeforeClauseContent() || !clause.getBeforeClauseContent().equals(clause.getClauseContent())).collect(Collectors.toList())
//                );
//            }
//
//            if (CollectionUtils.isNotEmpty(changeCompareVO.getPaymentList())){
//                changeCompareVO.setPaymentList(//前付款比例为空证明是新增项
//                        changeCompareVO.getPaymentList().stream().filter(payment -> null == payment.getBeforePaymentScale() || !payment.getBeforePaymentScale().equals(payment.getPaymentScale())).collect(Collectors.toList())
//                );
//            }
//
//
//            returnMap.put("newData", changeCompareVO);
//            returnMap.put("oldData", beforeChangeVO);
//        }
        if (changeCompareVO != null && beforeChangeVO != null) {
            //设置明细内容
            List<ChangeDetailVO> newDetail = new ArrayList<>();
            Map<Long, ChangeDetailVO> finalBeforeDetailMap = beforeDetailMap;
            if (CollectionUtils.isNotEmpty(changeCompareVO.getDetailList())) {
                changeCompareVO.getDetailList().stream().forEach(detail -> {
                    if (!String.valueOf(ChangeTypeEnum.未变更.getCode()).equals(detail.getChangeType())) {
                        if (detail.getSrcTblId() == null) {//新增项
                            detail.setChangeType("增补项");
                            newDetail.add(detail);
                        }
                        else if (finalBeforeDetailMap.containsKey(detail.getSrcTblId())) {
//                            detail.setBeforeChangeRate(finalBeforeDetailMap.get(detail.getSrcTblId()).getDetailTaxRate());
//                            detail.setBeforeChangePrice(finalBeforeDetailMap.get(detail.getSrcTblId()).getDetailPrice());
//                            detail.setBeforeChangeNum(finalBeforeDetailMap.get(detail.getSrcTblId()).getDetailNum());
                            newDetail.add(detail);
                            finalBeforeDetailMap.remove(detail.getSrcTblId());
                        }
                    }
                });

            }
            changeCompareVO.setDetailList(newDetail);
            //设置其他花费内容
            List<ChangeOtherCostVO> newFee = new ArrayList<>();
            Map<Long, ChangeOtherCostVO> finalBeforeFeeMap = beforeFeeMap;
            if (CollectionUtils.isNotEmpty(changeCompareVO.getOtherCostList())) {
                changeCompareVO.getOtherCostList().stream().forEach(fee -> {
                    if (!String.valueOf(ChangeTypeEnum.未变更.getCode()).equals(fee.getChangeType())) {
                        if (fee.getSrcTblId() == null) {//新增项
                            fee.setChangeType("增补项");
                            newFee.add(fee);
                        }
                        else if (finalBeforeFeeMap.containsKey(fee.getSrcTblId())) {
//                            fee.setBeforeChangeCostRate(finalBeforeFeeMap.get(fee.getSrcTblId()).getFreeTaxRate());
//                            fee.setBeforeChangeCostPrice(finalBeforeFeeMap.get(fee.getSrcTblId()).getFreePrice());
//                            fee.setBeforeChangeCostNum(finalBeforeFeeMap.get(fee.getSrcTblId()).getFreeNum());
                            newFee.add(fee);
                            finalBeforeFeeMap.remove(fee.getSrcTblId());
                        }
                    }
                });
            }
            changeCompareVO.setOtherCostList(newFee);
            //设置合同条款
            List<ChangeClauseVO> newClauses = new ArrayList<>();
            Map<Long, ChangeClauseVO> finalBeforeClauseMap = beforeClauseMap;
            if (CollectionUtils.isNotEmpty(changeCompareVO.getClauseList())) {
                changeCompareVO.getClauseList().stream().forEach(clause -> {
                    if (clause.getSrcTblId() == null) {
                        //没有来源则说明为新增项
                        clause.setChangeType("增补项");
                        newClauses.add(clause);
                    }
                    else if (finalBeforeClauseMap.containsKey(clause.getSrcTblId())) {
                        if (!clause.getClauseContent().equals(clause.getBeforeClauseContent())) {
//                            若内容有变更
//                            clause.setBeforeChangeClauseContent((finalBeforeClauseMap.get(clause.getSrcTblId()).getClauseContent()));
                            clause.setChangeType("内容变更");
                            newClauses.add(clause);
                        }
                        finalBeforeClauseMap.remove(clause.getSrcTblId());
                    }
                });
            }

            if (MapUtils.isNotEmpty(finalBeforeClauseMap)) {
                //若原始条款有剩余项，则说这些项变更时被删除
                finalBeforeClauseMap.values().forEach(c -> {
                    c.setChangeType("删除项");
                    newClauses.add(c);
                });
            }
            changeCompareVO.setClauseList(newClauses);

            //设置合同付款阶段
            List<ChangePaymentVO> newStageList = new ArrayList<>();
            Map<Long, ChangePaymentVO> finalBeforeStageMap = beforeStageMap;
            if (CollectionUtils.isNotEmpty(changeCompareVO.getPaymentList())) {
                for (ChangePaymentVO curItem : changeCompareVO.getPaymentList()) {
                    if (curItem.getSrcTblId() == null) {
                        //没有来源则说明为新增项
                        curItem.setChangeType("增补项");
                        newStageList.add(curItem);
                    }
                    else if (finalBeforeStageMap.containsKey(curItem.getSrcTblId())) {
                        if (curItem.getPaymentScale().compareTo(curItem.getBeforePaymentScale())!=0) {
                            curItem.setChangeType("内容变更");
                            newStageList.add(curItem);
                        }
                        finalBeforeStageMap.remove(curItem.getSrcTblId());
                    }
                }
            }

            if (MapUtils.isNotEmpty(finalBeforeStageMap)) {
                //若原始条款有剩余项，则说这些项变更时被删除
                finalBeforeStageMap.values().forEach(c -> {
                    c.setChangeType("删除项");
                    newStageList.add(c);
                });
            }
            changeCompareVO.setPaymentList(newStageList);
            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }
        return returnMap;
    }

    @Override
    public ChangeVO queryChangeRecord(Long contractId, Long changeId) {
        ContractEntity contractEntity = contractService.selectById(contractId);

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractEntity.getId()));
        queryParam.getParams().put("change_id", new Parameter(QueryParam.EQ, changeId));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<RecordEntity> recordList = recordService.queryList(queryParam);
        ChangeVO changeVO = new ChangeVO();
        if (CollectionUtils.isNotEmpty(recordList)){
            changeVO = BeanMapper.map(recordList.get(0), ChangeVO.class);
        }

        if (changeVO !=null){
            resetSub(changeVO);
        }

        return changeVO;
    }

    /**
     * 变更单据生效创建记录文件并回写主合同
     * @param changeBillId
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState,Boolean filingFlag) {
        CommonResponse<String> resp = null;
        /**更新变更的审批时间  begin */
        ChangeEntity changeEntity = changeService.selectById(changeBillId);
        if (commitState){
            changeEntity.setCommitDate(new Date());
            changeEntity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
            changeEntity.setCommitUserName(sessionManager.getUserContext().getUserName());
        }
        //签章来的 可以修改 不然不修改
        if (filingFlag){
            changeEntity.setChangeFilingStatus(FilingStatusEnum.已归档.getTypeCode());
            changeEntity.setFilingRef(0);
        }
        logger.info("进入变更终审！变更表数据------------->: {}", JSONObject.toJSONString(changeEntity));

        /**复制合同表数据到记录表 begin */
        ContractVO contractVO = contractService.queryDetail(changeEntity.getContractId());
        //获取当前合同记录数
        QueryWrapper<RecordEntity> countQuery = new QueryWrapper<>();
        countQuery.eq("contract_id", contractVO.getId());
        countQuery.eq("dr", BaseVO.DR_UNDELETE);
        int curRecordVersion = recordService.count(countQuery);

        Map<Long, Integer> contIdVersionMap =  new HashMap<>();
        RecordEntity recordEntity = BeanMapper.map(contractVO, RecordEntity.class);
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setChangeVersion(curRecordVersion+1);
        recordEntity.setId(null);
        logger.info("变更前主合同数据: {}", JSONObject.toJSONString(contractVO));
        logger.info("变更前主合同子表detail数据: {}", JSONObject.toJSONString(contractVO.getDetailList()));
        logger.info("记录表从主合同表复制的数据: {}", JSONObject.toJSONString(recordEntity));
        logger.info("记录表从主合同表复制的数据的子表detail数据: {}", JSONObject.toJSONString(recordEntity.getDetailList()));

        if(CollectionUtils.isNotEmpty(recordEntity.getDetailList())){
            recordEntity.getDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getClauseList())){
            recordEntity.getClauseList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getOtherCostList())){
            recordEntity.getOtherCostList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getPaymentList())){
            recordEntity.getPaymentList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }

        logger.info("记录表从主合同表复制的子表detail数据，设置id后的值: {}", JSONObject.toJSONString(recordEntity.getDetailList()));
        recordService.saveOrUpdate(recordEntity, false);
        logger.info("审批-变更记录表保存主合同数据成功！");
        //根据实体RefCode查询实体单据类型
//        String srcBillCode = PROSUB_Bill_CODE;
//        String targetBillCode = PROSUB_RECORD_Bill_CODE;
//        if (contractVO.getContractType().equals(0)){
//
//        }
        String srcBillCode = LABORSUB_Bill_CODE;
        String targetBillCode = LABORSUB_RECORD_Bill_CODE;
        //原合同附件、起草附件同步到记录单据中
        resp = copyFile(contractVO.getId().toString(), srcBillCode,
                recordEntity.getId().toString(), targetBillCode, CONTRACT_ATTACH_SOURCE_TYPE, true);
        if(resp != null) {
            logger.error("同步原合同附件到记录单据失败，失败原因：{}", JSONObject.toJSONString(resp));
        }
        /**复制合同表数据到记录表 end */

        /**更新变更表主表数据到原合同 begin */
        logger.info("更新变更数据到主合同表,contractVO---------------->: {}", JSONObject.toJSONString(contractVO));
        ContractEntity contractEntity = BeanMapper.map(contractVO, ContractEntity.class);
        //基本信息
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setFirstPartyId(changeEntity.getFirstPartyId());
        contractEntity.setFirstPartyName(changeEntity.getFirstPartyName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setSignPlace(changeEntity.getSignPlace());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setDraftType(changeEntity.getDraftType());
        contractEntity.setContractFilePath(changeEntity.getContractFilePath());
        contractEntity.setContractFileId(changeEntity.getContractFileId());
        contractEntity.setContractTemplateId(changeEntity.getContractTemplateId());
        contractEntity.setContractTemplateName(changeEntity.getContractTemplateName());
        contractEntity.setContractFileVersionId(changeEntity.getContractFileVersionId());
        contractEntity.setContractFileVersion(changeEntity.getContractFileVersion());
        contractEntity.setProjectAddress(changeEntity.getProjectAddress());
        contractEntity.setInvoiceTypeId(changeEntity.getInvoiceTypeId());
        contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());

        //劳务分包人资质
        contractEntity.setQualifyId(changeEntity.getQualifyId());
        contractEntity.setQualifyName(changeEntity.getQualifyName());
        contractEntity.setQualifyCertifyNo(changeEntity.getQualifyCertifyNo());
        contractEntity.setQualifyLicenceIssuingAuthority(changeEntity.getQualifyLicenceIssuingAuthority());
        contractEntity.setQualifyGrantDate(changeEntity.getQualifyGrantDate());
        contractEntity.setQualifyValidTillDate(changeEntity.getQualifyValidTillDate());
        contractEntity.setSafetyProductionLicenseNo(changeEntity.getSafetyProductionLicenseNo());
        contractEntity.setSafetyCertifyGrantDate(changeEntity.getSafetyCertifyGrantDate());
        contractEntity.setSafetyCertifyValidTillDate(changeEntity.getSafetyCertifyValidTillDate());
        //合同工期
        contractEntity.setProjectStartDate(changeEntity.getProjectStartDate());
        contractEntity.setPlannedFinishDate(changeEntity.getPlannedFinishDate());
        contractEntity.setContractDaysLimit(changeEntity.getContractDaysLimit());
        //项目经理代表人
        contractEntity.setFirstPartyProjectManagerId(changeEntity.getFirstPartyProjectManagerId());
        contractEntity.setFirstPartyProjectManagerLink(changeEntity.getFirstPartyProjectManagerLink());
        contractEntity.setFirstPartyProjectManagerName(changeEntity.getFirstPartyProjectManagerName());
        contractEntity.setFirstPartyProjectManagerPost(changeEntity.getFirstPartyProjectManagerPost());
        contractEntity.setSupplierProjectManagerId(changeEntity.getSupplierProjectManagerId());
        contractEntity.setSupplierProjectManagerIdCard(changeEntity.getSupplierProjectManagerIdCard());
        contractEntity.setSupplierProjectManagerLink(changeEntity.getSupplierProjectManagerLink());
        contractEntity.setSupplierProjectManagerName(changeEntity.getSupplierProjectManagerName());
        contractEntity.setSupplierProjectManagerPost(changeEntity.getSupplierProjectManagerPost());
        //分包款项
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setSubContractTaxMny(changeEntity.getSubContractTaxMny());
        contractEntity.setSubContractMny(changeEntity.getSubContractMny());
        contractEntity.setSubContractTax(changeEntity.getSubContractTax());
        contractEntity.setOtherCostMny(changeEntity.getOtherCostMny());
        contractEntity.setOtherCostTaxMny(changeEntity.getOtherCostTaxMny());
        contractEntity.setOtherCostTaxMny(changeEntity.getOtherCostTaxMny());

		/*
			起草方式为线下签订，则变更合同为已签章，直接生效。主合同状态改为已变更
			起草方式为线上起草、上传合同，则主合同状态改为变更单据已生效
		 */
        contractEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
        //清空变更单信息
        contractEntity.setChangingMny(null);
        contractEntity.setChangingTaxMny(null);

        logger.info("1212-进入变更终审审核完回调------>合同提交，线下签订直接修改签章状态");
        //设置变更合同生效状态
        changeEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
        changeEntity.setPerformanceStatus(ContractPerformanceStateEnum.履约中.getStateCode());
        //合同已生效，添加生效时间
        changeEntity.setEffectiveDate(new Date());

        //同步变更单附件（不包含变更变更附件）到原合同
        resp = copyFile(changeBillId.toString(), billTypeCode, contractEntity.getId().toString(), srcBillCode, "subChangeContractFile", false);
        if(resp != null) {
            logger.error("同步变更附件到原合同失败，失败原因：{}", JSONObject.toJSONString(resp));
        }


        //变更单更新
        changeService.saveOrUpdate(changeEntity);
        logger.info("更新变更表合同状态和数据,changeEntity---------->： {}", JSONObject.toJSONString(changeEntity));

        /**更新变更表主表数据到原合同 end */

        /**更新变更子表数据到原合同子表 begin */
        logger.info("更新变更表数据到主合同开始----------->" + contractEntity.getChangeStatus());
        ContractEntity contractChangeEntity = BeanMapper.map(changeEntity, ContractEntity.class);
        List<ChangeDetailEntity> changeDetailList = changeEntity.getDetailList();
        Map<Long,Long> changDetailIdMap = new HashMap<>();
		/*
			变更详情表和合同详情表有一个字段不一样
			变更详情表里 来源子表主键 srcTblId
			合同详情表里 变更子表主键 changeBid
		 */
        Map<Long, Long> changeParentIdMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(changeDetailList)){
            changeDetailList.forEach(changeDetailEntity -> {
                //设置id和来源子表主键对应map
                changDetailIdMap.put(changeDetailEntity.getId(), changeDetailEntity.getSrcTblId() != null ? changeDetailEntity.getSrcTblId() : IdWorker.getId());
            });
            changeDetailList.forEach(changeDetailEntity -> {
                if (changeDetailEntity.getParentId() != null){
                    changeParentIdMap.put(changeDetailEntity.getId(), changDetailIdMap.get(changeDetailEntity.getParentId()));
                }
            });
        }

        List<ContractDetailEntity> contractDetailList = contractChangeEntity.getDetailList();
        if(CollectionUtils.isNotEmpty(contractDetailList)){
            Long contractBid = null;
            for(ContractDetailEntity contractDetailEntity : contractDetailList) {
                contractBid = changDetailIdMap.get(contractDetailEntity.getId());

                contractDetailEntity.setContractId(changeEntity.getContractId());
                //设置变更子表主键
                contractDetailEntity.setChangeBid(contractDetailEntity.getId());
                //设置父级Id
                if(null != contractDetailEntity.getParentId()) {
                    contractDetailEntity.setParentId(changDetailIdMap.get(contractDetailEntity.getParentId()));
                }

                //合同子表对应变更子表主键
                contractDetailEntity.setId(contractBid);
                contractDetailEntity.setVersion(contIdVersionMap.get(contractBid));
                contractDetailEntity.setChangeType(null);
            }
        }
        contractEntity.setDetailList(contractDetailList);

        //其他费用表
        List<ChangeOtherCostEntity> changeOtherCostList = changeEntity.getOtherCostList();
        Map<Long,Long> changOtherCostIdMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(changeOtherCostList)){
            changeOtherCostList.forEach(changeOtherCostEntity -> {
                //设置id和来源子表主键对应map
                changOtherCostIdMap.put(changeOtherCostEntity.getId(), changeOtherCostEntity.getSrcTblId());
            });
        }
        List<ContractOtherCostEntity> contractOtherCostList = contractChangeEntity.getOtherCostList();
        if(CollectionUtils.isNotEmpty(contractOtherCostList)){
            Long contractBid = null;
            for(ContractOtherCostEntity contractOtherCostEntity : contractOtherCostList) {
                contractBid = changOtherCostIdMap.get(contractOtherCostEntity.getId());
                //设置变更子表主键
                contractOtherCostEntity.setChangeBid(contractOtherCostEntity.getId());
                //合同子表对应变更子表主键
                contractOtherCostEntity.setId(contractBid);
                contractOtherCostEntity.setVersion(contIdVersionMap.get(contractBid));
                contractOtherCostEntity.setContractId(contractEntity.getId());
            }
        }
        contractEntity.setOtherCostList(contractOtherCostList);

        //先删除合同条款表
        List<ContractClauseEntity> contractClauseList = contractEntity.getClauseList();
        List<ContractClauseEntity> contractChangeClauseList = contractChangeEntity.getClauseList();
        if(CollectionUtils.isNotEmpty(contractClauseList)){
            logger.info("删除合同条款子表数据: {}", JSONObject.toJSONString(contractClauseList));
            contractClauseService.deleteByIds(contractClauseList.stream().map(ContractClauseEntity::getId).collect(Collectors.toList()));

            contractChangeClauseList.forEach(clauseEntity -> {
                clauseEntity.setChangeBid(clauseEntity.getId());
                clauseEntity.setId(null);
                clauseEntity.setRowState("add");
                clauseEntity.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setClauseList(contractChangeClauseList);

        //合同付款阶段
        List<ContractPaymentEntity> contractPayList = contractEntity.getPaymentList();
        List<ContractPaymentEntity> pList = contractChangeEntity.getPaymentList();
        if(CollectionUtils.isNotEmpty(contractPayList)){
            logger.info("删除合同付款阶段子表数据: {}", JSONObject.toJSONString(contractPayList));
            contractPaymentService.deleteByIds(contractPayList.stream().map(ContractPaymentEntity::getId).collect(Collectors.toList()));

            pList.forEach(item -> {
                item.setChangeBid(item.getId());
                item.setId(null);
                item.setRowState("add");
                item.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setPaymentList(pList);

        contractService.saveOrUpdate(contractEntity, false);
        // 推送合同池
        boolean pushFlag = contractService.pushContract(BeanMapper.map(contractEntity, ContractVO.class));
        if(pushFlag){
            // 更新合同池数据的累计变更金额（含税、无税、税额）、累计变更比例
            this.updateTotalChangeDataByContractId(changeEntity, "approve");
        }
        logger.info("更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));

        /**更新变更子表数据到原合同子表 end */
        return CommonResponse.success("变更单生效，回写合同成功！");
    }

    /**
     * 合同变更修改合同池变更金额
     *
     * @param changeEntity 变更信息
     * @param type         变更类型
     */
    @Override
    public void updateTotalChangeDataByContractId(ChangeEntity changeEntity, String type) {
        logger.info("合同变更" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计变更金额（含税、无税、税额）和累计变更比例，开始，changeEntity={}，type={}", JSONObject.toJSONString(changeEntity), type);
        QueryWrapper<ChangeEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0).eq("tenant_id", InvocationInfoProxy.getTenantid())
                .eq("contract_id", changeEntity.getContractId())
                .eq("performance_status", ContractPerformanceStateEnum.履约中.getStateCode());
        if ("back".equals(type)) {
            // 当前是变更单撤回后调用此方法，查询变更表中的本次变更金额的累加值时排除自己
            wrapper.ne("id", changeEntity.getId());
        }
        wrapper.select("sum(ifnull(change_mny, 0)) as totalChangeTaxMny, sum(ifnull(change_mny, 0) - ifnull(change_tax, 0)) as totalChangeMny, sum(ifnull(change_tax, 0)) as totalChangeTax");
        Map<String, Object> totalChangeMap = super.getMap(wrapper);
        logger.info("查询当前合同的本次变更金额（含税、无税、税额）的累加值作为累计变更金额（含税、无税、税额），查询结果：{}", totalChangeMap);
        BigDecimal totalChangeTaxMny = BigDecimal.ZERO;
        BigDecimal totalChangeMny = BigDecimal.ZERO;
        BigDecimal totalChangeTax = BigDecimal.ZERO;
        BigDecimal totalChangeRate = BigDecimal.ZERO;
        if (MapUtils.isNotEmpty(totalChangeMap)) {
            totalChangeTaxMny = totalChangeMap.get("totalChangeTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(totalChangeMap.get("totalChangeTaxMny").toString());
            totalChangeMny = totalChangeMap.get("totalChangeMny") == null ? BigDecimal.ZERO : new BigDecimal(totalChangeMap.get("totalChangeMny").toString());
            totalChangeTax = totalChangeMap.get("totalChangeTax") == null ? BigDecimal.ZERO : new BigDecimal(totalChangeMap.get("totalChangeTax").toString());
            if (null != changeEntity.getBaseTaxMny() && changeEntity.getBaseTaxMny().compareTo(BigDecimal.ZERO) > 0 ){
                totalChangeRate = (totalChangeTaxMny.divide(changeEntity.getBaseTaxMny(),8, ROUND_HALF_DOWN)).multiply(new BigDecimal(100));
            }
            logger.info("计算：累计变更比例 = 累计变更金额（含税） / 合同初始金额（含税） = {}", totalChangeRate);
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            // 累计变更金额
            contractPoolVO.setTotalChangeTaxMny(totalChangeTaxMny);
            contractPoolVO.setTotalChangeMny(totalChangeMny);
            contractPoolVO.setTotalChangeTax(totalChangeTax);
            contractPoolVO.setTaotalChangeScale(totalChangeRate);
            contractPoolVO.setSourceId(changeEntity.getContractId());
            CommonResponse<ContractPoolVO> saveAfterChangeRes = contractPoolApi.saveOrUpdateContract(contractPoolVO);
            logger.info("合同变更" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计变更金额（含税、无税、税额）和累计变更比例，结束，接口返回结果：{}", JSONObject.toJSONString(saveAfterChangeRes));
        }
    }

    /**
     * 文件复制
     *
     * @param srcBillId 源单据Id
     * @param srcBillTypeCode 源单据类型
     * @param targetBillId 目标单据Id
     * @param targetBillTypeCode 目标单据类型
     * @param srcAttachSourceType 源单据附件业务类型
     * @return
     */
    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType, boolean copyContractFile) {

        //同步合同附件列表
        CommonResponse copyContractAttachResp = attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode,
                srcAttachSourceType, targetBillId, targetBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE);
        if (!copyContractAttachResp.isSuccess()){
            logger.info("同步合同文件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
                    ,srcBillId, srcBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE, targetBillId, targetBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE, copyContractAttachResp.getMsg());
            logger.info("同步附件管理中的附件失败--------------->失败信息------------>：{}", copyContractAttachResp.getMsg());
            return CommonResponse.error("审批失败，同步附件失败，错误信息：" + copyContractAttachResp.getMsg());
        }

        if(copyContractFile) {
            //同步合同文件
            CommonResponse copyContractFileResp = attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, CONTRACT_FILE_SOURCE_TYPE,
                    targetBillId, targetBillTypeCode, CONTRACT_FILE_SOURCE_TYPE);
            if (!copyContractFileResp.isSuccess()){
                logger.info("同步合同文件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
                        ,srcBillId, srcBillTypeCode, CONTRACT_FILE_SOURCE_TYPE, targetBillId, targetBillTypeCode, CONTRACT_FILE_SOURCE_TYPE, copyContractFileResp.getMsg());
                return CommonResponse.error("审批失败，同步合同文件失败，错误信息：" + copyContractFileResp.getMsg());
            }
        }

        return null;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(ChangeVO changeVO) {
        ChangeEntity entity = BeanMapper.map(changeVO, ChangeEntity.class);
        String linkUrl;
        String billType;
        linkUrl = getBaseHost() + "ejc-proequiment-frontend/#/otherSubList/changeCard?id=" + entity.getId()+"&cardType=otherSubCard";
        billType = BillTypeEnum.安拆合同变更.getCode();
        ExecutionVO executionVO = changeService.targetCost(BeanMapper.map(entity, ChangeVO.class),linkUrl,entity.getContractType());
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = checkParams(changeVO, response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        ChangeVO changeVO = changeService.queryDetail(id);
        String linkUrl;
        String billType;
        linkUrl = getBaseHost() + "ejc-proequiment-frontend/#/otherSubList/changeCard?id=" + changeVO.getId()+"&cardType=otherSubCard";
        billType = BillTypeEnum.安拆合同变更.getCode();
        ExecutionVO executionVO = changeService.targetCost(BeanMapper.map(changeVO, ChangeVO.class),linkUrl,changeVO.getContractType());
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = checkParams(changeVO, response.getData());
        return paramsCheckVO;
    }

    @Override
    public ExecutionVO targetCost(ChangeVO changeVO, String linkUrl, Integer contractType){
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(changeVO.getId());
        totalVO.setTenantId(changeVO.getTenantId());
        totalVO.setBillCode(changeVO.getBillCode());
        totalVO.setOrgId(changeVO.getOrgId());
        totalVO.setBillType(BillTypeEnum.安拆合同变更.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.大型设备安拆合同.getCode());
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        QueryWrapper<ChangeEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", changeVO.getContractId()).eq("dr", 0).orderByDesc("create_time");
        List<ChangeEntity> list = changeService.list(wrapper);
        if (list.size() > 0) {
            totalVO.setLastSourceId(list.get(0).getId());
        }else {
            totalVO.setLastSourceId(changeVO.getContractId());
        }
        if (changeVO.getProjectId()==null){
            throw new BusinessException("目标成本推送失败,请更换项目");
        }else {
            totalVO.setProjectId(changeVO.getProjectId());
        }
        if (changeVO.getOrgId()==null){
            throw new BusinessException("目标成本推送失败,请更换项目");
        }else {
            totalVO.setOrgId(changeVO.getOrgId());
        }
        totalVO.setMoney(changeVO.getContractMny()); //总计划金额无税
        totalVO.setTaxMoney(changeVO.getContractTaxMny()); //总计划金额
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    //单据SupRentSettlementVO
    @Override
    public ParamsCheckVO checkParams(ChangeVO vo, ParamsCheckVO paramsCheckVO2){
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        if(CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))){
            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));//施工合同控制
        }
        paramsCheckVOS.addAll(this.checkParamsMny(vo));//合同金额控制变更金额
        if(paramsCheckVO2!=null){//组合成本参数
            paramsCheckVOS.add(paramsCheckVO2);
        }
        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
    //施工合同参数控制
    @Override
    public List<ParamsCheckVO> checkParamsConstruction(ChangeVO vo) {
        CommonResponse<List<ParamsCheckVO>> response = paramCheckApi.paramsCheck(vo.getProjectId(), vo.getContractId(), vo.getContractTaxMny(),vo.getOrgId());
        logger.info("施工合同控制信息返回："+JSONObject.toJSONString(response.getData()));
        if(!response.isSuccess()){
            throw new BusinessException("获取施工参数控制信息失败!"+response.getMsg());
        }
        return response.getData();

    }
    /**
     * 单据管控-累计变更金额大于合同金额
     * @return
     */
    @Override
    public  List<ParamsCheckVO> checkParamsMny(ChangeVO vo) {
        BigDecimal changeMoney  = vo.getChangeMny()==null?BigDecimal.ZERO:vo.getChangeMny();
        BigDecimal contractTaxMny = vo.getBaseTaxMny()==null?BigDecimal.ZERO:vo.getBaseTaxMny();//初始合同金额
        BigDecimal totalChangeMoney =  changeMoney;//累计变更金额  默认赋值本次
        //查询累计变更金额
        QueryWrapper<ChangeEntity> query = new QueryWrapper<>();
        query.eq("contract_id", vo.getContractId());
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("bill_state",1,3);
        query.eq("signature_status",SignatureStatusEnum.已签章.getCode());
        List<ChangeEntity> list = this.list(query);
        if(CollectionUtils.isNotEmpty(list)){
            for (ChangeEntity changeEntity : list) {
                totalChangeMoney = ComputeUtil.safeAdd(changeEntity.getChangeMny(),totalChangeMoney);//累加变更金额
            }
        }
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
//        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("累计变更金额控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalChangeMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("变更超合同金额");
                        paramsCheckDsVO.setWarnName("累计变更金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次变更金额：").append(changeMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计变更金额：").append(totalChangeMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalChangeMoney, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

    /**
     * 根据变更合同id给水印文件赋值
     *
     * @param id 变更合同id
     */
    @Override
    public void asyncWatermarkById(Long id) {
        ChangeEntity changeEntity = super.selectById(id);
        logger.info("开始获取水印参数信息，变更合同id：{}--------", id);
        // 水印系统参数
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        logger.info("获取水印系统参数请求结果：{}", JSONObject.toJSONString(response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取水印系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
        Assert.hasText(valueData, "获取的水印系统参数不能为空!");

        // 是否限制： 0:不限制，1:限制
        if ("0".equals(valueData)) {
            String billType = "EJCBT202204000010";
            String sourceType = "contractAC";
            // 转换水印参数配置：默认规则
            WatermarkVO watermarkVO = signatureCommonApi.fetchWatermarkConfig(changeEntity.getChangeFileId(), changeEntity.getId(),
                    changeEntity.getBillCode(), billType, sourceType);
            Assert.notNull(watermarkVO, "获取水印系统参数失败!");
            // 获取上下文并异步调用添加水印
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            changeAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
    }
}
