package com.ejianc.business.rent.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.rent.bean.RentEquipmentPlanSubEntity;
/**
 * 租赁设备租赁计划
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipment_rent_equipment_plan")
public class RentEquipmentPlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 费用项目名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="company_id")
    private Long companyId; // 所属单位
    @TableField(value="company_name")
    private String companyName; // 所属单位名称
    @TableField(value="plan_code")
    private String planCode; // 计划编号
    @TableField(value="plan_out_date")
    private Date planOutDateMain; // 计划出场日期
    @TableField(value="plan_approach_date")
    private Date planApproachDateMain; // 计划进场日期
    @TableField(value="bidding_state")
    private Integer biddingState; // 招标状态:1-待招标,2-招标中，3-已招标
    @TableField(value="bidding_state_name")
    private String biddingStateName;
    @TableField(value="temporary_amount")
    private BigDecimal temporaryAmount; // 暂估金额
    @TableField(value="edition_code")
    private String editionCode; // 版本编号
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="organization_user_id")
    private Long organizationUserId; // 编制人id
    @TableField(value="organization_user_name")
    private String organizationUserName; // 编制人名称
    @TableField(value="equipment_type")
    private String equipmentType; // 设备分类
    @TableField(value="organization_date")
    private Date organizationDate;
    @TableField(value="org_id")
    private Long orgId;
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="org_name")
    private String orgName; // 上级组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(exist=false)
    @SubEntity(serviceName="rentEquipmentPlanSubService")
    private List<RentEquipmentPlanSubEntity> rentEquipmentPlanSubList = new ArrayList<>(); // 租赁设备租赁计划子表

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    public Date getPlanOutDateMain() {
        return planOutDateMain;
    }

    public void setPlanOutDateMain(Date planOutDateMain) {
        this.planOutDateMain = planOutDateMain;
    }

    public Date getPlanApproachDateMain() {
        return planApproachDateMain;
    }

    public void setPlanApproachDateMain(Date planApproachDateMain) {
        this.planApproachDateMain = planApproachDateMain;
    }

    public Integer getBiddingState() {
        return biddingState;
    }

    public void setBiddingState(Integer biddingState) {
        this.biddingState = biddingState;
    }
    public BigDecimal getTemporaryAmount() {
        return temporaryAmount;
    }

    public void setTemporaryAmount(BigDecimal temporaryAmount) {
        this.temporaryAmount = temporaryAmount;
    }
    public String getEditionCode() {
        return editionCode;
    }

    public void setEditionCode(String editionCode) {
        this.editionCode = editionCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getOrganizationUserId() {
        return organizationUserId;
    }

    public void setOrganizationUserId(Long organizationUserId) {
        this.organizationUserId = organizationUserId;
    }
    public String getOrganizationUserName() {
        return organizationUserName;
    }

    public void setOrganizationUserName(String organizationUserName) {
        this.organizationUserName = organizationUserName;
    }
    public String getEquipmentType() {
        return equipmentType;
    }

    public void setEquipmentType(String equipmentType) {
        this.equipmentType = equipmentType;
    }
    

    public List<RentEquipmentPlanSubEntity> getRentEquipmentPlanSubList() {
        return rentEquipmentPlanSubList;
    }

    public void setRentEquipmentPlanSubList(List<RentEquipmentPlanSubEntity> rentEquipmentPlanSubList) {
        this.rentEquipmentPlanSubList = rentEquipmentPlanSubList;
    }

    public Date getOrganizationDate() {
        return organizationDate;
    }

    public void setOrganizationDate(Date organizationDate) {
        this.organizationDate = organizationDate;
    }

    public String getBiddingStateName() {
        return biddingStateName;
    }

    public void setBiddingStateName(String biddingStateName) {
        this.biddingStateName = biddingStateName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
}
