package com.ejianc.business.rent.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.rent.vo.RentContractEquipmentAllVO;
import com.ejianc.business.rent.vo.RentContractVO;
import com.ejianc.business.rent.vo.RentDayDetailedVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.rent.bean.RentContractEntity;

import java.util.List;
import java.util.Map;

/**
 * 租赁合同
 * 
 * @author generator
 * 
 */
public interface IRentContractService extends IBaseService<RentContractEntity> {
    /**
     * 补充协议
     * @param rentContractVO
     */
    public RentContractVO saveOrUpdateSupplement(RentContractVO rentContractVO, String authority);

    boolean checkContract(Long id, Long otherId);

    public RentContractVO addConvertByConId(Long contractId);

    public Boolean addSupplementFlag(Long id);
    ExecutionVO targetCost(RentContractVO contractVO, String linkUrl);


    public Map<String, Object> countContractAmount(QueryParam param);

    public RentContractVO querySupplementRecord(Long id);
    void pushContract(RentContractVO contractVO);
    String validateContract(Long contractId, String billType, Long billId, String type);


    /**
     * 子表合计
     * @param param
     * @return
     */
    public IPage<RentContractEquipmentAllVO> queryEquipmentSubList(Map<String, Object> param);

    public Boolean delContractFile(Long contractFileId, String authority);

    public CommonResponse<String> deleteByIds(List<RentContractVO> vos);

    /**
     *
     * 查询合同编码是否重复
     * @param code
     * @return
     */
    public RentContractEntity selectCode(String code);

    /**
     * 弃审后删除合同池中的合同
     *
     * @param contractVO 需要删除的合同数据
     */
    void pushDelContract(RentContractVO contractVO);


    CommonResponse<RentContractVO> saveOrUpdate(RentContractVO saveOrUpdateVO, String authority, Boolean isControl);

    ParamsCheckVO targetCostCtrl(RentContractVO contractVO, String authority);

    ParamsCheckVO viewTargetCostCtrlInfo(Long id);

    RentContractVO queryDetail(Long id);

    CommonResponse<String> pushTargetCost(Long id);
    /**
     * 单据管控-合同金额大于总计划金额
     * @return
     */
    List<ParamsCheckVO> checkParamsMnyPlan(RentContractVO vo);
    /**
     * 单据管控-补充协议金额大于合同金额
     * @return
     */
    List<ParamsCheckVO> checkParamsMnySup(RentContractVO vo);

    ParamsCheckVO checkParams(RentContractVO vo, ParamsCheckVO paramsCheckVO2);

    /**
     * 删除文件中心水印文件
     *
     * @param watermarkFileId 水印合同附件id
     * @return boolean 是否删除标识
     */
    boolean delWatermarkContractFile(Long watermarkFileId);

    ContractPaymentResultVO queryPaymentApplyList(Long id);

    /*施工合同 控 补充协议,主合同
     *        @param 最新合同vo  或 协议vo

     * */
    List<ParamsCheckVO>  checkParamsConstruction(RentContractVO vo);

    void updateTargetResult(RentContractEntity vo, Integer type);

    Boolean validateTargetMny(RentContractEntity entity);

    List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList);

    /**
     * 根据合同id给水印文件赋值
     *
     * @param id 合同id
     */
    void asyncWatermarkById(Long id);

    /**
     * 获取合同归档控制参数  没有获取到参数默认不限制
     *
     * @return 合同归档控制参数(0：不限制，1：部分限制，2：全部限制)
     */
    String getContractFilingCode();

    /**
     * 根据合同归档控制参数，校验合同能否新增变更、补充协议
     *
     * @param contractId 合同id
     * @return true：可以新增，false：不能新增
     */
    boolean checkContractFiling(Long contractId);

    void delChangeById(Long id);

    void delRecordById(Long id);

    public Boolean delContractFromPool(Long id);

    public void delById(Long id);

        /**
     * 历史价控合同价
     * @param contractVO
     * @return
     */
    List<ParamsCheckVO>  historyPriceCtrlContractPrice(RentContractVO contractVO);
}
