package com.ejianc.business.temporary.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.api.IClauseSettingApi;
import com.ejianc.business.contractbase.vo.ClauseSettingVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * 合同条款
 *
 * @author CJ
 * @Description:
 * @date 2022/1/6 10:08
 */
@RestController
@RequestMapping("/temporaryContractClause/")
public class TemporaryContractClauseController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IClauseSettingApi clauseSettingApi;

    private String LaborSubCategoryProperty;

    /**
     * 根据合同分类属性查询合同下条款列表信息
     *
     * @return
     */
    @GetMapping("getContractClauses")
    public CommonResponse<JSONObject> getContractClauses() {
        JSONObject resp = new JSONObject();
        List<JSONObject> attrs = new ArrayList<>();
        resp.put("bo_code", "TemporaryContractClause");
        resp.put("bo_name", "合同条款");
        resp.put("bo_attrs", attrs);

        CommonResponse<List<ClauseSettingVO>> clauseResp = clauseSettingApi.getListByCategoryProperty("equipmentRent");

        if(!clauseResp.isSuccess()) {
            logger.error("查询合同条款列表失败, {} ", clauseResp.getMsg());
            return CommonResponse.error("查询合同条款列表失败！");
        }

        List<ClauseSettingVO> clauseList = clauseResp.getData();
        JSONObject tmp = null;
        for(ClauseSettingVO clause : clauseList) {
            tmp = new JSONObject();
            tmp.put("id", clause.getId());
            tmp.put("code", "::clauseNameId$clauseContent$"+clause.getId());
            tmp.put("fieldname", "::clauseNameId$clauseContent$"+clause.getId());
            tmp.put("clauseCode", clause.getCode());
            tmp.put("name", clause.getClauseName());
            tmp.put("type", "attr");
            tmp.put("fieldtype", "text");

            attrs.add(tmp);
        }
        return CommonResponse.success("查询成功！", resp);
    }

}
