/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.rent.bean.ConfirmationContentEntity;
import com.ejianc.business.rent.bean.ConfirmationEntity;
import com.ejianc.business.rent.service.IConfirmationService;
import com.ejianc.business.rent.service.impl.ConfirmationContentServiceImpl;
import com.ejianc.business.rent.service.impl.ConfirmationServiceImpl;
import com.ejianc.business.rent.vo.ConfirmationVO;
import com.ejianc.business.rent.vo.DisposalVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"confirmation"})
public class ConfirmationController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "CONFIRM";
    @Autowired
    private IConfirmationService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ConfirmationServiceImpl confirmationService;
    @Autowired
    private ConfirmationContentServiceImpl confirmationContentService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ConfirmationVO> saveOrUpdate(@RequestBody ConfirmationVO saveOrUpdateVO) {
        ConfirmationEntity entity = (ConfirmationEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ConfirmationEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ConfirmationVO vo = (ConfirmationVO)BeanMapper.map((Object)((Object)entity), ConfirmationVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ConfirmationVO> queryDetail(Long id) {
        ConfirmationEntity entity = (ConfirmationEntity)((Object)this.service.selectById(id));
        ConfirmationVO vo = (ConfirmationVO)BeanMapper.map((Object)((Object)entity), ConfirmationVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConfirmationVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ConfirmationVO confirmationVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryListDisposal"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DisposalVo>> queryListDisposal(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName", "supplierName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        if (param.getParams().containsKey("useDate")) {
            String useDate = ((Parameter)param.getParams().get("useDate")).getValue().toString();
            String[] split = useDate.split(",");
            param.getParams().put("useDate", new Parameter("sql", (Object)("use_date <= '" + split[1] + "' and use_date >='" + split[0] + "'")));
        }
        IPage<DisposalVo> page = this.service.queryData(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", page);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ConfirmationVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        Object orgVOList = null;
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ConfirmationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExportDisposal"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportDisposal(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName", "supplierName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        if (param.getParams().containsKey("useDate")) {
            String useDate = ((Parameter)param.getParams().get("useDate")).getValue().toString();
            String[] split = useDate.split(",");
            param.getParams().put("useDate", new Parameter("sql", (Object)("use_date <= '" + split[1] + "' and use_date >='" + split[0] + "'")));
        }
        IPage<DisposalVo> page = this.service.queryData(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", page.getRecords());
        ExcelExport.getInstance().export("disposal.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.service.queryPage(param, false);
        HashMap<String, List> beans = new HashMap<String, List>();
        if (pageData.getRecords() != null && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), ConfirmationVO.class);
            if (list != null) {
                list.forEach(vo -> {
                    BillStateEnum billStateEnum;
                    Integer billState = vo.getBillState();
                    if (billState != null && (billStateEnum = BillStateEnum.getEnumByStateCode((Integer)billState)) != null) {
                        vo.setBillStateName(billStateEnum.getDescription());
                    }
                });
            }
            beans.put("records", list);
            ExcelExport.getInstance().export("confirmation.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/refConfirmationData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ConfirmationVO>> refConfirmationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get("projectId") != null) {
                param.getParams().put("projectId", new Parameter("eq", _con.get("projectId")));
                this.logger.info("\u6761\u4ef6\u8fc7\u6ee4project:{}", _con.get("projectId"));
            }
            if (_con.get("contractId") != null) {
                param.getParams().put("contractId", new Parameter("eq", _con.get("contractId")));
                this.logger.info("\u6761\u4ef6\u8fc7\u6ee4contractId:{}", _con.get("contractId"));
            }
            if (_con.get("supplierId") != null) {
                param.getParams().put("supplierId", new Parameter("eq", _con.get("supplierId")));
                this.logger.info("\u6761\u4ef6\u8fc7\u6ee4supplierId:{}", _con.get("supplierId"));
            }
            param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List confirmationVOS = BeanMapper.mapList((Iterable)page.getRecords(), ConfirmationVO.class);
        List list = page.getRecords();
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            pageData.setRecords(confirmationVOS);
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(ConfirmationContentEntity::getConfirmId, ids);
        List confirmationContentEntities = this.confirmationContentService.list((Wrapper)lambdaQueryWrapper);
        Map collect = confirmationContentEntities.stream().collect(Collectors.toMap(ConfirmationContentEntity::getConfirmId, Function.identity()));
        confirmationVOS.forEach(vo -> {
            if (collect.containsKey(vo.getId())) {
                ConfirmationContentEntity confirmationContentEntity = (ConfirmationContentEntity)((Object)((Object)collect.get(vo.getId())));
                vo.setEquipmentCode(confirmationContentEntity.getEquipmentCode());
                vo.setEquipmentName(confirmationContentEntity.getEquipmentName());
                vo.setUnit(confirmationContentEntity.getRentUnit());
                vo.setSpecs(confirmationContentEntity.getSpecs());
                vo.setPrice(confirmationContentEntity.getPrice());
                vo.setNum(confirmationContentEntity.getNum());
                vo.setUseDate(confirmationContentEntity.getUseDate());
                vo.setContent(confirmationContentEntity.getContent());
                vo.setsId(confirmationContentEntity.getId());
                vo.setBeginTime(confirmationContentEntity.getBeginTime());
                vo.setEndTime(confirmationContentEntity.getEndTime());
            }
        });
        pageData.setRecords(confirmationVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

