/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.ac.enums.PerformanceStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.bean.RentDayDetailedEntity;
import com.ejianc.business.rent.bean.RentMonthDetailedEntity;
import com.ejianc.business.rent.bean.RentQuantitiesDetailedEntity;
import com.ejianc.business.rent.bean.RentRentalDayEntity;
import com.ejianc.business.rent.bean.RentRentalEntity;
import com.ejianc.business.rent.bean.RentRentalMonthEntity;
import com.ejianc.business.rent.bean.RentRentalQuantitiesEntity;
import com.ejianc.business.rent.bean.RentSettlementDayEntity;
import com.ejianc.business.rent.bean.RentSettlementEntity;
import com.ejianc.business.rent.bean.RentSettlementFeeEntity;
import com.ejianc.business.rent.bean.RentSettlementFragmentaryEntity;
import com.ejianc.business.rent.bean.RentSettlementMonthEntity;
import com.ejianc.business.rent.bean.RentSettlementQuantitiesEntity;
import com.ejianc.business.rent.bean.RentSettlementRentalEntity;
import com.ejianc.business.rent.mapper.RentSettlementMapper;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.service.IRentRentalDayService;
import com.ejianc.business.rent.service.IRentRentalMonthService;
import com.ejianc.business.rent.service.IRentRentalQuantitiesService;
import com.ejianc.business.rent.service.IRentRentalService;
import com.ejianc.business.rent.service.IRentSettlementDayService;
import com.ejianc.business.rent.service.IRentSettlementFragmentaryService;
import com.ejianc.business.rent.service.IRentSettlementMonthService;
import com.ejianc.business.rent.service.IRentSettlementQuantitiesService;
import com.ejianc.business.rent.service.IRentSettlementRentalService;
import com.ejianc.business.rent.service.IRentSettlementService;
import com.ejianc.business.rent.vo.RentSettleRecordVO;
import com.ejianc.business.rent.vo.RentSettlementDayVO;
import com.ejianc.business.rent.vo.RentSettlementVO;
import com.ejianc.business.rent.vo.SupRentSettlementDayVO;
import com.ejianc.business.rent.vo.SupRentSettlementFeeVO;
import com.ejianc.business.rent.vo.SupRentSettlementMonthVO;
import com.ejianc.business.rent.vo.SupRentSettlementQuantitiesVO;
import com.ejianc.business.rent.vo.SupRentSettlementRentalVO;
import com.ejianc.business.rent.vo.SupRentSettlementVO;
import com.ejianc.business.settle.vo.CostPriceApiVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.enums.RentTypeEnum;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.temporary.userecord.bean.TemporaryUseRecordSubEntity;
import com.ejianc.business.temporary.userecord.service.ITemporaryUseRecordSubService;
import com.ejianc.business.utils.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="rentSettlementService")
public class RentSettlementServiceImpl
extends BaseServiceImpl<RentSettlementMapper, RentSettlementEntity>
implements IRentSettlementService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDutyApi dutyApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String CHECK_PARAM_CODE_GC = "P-5kO0W220";
    private static final String CHECK_PARAM_CODE_ZZ = "P-Zez9060156";
    private static final String PRICE_PARAM_CODE = "P-3lt4470215";
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "RENT_SETTLE";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IRentRentalService rentRentalService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ITemporaryUseRecordSubService temporaryUseRecordSubService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IRentSettlementFragmentaryService rentSettlementFragmentaryService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private RentSettlementMapper rentSettlementMapper;
    @Autowired
    private IRentSettlementRentalService rentSettlementRentalService;
    @Autowired
    private IRentSettlementDayService rentSettlementDayService;
    @Autowired
    private IRentSettlementMonthService rentSettlementMonthService;
    @Autowired
    private IRentSettlementQuantitiesService rentSettlementQuantitiesService;
    @Autowired
    private IRentRentalDayService rentRentalDayService;
    @Autowired
    private IRentRentalMonthService rentRentalMonthService;
    @Autowired
    private IRentRentalQuantitiesService rentRentalQuantitiesService;
    private final String OPERATE = "RENT_SETTLE_JS";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/rentSettlement/saveRentSettlement";
    private final String DEL_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/rentSettlement/deleteRentSettlement";
    private static final String BILL_TYPE = "EJCBT202204000006";

    private String getBaseHost() {
        return StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
    }

    @Override
    public RentSettlementVO saveOrUpdate(RentSettlementVO saveOrUpdateVO) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, RentSettlementEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setRelationFlag("0");
            entity.setProportionFlag("0");
            entity.setSignStatus(0);
            entity.setSignatureStatus(0);
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        if (null != entity.getContractId() && this.queryExist(entity.getContractId(), entity.getId())) {
            throw new BusinessException("\u8be5\u5408\u540c\u4e0b\u6709\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355\uff01");
        }
        List<RentSettlementFragmentaryEntity> rentSettlementFragmentaryList = entity.getRentSettlementFragmentaryList();
        if (CollectionUtils.isNotEmpty(rentSettlementFragmentaryList)) {
            ArrayList<Long> addLong = new ArrayList<Long>();
            ArrayList<Long> delLong = new ArrayList<Long>();
            for (RentSettlementFragmentaryEntity fragmentaryEntity : rentSettlementFragmentaryList) {
                if ("del".equals(fragmentaryEntity.getRowState())) {
                    delLong.add(fragmentaryEntity.getSourceId());
                    continue;
                }
                addLong.add(fragmentaryEntity.getSourceId());
            }
            this.updateSettleFlag(addLong, true);
            this.updateSettleFlag(delLong, false);
        }
        super.saveOrUpdate((Object)entity, false);
        this.pushSettlementTargetCost(entity.getId());
        this.saveCost(entity, 0);
        RentSettlementVO vo = (RentSettlementVO)BeanMapper.map((Object)((Object)entity), RentSettlementVO.class);
        return vo;
    }

    public void updateSettleFlag(List<Long> ids, Boolean flag) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(TemporaryUseRecordSubEntity::getPid, ids);
        List list = this.temporaryUseRecordSubService.list((Wrapper)wrapper);
        List collect = list.stream().map(item -> item.getId()).collect(Collectors.toList());
        if (flag.booleanValue()) {
            this.logger.info("\u7ed3\u7b97--\u4e34\u65f6\u8bb0\u5f55id--{}", (Object)JSONObject.toJSONString(ids));
            this.temporaryUseRecordSubService.updateSettleFlag(collect, 1);
        } else {
            this.logger.info("\u91ca\u653e--\u4e34\u65f6\u8bb0\u5f55id--{}", (Object)JSONObject.toJSONString(ids));
            this.temporaryUseRecordSubService.updateSettleFlag(collect, 0);
        }
    }

    @Override
    public void delete(List<Long> settleIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(RentSettlementFragmentaryEntity::getSettlementId, settleIds);
        List list = this.rentSettlementFragmentaryService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List<Long> delIds = list.stream().map(RentSettlementFragmentaryEntity::getSourceId).collect(Collectors.toList());
            this.updateSettleFlag(delIds, false);
        }
        super.removeByIds(settleIds, false);
    }

    @Override
    public void delById(Long id) {
        Boolean flag = this.rentSettlementMapper.delById(id);
        if (Boolean.FALSE.equals(flag)) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25!");
        }
    }

    @Override
    public CommonResponse<String> pushSettlementTargetCost(Long id) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)this.selectById(id));
        this.logger.info("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5f00\u59cb");
        CommonResponse response = this.executionApi.aggPush(this.settlementTargetCost(entity, true));
        if (!response.isSuccess()) {
            this.logger.error("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5931\u8d25: , {}", (Object)response.getMsg());
            throw new BusinessException(response.getMsg());
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a8\u9001\u6210\u529f");
    }

    @Override
    public ParamsCheckVO costPriceParams(CostPriceApiVO materialPriceHistoryApiVO, String priceParam, String nodeName) {
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        List detailList = materialPriceHistoryApiVO.getCostPriceApiVOList();
        Long orgId = materialPriceHistoryApiVO.getOrgId();
        if (null == orgId) {
            this.logger.info("orgId\u4e3a\u7a7a");
            return paramsCheckVO;
        }
        this.logger.info("priceParam" + priceParam);
        this.logger.info("nodeName" + nodeName);
        CommonResponse maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(priceParam, orgId);
        if (!maxParamByCode.isSuccess() && null == maxParamByCode.getData()) {
            this.logger.info(maxParamByCode.getMsg());
            return paramsCheckVO;
        }
        List maxParamVOS = (List)maxParamByCode.getData();
        List materialIds = detailList.stream().map(CostPriceApiVO::getMaterialId).collect(Collectors.toList());
        CommonResponse dutyRes = this.dutyApi.queryPriceByRentDocIds(materialPriceHistoryApiVO.getProjectId(), DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode(), materialIds);
        if (null == dutyRes) {
            this.logger.info("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u4ef7\u683c\u4e3a\u7a7a");
            return paramsCheckVO;
        }
        Map dutyMap = (Map)dutyRes.getData();
        if (null == dutyMap) {
            this.logger.info("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u4ef7\u683cmap\u4e3a\u7a7a");
            return paramsCheckVO;
        }
        if (CollectionUtils.isNotEmpty((Collection)maxParamVOS)) {
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOCost = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOCost.setWarnType(paramsArray[maxParamVO.getControlType()]);
                for (CostPriceApiVO detailVO : detailList) {
                    BigDecimal maxPrice = dutyMap.get(detailVO.getMaterialId()) == null ? BigDecimal.ZERO : ((BigDecimal)dutyMap.get(detailVO.getMaterialId())).setScale(4, 4);
                    BigDecimal price = detailVO.getPrice() == null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, 4);
                    BigDecimal maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4);
                    this.logger.info("\u6d4b\u8bd5\u6570\u636e:maxPrice" + maxPrice);
                    this.logger.info("\u6d4b\u8bd5\u6570\u636e:price" + price);
                    this.logger.info("\u6d4b\u8bd5\u6570\u636e:roleValueMax" + roleValueMax);
                    this.logger.info("\u6d4b\u8bd5\u6570\u636e:maxPriceParam" + maxPriceParam);
                    this.logger.info("\u6d4b\u8bd5\u6570\u636e:maxPriceParam" + maxPriceParam);
                    if (price.compareTo(maxPriceParam) <= 0) continue;
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName(nodeName + "\u5355\u4ef7\u5927\u4e8e\u76ee\u6807\u6210\u672c\u5355\u4ef7");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(nodeName + "\u5355\u4ef7\uff1a").append(price).append("\uff0c\u76ee\u6807\u6210\u672c\u5355\u4ef7:(").append(maxPrice).append("),\u76ee\u6807\u6210\u672c\u5355\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\uff0c\u8d85\u51fa\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                paramsCheckVOCost.setDataSource(checkDsVOSMax);
                paramsCheckVOS.add(paramsCheckVOCost);
            }
        }
        String[] paramsArr = new String[]{"alert", "warn", "none"};
        HashMap<String, List> map = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArr) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public ExecutionVO settlementTargetCost(RentSettlementEntity entity, boolean detailListFlag) {
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getBillCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u8bbe\u5907\u79df\u8d41\u7ed3\u7b97\u5355.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u7ed3\u7b97.getCode());
        totalVO.setContractId(entity.getContractId());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        totalVO.setMoney(entity.getSettlementMny());
        totalVO.setTaxMoney(entity.getSettlementTaxMny());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setLinkUrl(this.getBaseHost() + "ejc-proequipment-frontend/#/rentSettleList/rentSettleCard?id=" + entity.getId());
        executionVO.setTotalVO(totalVO);
        if (detailListFlag) {
            List list;
            List categoryVOList;
            List<RentSettlementQuantitiesEntity> list2;
            List<RentSettlementMonthEntity> rentSettlementMonthList;
            List<RentSettlementDayEntity> rentSettlementDayList;
            List<RentSettlementRentalEntity> rentSettlementRentalList = entity.getRentSettlementRentalList();
            if (CollectionUtils.isNotEmpty(rentSettlementRentalList)) {
                List rentalIdList = rentSettlementRentalList.stream().map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList());
                for (Long l : rentalIdList) {
                    List<RentRentalQuantitiesEntity> list3;
                    Object rentRentalMonthEntity2;
                    List<RentRentalMonthEntity> rentalMonthList;
                    RentRentalEntity rentRentalEntity = (RentRentalEntity)((Object)this.rentRentalService.selectById(l));
                    List<RentRentalDayEntity> rentalDayList = rentRentalEntity.getRentRentalDayList();
                    if (CollectionUtils.isNotEmpty(rentalDayList)) {
                        for (RentRentalDayEntity rentRentalDayEntity : rentalDayList) {
                            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                            detailExecutionVO.setSourceId(Long.valueOf(rentRentalDayEntity.getId() == null ? IdWorker.getId() : rentRentalDayEntity.getId()));
                            detailExecutionVO.setSourceBillId(entity.getId());
                            detailExecutionVO.setCategoryId(rentRentalDayEntity.getCategoryId());
                            detailExecutionVO.setCategoryName(rentRentalDayEntity.getCategoryName());
                            detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                            detailExecutionVO.setDocId(rentRentalDayEntity.getEquipmentId());
                            detailExecutionVO.setCode(rentRentalDayEntity.getEquipmentCode());
                            detailExecutionVO.setName(rentRentalDayEntity.getEquipmentName());
                            detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                            detailExecutionVO.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
                            detailExecutionVO.setUnitName(rentRentalDayEntity.getUnitName());
                            detailExecutionVO.setNum(new BigDecimal(rentRentalDayEntity.getRentNum()));
                            detailExecutionVO.setSpec(rentRentalDayEntity.getSpec());
                            detailExecutionVO.setMoney(rentRentalDayEntity.getRentDayMny());
                            detailExecutionVO.setTaxMoney(rentRentalDayEntity.getRentDayTaxMny());
                            detailExecutionVO.setPrice(rentRentalDayEntity.getDayRentNotTaxPrice());
                            detailExecutionVO.setTaxPrice(rentRentalDayEntity.getDayRentPrice());
                            detailExecutionVO.setTaxRate(rentRentalDayEntity.getTax());
                            detailExecutionVO.setContractId(entity.getContractId());
                            detailExecutionVO.setRentType(RentTypeEnum.\u65e5\u79df.getCode());
                            detailList.add(detailExecutionVO);
                        }
                    }
                    if (CollectionUtils.isNotEmpty(rentalMonthList = rentRentalEntity.getRentRentalMonthList())) {
                        for (Object rentRentalMonthEntity2 : rentalMonthList) {
                            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                            detailExecutionVO.setSourceId(Long.valueOf(rentRentalMonthEntity2.getId() == null ? IdWorker.getId() : rentRentalMonthEntity2.getId()));
                            detailExecutionVO.setSourceBillId(entity.getId());
                            detailExecutionVO.setCategoryId(((RentRentalMonthEntity)((Object)rentRentalMonthEntity2)).getCategoryId());
                            detailExecutionVO.setCategoryName(((RentRentalMonthEntity)((Object)rentRentalMonthEntity2)).getCategoryName());
                            detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                            detailExecutionVO.setDocId(((RentRentalMonthEntity)((Object)rentRentalMonthEntity2)).getEquipmentId());
                            detailExecutionVO.setCode(((RentRentalMonthEntity)((Object)rentRentalMonthEntity2)).getEquipmentCode());
                            detailExecutionVO.setName(((RentRentalMonthEntity)((Object)rentRentalMonthEntity2)).getEquipmentName());
                            detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                            detailExecutionVO.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
                            detailExecutionVO.setUnitName(((RentRentalMonthEntity)((Object)rentRentalMonthEntity2)).getUnitName());
                            detailExecutionVO.setNum(new BigDecimal(((RentRentalMonthEntity)((Object)rentRentalMonthEntity2)).getRentNum()));
                            detailExecutionVO.setSpec(((RentRentalMonthEntity)((Object)rentRentalMonthEntity2)).getSpec());
                            detailExecutionVO.setMoney(((RentRentalMonthEntity)((Object)rentRentalMonthEntity2)).getRentMonthMny());
                            detailExecutionVO.setTaxMoney(((RentRentalMonthEntity)((Object)rentRentalMonthEntity2)).getRentMonthTaxMny());
                            detailExecutionVO.setPrice(((RentRentalMonthEntity)((Object)rentRentalMonthEntity2)).getMonthRentNotTaxPrice());
                            detailExecutionVO.setTaxPrice(((RentRentalMonthEntity)((Object)rentRentalMonthEntity2)).getMonthRentPrice());
                            detailExecutionVO.setTaxRate(((RentRentalMonthEntity)((Object)rentRentalMonthEntity2)).getTax());
                            detailExecutionVO.setContractId(entity.getContractId());
                            detailExecutionVO.setRentType(RentTypeEnum.\u6708\u79df.getCode());
                            detailList.add(detailExecutionVO);
                        }
                    }
                    if (!CollectionUtils.isNotEmpty(list3 = rentRentalEntity.getRentRentalQuantitiesList())) continue;
                    rentRentalMonthEntity2 = list3.iterator();
                    while (rentRentalMonthEntity2.hasNext()) {
                        RentRentalQuantitiesEntity rentRentalQuantitiesEntity = (RentRentalQuantitiesEntity)((Object)rentRentalMonthEntity2.next());
                        DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                        detailExecutionVO.setSourceId(Long.valueOf(rentRentalQuantitiesEntity.getId() == null ? IdWorker.getId() : rentRentalQuantitiesEntity.getId()));
                        detailExecutionVO.setSourceBillId(entity.getId());
                        detailExecutionVO.setCategoryId(rentRentalQuantitiesEntity.getCategoryId());
                        detailExecutionVO.setCategoryName(rentRentalQuantitiesEntity.getCategoryName());
                        detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                        detailExecutionVO.setDocId(rentRentalQuantitiesEntity.getEquipmentId());
                        detailExecutionVO.setCode(rentRentalQuantitiesEntity.getEquipmentCode());
                        detailExecutionVO.setName(rentRentalQuantitiesEntity.getEquipmentName());
                        detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                        detailExecutionVO.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
                        detailExecutionVO.setUnitName(rentRentalQuantitiesEntity.getUnitName());
                        detailExecutionVO.setNum(new BigDecimal(rentRentalQuantitiesEntity.getRentNum()));
                        detailExecutionVO.setSpec(rentRentalQuantitiesEntity.getSpec());
                        detailExecutionVO.setMoney(rentRentalQuantitiesEntity.getRentQuantitiesMny());
                        detailExecutionVO.setTaxMoney(rentRentalQuantitiesEntity.getRentQuantitiesTaxMny());
                        detailExecutionVO.setPrice(rentRentalQuantitiesEntity.getNotTaxQuantitiesPrice());
                        detailExecutionVO.setTaxPrice(rentRentalQuantitiesEntity.getQuantitiesPrice());
                        detailExecutionVO.setTaxRate(rentRentalQuantitiesEntity.getTax());
                        detailExecutionVO.setContractId(entity.getContractId());
                        detailExecutionVO.setRentType(RentTypeEnum.\u5de5\u7a0b\u91cf\u79df.getCode());
                        detailList.add(detailExecutionVO);
                    }
                }
            }
            if ((rentSettlementDayList = entity.getRentSettlementDayList()) != null) {
                for (RentSettlementDayEntity rentSettlementDayEntity : rentSettlementDayList) {
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(Long.valueOf(rentSettlementDayEntity.getId() == null ? IdWorker.getId() : rentSettlementDayEntity.getId()));
                    detailExecutionVO.setSourceBillId(entity.getId());
                    detailExecutionVO.setCategoryId(rentSettlementDayEntity.getEquipmentTypeId());
                    detailExecutionVO.setCategoryName(rentSettlementDayEntity.getEquipmentTypeName());
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocId(rentSettlementDayEntity.getEquipmentId());
                    detailExecutionVO.setCode(rentSettlementDayEntity.getEquipmentCode());
                    detailExecutionVO.setName(rentSettlementDayEntity.getEquipmentName());
                    detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
                    detailExecutionVO.setUnitId(rentSettlementDayEntity.getUnitId());
                    detailExecutionVO.setUnitName(rentSettlementDayEntity.getUnit());
                    detailExecutionVO.setNum(rentSettlementDayEntity.getDayNum());
                    detailExecutionVO.setSpec(rentSettlementDayEntity.getSpec());
                    detailExecutionVO.setMoney(rentSettlementDayEntity.getDayMny());
                    detailExecutionVO.setTaxMoney(rentSettlementDayEntity.getDayTaxMny());
                    detailExecutionVO.setPrice(rentSettlementDayEntity.getDayPrice());
                    detailExecutionVO.setTaxPrice(rentSettlementDayEntity.getDayTaxPrice());
                    detailExecutionVO.setTaxRate(rentSettlementDayEntity.getDayTaxRate());
                    detailExecutionVO.setContractId(entity.getContractId());
                    detailExecutionVO.setRentType(RentTypeEnum.\u65e5\u79df.getCode());
                    detailList.add(detailExecutionVO);
                }
            }
            if ((rentSettlementMonthList = entity.getRentSettlementMonthList()) != null) {
                for (RentSettlementMonthEntity rentSettlementMonthEntity : rentSettlementMonthList) {
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(Long.valueOf(rentSettlementMonthEntity.getId() == null ? IdWorker.getId() : rentSettlementMonthEntity.getId()));
                    detailExecutionVO.setSourceBillId(entity.getId());
                    detailExecutionVO.setCategoryId(rentSettlementMonthEntity.getEquipmentTypeId());
                    detailExecutionVO.setCategoryName(rentSettlementMonthEntity.getEquipmentTypeName());
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocId(rentSettlementMonthEntity.getEquipmentId());
                    detailExecutionVO.setCode(rentSettlementMonthEntity.getEquipmentCode());
                    detailExecutionVO.setName(rentSettlementMonthEntity.getEquipmentName());
                    detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
                    detailExecutionVO.setUnitId(rentSettlementMonthEntity.getUnitId());
                    detailExecutionVO.setUnitName(rentSettlementMonthEntity.getUnit());
                    detailExecutionVO.setNum(rentSettlementMonthEntity.getMonthNum());
                    detailExecutionVO.setSpec(rentSettlementMonthEntity.getSpec());
                    detailExecutionVO.setMoney(rentSettlementMonthEntity.getMonthMny());
                    detailExecutionVO.setTaxMoney(rentSettlementMonthEntity.getMonthTaxMny());
                    detailExecutionVO.setPrice(rentSettlementMonthEntity.getMonthPrice());
                    detailExecutionVO.setTaxPrice(rentSettlementMonthEntity.getMonthTaxPrice());
                    detailExecutionVO.setTaxRate(rentSettlementMonthEntity.getMonthTaxRate());
                    detailExecutionVO.setContractId(entity.getContractId());
                    detailExecutionVO.setRentType(RentTypeEnum.\u6708\u79df.getCode());
                    detailList.add(detailExecutionVO);
                }
            }
            if ((list2 = entity.getRentSettlementQuantitiesList()) != null) {
                for (RentSettlementQuantitiesEntity rentQuantitiesEntity : list2) {
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(Long.valueOf(rentQuantitiesEntity.getId() == null ? IdWorker.getId() : rentQuantitiesEntity.getId()));
                    detailExecutionVO.setSourceBillId(entity.getId());
                    detailExecutionVO.setCategoryId(rentQuantitiesEntity.getEquipmentTypeId());
                    detailExecutionVO.setCategoryName(rentQuantitiesEntity.getEquipmentTypeName());
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocId(rentQuantitiesEntity.getEquipmentId());
                    detailExecutionVO.setCode(rentQuantitiesEntity.getEquipmentCode());
                    detailExecutionVO.setName(rentQuantitiesEntity.getEquipmentName());
                    detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
                    detailExecutionVO.setUnitId(rentQuantitiesEntity.getUnitId());
                    detailExecutionVO.setUnitName(rentQuantitiesEntity.getUnit());
                    detailExecutionVO.setNum(rentQuantitiesEntity.getQuantitiesNum());
                    detailExecutionVO.setSpec(rentQuantitiesEntity.getSpec());
                    detailExecutionVO.setMoney(rentQuantitiesEntity.getQuantitiesMny());
                    detailExecutionVO.setTaxMoney(rentQuantitiesEntity.getQuantitiesTaxMny());
                    detailExecutionVO.setPrice(rentQuantitiesEntity.getQuantitiesPrice());
                    detailExecutionVO.setTaxPrice(rentQuantitiesEntity.getQuantitiesTaxPrice());
                    detailExecutionVO.setTaxRate(rentQuantitiesEntity.getQuantitiesTaxRate());
                    detailExecutionVO.setContractId(entity.getContractId());
                    detailExecutionVO.setRentType(RentTypeEnum.\u5de5\u7a0b\u91cf\u79df.getCode());
                    detailList.add(detailExecutionVO);
                }
            }
            if (CollectionUtils.isNotEmpty(detailList) && CollectionUtils.isNotEmpty((Collection)(categoryVOList = (List)this.materialApi.queryCategoryListByIds(list = detailList.stream().map(DetailExecutionVO::getCategoryId).collect(Collectors.toList())).getData()))) {
                Map categoryMap = categoryVOList.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
                for (DetailExecutionVO detailExecutionVO : detailList) {
                    if (null == categoryMap.get(detailExecutionVO.getCategoryId())) continue;
                    detailExecutionVO.setCategoryInnerCode(((MaterialCategoryVO)categoryMap.get(detailExecutionVO.getCategoryId())).getInnerCode());
                    detailExecutionVO.setCategoryCode(((MaterialCategoryVO)categoryMap.get(detailExecutionVO.getCategoryId())).getCode());
                }
            }
            executionVO.setDetailList(detailList);
        }
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e---\u8bbe\u5907\u79df\u8d41\u7ed3\u7b97\u4fdd\u5b58\u3001\u5220\u9664---->{}", (Object)JSONObject.toJSONString((Object)executionVO));
        return executionVO;
    }

    @Override
    public boolean queryExist(Long contractId, Long id) {
        List list;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(RentSettlementEntity::getContractId, (Object)contractId);
        wrapper.notIn(RentSettlementEntity::getBillState, new Object[]{1, 3});
        if (id != null) {
            wrapper.ne(BaseEntity::getId, (Object)id);
        }
        return CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)wrapper)));
    }

    @Override
    public CommonResponse<Map> getDateMny(Long contractId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BigDecimal currentTaxMny = BigDecimal.ZERO;
        BigDecimal currentMny = BigDecimal.ZERO;
        String sTDate = null;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        wrapper.in(RentSettlementEntity::getBillState, new Object[]{1, 3});
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.eq(RentSettlementEntity::getContractId, (Object)contractId);
        List list = super.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            sTDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)((RentSettlementEntity)((Object)list.get(0))).getSettlementDate());
            currentTaxMny = list.stream().filter(e -> null != e.getSettlementTaxMny()).map(RentSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentMny = list.stream().filter(e -> null != e.getSettlementMny()).map(RentSettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        map.put("currentTaxMny", currentTaxMny);
        map.put("currentMny", currentMny);
        map.put("sTDate", sTDate);
        map.put("settlementNum", list.size());
        return CommonResponse.success((String)"\u83b7\u53d6\u91d1\u989d\u548c\u65f6\u95f4\u6210\u529f\uff01", map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushBillToSupCenter(RentSettlementEntity entity) {
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = "EJCBT202204000006::" + entity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u8ba1\u91cf\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return false;
        }
        entity.setSystemId((String)ejcCloudSystemCode.getData());
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"RENT_SETTLE_JS", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "RENT_SETTLE_JS");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            SupRentSettlementVO supRentSettlementVO = (SupRentSettlementVO)BeanMapper.map((Object)((Object)entity), SupRentSettlementVO.class);
            List supRentSettlementDayVOS = BeanMapper.mapList(entity.getRentSettlementDayList(), SupRentSettlementDayVO.class);
            List supRentSettlementMonthVOS = BeanMapper.mapList(entity.getRentSettlementMonthList(), SupRentSettlementMonthVO.class);
            List supRentSettlementQuantitiesVOS = BeanMapper.mapList(entity.getRentSettlementQuantitiesList(), SupRentSettlementQuantitiesVO.class);
            List supRentSettlementRentalVOS = BeanMapper.mapList(entity.getRentSettlementRentalList(), SupRentSettlementRentalVO.class);
            List supSettlementFeeVOS = BeanMapper.mapList(entity.getRentSettlementFeeList(), SupRentSettlementFeeVO.class);
            supRentSettlementVO.setRentSettlementDayList(supRentSettlementDayVOS);
            supRentSettlementVO.setRentSettlementMonthList(supRentSettlementMonthVOS);
            supRentSettlementVO.setRentSettlementRentalList(supRentSettlementRentalVOS);
            supRentSettlementVO.setRentSettlementQuantitiesList(supRentSettlementQuantitiesVOS);
            supRentSettlementVO.setRentSettlementFeeList(supSettlementFeeVOS);
            paramMap.put("transData", JSONObject.toJSONString((Object)supRentSettlementVO));
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, "projectMangerSign", null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u9644\u4ef6\u53c2\u6570-{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString(files));
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u8ba1\u91cf\u5355\u636e\u53c2\u6570-{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-supbusiness-web/openapi/rentSettlement/saveRentSettlement", paramMap, entity.getSupplierId().toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), billPushResp.getMsg()});
                    }
                } else {
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{entity.getId(), entity.getSupplierId(), syncReqResp.getMsg()});
                }
            } else {
                this.logger.error("\u83b7\u53d6\u8ba2\u5355\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)entity.getId(), (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{entity.getId(), entity.getSupplierId(), e});
        }
        finally {
            this.releaseLock(jedis, locked, key, "RENT_SETTLE_JS");
        }
        return syncFlag;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CommonResponse<String> updatePushBill(RentSettlementEntity entity) {
        locked = false;
        jedis = this.jedisPool.getResource();
        key = "EJCBT202204000006::" + entity.getId().toString();
        ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
        entity.setSystemId((String)ejcCloudSystemCode.getData());
        entity.setSignStatus(0);
        ((RentSettlementMapper)this.baseMapper).updateById((Object)entity);
        this.logger.info("\u4fee\u6539\u7b7e\u5b57\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)entity));
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"RENT_SETTLE_JS", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "RENT_SETTLE_JS");
                var6_6 = CommonResponse.error((String)"\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25!");
                return var6_6;
            }
            paramMap = new HashMap<String, String>();
            paramMap.put("id", entity.getId().toString());
            paramMap.put("systemId", entity.getSystemId());
            this.logger.info("\u5355\u636eid-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", (Object)entity.getSupplierId(), (Object)entity.getId());
            syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem("/ejc-supbusiness-web/openapi/rentSettlement/deleteRentSettlement", RequestMethod.POST, JSONObject.toJSONString(paramMap), entity.getSupplierId().toString());
            if (!syncReqResp.isSuccess()) ** GOTO lbl36
            supHandleResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
            if (supHandleResp.isSuccess()) {
                var9_11 = supHandleResp;
                return var9_11;
            }
            try {
                this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u4f5c\u5e9f\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), supHandleResp.getMsg()});
                throw new BusinessException(supHandleResp.getMsg());
lbl36:
                // 1 sources

                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{} \u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), syncReqResp.getMsg()});
                throw new BusinessException(syncReqResp.getMsg());
            }
            catch (Exception e) {
                this.logger.error("\u901a\u77e5\u4f9b\u65b9\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)entity.getId(), (Object)e);
                throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
            }
        }
        finally {
            this.releaseLock(jedis, locked, key, "RENT_SETTLE_JS");
        }
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        RentSettlementEntity settlementEntity = (RentSettlementEntity)((Object)super.selectById((Serializable)((Object)billId)));
        settlementEntity.setSupOperateTime(supOperateTime);
        settlementEntity.setSupOperatorName(supOperatorName);
        settlementEntity.setSupOperatorPhone(supOperatorPhone);
        settlementEntity.setSupOperatorUserCode(supOperatorUserCode);
        String key = "EJCBT202204000006::" + settlementEntity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"RENT_SETTLE_JS", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)settlementEntity.getId());
                this.releaseLock(jedis, false, key, "RENT_SETTLE_JS");
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE, authority, settlementEntity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            settlementEntity.setAttachIds(attchIdsList);
            settlementEntity.setSignStatus(1);
            super.saveOrUpdate((Object)settlementEntity, false);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)settlementEntity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
            throw e;
        }
        finally {
            this.releaseLock(jedis, locked, key, "RENT_SETTLE_JS");
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean pushSettleToPool(RentSettlementVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb-----" + JSONObject.toJSONString((Object)vo));
            BeanConvertorUtil.convert((Object)vo, (Object)spv);
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
            this.convertSettleVOToSettlePoolVO(vo, spv);
            spv.setBillCodeUrl("/ejc-proequipment-frontend/#/rentSettleList/rentSettleCard?id=" + vo.getId());
            this.logger.info("\u63a8\u9001\u53c2\u6570----" + JSONObject.toJSONString((Object)spv));
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(spv);
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u7ed3\u675f---" + JSONObject.toJSONString((Object)res));
            if (!res.isSuccess()) {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)vo.getId(), (Object)res.getMsg());
                throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25!");
            }
            flag = true;
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u6210\u529f---{}", (Object)res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)vo.getId(), (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f00\u59cb,\u7ed3\u7b97\u5355id-{}", (Object)id);
            CommonResponse res = this.settlePoolApi.deleteSettle(spv);
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u7ed3\u675f---" + JSONObject.toJSONString((Object)res));
            if (!res.isSuccess()) {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
                throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25!");
            }
            flag = true;
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u6210\u529f---{}", (Object)res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)id, (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    private void convertSettleVOToSettlePoolVO(RentSettlementVO vo, SettlePoolVO spv) {
        if (null == vo || null == spv) {
            this.logger.error("\u5c06\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u539f\u56e0\uff1a\u7ed3\u7b97\u5355\u5bf9\u8c61\u4e3a\u7a7a\u6216\u7ed3\u7b97\u6c60\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u65e0\u6cd5\u8f6c\u6362\uff01");
            return;
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5f00\u59cb");
        spv.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        spv.setId(vo.getId());
        spv.setSourceType(SettleSourceTypeEnum.\u8bbe\u5907\u79df\u5165\u7ed3\u7b97.getCode());
        spv.setSettlePropertyName("\u652f\u51fa");
        spv.setSettleProperty(Integer.valueOf(0));
        spv.setSourceId(vo.getId());
        spv.setCreateUserCode(vo.getCreateUserCode());
        spv.setCreateTime(vo.getCreateTime());
        spv.setUpdateUserCode(vo.getUpdateUserCode());
        spv.setUpdateTime(vo.getUpdateTime());
        spv.setContractFlag(Integer.valueOf(0));
        spv.setHandleType(Integer.valueOf(0));
        if (vo.getContractId() != null) {
            spv.setContractFlag(Integer.valueOf(1));
            RentContractEntity contractEntity = (RentContractEntity)((Object)this.rentContractService.selectById(vo.getContractId()));
            spv.setContractType(ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode());
            spv.setSupplementFlag(contractEntity.getSupplementFlag());
            spv.setMaiContractId(contractEntity.getMainContractId());
            spv.setMaiContractName(contractEntity.getMainContractName());
            spv.setMaiContractCode(contractEntity.getMainContractCode());
            spv.setPartyaId(contractEntity.getPartyId());
            spv.setPartyaName(contractEntity.getPartyName());
            spv.setSignDate(contractEntity.getSignedDate());
            spv.setLastTaxMny(ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementTaxMny(), (BigDecimal)vo.getSettlementTaxMny()));
            spv.setLastMny(ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementMny(), (BigDecimal)vo.getSettlementMny()));
            spv.setLastTax(ComputeUtil.safeSub((BigDecimal)spv.getLastTaxMny(), (BigDecimal)spv.getLastMny()));
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210\uff0c\u4e0b\u9762\u5f00\u59cb\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60");
    }

    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }

    @Override
    public ExecutionVO targetCost(RentSettlementEntity entity) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(RentSettlementEntity::getContractId, (Object)entity.getContractId());
        wrapper.in(RentSettlementEntity::getBillState, Arrays.asList(1, 3));
        List settleList = this.list((Wrapper)wrapper);
        BigDecimal totalSettleTaxMny = settleList.stream().filter(e -> e.getSettlementTaxMny() != null).map(RentSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = settleList.stream().filter(e -> e.getSettlementMny() != null).map(RentSettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        RentContractEntity contractEntity = (RentContractEntity)((Object)this.rentContractService.getById(entity.getContractId()));
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getBillCode());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setBillCategory(BillCategoryEnum.\u7ed3\u7b97.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u8bbe\u5907\u79df\u8d41\u7ed3\u7b97\u5355.getCode());
        totalVO.setContractId(entity.getContractId());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        totalVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalSettleMny, (BigDecimal)contractEntity.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)contractEntity.getContractTaxMny()));
        totalVO.setLinkUrl(this.getBaseHost() + "ejc-proequipment-frontend/#/rentSettleList/rentSettleCard?id=" + entity.getId());
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(this.numDetailExecution(contractEntity, settleList));
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e---\u8bbe\u5907\u79df\u8d41\u5408\u540c\u6700\u7ec8\u7ed3\u7b97---->{}", (Object)JSONObject.toJSONString((Object)executionVO));
        return executionVO;
    }

    private List<DetailExecutionVO> numDetailExecution(RentContractEntity contractEntity, List<RentSettlementEntity> list) {
        List categoryIdList;
        List categoryVOList;
        DetailExecutionVO detailExecutionVO;
        BigDecimal sumTaxMny;
        BigDecimal sumMny;
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        Boolean dayDataFlag = CollectionUtils.isNotEmpty(contractEntity.getRentDayDetailedList());
        Boolean monthDataFlag = CollectionUtils.isNotEmpty(contractEntity.getRentMonthDetailedList());
        Boolean quantitiesDataFlag = CollectionUtils.isNotEmpty(contractEntity.getRentQuantitiesDetailedList());
        Map<Object, Object> settlementDayMap = new HashMap();
        Map<Object, Object> rentalDayMap = new HashMap();
        Map<Object, Object> settlementMonthMap = new HashMap();
        Map<Object, Object> rentalMonthMap = new HashMap();
        Map<Object, Object> settlementQuantitiesMap = new HashMap();
        Map<Object, Object> rentalQuantitiesMap = new HashMap();
        if (CollectionUtils.isNotEmpty(list)) {
            List settlementIdList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            if (dayDataFlag.booleanValue()) {
                LambdaQueryWrapper settlementDayQueryWrapper = new LambdaQueryWrapper();
                settlementDayQueryWrapper.in(RentSettlementDayEntity::getSettlementId, settlementIdList);
                List settlementDayList = this.rentSettlementDayService.list((Wrapper)settlementDayQueryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)settlementDayList)) {
                    settlementDayMap = settlementDayList.stream().filter(t -> null != t.getEquipmentId()).collect(Collectors.groupingBy(RentSettlementDayEntity::getEquipmentId));
                }
            }
            if (monthDataFlag.booleanValue()) {
                LambdaQueryWrapper settlementMonthQueryWrapper = new LambdaQueryWrapper();
                settlementMonthQueryWrapper.in(RentSettlementMonthEntity::getSettlementId, settlementIdList);
                List settlementMonthList = this.rentSettlementMonthService.list((Wrapper)settlementMonthQueryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)settlementMonthList)) {
                    settlementMonthMap = settlementMonthList.stream().filter(t -> null != t.getEquipmentId()).collect(Collectors.groupingBy(RentSettlementMonthEntity::getEquipmentId));
                }
            }
            if (quantitiesDataFlag.booleanValue()) {
                LambdaQueryWrapper settlementQuantitiesQueryWrapper = new LambdaQueryWrapper();
                settlementQuantitiesQueryWrapper.in(RentSettlementQuantitiesEntity::getSettlementId, settlementIdList);
                List settlementQuantitiesList = this.rentSettlementQuantitiesService.list((Wrapper)settlementQuantitiesQueryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)settlementQuantitiesList)) {
                    settlementQuantitiesMap = settlementQuantitiesList.stream().filter(t -> null != t.getEquipmentId()).collect(Collectors.groupingBy(RentSettlementQuantitiesEntity::getEquipmentId));
                }
            }
            LambdaQueryWrapper rentSettlementRentalQueryWrapper = new LambdaQueryWrapper();
            rentSettlementRentalQueryWrapper.in(RentSettlementRentalEntity::getSettlementId, settlementIdList);
            List rentSettlementRentalList = this.rentSettlementRentalService.list((Wrapper)rentSettlementRentalQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)rentSettlementRentalList)) {
                if (dayDataFlag.booleanValue()) {
                    LambdaQueryWrapper rentRentalDayWrapper = new LambdaQueryWrapper();
                    rentRentalDayWrapper.in(RentRentalDayEntity::getRentalId, (Collection)rentSettlementRentalList.stream().map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList()));
                    List rentRentalDayList = this.rentRentalDayService.list((Wrapper)rentRentalDayWrapper);
                    if (CollectionUtils.isNotEmpty((Collection)rentRentalDayList)) {
                        rentalDayMap = rentRentalDayList.stream().filter(t -> t.getEquipmentId() != null).collect(Collectors.groupingBy(RentRentalDayEntity::getEquipmentId));
                    }
                }
                if (monthDataFlag.booleanValue()) {
                    LambdaQueryWrapper rentRentalMonthWrapper = new LambdaQueryWrapper();
                    rentRentalMonthWrapper.in(RentRentalMonthEntity::getRentalId, (Collection)rentSettlementRentalList.stream().map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList()));
                    List rentRentalMonthList = this.rentRentalMonthService.list((Wrapper)rentRentalMonthWrapper);
                    if (CollectionUtils.isNotEmpty((Collection)rentRentalMonthList)) {
                        rentalMonthMap = rentRentalMonthList.stream().filter(t -> t.getEquipmentId() != null).collect(Collectors.groupingBy(RentRentalMonthEntity::getEquipmentId));
                    }
                }
                if (quantitiesDataFlag.booleanValue()) {
                    Iterator<BaseEntity> rentRentalQuantitiesWrapper = new LambdaQueryWrapper();
                    rentRentalQuantitiesWrapper.in(RentRentalQuantitiesEntity::getRentalId, rentSettlementRentalList.stream().map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList()));
                    List rentRentalQuantitiesList = this.rentRentalQuantitiesService.list((Wrapper)rentRentalQuantitiesWrapper);
                    if (CollectionUtils.isNotEmpty((Collection)rentRentalQuantitiesList)) {
                        rentalQuantitiesMap = rentRentalQuantitiesList.stream().filter(t -> t.getEquipmentId() != null).collect(Collectors.groupingBy(RentRentalQuantitiesEntity::getEquipmentId));
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(contractEntity.getRentDayDetailedList())) {
            for (RentDayDetailedEntity rentDayDetailedEntity : contractEntity.getRentDayDetailedList()) {
                sumMny = BigDecimal.ZERO;
                sumTaxMny = BigDecimal.ZERO;
                detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(rentDayDetailedEntity.getId());
                detailExecutionVO.setSourceBillId(rentDayDetailedEntity.getPid());
                detailExecutionVO.setCategoryId(rentDayDetailedEntity.getCategoryId());
                detailExecutionVO.setCategoryName(rentDayDetailedEntity.getCategoryName());
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocId(rentDayDetailedEntity.getEquipmentId());
                detailExecutionVO.setCode(rentDayDetailedEntity.getEquipmentCode());
                detailExecutionVO.setName(rentDayDetailedEntity.getName());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
                detailExecutionVO.setUnitName(rentDayDetailedEntity.getUnitName());
                detailExecutionVO.setSpec(rentDayDetailedEntity.getSpec());
                detailExecutionVO.setPrice(rentDayDetailedEntity.getDayRentPrice());
                detailExecutionVO.setTaxPrice(rentDayDetailedEntity.getDayRentNotTaxPrice());
                detailExecutionVO.setNum(new BigDecimal(rentDayDetailedEntity.getRentNum()));
                if (settlementDayMap.containsKey(rentDayDetailedEntity.getEquipmentId())) {
                    sumMny = ((List)settlementDayMap.get(rentDayDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getDayMny()).map(RentSettlementDayEntity::getDayMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = ((List)settlementDayMap.get(rentDayDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getDayTaxMny()).map(RentSettlementDayEntity::getDayTaxMny).reduce(sumTaxMny, BigDecimal::add);
                }
                if (rentalDayMap.containsKey(rentDayDetailedEntity.getEquipmentId())) {
                    sumMny = ((List)rentalDayMap.get(rentDayDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getRentDayMny()).map(RentRentalDayEntity::getRentDayMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = ((List)rentalDayMap.get(rentDayDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getRentDayTaxMny()).map(RentRentalDayEntity::getRentDayTaxMny).reduce(sumTaxMny, BigDecimal::add);
                }
                detailExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)sumMny, (BigDecimal)rentDayDetailedEntity.getRentMny()));
                detailExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)sumTaxMny, (BigDecimal)rentDayDetailedEntity.getRentTaxMny()));
                detailList.add(detailExecutionVO);
            }
        }
        if (CollectionUtils.isNotEmpty(contractEntity.getRentMonthDetailedList())) {
            for (RentMonthDetailedEntity rentMonthDetailedEntity : contractEntity.getRentMonthDetailedList()) {
                sumMny = BigDecimal.ZERO;
                sumTaxMny = BigDecimal.ZERO;
                detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(rentMonthDetailedEntity.getId());
                detailExecutionVO.setSourceBillId(rentMonthDetailedEntity.getPid());
                detailExecutionVO.setCategoryId(rentMonthDetailedEntity.getCategoryId());
                detailExecutionVO.setCategoryName(rentMonthDetailedEntity.getCategoryName());
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocId(rentMonthDetailedEntity.getEquipmentId());
                detailExecutionVO.setCode(rentMonthDetailedEntity.getEquipmentCode());
                detailExecutionVO.setName(rentMonthDetailedEntity.getName());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
                detailExecutionVO.setUnitName(rentMonthDetailedEntity.getUnitName());
                detailExecutionVO.setSpec(rentMonthDetailedEntity.getSpec());
                detailExecutionVO.setPrice(rentMonthDetailedEntity.getMonthRentPrice());
                detailExecutionVO.setTaxPrice(rentMonthDetailedEntity.getMonthRentNotTaxPrice());
                detailExecutionVO.setNum(new BigDecimal(rentMonthDetailedEntity.getRentNum()));
                if (settlementMonthMap.containsKey(rentMonthDetailedEntity.getEquipmentId())) {
                    sumMny = ((List)settlementMonthMap.get(rentMonthDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getMonthMny()).map(RentSettlementMonthEntity::getMonthMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = ((List)settlementMonthMap.get(rentMonthDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getMonthTaxMny()).map(RentSettlementMonthEntity::getMonthTaxMny).reduce(sumTaxMny, BigDecimal::add);
                }
                if (rentalMonthMap.containsKey(rentMonthDetailedEntity.getEquipmentId())) {
                    sumMny = ((List)rentalMonthMap.get(rentMonthDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getRentMonthMny()).map(RentRentalMonthEntity::getRentMonthMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = ((List)rentalMonthMap.get(rentMonthDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getRentMonthTaxMny()).map(RentRentalMonthEntity::getRentMonthTaxMny).reduce(sumTaxMny, BigDecimal::add);
                }
                detailExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)sumMny, (BigDecimal)rentMonthDetailedEntity.getRentMny()));
                detailExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)sumTaxMny, (BigDecimal)rentMonthDetailedEntity.getRentTaxMny()));
                detailList.add(detailExecutionVO);
            }
        }
        if (CollectionUtils.isNotEmpty(contractEntity.getRentQuantitiesDetailedList())) {
            for (RentQuantitiesDetailedEntity rentQuantitiesDetailedEntity : contractEntity.getRentQuantitiesDetailedList()) {
                sumMny = BigDecimal.ZERO;
                sumTaxMny = BigDecimal.ZERO;
                BigDecimal quantitiesNum = BigDecimal.ZERO;
                detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(rentQuantitiesDetailedEntity.getId());
                detailExecutionVO.setSourceBillId(rentQuantitiesDetailedEntity.getPid());
                detailExecutionVO.setCategoryId(rentQuantitiesDetailedEntity.getCategoryId());
                detailExecutionVO.setCategoryName(rentQuantitiesDetailedEntity.getCategoryName());
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocId(rentQuantitiesDetailedEntity.getEquipmentId());
                detailExecutionVO.setCode(rentQuantitiesDetailedEntity.getEquipmentCode());
                detailExecutionVO.setName(rentQuantitiesDetailedEntity.getName());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
                detailExecutionVO.setUnitName(rentQuantitiesDetailedEntity.getUnitName());
                detailExecutionVO.setSpec(rentQuantitiesDetailedEntity.getSpec());
                detailExecutionVO.setPrice(rentQuantitiesDetailedEntity.getQuantitiesPrice());
                detailExecutionVO.setTaxPrice(rentQuantitiesDetailedEntity.getNotTaxQuantitiesPrice());
                detailExecutionVO.setNum(new BigDecimal(rentQuantitiesDetailedEntity.getRentNum()));
                if (settlementQuantitiesMap.containsKey(rentQuantitiesDetailedEntity.getEquipmentId())) {
                    sumMny = ((List)settlementQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getQuantitiesMny()).map(RentSettlementQuantitiesEntity::getQuantitiesMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = ((List)settlementQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getQuantitiesTaxMny()).map(RentSettlementQuantitiesEntity::getQuantitiesTaxMny).reduce(sumTaxMny, BigDecimal::add);
                    quantitiesNum = ((List)settlementQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getQuantitiesNum()).map(RentSettlementQuantitiesEntity::getQuantitiesNum).reduce(quantitiesNum, BigDecimal::add);
                }
                if (rentalQuantitiesMap.containsKey(rentQuantitiesDetailedEntity.getEquipmentId())) {
                    sumMny = ((List)rentalQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getRentQuantitiesMny()).map(RentRentalQuantitiesEntity::getRentQuantitiesMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = ((List)rentalQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getRentQuantitiesTaxMny()).map(RentRentalQuantitiesEntity::getRentQuantitiesTaxMny).reduce(sumTaxMny, BigDecimal::add);
                    quantitiesNum = ((List)rentalQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getQuantitiesNum()).map(RentRentalQuantitiesEntity::getQuantitiesNum).reduce(quantitiesNum, BigDecimal::add);
                }
                detailExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)sumMny, (BigDecimal)rentQuantitiesDetailedEntity.getRentMny()));
                detailExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)sumTaxMny, (BigDecimal)rentQuantitiesDetailedEntity.getRentTaxMny()));
                detailExecutionVO.setQuantityNum(ComputeUtil.safeSub((BigDecimal)quantitiesNum, (BigDecimal)rentQuantitiesDetailedEntity.getQuantitiesNum()));
                detailList.add(detailExecutionVO);
            }
        }
        if (CollectionUtils.isNotEmpty(detailList) && CollectionUtils.isNotEmpty((Collection)(categoryVOList = (List)this.materialApi.queryCategoryListByIds(categoryIdList = detailList.stream().map(DetailExecutionVO::getCategoryId).collect(Collectors.toList())).getData()))) {
            Map categoryMap = categoryVOList.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
            for (DetailExecutionVO detailExecutionVO2 : detailList) {
                if (null == categoryMap.get(detailExecutionVO2.getCategoryId())) continue;
                detailExecutionVO2.setCategoryInnerCode(((MaterialCategoryVO)categoryMap.get(detailExecutionVO2.getCategoryId())).getInnerCode());
                detailExecutionVO2.setCategoryCode(((MaterialCategoryVO)categoryMap.get(detailExecutionVO2.getCategoryId())).getCode());
            }
        }
        return detailList;
    }

    @Override
    public CommonResponse<RentSettlementVO> pushCost(RentSettlementVO vo) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)((RentSettlementMapper)this.baseMapper).selectById(vo.getId()));
        if (CollectionUtils.isNotEmpty((Collection)vo.getRentSettlementRentalList())) {
            List rentalEntities = BeanMapper.mapList((Iterable)vo.getRentSettlementRentalList(), RentSettlementRentalEntity.class);
            entity.setRentSettlementRentalList(rentalEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getRentSettlementDayList())) {
            List dayEntities = BeanMapper.mapList((Iterable)vo.getRentSettlementDayList(), RentSettlementDayEntity.class);
            entity.setRentSettlementDayList(dayEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getRentSettlementMonthList())) {
            List monthEntities = BeanMapper.mapList((Iterable)vo.getRentSettlementMonthList(), RentSettlementMonthEntity.class);
            entity.setRentSettlementMonthList(monthEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getRentSettlementQuantitiesList())) {
            List quantitiesEntities = BeanMapper.mapList((Iterable)vo.getRentSettlementQuantitiesList(), RentSettlementQuantitiesEntity.class);
            entity.setRentSettlementQuantitiesList(quantitiesEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getRentSettlementFeeList())) {
            List feeEntities = BeanMapper.mapList((Iterable)vo.getRentSettlementFeeList(), RentSettlementFeeEntity.class);
            entity.setRentSettlementFeeList(feeEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getRentSettlementFragmentaryList())) {
            List fragmentaryEntities = BeanMapper.mapList((Iterable)vo.getRentSettlementFragmentaryList(), RentSettlementFragmentaryEntity.class);
            entity.setRentSettlementFragmentaryList(fragmentaryEntities);
        }
        super.saveOrUpdate((Object)entity, false);
        this.costPush(entity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), RentSettlementVO.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void costPush(RentSettlementEntity entity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<RentSettlementFragmentaryEntity> fragmentaryList = entity.getRentSettlementFragmentaryList();
        List<RentSettlementDayEntity> dayList = entity.getRentSettlementDayList();
        List<RentSettlementMonthEntity> monthList = entity.getRentSettlementMonthList();
        List<RentSettlementQuantitiesEntity> quantitiesList = entity.getRentSettlementQuantitiesList();
        List<RentSettlementFeeEntity> feeList = entity.getRentSettlementFeeList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(fragmentaryList)) {
            for (RentSettlementFragmentaryEntity rentSettlementFragmentaryEntity : fragmentaryList) {
                if (null != rentSettlementFragmentaryEntity.getSubjectIdFragmentary() && null != rentSettlementFragmentaryEntity.getWbsIdFragmentary()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(dayList)) {
            for (RentSettlementDayEntity rentSettlementDayEntity : dayList) {
                if (null != rentSettlementDayEntity.getSubjectId() && null != rentSettlementDayEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(monthList)) {
            for (RentSettlementMonthEntity rentSettlementMonthEntity : monthList) {
                if (null != rentSettlementMonthEntity.getSubjectId() && null != rentSettlementMonthEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(quantitiesList)) {
            for (RentSettlementQuantitiesEntity rentSettlementQuantitiesEntity : quantitiesList) {
                if (null != rentSettlementQuantitiesEntity.getSubjectId() && null != rentSettlementQuantitiesEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeList)) {
            for (RentSettlementFeeEntity rentSettlementFeeEntity : feeList) {
                if (null != rentSettlementFeeEntity.getSubjectId() && null != rentSettlementFeeEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(dayList) && ListUtil.isEmpty(monthList) && ListUtil.isEmpty(quantitiesList) && ListUtil.isEmpty(fragmentaryList)) {
            newRelationFlag = "0";
        }
        this.saveCost(entity, 1);
        entity.setRelationFlag(newRelationFlag);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(RentSettlementEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public List<RentRentalEntity> queryRental(Long contractId, String settleDate) {
        return ((RentSettlementMapper)this.baseMapper).queryRental(contractId, settleDate);
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnyList(RentContractEntity rentContractEntity, RentSettlementVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        if (null != rentContractEntity.getPurchaseType() && 2 == rentContractEntity.getPurchaseType()) {
            return paramsCheckVOList;
        }
        String CHECK_PARAM_CODE = "";
        switch (vo.getSettlementType()) {
            case 0: {
                CHECK_PARAM_CODE = CHECK_PARAM_CODE_GC;
                break;
            }
            case 1: {
                CHECK_PARAM_CODE = CHECK_PARAM_CODE_ZZ;
            }
        }
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u7ed3\u7b97\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    String orgName = datum.getOrgName();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BillParamVO billParamVO = datum;
                    BigDecimal totalSettleTaxMny = null == vo.getCurrentSettlementTaxMny() ? BigDecimal.ZERO : vo.getCurrentSettlementTaxMny();
                    BigDecimal settleTaxMny = null == vo.getSettlementTaxMny() ? BigDecimal.ZERO : vo.getSettlementTaxMny();
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)rentContractEntity.getContractTaxMny(), (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    if (totalSettleTaxMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(orgName);
                        paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                        paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff1a").append(settleTaxMny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff1a").append(totalSettleTaxMny.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public ParamsCheckVO checkParams(RentSettlementVO vo) {
        ParamsCheckVO costParams;
        CommonResponse costResponse;
        ParamsCheckVO costRes;
        CostCtrlVO costCtrlVO;
        RentSettlementEntity rentSettlementEntity;
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (null != vo.getProjectId() && null != vo.getOrgId()) {
            paramsCheckVOS.addAll(this.costProjectCheckParams(vo));
        }
        if (vo.getContractId() != null) {
            RentContractEntity rentContractEntity = (RentContractEntity)((Object)this.rentContractService.selectById(vo.getContractId()));
            paramsCheckVOS.addAll(this.checkParamsMnyList(rentContractEntity, vo));
        }
        if ((rentSettlementEntity = (RentSettlementEntity)((Object)BeanMapper.map((Object)vo, RentSettlementEntity.class))).getId() == null) {
            rentSettlementEntity.setId(IdWorker.getId());
        }
        ExecutionVO executionVO = this.settlementTargetCost(rentSettlementEntity, true);
        this.logger.error("\u8bbe\u5907\u79df\u8d41\u7ed3\u7b97\u76ee\u6807\u6210\u672c\u63a7\u5236\u63a8\u9001\u4f20\u53c2\uff1a" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO tarRes = (ParamsCheckVO)response.getData();
        if (null != tarRes) {
            paramsCheckVOS.add(tarRes);
        }
        if (null != (costCtrlVO = this.sjCost(vo)) && null != (costRes = (ParamsCheckVO)(costResponse = this.executionApi.ctrlCost(costCtrlVO)).getData())) {
            paramsCheckVOS.add(costRes);
        }
        if ((costParams = this.costPriceCheckParams(vo)) != null) {
            paramsCheckVOS.add(costParams);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    public List<ParamsCheckVO> costProjectCheckParams(RentSettlementVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse booleanCommonResponse = this.dutyApi.queryDutyByProjectId(vo.getProjectId());
        if (!booleanCommonResponse.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        this.logger.info("\u9879\u76ee\u76ee\u6807\u6210\u672c\u63a7\u5236 booleanCommonResponse\uff1a" + booleanCommonResponse);
        if (!((Boolean)booleanCommonResponse.getData()).booleanValue()) {
            CommonResponse billParamByCodeAndOrgId = this.paramConfigApi.getBillParamByCodeAndOrgId("P-ilUA850193", vo.getOrgId());
            this.logger.info("billParamByCodeAndOrgId:" + billParamByCodeAndOrgId);
            if (billParamByCodeAndOrgId.isSuccess() && null != billParamByCodeAndOrgId.getData()) {
                List data = (List)billParamByCodeAndOrgId.getData();
                if (CollectionUtils.isNotEmpty((Collection)data)) {
                    for (BillParamVO billParamByCode : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        String orgName = billParamByCode.getOrgName();
                        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                        paramsCheckVO.setWarnType(paramsArray[billParamByCode.getControlType()]);
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("\u65e0\u76ee\u6807\u6210\u672c\u63a7\u7ed3\u7b97");
                        paramsCheckDsVO.setOrgName(orgName);
                        paramsCheckDsVO.setWarnName("\u8be5\u9879\u76ee\u6ca1\u6709\u7f16\u5236\u76ee\u6807\u8d23\u4efb\u6210\u672c");
                        paramsCheckDsVO.setContent("\u8be5\u9879\u76ee\u6ca1\u6709\u7f16\u5236\u76ee\u6807\u8d23\u4efb\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u7ed3\u7b97\u5355");
                        checkDsVOS.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            } else {
                this.logger.info(billParamByCodeAndOrgId.getMsg());
                throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
            }
        }
        return paramsCheckVOList;
    }

    public ParamsCheckVO costPriceCheckParams(RentSettlementVO vo) {
        CostPriceApiVO priceHistoryApiVO;
        List rentSettlementDayList = vo.getRentSettlementDayList();
        List rentSettlementMonthList = vo.getRentSettlementMonthList();
        List rentSettlementQuantitiesList = vo.getRentSettlementQuantitiesList();
        CostPriceApiVO materialPriceHistoryApiVO = new CostPriceApiVO();
        ArrayList<CostPriceApiVO> materialPriceHistoryApiVOS = new ArrayList<CostPriceApiVO>();
        if (CollectionUtil.isNotEmpty((Collection)rentSettlementDayList)) {
            for (RentSettlementDayVO detailVO : rentSettlementDayList) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getEquipmentId() == null) continue;
                priceHistoryApiVO = new CostPriceApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getEquipmentId());
                priceHistoryApiVO.setMaterialName(detailVO.getEquipmentName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getDayPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getDayTaxPrice());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)rentSettlementMonthList)) {
            for (RentSettlementDayVO detailVO : rentSettlementMonthList) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getEquipmentId() == null) continue;
                priceHistoryApiVO = new CostPriceApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getEquipmentId());
                priceHistoryApiVO.setMaterialName(detailVO.getEquipmentName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getMonthPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getMonthTaxPrice());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)rentSettlementQuantitiesList)) {
            for (RentSettlementDayVO detailVO : rentSettlementQuantitiesList) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getEquipmentId() == null) continue;
                priceHistoryApiVO = new CostPriceApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getEquipmentId());
                priceHistoryApiVO.setMaterialName(detailVO.getEquipmentName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getQuantitiesPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getQuantitiesTaxPrice());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setProjectId(vo.getProjectId());
        materialPriceHistoryApiVO.setCostPriceApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = this.costPriceParams(materialPriceHistoryApiVO, PRICE_PARAM_CODE, SourceTypeEnum.\u8bbe\u5907\u79df\u8d41\u7ed3\u7b97.getTypeName());
        return paramsCheckVO;
    }

    public CostCtrlVO sjCost(RentSettlementVO vo) {
        BigDecimal taxMny;
        BigDecimal mny;
        CostCtrlDetailVO costCtrlDetailVO;
        BigDecimal detailTaxMny;
        BigDecimal detailMny;
        List rentSettlementDayList = vo.getRentSettlementDayList();
        List rentSettlementMonthList = vo.getRentSettlementMonthList();
        List rentSettlementQuantitiesList = vo.getRentSettlementQuantitiesList();
        List rentSettlementFeeVOList = vo.getRentSettlementFeeList();
        List rentSettlementFragmentaryList = vo.getRentSettlementFragmentaryList();
        HashMap<Long, CostCtrlDetailVO> map = new HashMap<Long, CostCtrlDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)rentSettlementDayList)) {
            for (RentSettlementDayVO settlementFeeVO : rentSettlementDayList) {
                if ("del".equals(settlementFeeVO.getRowState()) || null == settlementFeeVO.getSubjectId()) continue;
                detailMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getDayMny());
                detailTaxMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getDayTaxMny());
                if (map.containsKey(settlementFeeVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(settlementFeeVO.getSubjectId());
                    mny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getMny());
                    taxMny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getTaxMny());
                    costCtrlDetailVO.setMny(mny.add(detailMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(detailTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(settlementFeeVO.getSubjectId());
                costCtrlDetailVO.setMny(detailMny);
                costCtrlDetailVO.setTaxMny(detailTaxMny);
                map.put(settlementFeeVO.getSubjectId(), costCtrlDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)rentSettlementMonthList)) {
            for (RentSettlementDayVO settlementFeeVO : rentSettlementMonthList) {
                if ("del".equals(settlementFeeVO.getRowState()) || null == settlementFeeVO.getSubjectId()) continue;
                detailMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getMonthMny());
                detailTaxMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getMonthTaxMny());
                if (map.containsKey(settlementFeeVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(settlementFeeVO.getSubjectId());
                    mny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getMny());
                    taxMny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getTaxMny());
                    costCtrlDetailVO.setMny(mny.add(detailMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(detailTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(settlementFeeVO.getSubjectId());
                costCtrlDetailVO.setMny(detailMny);
                costCtrlDetailVO.setTaxMny(detailTaxMny);
                map.put(settlementFeeVO.getSubjectId(), costCtrlDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)rentSettlementQuantitiesList)) {
            for (RentSettlementDayVO settlementFeeVO : rentSettlementQuantitiesList) {
                if ("del".equals(settlementFeeVO.getRowState()) || null == settlementFeeVO.getSubjectId()) continue;
                detailMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getQuantitiesMny());
                detailTaxMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getQuantitiesTaxMny());
                if (map.containsKey(settlementFeeVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(settlementFeeVO.getSubjectId());
                    mny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getMny());
                    taxMny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getTaxMny());
                    costCtrlDetailVO.setMny(mny.add(detailMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(detailTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(settlementFeeVO.getSubjectId());
                costCtrlDetailVO.setMny(detailMny);
                costCtrlDetailVO.setTaxMny(detailTaxMny);
                map.put(settlementFeeVO.getSubjectId(), costCtrlDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)rentSettlementFeeVOList)) {
            for (RentSettlementDayVO settlementFeeVO : rentSettlementFeeVOList) {
                if ("del".equals(settlementFeeVO.getRowState()) || null == settlementFeeVO.getSubjectId()) continue;
                detailMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getFeeMny());
                detailTaxMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getFeeTaxMny());
                if (map.containsKey(settlementFeeVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(settlementFeeVO.getSubjectId());
                    mny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getMny());
                    taxMny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getTaxMny());
                    costCtrlDetailVO.setMny(mny.add(detailMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(detailTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(settlementFeeVO.getSubjectId());
                costCtrlDetailVO.setMny(detailMny);
                costCtrlDetailVO.setTaxMny(detailTaxMny);
                map.put(settlementFeeVO.getSubjectId(), costCtrlDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)rentSettlementFragmentaryList)) {
            for (RentSettlementDayVO settlementFeeVO : rentSettlementFragmentaryList) {
                if ("del".equals(settlementFeeVO.getRowState()) || null == settlementFeeVO.getSubjectIdFragmentary()) continue;
                detailMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getFragmentaryMny());
                detailTaxMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getFragmentaryTaxMny());
                if (map.containsKey(settlementFeeVO.getSubjectIdFragmentary())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(settlementFeeVO.getSubjectIdFragmentary());
                    mny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getMny());
                    taxMny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getTaxMny());
                    costCtrlDetailVO.setMny(mny.add(detailMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(detailTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(settlementFeeVO.getSubjectIdFragmentary());
                costCtrlDetailVO.setMny(detailMny);
                costCtrlDetailVO.setTaxMny(detailTaxMny);
                map.put(settlementFeeVO.getSubjectIdFragmentary(), costCtrlDetailVO);
            }
        }
        if (null != map && !map.isEmpty()) {
            CostCtrlVO ctrlVO = new CostCtrlVO();
            if (null != vo.getId()) {
                ctrlVO.setSourceId(vo.getId());
            }
            ctrlVO.setOrgId(vo.getOrgId());
            ctrlVO.setProjectId(vo.getProjectId());
            ctrlVO.setDetailList(new ArrayList(map.values()));
            return ctrlVO;
        }
        return null;
    }

    private void saveCost(RentSettlementEntity entity, Integer effectiveStatus) {
        CostDetailVO costDetailVO;
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<RentSettlementFragmentaryEntity> fragmentaryList = entity.getRentSettlementFragmentaryList();
        List<RentSettlementDayEntity> dayList = entity.getRentSettlementDayList();
        List<RentSettlementMonthEntity> monthList = entity.getRentSettlementMonthList();
        List<RentSettlementQuantitiesEntity> quantitiesList = entity.getRentSettlementQuantitiesList();
        List<RentSettlementFeeEntity> feeList = entity.getRentSettlementFeeList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(fragmentaryList)) {
            for (RentSettlementFragmentaryEntity rentSettlementFragmentaryEntity : fragmentaryList) {
                costDetailVO = (CostDetailVO)BeanMapper.map((Object)((Object)rentSettlementFragmentaryEntity), CostDetailVO.class);
                costDetailVO.setSourceDetailId(rentSettlementFragmentaryEntity.getId());
                costDetailVO.setHappenTaxMny(rentSettlementFragmentaryEntity.getFragmentaryTaxMny());
                costDetailVO.setHappenMny(rentSettlementFragmentaryEntity.getFragmentaryMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_FRAGMENTARY");
                costDetailVO.setWbsId(rentSettlementFragmentaryEntity.getWbsIdFragmentary());
                costDetailVO.setWbsCode(rentSettlementFragmentaryEntity.getWbsCodeFragmentary());
                costDetailVO.setWbsName(rentSettlementFragmentaryEntity.getWbsNameFragmentary());
                costDetailVO.setSubjectId(rentSettlementFragmentaryEntity.getSubjectIdFragmentary());
                costDetailVO.setSubjectCode(rentSettlementFragmentaryEntity.getSubjectCodeFragmentary());
                costDetailVO.setSubjectName(rentSettlementFragmentaryEntity.getSubjectNameFragmentary());
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(dayList)) {
            for (RentSettlementDayEntity rentSettlementDayEntity : dayList) {
                costDetailVO = (CostDetailVO)BeanMapper.map((Object)((Object)rentSettlementDayEntity), CostDetailVO.class);
                costDetailVO.setSourceDetailId(rentSettlementDayEntity.getId());
                costDetailVO.setHappenTaxMny(rentSettlementDayEntity.getDayTaxMny());
                costDetailVO.setHappenMny(rentSettlementDayEntity.getDayMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_DAY");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(monthList)) {
            for (RentSettlementMonthEntity rentSettlementMonthEntity : monthList) {
                costDetailVO = (CostDetailVO)BeanMapper.map((Object)((Object)rentSettlementMonthEntity), CostDetailVO.class);
                costDetailVO.setSourceDetailId(rentSettlementMonthEntity.getId());
                costDetailVO.setHappenTaxMny(rentSettlementMonthEntity.getMonthTaxMny());
                costDetailVO.setHappenMny(rentSettlementMonthEntity.getMonthMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_MONTH");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(quantitiesList)) {
            for (RentSettlementQuantitiesEntity rentSettlementQuantitiesEntity : quantitiesList) {
                costDetailVO = (CostDetailVO)BeanMapper.map((Object)((Object)rentSettlementQuantitiesEntity), CostDetailVO.class);
                costDetailVO.setSourceDetailId(rentSettlementQuantitiesEntity.getId());
                costDetailVO.setHappenTaxMny(rentSettlementQuantitiesEntity.getQuantitiesTaxMny());
                costDetailVO.setHappenMny(rentSettlementQuantitiesEntity.getQuantitiesMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_QUANTITIES");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeList)) {
            for (RentSettlementFeeEntity rentSettlementFeeEntity : feeList) {
                costDetailVO = (CostDetailVO)BeanMapper.map((Object)((Object)rentSettlementFeeEntity), CostDetailVO.class);
                costDetailVO.setSourceDetailId(rentSettlementFeeEntity.getId());
                costDetailVO.setHappenTaxMny(rentSettlementFeeEntity.getFeeTaxMny());
                costDetailVO.setHappenMny(rentSettlementFeeEntity.getFeeMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_FEE");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(costDetailVOList)) {
            for (CostDetailVO costDetailVO2 : costDetailVOList) {
                costDetailVO2.setSourceBillCode(entity.getBillCode());
                costDetailVO2.setSourceBillName(SourceTypeEnum.\u8bbe\u5907\u79df\u8d41\u7ed3\u7b97.getTypeName());
                costDetailVO2.setSourceBillUrl("/ejc-proequipment-frontend/#/rentSettleList/rentSettleCard?id=" + entity.getId());
                costDetailVO2.setSourceId(entity.getId());
                costDetailVO2.setHappenDate(entity.getSettlementDate());
                costDetailVO2.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO2.setId(null);
                costDetailVO2.setSourceType("TEMP_EQ_JS");
                costDetailVO2.setProjectId(entity.getProjectId());
                costDetailVO2.setEffectiveStatus(effectiveStatus);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u8bbe\u5907\u79df\u8d41\u7ed3\u7b97\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)this.selectById(id));
        if (entity.getSettlementType() != null && entity.getSettlementType() == 1) {
            this.logger.info("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5f00\u59cb");
            CommonResponse response = this.executionApi.aggPush(this.targetCost(entity));
            this.logger.info("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)this.targetCost(entity)));
            if (!response.isSuccess()) {
                this.logger.error("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5931\u8d25: , {}", (Object)response.getMsg());
                throw new BusinessException(response.getMsg());
            }
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a8\u9001\u6210\u529f");
    }

    @Override
    public RentSettleRecordVO queryDetailRecord(Long contractId) {
        RentSettleRecordVO settleRecordVO = new RentSettleRecordVO();
        RentContractEntity contract = (RentContractEntity)((Object)this.rentContractService.selectById(contractId));
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getContractPerformanceState());
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"contract_id", (Object)contractId);
        listQuery.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        listQuery.orderByDesc((Object)"settlement_date");
        List list = super.list((Wrapper)listQuery);
        List rentSettlementVOS = BeanMapper.mapList((Iterable)list, RentSettlementVO.class);
        settleRecordVO.setSettleList(rentSettlementVOS);
        BigDecimal contractSettleMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            contractSettleMny = list.stream().map(RentSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        settleRecordVO.setContractSettleMny(contractSettleMny);
        if (BigDecimal.ZERO.compareTo(settleRecordVO.getContractTaxMny()) == 0) {
            settleRecordVO.setSettleRate(BigDecimal.ZERO);
        } else {
            settleRecordVO.setSettleRate(settleRecordVO.getContractSettleMny().multiply(BigDecimal.valueOf(100L)).divide(settleRecordVO.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        return settleRecordVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateContractPoolSettle(RentSettlementVO vo, Boolean type) {
        if (null != vo.getContractId()) {
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + (type != false ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0csettleEntity={}, \u8fc7\u7a0b\uff080\uff09/\u6700\u7ec8\uff081\uff09={}, type={}", new Object[]{vo, vo.getSettlementType(), type});
            BigDecimal totalSettleTaxMny = BigDecimal.ZERO;
            BigDecimal totalSettleMny = BigDecimal.ZERO;
            BigDecimal totalSettleTax = BigDecimal.ZERO;
            if (type.booleanValue()) {
                totalSettleTaxMny = vo.getCurrentSettlementTaxMny() == null ? BigDecimal.ZERO : vo.getCurrentSettlementTaxMny();
                totalSettleMny = vo.getCurrentSettlementMny() == null ? BigDecimal.ZERO : vo.getCurrentSettlementMny();
                totalSettleTax = ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)totalSettleMny);
            } else {
                totalSettleTaxMny = ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementTaxMny(), (BigDecimal)vo.getSettlementTaxMny());
                totalSettleMny = ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementMny(), (BigDecimal)vo.getSettlementMny());
                totalSettleTax = ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)totalSettleMny);
            }
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setSourceId(vo.getContractId());
            contractPoolVO.setTotalSettleTaxMny(totalSettleTaxMny);
            contractPoolVO.setTotalSettleMny(totalSettleMny);
            contractPoolVO.setTotalSettleTax(totalSettleTax);
            if (1 == vo.getSettlementType()) {
                if (type.booleanValue()) {
                    contractPoolVO.setFinishSettleDate(new Date());
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode());
                } else {
                    contractPoolVO.setFinishSettleDate(null);
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                }
            }
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u7ed3\u675f\uff0c\u66f4\u65b0\u5408\u540c\u6c60\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)contractPoolVO));
            CommonResponse updateConPoolRes = this.contractPoolApi.saveOrUpdateContract(contractPoolVO);
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u7ed3\u675f\uff0c\u66f4\u65b0\u5408\u540c\u6c60\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)updateConPoolRes));
        }
    }
}

