package com.ejianc.business.ac.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.ac.bean.*;
import com.ejianc.business.ac.enums.BillTypeEnum;
import com.ejianc.business.ac.mapper.ContractMapper;
import com.ejianc.business.ac.service.IChangeService;
import com.ejianc.business.ac.service.IContractDetailService;
import com.ejianc.business.ac.service.IContractRelieveService;
import com.ejianc.business.ac.service.IContractService;
import com.ejianc.business.ac.utils.TreeNodeBUtil;
import com.ejianc.business.ac.vo.ChangeVO;
import com.ejianc.business.ac.vo.ContractDetailVO;
import com.ejianc.business.ac.vo.ContractRelieveVO;
import com.ejianc.business.ac.vo.ContractVO;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.rent.enums.ChangeStatusEnum;
import com.ejianc.business.rent.enums.DraftTypeEnum;
import com.ejianc.business.rent.enums.SignatureStatusEnum;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.business.tender.api.ITenderSubApi;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 安拆合同主实体
 *
 * @author generator
 */
@Service("contractService")
public class ContractServiceImpl extends BaseServiceImpl<ContractMapper, ContractEntity> implements IContractService {

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IContractRelieveService contractRelieveService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractService service;

    private static final String BILL_CODE = "AC_MDGP";
    private static final String BILL_CODE_YNJT = "AC_MDGP_YNJT01";

    @Autowired
    private IContractDetailService contractDetailService;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IParamCheckApi paramCheckApi;

    @Autowired
    private ITenderSubApi tenderApi;
    //定标结果未占用状态
    int unOccupyState = 0;
    //定标结果已占用状态
    int occupyState = 1;


    @Value("${common.env.base-host}")
    private String BaseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Value("${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;
    private static final String GenerateSourceType = "ACQT10086";//编码流水号业务类型

    @Autowired
    private ICommonSNAPI commonSNAPI;

    @Autowired
    private IShareMaterialApi materialApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String CHECK_PARAM_CODE = "P-w9M68894";//安拆合同补充金额控制

    private static final String CONTRACT_FILING_CODE = "P-eg7rBO0134"; //合同归档控制

    private String getBaseHost(){
        return StringUtils.isNotBlank(BASE_HOST_FRONTEND) && !("null").equals(BASE_HOST_FRONTEND) ? BASE_HOST_FRONTEND : BaseHost;
    }

    @Override
    public ContractVO insertOrUpdate(ContractVO contractVO, String authority) {
        ContractEntity entity = BeanMapper.map(contractVO, ContractEntity.class);
        // parentOrgCode如果是空的，则需要查询赋值
//        if (StringUtils.isEmpty(entity.getParentOrgCode()) && entity.getParentOrgId() != null) {
//            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(entity.getParentOrgId());
//            if (orgResponse.isSuccess()) {
//                OrgVO orgVO = orgResponse.getData();
//                entity.setParentOrgCode(orgVO.getCode());
//            }
//        }
        if (entity.getOrgId() != null && (StringUtils.isEmpty(entity.getOrgCode()) || StringUtils.isEmpty(entity.getParentOrgCode()))) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(entity.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                entity.setOrgCode(orgVO.getCode());
                // 项目部
                if(5 == orgVO.getOrgType()){
                    CommonResponse<OrgVO> parentOrgResponse = iOrgApi.getOneById(orgVO.getParentId());
                    if (parentOrgResponse.isSuccess()) {
                        OrgVO parentOrgVO = parentOrgResponse.getData();
                        entity.setParentOrgId(parentOrgVO.getId());
                        entity.setParentOrgCode(parentOrgVO.getCode());
                        entity.setParentOrgName(parentOrgVO.getName());
                    }
                }
                // 非项目部
                else {
                    entity.setParentOrgId(entity.getOrgId());
                    entity.setParentOrgCode(entity.getOrgCode());
                    entity.setParentOrgName(entity.getOrgName());
                }
            }
        }
        if (entity.getId() == null) {
            //设置归档状态
            if (entity.getFilingStatus() == null) {
                entity.setFilingStatus(FilingStatusEnum.未归档.getTypeCode());
            }
//            else if (FilingStatusEnum.已归档.getTypeCode().equals(entity.getFilingStatus())) {
                entity.setFilingRef(0);
//            }
            //设置合同初始状态
            entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
            entity.setSupplementFlag(0);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
            entity.setMainContractCreateDate(new Date());
            //回写定标结果占据状态
            tenderApi.updateById(entity.getTargetResultId(), occupyState);
        }
        else {
            //若定标结果更换则回写原来定标结果为为占用状态，新定标结果为占用状态
            ContractEntity oldContractEntity = super.selectById(entity.getId());
            if (null != entity.getTargetResultId() && !entity.getTargetResultId().equals(oldContractEntity.getTargetResultId())) {
                tenderApi.updateById(oldContractEntity.getTargetResultId(), unOccupyState);
                tenderApi.updateById(entity.getTargetResultId(), occupyState);
            }
            if (StringUtils.isBlank(entity.getBillCode())) {
                entity.setBillCode(oldContractEntity.getBillCode());
            }
        }
        //如果编码为空，就新增编码
        if (StringUtils.isBlank(entity.getBillCode())) {
            switch (GenerateBillCodeType) {
                case "common":
                    CommonResponse<String> billCode = billCodeApi.generateBillCode(BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), contractVO));
                    if (!billCode.isSuccess()) {
                        logger.error("保存合同失败，自动生成合同合同失败: {}", billCode.getMsg());
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    entity.setBillCode(billCode.getData());
                    break;
                case "ynjt":
                    CommonResponse<String> billCodeFirstPart = billCodeApi.generateBillCode(BillCodeParam.build(BILL_CODE_YNJT, InvocationInfoProxy.getTenantid(), contractVO));
                    if(!billCodeFirstPart.isSuccess()) {
                        logger.error("保存合同失败，自动生成合同合同失败: {}", billCodeFirstPart.getMsg());
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    //根据合同基层单位后三位查询查询流水号
                    CommonSNVO commonSNVO = new CommonSNVO();
                    commonSNVO.setSnLength(4);
                    commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());
                    commonSNVO.setDimension(entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3));
                    commonSNVO.setSourceType(GenerateSourceType);
                    CommonResponse<String> snResp = commonSNAPI.getNext(commonSNVO);
                    if(!snResp.isSuccess()) {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    entity.setBillCode(billCodeFirstPart.getData() + entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3) + snResp.getData());
                    break;
            }
        } else {
            //验证编码是否唯一
            if (checkSameBillCode(BeanMapper.map(entity, ContractVO.class))) {
                throw new BusinessException("编码重复，不允许保存!");
            }
        }
        //补充金额明细
        entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
        entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
        entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
        //分包明细
        entity.setSubContractMny(contractVO.getSubContractMny() == null ? BigDecimal.ZERO : contractVO.getSubContractMny());
        entity.setSubContractTaxMny(contractVO.getSubContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getSubContractTaxMny());
        entity.setSubContractTax(contractVO.getSubContractTax() == null ? BigDecimal.ZERO : contractVO.getSubContractTax());
        //其他费用
        entity.setOtherCostMny(contractVO.getOtherCostMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostMny());
        entity.setOtherCostTaxMny(contractVO.getOtherCostTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostTaxMny());
        entity.setOtherCostTax(contractVO.getOtherCostTax() == null ? BigDecimal.ZERO : contractVO.getOtherCostTax());
        //设置初始金额
        entity.setBaseMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        //设置变更前金额
        entity.setBeforeChangeMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());

//        if (entity.getContractFileId() != null) {
//            if (entity.getId() != null) {
//                ContractEntity contract = service.getById(entity.getId());
//                //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
//                if (contract != null && !DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
//                    delContractFile(entity.getContractFileId(), authority);
//                    entity.setContractFileId(null);
//                    entity.setContractFilePath(null);
//                }
//            }
//            else {
//                //如果是新建合同，且起草方式为线上起草则删除附件
//                if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
//                    delContractFile(entity.getContractFileId(), authority);
//                    entity.setContractFileId(null);
//                    entity.setContractFilePath(null);
//                }
//            }
//        }
        if (entity.getContractFileId() != null) {
            //合同旧数据
            ContractEntity contract = service.getById(entity.getId());
            if (contract != null && (
                    //如果当前合同是线上起草，而且合同分类做了变更，那么删除附件
                    !contract.getContractCategoryId().equals(entity.getContractCategoryId())
                            //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
                            || !(DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType())
                            || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(contract.getDraftType()))
            ) && (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType()) ||
                    DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(entity.getDraftType())
            )) {
                if (null != contract.getContractFileId()) {
                    delContractFile(contract.getContractFileId(), authority);
                }
                entity.setContractFileId(null);
                entity.setContractFilePath(null);
            }
        }
        //保存前清空主键和父主键，重新生成
        resetPid(entity.getDetailList());
        //将合同文件同步标识置为未同步
        if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(entity.getDraftType())) {
            entity.setContractFileSyncFlag(false);
        }

        super.saveOrUpdate(entity, false);

        //目标成本推送
        String linkUrl;
        linkUrl = getBaseHost() + "ejc-proequipment-frontend/#/otherSubList/card?id=" + entity.getId()+"&cardType=otherSubDirectCard";
        ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, ContractVO.class), linkUrl, entity.getContractType());
        logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("目标成本推送失败," + response.getMsg());
        }

        return queryDetail(entity.getId());
    }

    /**
     * 检查单据是否存在相同编码
     *
     * @param contractVO
     * @return
     */
    private Boolean checkSameBillCode(ContractVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<ContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ContractEntity::getBillCode, contractVO.getBillCode());
        lambda.eq(ContractEntity::getTenantId, tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0) {
            lambda.ne(ContractEntity::getId, contractVO.getId());
        }
        return super.list(lambda).size() > 0;
    }

    @Override
    public Boolean delContractFile(Long fileId, String authority) {
        Map<String, Object> params = new HashMap<>();
        Map<String, String> header = new HashMap<>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);

        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get(BaseHost + "ejc-file-web/attachment/delete", params, header, 10000, 10000);
        } catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse<String> delResp = JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            logger.info("在线起草，删除上传合同返回信息：" + delResp.getMsg());
        }
        return true;
    }

    private void resetPid(List<ContractDetailEntity> detailList) {
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map<String, Long> idMap = new HashMap<>();
            for (ContractDetailEntity cdEntity : detailList) {
                if (cdEntity.getId() == null) {
                    cdEntity.setId(IdWorker.getId());
                }
                idMap.put(cdEntity.getTid(), cdEntity.getId());
                cdEntity.setParentId(null);
            }
            for (ContractDetailEntity cdEntity : detailList) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
        }
    }

    @Override
    public ContractVO queryDetail(Long id) {
        Map<String, LinkedHashMap<String, String>> orderMap = new HashMap<>();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<>();
        orderParams.put("treeIndex", QueryParam.ASC);
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);

        ContractEntity contractEntity = super.selectById(id, orderMap);
        ContractVO contractVO = BeanMapper.map(contractEntity, ContractVO.class);

        //明细子表排序为树形
        if (CollectionUtils.isNotEmpty(contractVO.getDetailList())) {
            for (ContractDetailVO detail : contractVO.getDetailList()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            contractVO.setDetailList(TreeNodeBUtil.buildTree(contractVO.getDetailList()));
        }

        return contractVO;
    }

    /**
     * 计算合同列表需要字段
     *
     * @param param
     * @return
     */
    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(base_tax_mny) as baseTaxMny, sum(contract_tax_mny) as contractTaxMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("baseTaxMny", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;

    }

    /**
     * 查询当前合同下补充协议列表
     *
     * @param id
     * @return
     */
    @Override
    public ContractVO querySupplementRecord(Long id) {
        ContractEntity contractEntity = super.selectById(id);
        ContractVO contractVO = new ContractVO();

        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();

        contractVO.setId(id);
        contractVO.setContractTaxMny(contractTaxMny);
        contractVO.setChangeStatus(contractEntity.getChangeStatus());
//        contractVO.setContractType(contractEntity.getContractType());

        QueryWrapper<ContractEntity> query = new QueryWrapper<>();
        query.eq("main_contract_id", id);
        query.eq("performance_status", ContractPerformanceStateEnum.履约中.getStateCode());
        query.orderByDesc("create_time");
        List<ContractEntity> supplementEntities = super.list(query);

        contractVO.setSupplementList(BeanMapper.mapList(supplementEntities, ContractVO.class));
        //补充协议次数
        contractVO.setSupplementNum(supplementEntities.size());
        //设置累计补充总金额
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(supplementEntities)) {
            for (ContractEntity c : supplementEntities) {
                if (c.getContractTaxMny() != null) {
                    allSupplementAmt = c.getContractTaxMny().add(allSupplementAmt);
                }
            }
        }
        contractVO.setAllSupplementMny(allSupplementAmt);
        //设置补充金额比例
        contractVO.setSupplementMnyRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? (allSupplementAmt.divide(contractTaxMny, 8, BigDecimal.ROUND_HALF_UP)).multiply(new BigDecimal(100)) : BigDecimal.ZERO);

        //判断能否新增补充协议
        if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureStatus())
                && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))
                && (!(ContractPerformanceStateEnum.已作废.getStateCode().equals(contractEntity.getPerformanceStatus()) || ContractPerformanceStateEnum.已冻结.getStateCode().equals(contractEntity.getPerformanceStatus())))) {
            contractVO.setEditFlag(this.addSupplementFlag(id));
        }
        else {
            contractVO.setEditFlag(false);
        }
        return contractVO;
    }

    /**
     * 判断当前合同是否能新增补充协议
     *
     * @param id
     * @return
     */
    @Override
    public Boolean addSupplementFlag(Long id) {
        /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
         */
        LambdaQueryWrapper<ContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ContractEntity::getMainContractId, id);
        lambda.eq(ContractEntity::getSupplementFlag, ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> l.ne(ContractEntity::getSignatureStatus, String.valueOf(SignatureStatusEnum.已签章.getCode()))//不是已签章的
                .or(c -> c.notIn(ContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));//单据状态不是1和3的
        List<ContractEntity> supplementList = super.list(lambda);
        return supplementList.size() == 0;
    }

    @Override
    public boolean pushContract(ContractVO vo) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(vo, data);
            data.setSourceType(ContractTypeEnum.安拆合同.getTypeCode());
            data.setContractProperty(ContractPropertyEnum.支出合同.getPropertyCode());
            data.setContractPropertyName(ContractPropertyEnum.支出合同.getPropertyName());
            data.setPcCardUrl("/ejc-proequipment-frontend/#/otherSubList/contractMultiCards?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() + "&cardType=otherSubDirectCard&performanceStatus=" + vo.getPerformanceStatus());
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);

            if (transDataResp.isSuccess()) {
                return true;
            }
            else {
                logger.error("合同id-{}推送合同池失败，{}", vo.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        }

        return false;
    }

    @Override
    public boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);

        logger.info("将合同-{}从合同池中删除！", id);
        CommonResponse<String> delDataResp = contractPoolApi.deleteContract(c);
        if (delDataResp.isSuccess()) {
            return true;
        }

        logger.error("将合同-{}从合同池中删除失败, {}！", id, delDataResp.getMsg());
        return false;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<ContractVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            //目标成本推送
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            for (ContractVO contractVO : vos) {
                ContractEntity contractEntity = service.selectById(contractVO.getId());
                ExecutionVO executionVO = service.targetCost(BeanMapper.map(contractEntity, ContractVO.class), "", contractEntity.getContractType());
                totalExecutionVOList.add(executionVO.getTotalVO());
                logger.info("目标成本删除数据" + JSON.toJSONString(totalExecutionVOList));
                CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
                if (!response.isSuccess()) {
                    throw new BusinessException("目标成本推送失败," + response.getMsg());
                }
            }
        }
        vos.forEach(contractVO -> {
            ContractEntity contractEntity = super.getById(contractVO.getId());
            if (null != contractEntity.getTargetResultId()) {
                CommonResponse<String> tender = tenderApi.updateById(contractEntity.getTargetResultId(), unOccupyState);
                logger.info("定标结果占用状态修改为未占用状态信息：" + tender.getMsg());
            }
        });
        service.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success("删除成功！");
    }

    /**
     * 新增或者修改补充协议
     *
     * @param contractVO
     * @return
     */
    @Override
    public ContractVO saveOrUpdateSupplement(ContractVO contractVO) {
        ContractEntity entity = null;
        if (StringUtils.isNotBlank(contractVO.getBillCode()) && checkSameBillCode(contractVO)) {
            throw new BusinessException("编码重复，不允许保存!");
        }
        //主合同
        ContractEntity mainContract = service.selectById(contractVO.getMainContractId());
        if (null == mainContract) {
            throw new BusinessException("未找到主合同，不能创建补充协议！");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("main_contract_id", new Parameter("eq", contractVO.getMainContractId()));
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStateList));
        List<ContractEntity> supplementList = service.queryList(param, false);

        if (StringUtils.isBlank(contractVO.getBillCode())) {
            //设置补充协议编码
            String supplementNum = "";
            if (supplementList.size() < 9) {
                supplementNum += "0" + (supplementList.size() + 1);
            }
            else {
                supplementNum += (supplementList.size() + 1);
            }
            contractVO.setBillCode(mainContract.getBillCode() + "-2-" + supplementNum);
        }

        if (contractVO.getId() == null) {
            //新增补充协议

            //校验：补充协议只能存在一条未生效的
            supplementList.stream().forEach(e -> {
                if (!(e.getSignatureStatus().equals(SignatureStatusEnum.已签章.getCode()) &&
                        (e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode())
                                || e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())))) {
                    //存在未生效的补充协议
                    throw new BusinessException("该合同已存在未生效的补充协议!");
                }
            });
            entity = BeanMapper.map(mainContract, ContractEntity.class);
            //清空基础字段
            clearBaseFields(entity);
            entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setBillCode(contractVO.getBillCode());

            //基本信息
            entity.setContractName(contractVO.getContractName());
            entity.setSignDate(contractVO.getSignDate());
            entity.setEmployeeId(contractVO.getEmployeeId());
            entity.setEmployeeName(contractVO.getEmployeeName());
            entity.setEmployeePhone(contractVO.getEmployeePhone());
            entity.setSupplierEmployee(contractVO.getSupplierEmployee());
            entity.setSupplierEmployeePhone(contractVO.getSupplierEmployeePhone());
            entity.setPerformanceStatus(contractVO.getPerformanceStatus());

            entity.setDraftType(contractVO.getDraftType());
            //设置文件路径
            entity.setContractFilePath(contractVO.getContractFilePath());
            entity.setContractFileId(contractVO.getContractFileId());

            entity.setContractTemplateId(contractVO.getContractTemplateId());
            entity.setContractTemplateName(contractVO.getContractTemplateName());
            entity.setContractFileVersionId(contractVO.getContractFileVersionId());
            entity.setContractFileVersion(contractVO.getContractFileVersion());
            entity.setSupplementDescribe(contractVO.getSupplementDescribe());

            //补充金额明细
            entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
            entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
            entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
            //分包明细
            entity.setSubContractMny(contractVO.getSubContractMny() == null ? BigDecimal.ZERO : contractVO.getSubContractMny());
            entity.setSubContractTaxMny(contractVO.getSubContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getSubContractTaxMny());
            entity.setSubContractTax(contractVO.getSubContractTax() == null ? BigDecimal.ZERO : contractVO.getSubContractTax());
            //其他费用
            entity.setOtherCostMny(contractVO.getOtherCostMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostMny());
            entity.setOtherCostTaxMny(contractVO.getOtherCostTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherCostTaxMny());
            entity.setOtherCostTax(contractVO.getOtherCostTax() == null ? BigDecimal.ZERO : contractVO.getOtherCostTax());
            //子表
            entity.setDetailList(BeanMapper.mapList(contractVO.getDetailList(), ContractDetailEntity.class));
            entity.setOtherCostList(BeanMapper.mapList(contractVO.getOtherCostList(), ContractOtherCostEntity.class));
            entity.setClauseList(BeanMapper.mapList(contractVO.getClauseList(), ContractClauseEntity.class));
            entity.setPaymentList(BeanMapper.mapList(contractVO.getPaymentList(), ContractPaymentEntity.class));

            //初始化变更字段
            entity.setChangingMny(null);
            entity.setChangeCode(null);
            entity.setChangeVersion(null);
            entity.setChangeId(null);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());

            //补充协议状态
            entity.setSupplementFlag(ContractVO.CONTRACT_TYPE_SUPPLEMENT);
            entity.setMainContractId(contractVO.getMainContractId());
            entity.setMainContractCode(contractVO.getMainContractCode());
            entity.setMainContractName(contractVO.getMainContractName());
        }
        else {
            entity = BeanMapper.map(contractVO, ContractEntity.class);
        }

        //设置初始金额
        entity.setBaseMny(entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny());
        //设置变更前金额
        entity.setBeforeChangeMny(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        //设置关联的附件Ids
        entity.setAttachIds(contractVO.getAttachIds());

        //保存前清空主键和父主键，重新生成
        resetPid(entity.getDetailList());
//        if (FilingStatusEnum.已归档.getTypeCode().equals(contractVO.getFilingStatus())) {
        entity.setFilingRef(0);
//        }
        service.saveOrUpdate(entity, false);
        //目标成本推送
        String linkUrl;
        linkUrl = getBaseHost() + "ejc-proequipment-frontend/#/otherSubList/supplementCard?id=" + entity.getId();
        ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, ContractVO.class), linkUrl, entity.getContractType());
        logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("目标成本推送失败," + response.getMsg());
        }

        return queryDetail(entity.getId());
    }

    /**
     * 重置单据基础字段
     *
     * @param entity
     */
    private void clearBaseFields(ContractEntity entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserName(null);
        entity.setEffectiveDate(null);
    }

    /**
     * 查询补充协议代入的主合同信息
     *
     * @param contractId
     * @return
     */
    @Override
    public ContractVO addConvertByConId(Long contractId) {
        ContractEntity contractVO = super.selectById(contractId);
        ContractVO supplementVO = new ContractVO();
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setSupplementFlag(ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        supplementVO.setContractCategoryId(contractVO.getContractCategoryId());

        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setFirstPartyId(contractVO.getFirstPartyId());
        supplementVO.setFirstPartyName(contractVO.getFirstPartyName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());
        supplementVO.setDraftType(DraftTypeEnum.上传合同.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "补充协议");
//        supplementVO.setContractType(contractVO.getContractType());
        supplementVO.setFilingStatus(FilingStatusEnum.未归档.getTypeCode());

        return supplementVO;
    }

    @Override
    public Integer deleteContractFileById(Long id) {
        ContractEntity contractEntity = service.selectById(id);
        contractEntity.setContractFileId(null);
        contractEntity.setContractFilePath(null);
        contractEntity.setContractFileHighlightId(null);
        contractEntity.setContractFilePath(null);
        contractEntity.setContractFileVersion(null);
        contractEntity.setContractFileVersionId(null);
        Boolean deleteContractFileResult = service.saveOrUpdate(contractEntity, false);
        if (!deleteContractFileResult) {
            return -1;
        }
        return contractEntity.getVersion();
    }

    @Override
    public ExecutionVO targetCost(ContractVO contractVO, String linkUrl, Integer contractType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        if(contractVO.getId()==null){
            totalVO.setSourceId(IdWorker.getId());
        }else {
            totalVO.setSourceId(contractVO.getId());
        }
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setBillType(BillTypeEnum.安拆合同主表.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.大型设备安拆合同.getCode());
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        if (contractVO.getProjectId() == null) {
            throw new BusinessException("目标成本推送失败,请更换项目");
        }
        else {
            totalVO.setProjectId(contractVO.getProjectId());
        }
        if (contractVO.getOrgId() == null) {
            throw new BusinessException("目标成本推送失败,请更换项目");
        }
        else {
            totalVO.setOrgId(contractVO.getOrgId());
        }
        totalVO.setMoney(contractVO.getContractMny()); //总计划金额无税
        totalVO.setTaxMoney(contractVO.getContractTaxMny()); //总计划金额
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(ContractVO contractVO) {
        ContractEntity entity = BeanMapper.map(contractVO, ContractEntity.class);
        String linkUrl;
        String billType;
        linkUrl = getBaseHost() + "ejc-proequiment-frontend/#/otherSubList/card?id=" + entity.getId()+"&cardType=otherSubDirectCard";
        billType = BillTypeEnum.安拆合同主表.getCode();
        ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, ContractVO.class), linkUrl, entity.getContractType());
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        //参数控制
        ParamsCheckVO paramsCheckVO = checkParams(contractVO, response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        ContractVO contractVO = service.queryDetail(id);
        String linkUrl;
        String billType;
        linkUrl = getBaseHost() + "ejc-proequiment-frontend/#/otherSubList/card?id=" + contractVO.getId()+"&cardType=otherSubDirectCard";
        billType = BillTypeEnum.安拆合同主表.getCode();
        ExecutionVO executionVO = service.targetCost(BeanMapper.map(contractVO, ContractVO.class), linkUrl, contractVO.getContractType());
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        //参数控制
        ParamsCheckVO paramsCheckVO = checkParams(contractVO, response.getData());
        return paramsCheckVO;
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        QueryWrapper<ChangeEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", id).eq("dr", 0).orderByDesc("create_time");
        List<ChangeEntity> list = changeService.list(wrapper);
        Boolean flag = true;
        ExecutionVO executionVO;
        //判断是否有过变更
        if (list.size() > 0) {
            flag = false;
            ChangeEntity changeEntity = list.get(0);
            String changeLinkUrl = getBaseHost() + "ejc-proequipment-frontend/#/otherSubList/changeCard?id=" + changeEntity.getId()+"&cardType=otherSubCard";
            executionVO = changeService.targetCost(BeanMapper.map(changeEntity, ChangeVO.class), changeLinkUrl, changeEntity.getContractType());
        }
        else {
            flag = true;
            String linkUrl = getBaseHost() + "ejc-proequipment-frontend/#/otherSubList/card?id=" + id+"&cardType=otherSubDirectCard";
            ContractVO contractVO = service.queryDetail(id);
            executionVO = service.targetCost(contractVO, linkUrl, contractVO.getContractType());
        }
        logger.info("目标成本推送单据类型" + (flag ? "主合同" : "变更合同"));
        logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("合同目标成本推送失败," + response.getMsg());
        }
        //解除单推送
        QueryWrapper<ContractRelieveEntity> relieveEntityQueryWrapper = new QueryWrapper<>();
        relieveEntityQueryWrapper.eq("contract_id", id).eq("dr", 0).in("bill_state",1,3).orderByDesc("create_time");
        List<ContractRelieveEntity> relieveEntityList = contractRelieveService.list(relieveEntityQueryWrapper);
        if(CollectionUtils.isNotEmpty(relieveEntityList)){
            ContractRelieveEntity entity = relieveEntityList.get(0);
            //目标成本推送
            String linkUrl;
            ContractEntity contractEntity = service.selectById(entity.getContractId());
            linkUrl = getBaseHost()+"ejc-proequipment-frontend/#/contractRelieve/card?id="+entity.getId();
            ExecutionVO executionVO1 = contractRelieveService.targetCost(BeanMapper.map(entity, ContractRelieveVO.class),linkUrl,contractEntity.getContractType());
            logger.info("解除单目标成本推送数据"+ JSON.toJSONString(executionVO1));
            CommonResponse<String> response1 = executionApi.aggPush(executionVO1);
            if (!response.isSuccess()){
                throw new BusinessException("解除单目标成本推送失败,"+response1.getMsg());
            }
        }
        return CommonResponse.success("目标成本推送成功");
    }

    //单据参数控制
    @Override
    public ParamsCheckVO checkParams(ContractVO vo, ParamsCheckVO paramsCheckVO2){
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))){
            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));//施工合同控制
        }
        if(vo.getSupplementFlag()!=null && Objects.equals(vo.getSupplementFlag(), ContractVO.CONTRACT_TYPE_SUPPLEMENT)){
            paramsCheckVOS.addAll(this.checkParamsMnySup(vo));//合同金额控制补充协同金额
        }
        if(paramsCheckVO2!=null){//组合成本参数
            paramsCheckVOS.add(paramsCheckVO2);
        }
        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull(watermarkFileId, "水印合同附件不能为空！");
        CommonResponse<String> res = attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            logger.error("删除文件中心水印文件失败，原因：{}，水印文件id：{}", res.getMsg(), watermarkFileId);
            throw new BusinessException("删除文件中心水印文件失败，原因：" + res.getMsg() + "，水印文件id：" + watermarkFileId);
        }
        return true;
    }
    //施工合同参数控制
    @Override
    public List<ParamsCheckVO>  checkParamsConstruction(ContractVO vo) {
        CommonResponse<List<ParamsCheckVO> > response = paramCheckApi.paramsCheck(vo.getProjectId(), vo.getId(), vo.getContractTaxMny(),vo.getOrgId());
        logger.info("施工合同控制信息返回："+JSONObject.toJSONString(response.getData()));
        if(!response.isSuccess()){
            throw new BusinessException("获取施工参数控制信息失败!"+response.getMsg());
        }
        return response.getData();
    }



    /**
     * 单据管控-补充协议金额大于合同金额
     * @return
     */
    @Override
    public List<ParamsCheckVO>  checkParamsMnySup(ContractVO vo) {
        BigDecimal contractTaxMnySup = vo.getContractTaxMny()==null?BigDecimal.ZERO:vo.getContractTaxMny();//本次补充协议金额
        ContractEntity contractEntity = super.selectById(vo.getMainContractId());
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny()==null?BigDecimal.ZERO:contractEntity.getContractTaxMny();//初始合同金额
        BigDecimal totalSupMoney =  contractTaxMnySup;//累计补充金额  默认赋值本次
        //查询累计补充金额
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, vo.getMainContractId()));
        if (vo.getId() != null) {
            supplementQueryParam.getParams().put("id", new Parameter(QueryParam.NE, vo.getId()));
        }
        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, vo.getMainContractId()));
        supplementQueryParam.getParams().put("signatureStatus", new Parameter(QueryParam.EQ, SignatureStatusEnum.已签章.getCode()));
        List<ContractEntity> supplementContractList = super.queryList(supplementQueryParam, false);
        if(CollectionUtils.isNotEmpty(supplementContractList)){
            for (ContractEntity entity : supplementContractList) {
                totalSupMoney = ComputeUtil.safeAdd(entity.getContractTaxMny(),totalSupMoney);//累加变更金额
            }
        }
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
//        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("协议金额控制信息返回："+JSONObject.toJSONString(data));
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);

                    if (totalSupMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("补充协议超合同金额");
                        paramsCheckDsVO.setWarnName("累计补充协议金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次补充协议金额：").append(contractTaxMnySup.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次补充协议金额：").append(totalSupMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalSupMoney, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

    /**
     * 获取合同归档控制参数  没有获取到参数默认不限制
     *
     * @return 合同归档控制参数(0：不限制，1：部分限制，2：全部限制)
     */
    @Override
    public String getContractFilingCode() {
        // 合同归档参数控制
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(CONTRACT_FILING_CODE);
        logger.info("合同归档控制参数查询结果：{}", JSONObject.toJSONString(response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取合同归档控制参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
//        Assert.hasText(valueData, "获取的合同归档控制参数不能为空!");
        return com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty(valueData) ? valueData : "0";
    }

    /**
     * 根据合同归档控制参数，校验合同能否新增变更、补充协议
     *
     * @param contractId 合同id
     * @return true：可以新增，false：不能新增
     */
    @Override
    public boolean checkContractFiling(Long contractId) {
        String valueData = this.getContractFilingCode();
        ContractEntity contractEntity = super.selectById(contractId);
        // 不限制
        if("0".equals(valueData)){
            return true;
        }
        // 部分限制、全部限制，合同未归档，都不能新增合同变更、补充协议
        else {
            return FilingStatusEnum.已归档.getTypeCode().equals(contractEntity.getFilingStatus());
        }
    }

}
