package com.ejianc.business.rent.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.rent.bean.*;
import com.ejianc.business.rent.enums.ChangeStatusEnum;
import com.ejianc.business.rent.enums.DraftTypeEnum;
import com.ejianc.business.rent.enums.RentContractSyncTypeEnum;
import com.ejianc.business.rent.enums.SignatureStatusEnum;
import com.ejianc.business.rent.service.*;
import com.ejianc.business.rent.service.impl.RentContractChangeServiceImpl;
import com.ejianc.business.rent.service.impl.RentContractFreezeServiceImpl;
import com.ejianc.business.rent.service.impl.RentContractRelieveServiceImpl;
import com.ejianc.business.rent.service.impl.RentContractServiceImpl;
import com.ejianc.business.rent.vo.RentContractChangeVO;
import com.ejianc.business.rent.vo.RentContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.utils.RentEntityUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@RestController
@RequestMapping
public class RentContractApiController implements Serializable {

    @Autowired
    private IRentContractService rentContractService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${common.env.base-host}")
    private String BaseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IRentContractService service;

    @Autowired
    private IRentContractChangeService changeService;

    @Autowired
    private RentContractChangeServiceImpl changeImpl;

    @Autowired
    private IRentContractRelieveService relieveService;

    @Autowired
    private IRentContractFreezeService freezeService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    private IExecutionApi executionApi;


    @Autowired
    private IRentContractRecordService recordService;
    @Autowired
    private RentContractServiceImpl contractService;

    private String getBaseHost(){
        return StringUtils.isNotBlank(BASE_HOST_FRONTEND) && !("null").equals(BASE_HOST_FRONTEND) ? BASE_HOST_FRONTEND : BaseHost;
    }

    /**
     * 根据定标参照id查询对应的合同
     *
     * @param targetResultIdList 定标结果参照id
     * @return 修改结果
     */
    @ApiOperation("根据定标参照id查询对应的合同")
    @RequestMapping(value = "/api/rentContract/queryContractByTargetResultId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SignContractVo>> queryContractByTargetResultId(@RequestParam("targetResultIdList") List<String> targetResultIdList) {
        logger.info("根据定标结果id查询合同，查询参数：{}", JSONObject.toJSONString(targetResultIdList));
        List<SignContractVo> list = rentContractService.queryContractByTargetResultId(targetResultIdList);
        logger.info("根据定标结果id查询合同，查询结果：{}", JSONObject.toJSONString(list));
        return CommonResponse.success("查询成功", list);
    }

    /**
     * 设备公司中送同步生成内租合同
     * @param json,type
     * @return
     */
    @PostMapping(value = "/api/rentContract/contractSync")
    public CommonResponse<String> contractSync(@RequestBody JSONObject json,@RequestParam("type") String type){
        String msg = "单据已经进行过同步操作，请勿重复操作！";
        switch (RentContractSyncTypeEnum.getEnumByName(type)) {
            case 租赁合同:
                RentContractEntity entity = JSON.parseObject(json.toJSONString(), RentContractEntity.class);
                RentContractEntity data = RentEntityUtil.selectOneService("id", entity.getId(), RentContractServiceImpl.class);
                if(null != data) {
                    service.delById(data.getId());
                }
                entity.setAddType(1);
                entity.setSignatureState(String.valueOf(Integer.valueOf(entity.getSignatureState())));
                // 推送合同池
                service.pushContract(BeanMapper.map(entity, RentContractVO.class));

                // 推送目标成本
                String linkUrl = getBaseHost() + "ejc-proequipment-frontend/#/leaseContract/card?id=" + entity.getId();

                CommonResponse<String> response = executionApi.aggPush(service.targetCost(BeanMapper.map(entity, RentContractVO.class),linkUrl));
                if (!response.isSuccess()){
                    logger.error("推送目标成本失败: , {}", response.getMsg());
                    throw new BusinessException(response.getMsg());
                }
                service.saveOrUpdate(entity,false);
                break;
            case 租赁合同变更:
                RentContractChangeEntity changeEntity = JSON.parseObject(json.toJSONString(), RentContractChangeEntity.class);
                RentContractChangeEntity changeData = RentEntityUtil.selectOneService("id", changeEntity.getId(), RentContractChangeServiceImpl.class);
                if(null != changeData) {
                    //删除变更记录历史记录
                    LambdaQueryWrapper<RentContractRecordEntity> wrapper = new LambdaQueryWrapper<>();
                    wrapper.eq(RentContractRecordEntity::getChangeId, changeEntity.getId());
                    List<RentContractRecordEntity> list = recordService.list(wrapper);
                    service.delChangeById(changeEntity.getId());
                    if (ListUtil.isNotEmpty(list)) {
                        //service.delRecordById(list.get(0).getId());
                    }
                }
                saveChange(changeEntity);
                break;
            case 租赁合同解除:
                RentContractRelieveEntity relieveEntity = JSON.parseObject(json.toJSONString(), RentContractRelieveEntity.class);
                RentContractRelieveEntity relieveData = RentEntityUtil.selectOneService("id", relieveEntity.getId(), RentContractRelieveServiceImpl.class);
                if(null != relieveData) {
                    return CommonResponse.error(msg);
                }
                // 已签章
                if (relieveEntity.getDraftType() == 2) {
                    QueryParam param = new QueryParam();
                    param.getParams().put("id", new Parameter(QueryParam.EQ, relieveEntity.getContractId()));
                    List<RentContractEntity> contractEntities = service.queryList(param, false);
                    if (ListUtil.isNotEmpty(contractEntities)) {
                        RentContractEntity contractEntity = contractEntities.get(0);
                        contractEntity.setContractPerformanceState(ContractPerformanceStateEnum.已作废.getStateCode());
                        logger.info("======终审审核完回调,已签章======,{}", JSONObject.toJSONString(contractEntity));
                        service.saveOrUpdate(contractEntity, false);
                        // 推送目标成本
                        CommonResponse<String> response1 = executionApi.aggPush(relieveService.targetCost(relieveEntity));
                        logger.info("推送目标成本入参：" + JSONObject.toJSONString(relieveService.targetCost(relieveEntity)));
                        if (!response1.isSuccess()){
                            logger.error("推送目标成本失败: , {}", response1.getMsg());
                            throw new BusinessException(response1.getMsg());
                        }
//                        // 合同推送合同池，更新解除状态
//                        boolean pushResult = service.pushContract(BeanMapper.map(contractEntity, ContractVO.class));
//                        if(pushResult) {
//                            contractEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
//                        } else {
//                            contractEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
//                        }
                        // 更新合同履约状态
                        ContractPoolVO contractPoolVO = new ContractPoolVO();
                        contractPoolVO.setPerformanceStatus(ContractPerformanceStateEnum.已作废.getStateCode());
                        contractPoolVO.setSourceId(relieveEntity.getContractId());
                        contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
                        // 更新合同履约状态
                        LambdaUpdateWrapper<RentContractEntity> wrapper = new LambdaUpdateWrapper<>();
                        wrapper.eq(RentContractEntity::getId, relieveEntity.getContractId());
                        wrapper.set(RentContractEntity::getContractPerformanceState, ContractPerformanceStateEnum.已作废.getStateCode());
                        service.update(wrapper);
                    }
                }
                relieveService.saveOrUpdate(relieveEntity,false);
                break;
            case 租赁合同冻结:
                RentContractFreezeEntity freezeEntity = JSON.parseObject(json.toJSONString(), RentContractFreezeEntity.class);
                RentContractFreezeEntity freezeData = RentEntityUtil.selectOneService("id", freezeEntity.getId(), RentContractFreezeServiceImpl.class);
                if(null != freezeData) {
                    return CommonResponse.error(msg);
                }
                freezeService.saveOrUpdate(freezeEntity,false);
                ContractPoolVO contractPoolVO = new ContractPoolVO();
                RentContractEntity contractEntity = service.getById(freezeEntity.getContractId());
                if(contractEntity.getContractPerformanceState().equals(ContractPerformanceStateEnum.履约中.getStateCode())){
                    contractEntity.setContractPerformanceState(ContractPerformanceStateEnum.已冻结.getStateCode());
                    contractPoolVO.setPerformanceStatus(ContractPerformanceStateEnum.已冻结.getStateCode());
                }else if (contractEntity.getContractPerformanceState().equals(ContractPerformanceStateEnum.已冻结.getStateCode())) {
                    contractEntity.setContractPerformanceState(ContractPerformanceStateEnum.履约中.getStateCode());
                    contractPoolVO.setPerformanceStatus(ContractPerformanceStateEnum.履约中.getStateCode());
                }
                // 更新合同履约状态
                contractPoolVO.setSourceId(freezeEntity.getContractId());
                contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
                service.saveOrUpdate(contractEntity, false);
                break;
            default:
                RentContractChangeEntity cEntity = JSON.parseObject(json.toJSONString(), RentContractChangeEntity.class);
                cEntity.setSignatureState(String.valueOf(Integer.valueOf(cEntity.getSignatureState()) ));
                if (cEntity.getSignatureState().equals(SignatureStatusEnum.已签章.getCode())) {
                    changeService.effectiveSaveWriteContract(cEntity.getId(), cEntity.getCode(), false);
                }else {
                    changeService.saveOrUpdate(cEntity);
                    logger.info("变更合同签章状态已修改---------------->");
                    //回写主合同（变更合同签章状态，主合同变更状态）
                    LambdaUpdateWrapper<RentContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.eq(RentContractEntity::getId, cEntity.getContractId());
                    updateWrapper.set(RentContractEntity::getChangeContractSignatureStatus, cEntity.getSignatureState());
                    service.update(service.selectById(cEntity.getContractId()), updateWrapper, false);
                    logger.info("签章状态为已签章，回写主合同签章状态---------------->");
                }
                break;
        }
        return CommonResponse.success("同步成功！");
    }

    /**
     * 合同删除
     *
     * @param id,type
     * @return
     */
    @PostMapping(value = "/api/rentContract/delContract")
    public CommonResponse<String> delContract(@RequestParam("id") Long id,@RequestParam("type") String type){
        String msg = "操作失败,未查到单据!";
        switch (RentContractSyncTypeEnum.getEnumByName(type)){
            case 租赁合同:
                RentContractEntity data = RentEntityUtil.selectOneService("id", id, RentContractServiceImpl.class);
                if(data == null){
                    return CommonResponse.error(msg);
                }
                // 从合同池删除数据
                boolean delResult = service.delContractFromPool(data.getId());
                if(!delResult) {
                    return CommonResponse.error("操作失败，单据从合同池删除失败！");
                }
                List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
                String linkUrl = getBaseHost() + "ejc-proequipment-frontend/#/leaseContract/card?id=" + data.getId();

                ExecutionVO executionVO = contractService.targetCost(BeanMapper.map(data, RentContractVO.class),linkUrl);
                totalExecutionVOList.add(executionVO.getTotalVO());
                CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
                if (!response.isSuccess()){
                    throw new BusinessException("目标成本删除失败！");
                }
                service.delById(id);
                break;
            case 租赁合同变更:
                RentContractChangeEntity changeData = RentEntityUtil.selectOneService("id",id, RentContractChangeServiceImpl.class);
                if(changeData == null){
                    return CommonResponse.error(msg);
                }
                QueryWrapper<RentContractChangeEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("contract_id", changeData.getContractId()).orderByDesc("create_time");
                List<RentContractChangeEntity> list = changeService.list(wrapper);
                RentContractEntity rentContractEntity = contractService.selectById(changeData.getContractId());
                Long lastSourceId = null;
                if (list.size() > 0) {
                    lastSourceId = list.get(0).getId();
                }else {
                    lastSourceId = rentContractEntity.getId();

                }
                // 删除当前变更单的目标成本
                changeImpl.deleteTargetCost(changeImpl.targetCost(BeanMapper.map(changeData, RentContractChangeVO.class),lastSourceId));
                RentContractChangeEntity oldEntity = changeImpl.queryChangeList(changeData);
                ExecutionVO executionVO1 = null;
                if (oldEntity == null) {
                    // 原合同
                    RentContractEntity contractEntity = service.selectById(changeData.getContractId());
                    String linkUrlnew = getBaseHost() + "ejc-proequipment-frontend/#/leaseContract/card?id=" + contractEntity.getId();
                    executionVO1 = service.targetCost(BeanMapper.map(contractEntity, RentContractVO.class),linkUrlnew);
                }else {
                    // 推送上个变更单
                    executionVO1 = changeImpl.targetCost(BeanMapper.map(oldEntity, RentContractChangeVO.class),lastSourceId);
                }
                // 推送上个版本的目标成本
                CommonResponse<String> response2 = executionApi.aggPush(executionVO1);
                if (!response2.isSuccess()){
                    throw new BusinessException("目标成本推送失败！");
                }
                //回写状态
                LambdaUpdateWrapper<RentContractEntity> lambdaUpdate = new LambdaUpdateWrapper<>();
                if (changeData.getChangeVersion() == 1) {
                    lambdaUpdate.set(RentContractEntity::getChangeStatus, 1);
                } else {
                    lambdaUpdate.set(RentContractEntity::getChangeStatus, 3);
                }
                lambdaUpdate.eq(RentContractEntity::getId, changeData.getContractId());
                service.update(lambdaUpdate);
                service.delChangeById(id);
                break;
            default:
                RentContractRelieveEntity relieveData = RentEntityUtil.selectOneService("id",id, RentContractRelieveServiceImpl.class);
                if(relieveData == null){
                    return CommonResponse.error(msg);
                }
                // 更新合同履约状态
                ContractPoolVO contractPoolVO = new ContractPoolVO();
                contractPoolVO.setPerformanceStatus(ContractPerformanceStateEnum.履约中.getStateCode());
                contractPoolVO.setSourceId(relieveData.getContractId());
                contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
                // 解除单撤回后，更新合同状态为履约中
                LambdaUpdateWrapper<RentContractEntity> wrapperNew = new LambdaUpdateWrapper<>();
                wrapperNew.eq(RentContractEntity::getId, relieveData.getContractId());
                wrapperNew.set(RentContractEntity::getContractPerformanceState, ContractPerformanceStateEnum.履约中.getStateCode());
                service.update(wrapperNew);
                relieveService.delById(id);
                break;
        }
        return CommonResponse.success("删除成功！");
    }

    private String saveChange(RentContractChangeEntity entity){
        // 获取主合同当前合同文件Id
        QueryWrapper<RentContractChangeEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", entity.getContractId()).orderByDesc("create_time");
        List<RentContractChangeEntity> list = changeService.list(wrapper);
        RentContractEntity rentContractEntity = contractService.selectById(entity.getContractId());
        Long lastSourceId = null;
        if (list.size() > 0) {
            lastSourceId = list.get(0).getId();
        }else {
            lastSourceId = rentContractEntity.getId();
        }
        RentContractEntity contractEntity = service.selectById(entity.getMainContractId());
        RentContractChangeEntity oldEntity = changeImpl.queryChangeList(entity);
        ExecutionVO executionVO = null;
        String linkUrl= getBaseHost() + "ejc-proequipment-frontend/#/leaseContract/card?id=" + contractEntity.getId();

        if (oldEntity == null) {
            // 原合同
            executionVO = service.targetCost(BeanMapper.map(contractEntity, RentContractVO.class),linkUrl);
        }else {
            // 上个变更单
            executionVO = changeImpl.targetCost(BeanMapper.map(oldEntity, RentContractChangeVO.class),lastSourceId);
        }
        // 删除旧的目标成本
        changeImpl.deleteTargetCost(executionVO);
        entity.setSignatureState(String.valueOf(Integer.valueOf(entity.getSignatureState()) - 1));

        // 推送新目标成本
        CommonResponse<String> response = executionApi.aggPush(changeImpl.targetCost(BeanMapper.map(entity, RentContractChangeVO.class),lastSourceId));
        if (!response.isSuccess()){
            throw new BusinessException("目标成本推送失败！");
        }
        if (!BillStateEnum.COMMITED_STATE.getBillStateCode().equals(entity.getBillState())
                && !BillStateEnum.PASSED_STATE.getBillStateCode().equals(entity.getBillState())){
            // 回写主合同信息
            LambdaUpdateWrapper<RentContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(RentContractEntity::getChangeId, entity.getId());
            updateWrapper.set(RentContractEntity::getChangingMny, entity.getContractMny());
            updateWrapper.set(RentContractEntity::getChangingTaxMny, entity.getContractTaxMny());
            updateWrapper.set(RentContractEntity::getChangeCode, entity.getCode());
            updateWrapper.set(RentContractEntity::getChangeVersion, entity.getChangeVersion());
            updateWrapper.set(RentContractEntity::getChangeDate, entity.getChangeDate());
            updateWrapper.set(RentContractEntity::getChangeDraftType, entity.getChangeDraftType());
            updateWrapper.set(RentContractEntity::getChangeContractSignatureStatus, entity.getSignatureState());
            updateWrapper.set(RentContractEntity::getChangeFileId, entity.getChangeFileId());
            updateWrapper.set(RentContractEntity::getChangeContractName, entity.getContractName());
            updateWrapper.eq(RentContractEntity::getId, entity.getMainContractId());
            updateWrapper.set(RentContractEntity::getChangeStatus, ChangeStatusEnum.变更中.getCode());
            service.update(updateWrapper);
        }else {
            if (DraftTypeEnum.线下签订.getCode().equals(entity.getChangeDraftType())){
                // 调用生效回写服务
                //changeService.effectiveSaveWriteContract(entity.getId(), BillTypeEnum.周转材租赁合同变更.getCode(), false);
            }else {
                entity.setCommitDate(new Date());
                changeService.saveOrUpdate(entity,false);
                // 回写主合同信息
                LambdaUpdateWrapper<RentContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.set(RentContractEntity::getChangeStatus, ChangeStatusEnum.变更单据审批通过.getCode());
                updateWrapper.eq(RentContractEntity::getId, entity.getContractId());
                service.update(updateWrapper);
            }
        }
        changeService.saveOrUpdate(entity,false);
        return "保存成功!";
    }
}
