package com.ejianc.business.rent.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.ac.enums.SupplierSignStatusEnum;
import com.ejianc.business.appearance.bean.AppearanceEntity;
import com.ejianc.business.appearance.service.IAppearanceService;
import com.ejianc.business.order.enums.OutRentReceiptsEnum;
import com.ejianc.business.order.enums.OutStatusTypeEnum;
import com.ejianc.business.order.mapper.RentOrderMapper;
import com.ejianc.business.order.service.IRentOrderService;
import com.ejianc.business.proequipmentcorpout.api.IOutCorpApi;
import com.ejianc.business.rent.bean.*;
import com.ejianc.business.rent.service.*;
import com.ejianc.business.rent.service.impl.*;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.*;


@RestController
@RequestMapping("/api/outEquipment/")
public class RentWriteBackApi {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRentContractService service;

    @Autowired
    private IRentAcceptanceService checkService;

    @Autowired
    private IRentEquipmentStartService startService;

    @Autowired
    private IRentEquipmentStopService stopService;

    @Autowired
    private IRentSettlementService settleService;

    @Autowired
    private IAppearanceService appearanceService;

    @Autowired
    private RentSettlementBpmServiceImpl settleBpmService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IRentOrderService orderService;

    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private RentOrderMapper mapper;

    @Autowired
    private IUserApi userApi;

    @Autowired
    private IOutCorpApi outCorpApi;




    /**
     * 回写设备公司签字状态
     * @param id,type
     * @return
     */
    @GetMapping(value = "/writeBackSign")
    public CommonResponse<String> writeBackSign(@RequestParam(value = "id") String id,@RequestParam(value = "type") String type) {
        CommonResponse<UserVO> userResp = userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        if(!userResp.isSuccess()) {
            logger.error("查询当前用户id-{},信息失败， {}", InvocationInfoProxy.getUserid(), userResp.getMsg());
            throw new BusinessException("查询当前用户信息失败!");
        }
        UserVO user = userResp.getData();
        Map<String,String> map = new HashMap<>();
        map.put("billId", id);
        map.put("supOperatorName", user.getUserName());
        map.put("supOperatorPhone", user.getUserMobile());
        map.put("supOperatorUserCode", user.getUserCode());
        map.put("supOperateTime", Long.toString(System.currentTimeMillis()));
        logger.info("推送项目方单据信息：{}", JSONObject.toJSONString(map));
        Boolean flag = outCorpApi.updateBillSupSignSyncInfo(map,type).isSuccess();
        if (Boolean.FALSE.equals(flag)){
            return CommonResponse.error("回写失败!");
        }else {
            switch (OutRentReceiptsEnum.getEnumBySourceName(type)) {
                case 验收单:
                    RentAcceptanceEntity entity = checkService.selectById(id);
                    entity.setSupOperateTime(new Date());
                    entity.setSupOperatorPhone(user.getUserMobile());
                    entity.setSupOperatorName(user.getUserName());
                    entity.setSupOperatorUserCode(user.getUserCode());
                    entity.setSignStatus(SupplierSignStatusEnum.乙方已签字.getCode());
                    checkService.saveOrUpdate(entity,false);
                    break;
                case 启用单:
                    RentEquipmentStartEntity startEntity = startService.selectById(id);
                    startEntity.setSupOperateTime(new Date());
                    startEntity.setSupOperatorPhone(user.getUserMobile());
                    startEntity.setSupOperatorName(user.getUserName());
                    startEntity.setSupOperatorUserCode(user.getUserCode());
                    startEntity.setSignStatus(SupplierSignStatusEnum.乙方已签字.getCode());
                    startService.saveOrUpdate(startEntity,false);
                    break;
                case 停用单:
                    RentEquipmentStopEntity stopEntity = stopService.selectById(id);
                    stopEntity.setSupOperateTime(new Date());
                    stopEntity.setSupOperatorPhone(user.getUserMobile());
                    stopEntity.setSupOperatorName(user.getUserName());
                    stopEntity.setSupOperatorUserCode(user.getUserCode());
                    stopEntity.setSignStatus(SupplierSignStatusEnum.乙方已签字.getCode());
                    stopService.saveOrUpdate(stopEntity,false);
                    break;
                case 退场单:
                    AppearanceEntity appearanceEntity = appearanceService.selectById(id);
                    appearanceEntity.setSupOperateTime(new Date());
                    appearanceEntity.setSupOperatorPhone(user.getUserMobile());
                    appearanceEntity.setSupOperatorName(user.getUserName());
                    appearanceEntity.setSupOperatorUserCode(user.getUserCode());
                    appearanceEntity.setNotSignature(true);
                    appearanceService.saveOrUpdate(appearanceEntity,false);
                    break;
                case 结算单:
                    RentSettlementEntity settleEntity = settleService.selectById(id);
                    settleEntity.setSupOperateTime(new Date());
                    settleEntity.setSupOperatorPhone(user.getUserMobile());
                    settleEntity.setSupOperatorName(user.getUserName());
                    settleEntity.setSupOperatorUserCode(user.getUserCode());
                    settleEntity.setSignStatus(SupplierSignStatusEnum.乙方已签字.getCode());
                    settleService.saveOrUpdate(settleEntity,false);
                    break;
            }
            logger.info("回写设备公司项目方签字：");
            logger.info("id：{}，sourceBillType：{}，sourceBillSourceType：{}，targetBillType：{}，targetBillSourceType：{}", id, OutRentReceiptsEnum.getEnumBySourceName(type).getCode(), OutRentReceiptsEnum.getEnumBySourceName(type).getFileType(), OutStatusTypeEnum.getEnumByName(type).getCode(),OutStatusTypeEnum.getEnumByName(type).getFileType());
            signSync(id, OutRentReceiptsEnum.getEnumBySourceName(type).getCode(), OutRentReceiptsEnum.getEnumBySourceName(type).getFileType(), OutStatusTypeEnum.getEnumByName(type).getCode(),OutStatusTypeEnum.getEnumByName(type).getFileType());
        }
        return CommonResponse.success("回写成功!");
    }

    @Autowired
    private IAttachmentApi attachmentApi;
    private void signSync(String id,String sourceBillType,String sourceBillSourceType,String targetBillType,String targetBillSourceType){
        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                id, sourceBillType, sourceBillSourceType,
                id, targetBillType, targetBillSourceType);
        if(!response.isSuccess()) {
            throw new BusinessException("同步单据附件失败！");
        }
    }
}
