package com.ejianc.business.tool.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.tool.bean.BorrowContentEntity;
import com.ejianc.business.tool.bean.ReturnContentEntity;
import com.ejianc.business.tool.bean.ReturnEntity;
import com.ejianc.business.tool.service.impl.BorrowContentServiceImpl;
import com.ejianc.business.tool.service.impl.ReturnContentServiceImpl;
import com.ejianc.business.tool.service.impl.ReturnServiceImpl;
import com.ejianc.business.tool.vo.BorrowContentVO;
import com.ejianc.business.tool.vo.BorrowRequestVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.models.auth.In;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.similarities.Lambda;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.tool.bean.BorrowEntity;
import com.ejianc.business.tool.service.IBorrowService;
import com.ejianc.business.tool.vo.BorrowVO;

/**
 * 工机具借用
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("borrow")
public class BorrowController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BORROW";//此处需要根据实际修改

    @Autowired
    private IBorrowService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private BorrowContentServiceImpl borrowContentService;
    @Autowired
    private ReturnContentServiceImpl returnContentService;
    @Autowired
    private ReturnServiceImpl returnService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BorrowVO> saveOrUpdate(@RequestBody BorrowVO saveOrUpdateVO) {
    	BorrowEntity entity = BeanMapper.map(saveOrUpdateVO, BorrowEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	BorrowVO vo = BeanMapper.map(entity, BorrowVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BorrowVO> queryDetail(Long id) {
    	BorrowEntity entity = service.selectById(id);
    	BorrowVO vo = BeanMapper.map(entity, BorrowVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BorrowVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (BorrowVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(BorrowVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BorrowVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","projectName","borrowName","billName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<BorrowEntity> page = service.queryPage(param,false);
        IPage<BorrowVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BorrowVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @ResponseBody
    @RequestMapping(value = "/getHaveBorrowNum",method = RequestMethod.POST)
    public CommonResponse<Map<Long,Integer>> getHaveBorrowNum(@RequestBody BorrowRequestVO borrowVO) {
        Long projectId = borrowVO.getProjectId();
        Long storeId = borrowVO.getStoreId();
        List<Long> materialIds = borrowVO.getMaterialIds();

        Map<Long,Integer> map = null;
        if(storeId == null || projectId == null){
            return CommonResponse.error("项目或仓库Id不能为空");
        }
        LambdaQueryWrapper<BorrowEntity> query = new LambdaQueryWrapper<BorrowEntity>().eq(BorrowEntity::getProjectId, projectId)
                .eq(BorrowEntity::getStoreId, storeId)
                .in(BorrowEntity::getBillState, Arrays.asList(1, 3));
        List<BorrowEntity> list = service.list(query);
        List<Long> collect1 = list.stream().map(BorrowEntity::getId).collect(Collectors.toList());

        if (CollectionUtils.isEmpty(collect1)) {
            return CommonResponse.success(null);
        }

        LambdaQueryWrapper<BorrowContentEntity> queryWrapper = new LambdaQueryWrapper<BorrowContentEntity>()
                    .in(BorrowContentEntity::getToolId,materialIds)
                    .in(BorrowContentEntity::getBorrowId,collect1);


        if(queryWrapper == null){
            return CommonResponse.success(null);
        }

        List<BorrowContentEntity> borrowList = borrowContentService.list(queryWrapper);
        if(CollectionUtils.isEmpty(borrowList)){
            return CommonResponse.success(null);
        }
        map = borrowList.stream().collect(Collectors.groupingBy(BorrowContentEntity::getToolId,
                Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().mapToInt(BorrowContentEntity::getBorrowNum).sum())));

        LambdaQueryWrapper<ReturnContentEntity> wrapper = new LambdaQueryWrapper<ReturnContentEntity>()
                .in(ReturnContentEntity::getId,materialIds);

        List<ReturnContentEntity> returnList =  returnContentService.list(wrapper);
        if(CollectionUtils.isEmpty(returnList)){
            return CommonResponse.success(map);
        }
        Map<Long, Integer> collect = returnList.stream().collect(Collectors.groupingBy(ReturnContentEntity::getToolId,
                Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().mapToInt(ReturnContentEntity::getReturnNum).sum())));

        for (Map.Entry<Long, Integer> longIntegerEntry : map.entrySet()) {
            Long key = longIntegerEntry.getKey();
            if(collect.containsKey(key)){
                longIntegerEntry.setValue(map.get(key) - collect.get(key));
            }
        }

        return CommonResponse.success(map);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","projectName","borrowName","billName"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BorrowEntity> entityList = service.queryList(param);
        List<BorrowVO> list = BeanMapper.mapList(entityList,BorrowVO.class);
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(vo -> {
                Integer billState = vo.getBillState();
                if (billState != null) {
                    BillStateEnum billStateEnum = BillStateEnum.getEnumByStateCode(billState);
                    if (billStateEnum != null) {
                        vo.setBillStateName(billStateEnum.getDescription());
                    }
                }
            });
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Borrow-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refBorrowData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BorrowContentVO>> refBorrowData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(condition.contains("projectId")){
                param.getParams().put("projectId",new Parameter(QueryParam.EQ,_con.getString("projectId")));
            }
            if(condition.contains("storeId")){
                param.getParams().put("storeId",new Parameter(QueryParam.EQ,_con.getString("storeId")));
            }
        }
        param.getParams().put("billState",new Parameter(QueryParam.IN,Arrays.asList(1,3)));

        IPage<BorrowContentVO> pageData = new Page<>();

        List<BorrowContentVO> voList = new ArrayList<>();
//
//        IPage<BorrowEntity> page = service.queryPage(param,false);
//        IPage<BorrowVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BorrowVO.class));

        IPage<BorrowEntity> borrowEntityIPage = service.queryPage(param, false);
        List<BorrowEntity> borrowList = borrowEntityIPage.getRecords();
        List<Long> ids = borrowList.stream().map(BorrowEntity::getId).collect(Collectors.toList());


        LambdaQueryWrapper<BorrowContentEntity> in = new LambdaQueryWrapper<BorrowContentEntity>().in(BorrowContentEntity::getBorrowId, ids);

        List<BorrowContentEntity> list = borrowContentService.list(in);

        List<BorrowContentVO> records = BeanMapper.mapList(list, BorrowContentVO.class);

        //查询已归还数量
        IPage<ReturnEntity> returnEntityIPage = returnService.queryPage(param, false);
        List<ReturnEntity> records1 = returnEntityIPage.getRecords();
        List<Long> collect = records1.stream().map(ReturnEntity::getId).collect(Collectors.toList());

        LambdaQueryWrapper<ReturnContentEntity> wrapper = new LambdaQueryWrapper<ReturnContentEntity>().in(ReturnContentEntity::getReturnId, collect);
        List<ReturnContentEntity> list1 = returnContentService.list(wrapper);
        Map<Long, Integer> map = list1.stream().collect(Collectors.toMap(ReturnContentEntity::getToolId, ReturnContentEntity::getReturnNum));


        if(CollectionUtils.isNotEmpty(records)){
            records.forEach(record -> {
                Integer returnNum = 0;
                if(record.getHaveBorrowNum() != null){
                    Long toolId = record.getToolId();
                    if(map.containsKey(toolId)){
                        returnNum = map.get(toolId);
                    }
                    record.setHaveBorrowNum(record.getHaveBorrowNum() - returnNum);
                    if(record.getHaveBorrowNum() - returnNum > 0){
                        voList.add(record);
                    }
                }
            });
        }
        pageData.setRecords(voList);


        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
