/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.rent.bean.FactoryContentEntity;
import com.ejianc.business.rent.bean.FactoryEntity;
import com.ejianc.business.rent.service.IFactoryService;
import com.ejianc.business.rent.service.impl.ConfirmationServiceImpl;
import com.ejianc.business.rent.service.impl.FactoryContentServiceImpl;
import com.ejianc.business.rent.vo.FactoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"factory"})
public class FactoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "FACTORY";
    private static final String BILL_CODE1 = "equipment";
    @Autowired
    private IFactoryService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ConfirmationServiceImpl confirmationService;
    @Autowired
    private FactoryContentServiceImpl factoryContentService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FactoryVO> saveOrUpdate(@RequestBody FactoryVO saveOrUpdateVO) {
        BillCodeParam billCodeParam1;
        CommonResponse billCode1;
        FactoryEntity entity = (FactoryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, FactoryEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (!(billCode1 = this.billCodeApi.generateBillCode(billCodeParam1 = BillCodeParam.build((String)BILL_CODE1, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        entity.setEquipmentCode((String)billCode1.getData());
        this.service.saveOrUpdate((Object)entity, false);
        FactoryVO vo = (FactoryVO)BeanMapper.map((Object)((Object)entity), FactoryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FactoryVO> queryDetail(Long id) {
        FactoryEntity entity = (FactoryEntity)((Object)this.service.selectById(id));
        FactoryVO vo = (FactoryVO)BeanMapper.map((Object)((Object)entity), FactoryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FactoryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FactoryVO factoryVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FactoryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("isContract");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        Object orgVOList = null;
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List factoryVOS = BeanMapper.mapList((Iterable)page.getRecords(), FactoryVO.class);
        List records = page.getRecords();
        List ids = records.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            pageData.setRecords(factoryVOS);
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(FactoryContentEntity::getFactoryId, ids);
        List factoryContentEntities = this.factoryContentService.list((Wrapper)lambdaQueryWrapper);
        Map collect = factoryContentEntities.stream().collect(Collectors.toMap(FactoryContentEntity::getFactoryId, Function.identity()));
        factoryVOS.forEach(vo -> {
            if (collect.containsKey(vo.getId())) {
                FactoryContentEntity factoryContentEntity1 = (FactoryContentEntity)((Object)((Object)collect.get(vo.getId())));
                vo.setSpecs(factoryContentEntity1.getSpecs());
                vo.setEquipmentName(factoryContentEntity1.getEquipmentName());
            }
        });
        pageData.setRecords(factoryVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("isContract");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.service.queryPage(param, false);
        HashMap<String, List> beans = new HashMap<String, List>();
        List records = pageData.getRecords();
        if (records != null && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), FactoryVO.class);
            if (list != null) {
                list.forEach(vo -> {
                    Integer billState = vo.getBillState();
                    String isContract = vo.getIsContract();
                    if (billState != null) {
                        BillStateEnum billStateEnum = BillStateEnum.getEnumByStateCode((Integer)billState);
                        if (billStateEnum != null) {
                            vo.setBillStateName(billStateEnum.getDescription());
                        }
                        if (isContract != null) {
                            vo.setIsContract(isContract);
                        }
                    }
                });
            }
            List ids = records.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(FactoryContentEntity::getFactoryId, ids);
            List factoryContentEntity = this.factoryContentService.list((Wrapper)lambdaQueryWrapper);
            Map collect = factoryContentEntity.stream().collect(Collectors.toMap(FactoryContentEntity::getFactoryId, Function.identity()));
            list.forEach(vo -> {
                if (collect.containsKey(vo.getId())) {
                    FactoryContentEntity factoryContentEntity1 = (FactoryContentEntity)((Object)((Object)collect.get(vo.getId())));
                    vo.setSpecs(factoryContentEntity1.getSpecs());
                    vo.setEquipmentName(factoryContentEntity1.getEquipmentName());
                }
            });
            beans.put("records", list);
            ExcelExport.getInstance().export("factory.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/refFactoryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FactoryVO>> refFactoryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get("projectId") != null) {
                param.getParams().put("projectId", new Parameter("eq", _con.get("projectId")));
                this.logger.info("\u6761\u4ef6\u8fc7\u6ee4project:{}", _con.get("projectId"));
            }
            if (_con.get("contractId") != null) {
                param.getParams().put("contractId", new Parameter("eq", _con.get("contractId")));
                this.logger.info("\u6761\u4ef6\u8fc7\u6ee4contractId:{}", _con.get("contractId"));
            }
            if (_con.get("supplierId") != null) {
                param.getParams().put("supplierId", new Parameter("eq", _con.get("supplierId")));
                this.logger.info("\u6761\u4ef6\u8fc7\u6ee4supplierId:{}", _con.get("supplierId"));
            }
            param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
            QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", _con.get("projectId"))).eq((Object)"supplier_id", _con.get("supplierId"));
            if (_con.get("contractId") != null) {
                queryWrapper.eq((Object)"contract_id", _con.get("contractId"));
            }
            List list = this.confirmationService.list((Wrapper)queryWrapper);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List factoryVOS = BeanMapper.mapList((Iterable)page.getRecords(), FactoryVO.class);
        List list = page.getRecords();
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            pageData.setRecords(factoryVOS);
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(FactoryContentEntity::getFactoryId, ids);
        List factoryContentEntities = this.factoryContentService.list((Wrapper)lambdaQueryWrapper);
        Map collect = factoryContentEntities.stream().collect(Collectors.toMap(FactoryContentEntity::getFactoryId, Function.identity()));
        factoryVOS.forEach(vo -> {
            if (collect.containsKey(vo.getId())) {
                FactoryContentEntity factoryContentEntity = (FactoryContentEntity)((Object)((Object)collect.get(vo.getId())));
                vo.setSpecs(factoryContentEntity.getSpecs());
                vo.setEquipmentName(factoryContentEntity.getEquipmentName());
                vo.setUnit(factoryContentEntity.getUnit());
            }
        });
        pageData.setRecords(factoryVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

