/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.rent.bean.RentContractChangeEntity;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.bean.RentContractFreezeEntity;
import com.ejianc.business.rent.bean.RentContractRecordEntity;
import com.ejianc.business.rent.bean.RentContractRelieveEntity;
import com.ejianc.business.rent.enums.ChangeStatusEnum;
import com.ejianc.business.rent.enums.DraftTypeEnum;
import com.ejianc.business.rent.enums.RentContractSyncTypeEnum;
import com.ejianc.business.rent.enums.SignatureStatusEnum;
import com.ejianc.business.rent.service.IRentContractChangeService;
import com.ejianc.business.rent.service.IRentContractFreezeService;
import com.ejianc.business.rent.service.IRentContractRecordService;
import com.ejianc.business.rent.service.IRentContractRelieveService;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.service.impl.RentContractChangeServiceImpl;
import com.ejianc.business.rent.service.impl.RentContractFreezeServiceImpl;
import com.ejianc.business.rent.service.impl.RentContractRelieveServiceImpl;
import com.ejianc.business.rent.service.impl.RentContractServiceImpl;
import com.ejianc.business.rent.vo.RentContractChangeVO;
import com.ejianc.business.rent.vo.RentContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.utils.RentEntityUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class RentContractApiController
implements Serializable {
    @Autowired
    private IRentContractService rentContractService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IRentContractService service;
    @Autowired
    private IRentContractChangeService changeService;
    @Autowired
    private RentContractChangeServiceImpl changeImpl;
    @Autowired
    private IRentContractRelieveService relieveService;
    @Autowired
    private IRentContractFreezeService freezeService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IRentContractRecordService recordService;
    @Autowired
    private RentContractServiceImpl contractService;

    private String getBaseHost() {
        return StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BaseHost;
    }

    @ApiOperation(value="\u6839\u636e\u5b9a\u6807\u53c2\u7167id\u67e5\u8be2\u5bf9\u5e94\u7684\u5408\u540c")
    @RequestMapping(value={"/api/rentContract/queryContractByTargetResultId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SignContractVo>> queryContractByTargetResultId(@RequestParam(value="targetResultIdList") List<String> targetResultIdList) {
        this.logger.info("\u6839\u636e\u5b9a\u6807\u7ed3\u679cid\u67e5\u8be2\u5408\u540c\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(targetResultIdList));
        List<SignContractVo> list = this.rentContractService.queryContractByTargetResultId(targetResultIdList);
        this.logger.info("\u6839\u636e\u5b9a\u6807\u7ed3\u679cid\u67e5\u8be2\u5408\u540c\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(list));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", list);
    }

    @PostMapping(value={"/api/rentContract/contractSync"})
    public CommonResponse<String> contractSync(@RequestBody JSONObject json, @RequestParam(value="type") String type) {
        String msg = "\u5355\u636e\u5df2\u7ecf\u8fdb\u884c\u8fc7\u540c\u6b65\u64cd\u4f5c\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01";
        switch (RentContractSyncTypeEnum.getEnumByName(type)) {
            case \u79df\u8d41\u5408\u540c: {
                RentContractEntity entity = (RentContractEntity)((Object)JSON.parseObject((String)json.toJSONString(), RentContractEntity.class));
                RentContractEntity data = (RentContractEntity)((Object)RentEntityUtil.selectOneService("id", entity.getId(), RentContractServiceImpl.class));
                if (null != data) {
                    this.service.delById(data.getId());
                }
                entity.setAddType(1);
                entity.setSignatureState(String.valueOf(Integer.valueOf(entity.getSignatureState())));
                this.service.pushContract((RentContractVO)BeanMapper.map((Object)((Object)entity), RentContractVO.class));
                String linkUrl = this.getBaseHost() + "ejc-proequipment-frontend/#/leaseContract/card?id=" + entity.getId();
                CommonResponse response = this.executionApi.aggPush(this.service.targetCost((RentContractVO)BeanMapper.map((Object)((Object)entity), RentContractVO.class), linkUrl));
                if (!response.isSuccess()) {
                    this.logger.error("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5931\u8d25: , {}", (Object)response.getMsg());
                    throw new BusinessException(response.getMsg());
                }
                this.service.saveOrUpdate((Object)entity, false);
                break;
            }
            case \u79df\u8d41\u5408\u540c\u53d8\u66f4: {
                RentContractChangeEntity changeEntity = (RentContractChangeEntity)((Object)JSON.parseObject((String)json.toJSONString(), RentContractChangeEntity.class));
                RentContractChangeEntity changeData = (RentContractChangeEntity)((Object)RentEntityUtil.selectOneService("id", changeEntity.getId(), RentContractChangeServiceImpl.class));
                if (null != changeData) {
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(RentContractRecordEntity::getChangeId, (Object)changeEntity.getId());
                    List list = this.recordService.list((Wrapper)wrapper);
                    this.service.delChangeById(changeEntity.getId());
                    if (ListUtil.isNotEmpty((List)list)) {
                        // empty if block
                    }
                }
                this.saveChange(changeEntity);
                break;
            }
            case \u79df\u8d41\u5408\u540c\u89e3\u9664: {
                RentContractRelieveEntity relieveEntity = (RentContractRelieveEntity)((Object)JSON.parseObject((String)json.toJSONString(), RentContractRelieveEntity.class));
                RentContractRelieveEntity relieveData = (RentContractRelieveEntity)((Object)RentEntityUtil.selectOneService("id", relieveEntity.getId(), RentContractRelieveServiceImpl.class));
                if (null != relieveData) {
                    return CommonResponse.error((String)msg);
                }
                if (relieveEntity.getDraftType() == 2) {
                    QueryParam param = new QueryParam();
                    param.getParams().put("id", new Parameter("eq", (Object)relieveEntity.getContractId()));
                    List contractEntities = this.service.queryList(param, false);
                    if (ListUtil.isNotEmpty((List)contractEntities)) {
                        RentContractEntity contractEntity = (RentContractEntity)((Object)contractEntities.get(0));
                        contractEntity.setContractPerformanceState(ContractPerformanceStateEnum.\u5df2\u4f5c\u5e9f.getStateCode());
                        this.logger.info("======\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03,\u5df2\u7b7e\u7ae0======,{}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
                        this.service.saveOrUpdate((Object)contractEntity, false);
                        CommonResponse response1 = this.executionApi.aggPush(this.relieveService.targetCost(relieveEntity));
                        this.logger.info("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)this.relieveService.targetCost(relieveEntity)));
                        if (!response1.isSuccess()) {
                            this.logger.error("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5931\u8d25: , {}", (Object)response1.getMsg());
                            throw new BusinessException(response1.getMsg());
                        }
                        ContractPoolVO contractPoolVO = new ContractPoolVO();
                        contractPoolVO.setPerformanceStatus(ContractPerformanceStateEnum.\u5df2\u4f5c\u5e9f.getStateCode());
                        contractPoolVO.setSourceId(relieveEntity.getContractId());
                        this.contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
                        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                        wrapper.eq(BaseEntity::getId, (Object)relieveEntity.getContractId());
                        wrapper.set(RentContractEntity::getContractPerformanceState, (Object)ContractPerformanceStateEnum.\u5df2\u4f5c\u5e9f.getStateCode());
                        this.service.update((Wrapper)wrapper);
                    }
                }
                this.relieveService.saveOrUpdate((Object)relieveEntity, false);
                break;
            }
            case \u79df\u8d41\u5408\u540c\u51bb\u7ed3: {
                RentContractFreezeEntity freezeEntity = (RentContractFreezeEntity)((Object)JSON.parseObject((String)json.toJSONString(), RentContractFreezeEntity.class));
                RentContractFreezeEntity freezeData = (RentContractFreezeEntity)((Object)RentEntityUtil.selectOneService("id", freezeEntity.getId(), RentContractFreezeServiceImpl.class));
                if (null != freezeData) {
                    return CommonResponse.error((String)msg);
                }
                this.freezeService.saveOrUpdate((Object)freezeEntity, false);
                ContractPoolVO contractPoolVO = new ContractPoolVO();
                RentContractEntity contractEntity = (RentContractEntity)((Object)this.service.getById(freezeEntity.getContractId()));
                if (contractEntity.getContractPerformanceState().equals(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode())) {
                    contractEntity.setContractPerformanceState(ContractPerformanceStateEnum.\u5df2\u51bb\u7ed3.getStateCode());
                    contractPoolVO.setPerformanceStatus(ContractPerformanceStateEnum.\u5df2\u51bb\u7ed3.getStateCode());
                } else if (contractEntity.getContractPerformanceState().equals(ContractPerformanceStateEnum.\u5df2\u51bb\u7ed3.getStateCode())) {
                    contractEntity.setContractPerformanceState(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
                    contractPoolVO.setPerformanceStatus(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
                }
                contractPoolVO.setSourceId(freezeEntity.getContractId());
                this.contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
                this.service.saveOrUpdate((Object)contractEntity, false);
                break;
            }
            default: {
                RentContractChangeEntity cEntity = (RentContractChangeEntity)((Object)JSON.parseObject((String)json.toJSONString(), RentContractChangeEntity.class));
                cEntity.setSignatureState(String.valueOf(Integer.valueOf(cEntity.getSignatureState())));
                if (cEntity.getSignatureState().equals(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())) {
                    this.changeService.effectiveSaveWriteContract(cEntity.getId(), cEntity.getCode(), false);
                    break;
                }
                this.changeService.saveOrUpdate((Object)cEntity);
                this.logger.info("\u53d8\u66f4\u5408\u540c\u7b7e\u7ae0\u72b6\u6001\u5df2\u4fee\u6539---------------->");
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)cEntity.getContractId());
                updateWrapper.set(RentContractEntity::getChangeContractSignatureStatus, (Object)cEntity.getSignatureState());
                this.service.update(this.service.selectById(cEntity.getContractId()), (Wrapper)updateWrapper, false);
                this.logger.info("\u7b7e\u7ae0\u72b6\u6001\u4e3a\u5df2\u7b7e\u7ae0\uff0c\u56de\u5199\u4e3b\u5408\u540c\u7b7e\u7ae0\u72b6\u6001---------------->");
            }
        }
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f\uff01");
    }

    @PostMapping(value={"/api/rentContract/delContract"})
    public CommonResponse<String> delContract(@RequestParam(value="id") Long id, @RequestParam(value="type") String type) {
        String msg = "\u64cd\u4f5c\u5931\u8d25,\u672a\u67e5\u5230\u5355\u636e!";
        switch (RentContractSyncTypeEnum.getEnumByName(type)) {
            case \u79df\u8d41\u5408\u540c: {
                RentContractEntity data = (RentContractEntity)((Object)RentEntityUtil.selectOneService("id", id, RentContractServiceImpl.class));
                if (data == null) {
                    return CommonResponse.error((String)msg);
                }
                boolean delResult = this.service.delContractFromPool(data.getId());
                if (!delResult) {
                    return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u4ece\u5408\u540c\u6c60\u5220\u9664\u5931\u8d25\uff01");
                }
                ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
                String linkUrl = this.getBaseHost() + "ejc-proequipment-frontend/#/leaseContract/card?id=" + data.getId();
                ExecutionVO executionVO = this.contractService.targetCost((RentContractVO)BeanMapper.map((Object)((Object)data), RentContractVO.class), linkUrl);
                totalExecutionVOList.add(executionVO.getTotalVO());
                CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u5220\u9664\u5931\u8d25\uff01");
                }
                this.service.delById(id);
                break;
            }
            case \u79df\u8d41\u5408\u540c\u53d8\u66f4: {
                RentContractChangeEntity changeData = (RentContractChangeEntity)((Object)RentEntityUtil.selectOneService("id", id, RentContractChangeServiceImpl.class));
                if (changeData == null) {
                    return CommonResponse.error((String)msg);
                }
                QueryWrapper wrapper = new QueryWrapper();
                ((QueryWrapper)wrapper.eq((Object)"contract_id", (Object)changeData.getContractId())).orderByDesc((Object)"create_time");
                List list = this.changeService.list((Wrapper)wrapper);
                RentContractEntity rentContractEntity = (RentContractEntity)((Object)this.contractService.selectById(changeData.getContractId()));
                Long lastSourceId = null;
                lastSourceId = list.size() > 0 ? ((RentContractChangeEntity)((Object)list.get(0))).getId() : rentContractEntity.getId();
                this.changeImpl.deleteTargetCost(this.changeImpl.targetCost((RentContractChangeVO)BeanMapper.map((Object)((Object)changeData), RentContractChangeVO.class), lastSourceId));
                RentContractChangeEntity oldEntity = this.changeImpl.queryChangeList(changeData);
                ExecutionVO executionVO1 = null;
                if (oldEntity == null) {
                    RentContractEntity contractEntity = (RentContractEntity)((Object)this.service.selectById(changeData.getContractId()));
                    String linkUrlnew = this.getBaseHost() + "ejc-proequipment-frontend/#/leaseContract/card?id=" + contractEntity.getId();
                    executionVO1 = this.service.targetCost((RentContractVO)BeanMapper.map((Object)((Object)contractEntity), RentContractVO.class), linkUrlnew);
                } else {
                    executionVO1 = this.changeImpl.targetCost((RentContractChangeVO)BeanMapper.map((Object)((Object)oldEntity), RentContractChangeVO.class), lastSourceId);
                }
                CommonResponse response2 = this.executionApi.aggPush(executionVO1);
                if (!response2.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25\uff01");
                }
                LambdaUpdateWrapper lambdaUpdate = new LambdaUpdateWrapper();
                if (changeData.getChangeVersion() == 1) {
                    lambdaUpdate.set(RentContractEntity::getChangeStatus, (Object)1);
                } else {
                    lambdaUpdate.set(RentContractEntity::getChangeStatus, (Object)3);
                }
                lambdaUpdate.eq(BaseEntity::getId, (Object)changeData.getContractId());
                this.service.update((Wrapper)lambdaUpdate);
                this.service.delChangeById(id);
                break;
            }
            default: {
                RentContractRelieveEntity relieveData = (RentContractRelieveEntity)((Object)RentEntityUtil.selectOneService("id", id, RentContractRelieveServiceImpl.class));
                if (relieveData == null) {
                    return CommonResponse.error((String)msg);
                }
                ContractPoolVO contractPoolVO = new ContractPoolVO();
                contractPoolVO.setPerformanceStatus(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
                contractPoolVO.setSourceId(relieveData.getContractId());
                this.contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
                LambdaUpdateWrapper wrapperNew = new LambdaUpdateWrapper();
                wrapperNew.eq(BaseEntity::getId, (Object)relieveData.getContractId());
                wrapperNew.set(RentContractEntity::getContractPerformanceState, (Object)ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
                this.service.update((Wrapper)wrapperNew);
                this.relieveService.delById(id);
            }
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private String saveChange(RentContractChangeEntity entity) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"contract_id", (Object)entity.getContractId())).orderByDesc((Object)"create_time");
        List list = this.changeService.list((Wrapper)wrapper);
        RentContractEntity rentContractEntity = (RentContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        Long lastSourceId = null;
        lastSourceId = list.size() > 0 ? ((RentContractChangeEntity)((Object)list.get(0))).getId() : rentContractEntity.getId();
        RentContractEntity contractEntity = (RentContractEntity)((Object)this.service.selectById(entity.getMainContractId()));
        RentContractChangeEntity oldEntity = this.changeImpl.queryChangeList(entity);
        ExecutionVO executionVO = null;
        String linkUrl = this.getBaseHost() + "ejc-proequipment-frontend/#/leaseContract/card?id=" + contractEntity.getId();
        executionVO = oldEntity == null ? this.service.targetCost((RentContractVO)BeanMapper.map((Object)((Object)contractEntity), RentContractVO.class), linkUrl) : this.changeImpl.targetCost((RentContractChangeVO)BeanMapper.map((Object)((Object)oldEntity), RentContractChangeVO.class), lastSourceId);
        this.changeImpl.deleteTargetCost(executionVO);
        entity.setSignatureState(String.valueOf(Integer.valueOf(entity.getSignatureState()) - 1));
        CommonResponse response = this.executionApi.aggPush(this.changeImpl.targetCost((RentContractChangeVO)BeanMapper.map((Object)((Object)entity), RentContractChangeVO.class), lastSourceId));
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25\uff01");
        }
        if (!BillStateEnum.COMMITED_STATE.getBillStateCode().equals(entity.getBillState()) && !BillStateEnum.PASSED_STATE.getBillStateCode().equals(entity.getBillState())) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(RentContractEntity::getChangeId, (Object)entity.getId());
            updateWrapper.set(RentContractEntity::getChangingMny, (Object)entity.getContractMny());
            updateWrapper.set(RentContractEntity::getChangingTaxMny, (Object)entity.getContractTaxMny());
            updateWrapper.set(RentContractEntity::getChangeCode, (Object)entity.getCode());
            updateWrapper.set(RentContractEntity::getChangeVersion, (Object)entity.getChangeVersion());
            updateWrapper.set(RentContractEntity::getChangeDate, (Object)entity.getChangeDate());
            updateWrapper.set(RentContractEntity::getChangeDraftType, (Object)entity.getChangeDraftType());
            updateWrapper.set(RentContractEntity::getChangeContractSignatureStatus, (Object)entity.getSignatureState());
            updateWrapper.set(RentContractEntity::getChangeFileId, (Object)entity.getChangeFileId());
            updateWrapper.set(RentContractEntity::getChangeContractName, (Object)entity.getContractName());
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getMainContractId());
            updateWrapper.set(RentContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
            this.service.update((Wrapper)updateWrapper);
        } else if (!DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().equals(entity.getChangeDraftType())) {
            entity.setCommitDate(new Date());
            this.changeService.saveOrUpdate((Object)entity, false);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(RentContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u5355\u636e\u5ba1\u6279\u901a\u8fc7.getCode());
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getContractId());
            this.service.update((Wrapper)updateWrapper);
        }
        this.changeService.saveOrUpdate((Object)entity, false);
        return "\u4fdd\u5b58\u6210\u529f!";
    }
}

