/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.ac.enums.PerformanceStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.bean.RentMachineSettlementEntity;
import com.ejianc.business.rent.mapper.RentMachineSettlementMapper;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.service.IRentMachineSettlementService;
import com.ejianc.business.rent.vo.RentMachineSettlementVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="rentMachineSettlementService")
public class RentMachineSettlementServiceImpl
extends BaseServiceImpl<RentMachineSettlementMapper, RentMachineSettlementEntity>
implements IRentMachineSettlementService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentMachineSettlementService rentMachineSettlementService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IRentContractService contractService;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        spv.setSourceId(id);
        CommonResponse res = this.settlePoolApi.deleteSettle(spv);
        if (res.isSuccess()) {
            this.logger.info("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)id);
            return true;
        }
        this.logger.error("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
        throw new BusinessException("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u5931\u8d25:" + res.getMsg());
    }

    @Override
    public void updateContractPoolSettle(RentMachineSettlementVO vo, boolean type) {
        if (null != vo.getContractId()) {
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + (type ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0csettleEntity={}, \u8fc7\u7a0b\uff080\uff09/\u6700\u7ec8\uff081\uff09={}, type={}", new Object[]{vo, vo.getSettleType(), type});
            BigDecimal totalSettleTaxMny = BigDecimal.ZERO;
            BigDecimal totalSettleMny = BigDecimal.ZERO;
            BigDecimal totalSettleTax = BigDecimal.ZERO;
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setSourceId(vo.getContractId());
            contractPoolVO.setTotalSettleTaxMny(totalSettleTaxMny);
            contractPoolVO.setTotalSettleMny(totalSettleMny);
            contractPoolVO.setTotalSettleTax(totalSettleTax);
            if (1 == vo.getSettleType()) {
                if (type) {
                    contractPoolVO.setFinishSettleDate(new Date());
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode());
                } else {
                    contractPoolVO.setFinishSettleDate(null);
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                }
            }
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u7ed3\u675f\uff0c\u66f4\u65b0\u5408\u540c\u6c60\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)contractPoolVO));
            CommonResponse updateConPoolRes = this.contractPoolApi.saveOrUpdateContract(contractPoolVO);
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u7ed3\u675f\uff0c\u66f4\u65b0\u5408\u540c\u6c60\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)updateConPoolRes));
        }
    }

    @Override
    public ExecutionVO targetCost(RentMachineSettlementVO settleVO, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList detailList = new ArrayList();
        totalVO.setSourceId(settleVO.getId());
        totalVO.setTenantId(settleVO.getTenantId());
        totalVO.setBillCode(settleVO.getBillCode());
        totalVO.setOrgId(settleVO.getOrgId());
        totalVO.setBillType("EJCBT202204000007");
        totalVO.setBussinessType(BussinessTypeEnum.\u5927\u578b\u8bbe\u5907\u5b89\u62c6\u5408\u540c.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        if (settleVO.getProjectId() == null) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setProjectId(settleVO.getProjectId());
        if (settleVO.getOrgId() == null) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setOrgId(settleVO.getOrgId());
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(RentMachineSettlementEntity::getContractId, (Object)settleVO.getContractId());
        query.in(RentMachineSettlementEntity::getBillState, new Object[]{1, 3});
        query.eq(BaseEntity::getDr, (Object)0);
        List entity = this.rentMachineSettlementService.list((Wrapper)query);
        BigDecimal sumMny = BigDecimal.ZERO;
        BigDecimal sumTaxMny = BigDecimal.ZERO;
        RentContractEntity contractEntity = (RentContractEntity)((Object)this.contractService.selectById(settleVO.getContractId()));
        for (RentMachineSettlementEntity settleEntity : entity) {
            sumMny = ComputeUtil.safeAdd((BigDecimal)sumMny, (BigDecimal)settleEntity.getSettlementNoTaxAmount());
            sumTaxMny = ComputeUtil.safeAdd((BigDecimal)sumTaxMny, (BigDecimal)settleEntity.getSettlementAmount());
        }
        totalVO.setMoney(ComputeUtil.safeSub((BigDecimal)sumMny, (BigDecimal)contractEntity.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)sumTaxMny, (BigDecimal)contractEntity.getContractTaxMny()));
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public boolean pushSettleToPool(RentMachineSettlementVO settleVO) {
        SettlePoolVO poolVO = new SettlePoolVO();
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb");
            BeanConvertorUtil.convert((Object)settleVO, (Object)poolVO);
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
            this.convertSettleVOToSettlePoolVO(settleVO, poolVO);
            poolVO.setBillCodeUrl("/ejc-proequipment-frontend/#/rentMachineSettlement/card?id=" + settleVO.getId());
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(poolVO);
            if (res.isSuccess()) {
                this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)settleVO.getId());
                return true;
            }
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)settleVO.getId(), (Object)res.getMsg());
            throw new BusinessException("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25:" + res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97-{}\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff0c", (Object)settleVO.getId(), (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25!");
        }
    }

    private void convertSettleVOToSettlePoolVO(RentMachineSettlementVO settleVO, SettlePoolVO poolVO) {
        if (null == settleVO || null == poolVO) {
            this.logger.error("\u5c06\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u539f\u56e0\uff1a\u7ed3\u7b97\u5355\u5bf9\u8c61\u4e3a\u7a7a\u6216\u7ed3\u7b97\u6c60\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u65e0\u6cd5\u8f6c\u6362\uff01");
            return;
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5f00\u59cb");
        poolVO.setSourceType(settleVO.getSettleType() == 0 ? SettleSourceTypeEnum.\u5b89\u62c6\u5408\u540c\u8fc7\u7a0b\u7ed3\u7b97.getCode() : SettleSourceTypeEnum.\u5b89\u62c6\u5408\u540c\u6700\u7ec8\u7ed3\u7b97.getCode());
        poolVO.setSettleProperty(Integer.valueOf(0));
        poolVO.setHandleType(Integer.valueOf(0));
        poolVO.setContractType(ContractTypeEnum.\u5b89\u62c6\u5408\u540c.getTypeCode());
        poolVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)poolVO.getBillState()).getDescription());
        RentContractEntity ce = (RentContractEntity)((Object)this.contractService.selectById(settleVO.getContractId()));
        this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u8fc7\u7a0b\u4e2d\uff0c\u6839\u636e\u5408\u540cid\u67e5\u8be2\u5408\u540c\uff0c\u5408\u540cid-{}", (Object)settleVO.getContractId());
        if (ce == null) {
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u8fc7\u7a0b\u4e2d\uff0c\u6839\u636e\u5408\u540cid\u67e5\u8be2\u5408\u540c\uff0c\u5408\u540cid-{}\uff0c\u672a\u67e5\u8be2\u5230\u5408\u540c\u4fe1\u606f\uff0c\u6545\u7ed3\u7b97\u5355\u7684 \u4e3b\u5408\u540c/\u7532\u65b9/\u4e59\u65b9/\u7b7e\u8ba2\u65e5\u671f/\u521b\u5efa\u65f6\u95f4\u548c\u4eba\u5458/\u66f4\u65b0\u65f6\u95f4\u548c\u4eba\u5458 \u7b49\u4fe1\u606f\u65e0\u6cd5\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60", (Object)settleVO.getContractId());
            return;
        }
        poolVO.setContractFlag(Integer.valueOf(1));
        poolVO.setMaiContractId(ce.getMainContractId());
        poolVO.setMaiContractName(ce.getMainContractName());
        poolVO.setMaiContractCode(ce.getMainContractCode());
        poolVO.setContractTypeName(ContractTypeEnum.\u5b89\u62c6\u5408\u540c.getTypeName());
        poolVO.setSupplementFlag(ce.getSupplementFlag());
        poolVO.setMemo(ce.getMemo());
        poolVO.setPartyaId(ce.getPartyId());
        poolVO.setPartyaName(ce.getPartyName());
        poolVO.setSignDate(ce.getSignedDate());
        poolVO.setCreateTime(settleVO.getCreateTime());
        poolVO.setCreateUserCode(settleVO.getCreateUserCode());
        poolVO.setUpdateTime(settleVO.getUpdateTime());
        poolVO.setUpdateUserCode(settleVO.getUpdateUserCode());
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210\uff0c\u4e0b\u9762\u5f00\u59cb\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60");
    }

    @Override
    public void costPush(RentMachineSettlementEntity settleEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
    }
}

