/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tool.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.tool.bean.ScrapEntity;
import com.ejianc.business.tool.service.impl.ScrapBpmServiceImpl;
import com.ejianc.business.tool.service.impl.ScrapServiceImpl;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="scrapContent")
public class ScrapContentBpmServiceImpl
implements ICommonBusinessService {
    private final ScrapServiceImpl scrapService;
    private final IStoreManageApi iStoreManageApi;
    private final IBillTypeApi iBillTypeApi;
    private final ScrapBpmServiceImpl scrap;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public ScrapContentBpmServiceImpl(ScrapServiceImpl scrapService, @Qualifier(value="com.ejianc.business.store.api.IStoreManageApi") IStoreManageApi iStoreManageApi, @Qualifier(value="com.ejianc.foundation.support.api.IBillTypeApi") IBillTypeApi iBillTypeApi, ScrapBpmServiceImpl scrap) {
        this.scrapService = scrapService;
        this.iStoreManageApi = iStoreManageApi;
        this.iBillTypeApi = iBillTypeApi;
        this.scrap = scrap;
    }

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ScrapEntity scrapEntity = (ScrapEntity)((Object)this.scrapService.selectById(billId));
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setStoreId(scrapEntity.getStoreId());
        storeManageVO.setSourceId(scrapEntity.getId());
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u9886\u6599\u51fa\u5e93);
        storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
        ArrayList flowVOS = new ArrayList();
        scrapEntity.getDetailList().forEach(t -> {
            FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u9886\u6599\u51fa\u5e93, (Integer)0);
            flowVO.setStoreId(scrapEntity.getStoreId());
            flowVO.setStoreName(scrapEntity.getStoreName());
            flowVO.setProjectId(scrapEntity.getProjectId());
            flowVO.setProjectName(scrapEntity.getProjectName());
            flowVO.setOrgId(scrapEntity.getOrgId());
            flowVO.setOrgName(scrapEntity.getOrgName());
            flowVO.setParentOrgId(scrapEntity.getParentOrgId());
            flowVO.setParentOrgName(scrapEntity.getParentOrgName());
            flowVO.setEmployeeId(scrapEntity.getEmployeeId());
            flowVO.setEmployeeName(scrapEntity.getEmployeeName());
            flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
            flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
            flowVO.setMaterialId(t.getToolId());
            flowVO.setMaterialName(t.getToolName());
            flowVO.setMaterialSpec(t.getSpecs());
            flowVO.setMaterialUnitId(t.getUnitId());
            flowVO.setMaterialUnitName(t.getUnit());
            flowVO.setNum(t.getNum());
            flowVO.setSourceBillDetailRemark(t.getMemo());
            flowVO.setSourceId(scrapEntity.getId());
            flowVO.setSourceDetailId(t.getId());
            flowVO.setSourceBillCode(scrapEntity.getBillCode());
            flowVO.setSourceBillDate(scrapEntity.getScrapDate());
            flowVO.setSourceBillTypeCode("BT220215000000004");
            flowVO.setSourceBillTypeName("\u9886\u6599\u51fa\u5e93");
            flowVO.setSourceType(Integer.valueOf(1));
            flowVO.setRowState(t.getRowState());
            flowVO.setSourceBillRemark(scrapEntity.getMemo());
            flowVOS.add(flowVO);
        });
        this.logger.info("\u8c03\u7528\u5e93\u5b58---");
        storeManageVO.setFlowVOList(flowVOS);
        CommonResponse response = this.iStoreManageApi.inOutStore(storeManageVO);
        this.logger.info("\u5e93\u5b58\u7ed3\u679c" + JSONObject.toJSONString((Object)response));
        if (!response.isSuccess()) {
            return CommonResponse.error((String)("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg()));
        }
        this.scrapService.updateById((Object)scrapEntity);
        return CommonResponse.success((String)"");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ScrapEntity scrapEntity = (ScrapEntity)((Object)this.scrapService.selectById(billId));
        if (scrapEntity.getBillState() == 1) {
            throw new BusinessException("\u5df2\u7b7e\u5b57\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        CommonResponse res = this.iBillTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

