package com.ejianc.business.pricelib.mapper;

import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.bean.RentDayDetailedEntity;
import com.ejianc.business.rent.bean.RentMonthDetailedEntity;
import com.ejianc.business.rent.bean.RentQuantitiesDetailedEntity;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.pricelib.bean.RentPriceContractEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * 设备租赁价格库-清单明细实体
 * 
 * @author generator
 * 
 */
@Mapper
public interface RentPriceContractMapper extends BaseCrudMapper<RentPriceContractEntity> {

    @Select("select * from ejc_proequipment_rent_contract where dr = 0 and create_time >= #{time} or update_time >= #{time}")
    List<RentContractEntity> getContractListByTime(Date time);


    //需从三个子表中获取数据
    //日租
    @Select({
            "<script>",
            "select * from ejc_proequipment_rent_day_detailed where dr = 0 and pid in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<RentDayDetailedEntity> getDayDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);

    //月租
    @Select({
            "<script>",
            "select * from ejc_proequipment_rent_month_detailed where dr = 0 and pid in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<RentMonthDetailedEntity> getMonthDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);

    //工程量租
    @Select({
            "<script>",
            "select * from ejc_proequipment_rent_quantities_detailed where dr = 0 and pid in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<RentQuantitiesDetailedEntity> getQuantitiesDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);
}
