package com.ejianc.business.rent.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.rent.bean.ApplyContentEntity;
import com.ejianc.business.rent.bean.EquipmentAdviceEntity;
import com.ejianc.business.rent.service.IApplyContentService;
import com.ejianc.business.rent.service.impl.ApplyContentServiceImpl;
import com.ejianc.business.rent.vo.ApplyContentVO;
import com.ejianc.business.rent.vo.EquipmentAdviceVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.rent.bean.ApplyEntity;
import com.ejianc.business.rent.service.IApplyService;
import com.ejianc.business.rent.vo.ApplyVO;

/**
 * 机械台班使用申请
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("apply")
public class ApplyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "APPLY";//此处需要根据实际修改

    @Autowired
    private IApplyService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ApplyContentServiceImpl applyContentService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ApplyVO> saveOrUpdate(@RequestBody ApplyVO saveOrUpdateVO) {
    	ApplyEntity entity = BeanMapper.map(saveOrUpdateVO, ApplyEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ApplyVO vo = BeanMapper.map(entity, ApplyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ApplyVO> queryDetail(Long id) {
    	ApplyEntity entity = service.selectById(id);
    	ApplyVO vo = BeanMapper.map(entity, ApplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApplyVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ApplyVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ApplyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ApplyEntity> page = service.queryPage(param,false);
        IPage<ApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<ApplyEntity> pageData = service.queryPage(param, false);
        Map<String, Object> beans = new HashMap<String, Object>();
        if (pageData.getRecords() != null && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<ApplyVO> list = BeanMapper.mapList(pageData.getRecords(), ApplyVO.class);
            if (list != null) {
                list.forEach(vo -> {
                    Integer billState = vo.getBillState();
                    if (billState != null) {
                        BillStateEnum billStateEnum = BillStateEnum.getEnumByStateCode(billState);
                        if (billStateEnum != null) {
                            vo.setBillStateName(billStateEnum.getDescription());
                        }
                    }
                });
            }

            beans.put("records", list);
            ExcelExport.getInstance().export("apply.xlsx", beans, response);
        }
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refApplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ApplyContentVO>> refApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            Map<String, Object> _con = JSONObject.parseObject(condition);
            //根据项目过滤
            if (_con.get("projectId") != null) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
                logger.info("条件过滤project:{}", _con.get("projectId"));
            }
        }
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));

        IPage<ApplyEntity> page = service.queryPage(param,false);
        List<ApplyEntity> records = page.getRecords();
        List<Long> ids = records.stream().map(ApplyEntity::getId).collect(Collectors.toList());

        IPage<ApplyContentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        if (CollectionUtils.isNotEmpty(ids)) {
            LambdaQueryWrapper<ApplyContentEntity> lambdaQueryWrapper = new LambdaQueryWrapper<ApplyContentEntity>()
                    .in(ApplyContentEntity::getApplyId, ids);

            List<ApplyContentEntity> list = applyContentService.list(lambdaQueryWrapper);
            pageData.setRecords(BeanMapper.mapList(list, ApplyContentVO.class));
        }
        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
