package com.ejianc.business.rent.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.rent.bean.ConfirmationContentEntity;
import com.ejianc.business.rent.bean.ConfirmationEntity;
import com.ejianc.business.rent.bean.FactoryContentEntity;
import com.ejianc.business.rent.service.impl.ConfirmationServiceImpl;
import com.ejianc.business.rent.service.impl.FactoryContentServiceImpl;
import com.ejianc.business.rent.vo.ConfirmationVO;
import com.ejianc.business.rent.vo.FactoryContentVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.rent.bean.FactoryEntity;
import com.ejianc.business.rent.service.IFactoryService;
import com.ejianc.business.rent.vo.FactoryVO;

import static org.codehaus.groovy.runtime.DefaultGroovyMethods.collect;

/**
 * 施工机械进场登记
 *
 * @author generator
 */
@Controller
@RequestMapping("factory")
public class FactoryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "FACTORY";//此处需要根据实际修改
    private static final String BILL_CODE1 = "equipment";//此处需要根据实际修改

    @Autowired
    private IFactoryService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ConfirmationServiceImpl confirmationService;
    @Autowired
    private FactoryContentServiceImpl factoryContentService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FactoryVO> saveOrUpdate(@RequestBody FactoryVO saveOrUpdateVO) {
        FactoryEntity entity = BeanMapper.map(saveOrUpdateVO, FactoryEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

        }
        BillCodeParam billCodeParam1 = BillCodeParam.build(BILL_CODE1, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
        CommonResponse<String> billCode1 = billCodeApi.generateBillCode(billCodeParam1);
        if (billCode1.isSuccess()) {
            entity.setEquipmentCode(billCode1.getData());//此处需要根据实际修改 删除本行或者上一行
        } else {
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }

        service.saveOrUpdate(entity, false);

        FactoryVO vo = BeanMapper.map(entity, FactoryVO.class);

        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FactoryVO> queryDetail(Long id) {
        FactoryEntity entity = service.selectById(id);
        FactoryVO vo = BeanMapper.map(entity, FactoryVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FactoryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FactoryVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(FactoryVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FactoryVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("isContract");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<FactoryEntity> page = service.queryPage(param, false);

        IPage<FactoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        List<FactoryVO> factoryVOS = BeanMapper.mapList(page.getRecords(), FactoryVO.class);

        List<FactoryEntity> records = page.getRecords();

        List<Long> ids = records.stream().map(FactoryEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            pageData.setRecords(factoryVOS);
            return CommonResponse.success("查询参照数据成功！", pageData);
        }
        LambdaQueryWrapper<FactoryContentEntity> lambdaQueryWrapper = new LambdaQueryWrapper<FactoryContentEntity>().in(FactoryContentEntity::getFactoryId, ids);
        List<FactoryContentEntity> factoryContentEntities = factoryContentService.list(lambdaQueryWrapper);
        Map<Long, FactoryContentEntity> collect = factoryContentEntities.stream().collect(Collectors.toMap(FactoryContentEntity::getFactoryId, Function.identity()));

        factoryVOS.forEach(vo -> {
            if(collect.containsKey(vo.getId())){
                FactoryContentEntity factoryContentEntity1 = collect.get(vo.getId());
                vo.setSpecs(factoryContentEntity1.getSpecs());
                vo.setEquipmentName(factoryContentEntity1.getEquipmentName());
            }
        });
        pageData.setRecords(factoryVOS);

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("isContract");
        fuzzyFields.add("supplierName");

        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<FactoryEntity> pageData = service.queryPage(param, false);
        Map<String, Object> beans = new HashMap<String, Object>();
        List<FactoryEntity> records = pageData.getRecords();
        if (records != null && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<FactoryVO> list = BeanMapper.mapList(pageData.getRecords(), FactoryVO.class);
            if (list != null) {
                list.forEach(vo -> {
                    Integer billState = vo.getBillState();
                    String isContract = vo.getIsContract();
                    if (billState != null) {
                        BillStateEnum billStateEnum = BillStateEnum.getEnumByStateCode(billState);
                        if (billStateEnum != null) {
                            vo.setBillStateName(billStateEnum.getDescription());
                        }
                        if (isContract != null) {
                            vo.setIsContract(isContract);
                        }
                    }
                });
            }
            List<Long> ids = records.stream().map(FactoryEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<FactoryContentEntity> lambdaQueryWrapper = new LambdaQueryWrapper<FactoryContentEntity>().in(FactoryContentEntity::getFactoryId, ids);
            List<FactoryContentEntity> factoryContentEntity = factoryContentService.list(lambdaQueryWrapper);
            Map<Long, FactoryContentEntity> collect = factoryContentEntity.stream().collect(Collectors.toMap(FactoryContentEntity::getFactoryId, Function.identity()));
            list.forEach(vo -> {
                if (collect.containsKey(vo.getId())) {
                    FactoryContentEntity factoryContentEntity1 = collect.get(vo.getId());
                    vo.setSpecs(factoryContentEntity1.getSpecs());
                    vo.setEquipmentName(factoryContentEntity1.getEquipmentName());
                }
            });

            beans.put("records", list);
            ExcelExport.getInstance().export("factory.xlsx", beans, response);
        }
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refFactoryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FactoryVO>> refFactoryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                           String condition,
                                                           String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            Map<String, Object> _con = JSONObject.parseObject(condition);
            //根据项目过滤
            if (_con.get("projectId") != null) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
                logger.info("条件过滤project:{}", _con.get("projectId"));
            }
            if (_con.get("contractId") != null) {
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, _con.get("contractId")));
                logger.info("条件过滤contractId:{}", _con.get("contractId"));
            }
            if (_con.get("supplierId") != null) {
                param.getParams().put("supplierId", new Parameter(QueryParam.EQ, _con.get("supplierId")));
                logger.info("条件过滤supplierId:{}", _con.get("supplierId"));
            }
            param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
            QueryWrapper<ConfirmationEntity> queryWrapper = new QueryWrapper<ConfirmationEntity>().eq("project_id", _con.get("projectId"))
                    .eq("supplier_id", _con.get("supplierId"));
            if (_con.get("contractId") != null) {
                queryWrapper.eq("contract_id", _con.get("contractId"));
            }
            List<ConfirmationEntity> list = confirmationService.list(queryWrapper);
//            if (CollectionUtils.isNotEmpty(list)) {
//                List<Long> ids = list.stream().map(ConfirmationEntity::getId).collect(Collectors.toList());
//                param.getParams().put("id", new Parameter(QueryParam.NOT_IN, ids));
//            }
        }
        IPage<FactoryEntity> page = service.queryPage(param, false);

        IPage<FactoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        List<FactoryVO> factoryVOS = BeanMapper.mapList(page.getRecords(), FactoryVO.class);

        List<FactoryEntity> list = page.getRecords();
        List<Long> ids = list.stream().map(FactoryEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            pageData.setRecords(factoryVOS);
            return CommonResponse.success("查询参照数据成功！", pageData);
        }
        LambdaQueryWrapper<FactoryContentEntity> lambdaQueryWrapper = new LambdaQueryWrapper<FactoryContentEntity>().in(FactoryContentEntity::getFactoryId, ids);
        List<FactoryContentEntity> factoryContentEntities = factoryContentService.list(lambdaQueryWrapper);
        Map<Long, FactoryContentEntity> collect = factoryContentEntities.stream().collect(Collectors.toMap(FactoryContentEntity::getFactoryId, Function.identity()));
        factoryVOS.forEach(vo -> {
            if (collect.containsKey(vo.getId())) {
                FactoryContentEntity factoryContentEntity = collect.get(vo.getId());
                vo.setSpecs(factoryContentEntity.getSpecs());
                vo.setEquipmentName(factoryContentEntity.getEquipmentName());
                vo.setUnit(factoryContentEntity.getUnit());
            }
        });

        pageData.setRecords(factoryVOS);

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
