package com.ejianc.business.rent.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.rent.service.IRentRentalService;
import com.ejianc.business.rent.vo.RentalSumVo;
import com.ejianc.business.settle.mapper.SettleMapper;
import com.ejianc.business.settle.vo.SourceBliVO;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping
public class RentRentalApiController implements Serializable {

    @Autowired
    private IRentRentalService service;

    /**
     * 根据合同id查询审批通过的租金计算金额
     *
     * @param contractId 合同id
     * @return 租金计算金额
     */
    @GetMapping(value = "/api/rentRental/queryRentalMnyByContractId")
    @ResponseBody
    CommonResponse<RentalSumVo> queryRentalMnyByContractId(@RequestParam(value = "contractId") Long contractId) {
        return CommonResponse.success("查询成功", service.queryRentalMnyByContractId(contractId));
    }
}
