package com.ejianc.business.rent.mapper;

import com.ejianc.business.rent.vo.RentContractChangeVO;
import com.ejianc.business.rent.vo.RentContractEquipmentAllVO;
import com.ejianc.business.rent.vo.RentDayDetailedVO;
import com.ejianc.business.rent.vo.RentSettlementVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.rent.bean.RentContractEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 租赁合同
 * 
 * @author generator
 * 
 */
@Mapper
public interface RentContractMapper extends BaseCrudMapper<RentContractEntity> {
    /**
     * 查询数量
     * @param queryParam
     * @return
     */
    public Integer countNumber(Map<String, Object> queryParam);

    /**
     * 分页查询
     * @param queryParam
     * @return
     */
    List<RentContractEquipmentAllVO> queryEquipmentSubList(Map<String, Object> queryParam);

    List<RentContractChangeVO> getRentContractChangeList(@Param("contractIds") List<Long> contractIds);
    List<RentSettlementVO> getRentSettlementList(@Param("contractIds") List<Long> contractIds);

    public void delChangeById(Long id);

    public void delRecordById(Long id);

    public void delById(Long id);
}
