package com.ejianc.business.rent.service;

import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.rent.bean.RentParameterDetailEntity;

import java.util.Date;
import java.util.List;

/**
 * 租赁设备台账明细
 *
 * @author generator
 */
public interface IRentParameterDetailService extends IBaseService<RentParameterDetailEntity> {

    /**
     * 根据sourceId,sourceType删除明细
     *
     * @param sourceId   来源id
     * @param sourceType 来源类型
     */
    void delParameterDetail(Long sourceId, String sourceType);

    /**
     * 查询上次租金自动计算日期
     *
     * @param parameterIdList 设备台账列表
     * @return 上次租金计算日期
     */
    Date getMaxOperationDate(List<Long> parameterIdList);
}
