package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.rent.bean.*;
import com.ejianc.business.rent.mapper.RentAcceptanceMapper;
import com.ejianc.business.rent.mapper.RentEquipmentStartMapper;
import com.ejianc.business.rent.service.IRentAcceptanceService;
import com.ejianc.business.rent.service.IRentEquipmentStartService;
import com.ejianc.business.rent.service.IRentParameterService;
import com.ejianc.business.rent.vo.*;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.rent.mapper.RentEquipmentStopMapper;
import com.ejianc.business.rent.service.IRentEquipmentStopService;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 租赁设备停用
 * 
 * @author generator
 * 
 */
@Service("rentEquipmentStopService")
public class RentEquipmentStopServiceImpl extends BaseServiceImpl<RentEquipmentStopMapper, RentEquipmentStopEntity> implements IRentEquipmentStopService{

    @Autowired
    private RentEquipmentStopMapper rentEquipmentStopMapper;
    @Autowired
    private IRentParameterService rentParameterService;
    @Autowired
    private JedisPool jedisPool;
    private static final String BILL_TYPE = "BT220221000000004";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IRentAcceptanceService rentAcceptanceService;
    @Autowired
    private IRentEquipmentStartService rentEquipmentStartService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/equipmentStop/saveStop";
    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proEquipments/stopUse/card";

    private final String OPERATE = "EQUIPMENT-RENT-STOP";



    private SessionManager sessionManager;

    /**
     * 根据合同id查询未生效的单据数据
     * @param contractId
     * @return
     */
    public RentEquipmentStopEntity selectByEquipmentStop(Long contractId) {
        QueryWrapper<RentEquipmentStopEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.eq("dr","0");
        queryWrapper.eq("bill_state","0");
        List<RentEquipmentStopEntity> list= rentEquipmentStopMapper.selectList(queryWrapper);
        if(CollectionUtils.isNotEmpty(list)){
            RentEquipmentStopEntity entity = list.get(0);
            return entity;
        }
        return null;
    }

    @Transactional
    public void saveOrUpdates(RentEquipmentStopEntity entity) {
        entity.setType(2);


        RentAcceptanceEntity validaAcceptanceEntity =rentAcceptanceService.selectByContractId(entity.getContractId());
        if(validaAcceptanceEntity != null && !entity.getContractId().equals(validaAcceptanceEntity.getContractId())){
            throw new BusinessException("该合同存在未生效的验收单据");
        }

        RentEquipmentStartEntity vStartEntity = rentEquipmentStartService.selectByContractIdEquipmentStart(entity.getContractId());
        if(vStartEntity != null && vStartEntity.getContractId() != entity.getContractId()){
            throw new BusinessException("该合同存在未生效的设备启用单据");
        }

        RentEquipmentStopEntity stopEntity =this.selectByEquipmentStop(entity.getContractId());
        if(stopEntity != null && !stopEntity.getId().equals(entity.getId())){
            throw new BusinessException("该合同存在未生效的停用单据");
        }

        CommonResponse<String> commonResponse=rentParameterService.selectValidationNewDate(entity.getContractId(),entity.getTypeDate(),entity.getId());
        if(!commonResponse.isSuccess()){
            throw new BusinessException(commonResponse.getMsg());
        }

        if(CollectionUtils.isNotEmpty(entity.getRentEquipmentStopSubList())){
            EquipmentNewDateVO subDate =rentParameterService.selectValidationNewDateSub(entity.getContractId());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (RentEquipmentStopSubEntity stopSubEntity:entity.getRentEquipmentStopSubList()){
                if(subDate != null && stopSubEntity.getTypeDate().getTime() < subDate.getPerformDate().getTime()){
                    throw new BusinessException("设备清单日期不是最新日期,最新日期:"+sdf.format(subDate.getPerformDate()));
                }
            }
        }
        super.saveOrUpdate(entity,false);
    }
    @Override
    public CommonResponse<JSONObject> getBillShareLink(Long id) {
        RentEquipmentStopEntity entity = super.selectById(id);
        //校验供应商
        CommonResponse<Boolean> supplierResp = proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            logger.error("根据供应商主键-{}查询失败，{}", entity.getSupplierId(), supplierResp.getMsg());
            return CommonResponse.error("获取供应商信息失败！");
        }
        Boolean flag = supplierResp.getData();
        if(!flag){
            return CommonResponse.error("该供应商未开通协同权限，无法协同启用单。 请先到供应商库—生成协同账号再进行协同操作。");
        }

        // 没有推送成功，则需要重新推送数据
        if (BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(BILL_TYPE);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", BILL_TYPE, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            }
            else {
                //未曾成功推送单据，则先向供方推送单据
                //推送供方处理
                PushRentEquipmentStopVO supplierPushCheckVO = BeanMapper.map(entity, PushRentEquipmentStopVO.class);
                supplierPushCheckVO.setSourceId(entity.getId());
                List<PushRentEquipmentStopSubVO> pushRentEquipmentStopSubVOS = BeanMapper.mapList(entity.getRentEquipmentStopSubList(), PushRentEquipmentStopSubVO.class);
                for (PushRentEquipmentStopSubVO supplierPushCheckDetailVO : pushRentEquipmentStopSubVOS) {
                    supplierPushCheckDetailVO.setSourceId(entity.getId());
                    supplierPushCheckDetailVO.setSourceDetailId(supplierPushCheckDetailVO.getId());
                    supplierPushCheckDetailVO.setId(null);
                }
                supplierPushCheckVO.setEquipmentStopDetailList(pushRentEquipmentStopSubVOS);
                //设置单据当前系统信息
                CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
                if (!ejcCloudSystemCode.isSuccess()) {
                    return CommonResponse.error("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
                }
                //设置当前系统ID
                supplierPushCheckVO.setSystemId(ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(supplierPushCheckVO);
                boolean pushResult = rentAcceptanceService
                        .pushBillToSupCenter(dataInfo, entity.getSupplierId(), entity.getId(), BILL_TYPE, cooperateResp
                                .getData(), PUSH_SAVE_URL);
                if (!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                }
                else {
                    entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    super.saveOrUpdate(entity, false);
                }
            }
        }
        return shareCooperateApi
                .getShareLink(id, BILL_TYPE, entity.getSupplierId().toString(), mobileBillShareFrontUrl, null);
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {

        String authority = request.getHeader("authority");
        String msg = null;

        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        RentEquipmentStopEntity checkEntity = super.selectById(billId);
        //设置供方签字信息
        checkEntity.setSupOperateTime(supOperateTime);
        checkEntity.setSupOperatorName(supOperatorName);
        checkEntity.setSupOperatorPhone(supOperatorPhone);
        checkEntity.setSupOperatorUserCode(supOperatorUserCode);

        String key = BILL_TYPE + "::" + checkEntity.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据id-{}签字信息回写加锁失败！", checkEntity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字信息回写加锁失败";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, BILL_TYPE, authority, checkEntity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            checkEntity.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态 签字状态：1-未签字、2-待乙方签字、3-待甲方签字、4-已签字
            // 乙方已签字状态即待甲方签字
            checkEntity.setSignStatus(1);
            //更新单据
            super.saveOrUpdate(checkEntity, false);

//            //向单据制单人和经办人推送该消息
//            String msgSendResult = sendMsg(checkEntity, "供方已签字提醒", "结算单据[" + settleEntity.getBillCode() + "]供方已签字完成");
//            if (null != msgSendResult) {
//                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(settleEntity.getCreateUserId(), settleEntity.getEmployeeId()),
//                        settleEntity.getId(), msgSendResult);
//            }

        } catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", checkEntity.getId(), e);
            msg = "单据签字信息回写失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }

    @Override
    public void delById(Long id) {
        Boolean flag = rentEquipmentStopMapper.delById(id);
        if (Boolean.FALSE.equals(flag)) {
            throw new BusinessException("删除失败!");
        }
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }
}
