package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.ac.bean.ContractEntity;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.ac.enums.PerformanceStatusEnum;

import com.ejianc.business.ac.service.IContractService;
import com.ejianc.business.ac.vo.ContractVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.bean.RentMachineSettlementEntity;
import com.ejianc.business.rent.enums.ContractStatusEnum;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.service.IRentMachineSettlementService;
import com.ejianc.business.rent.vo.RentContractVO;
import com.ejianc.business.rent.vo.RentMachineSettlementVO;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("rentMachineSettlement") 
public class RentMachineSettlementBpmServiceImpl implements ICommonBusinessService {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());


	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IRentMachineSettlementService service;
	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IRentContractService contractService;

	@Value("${common.env.base-host}")
	private String BaseHost;
	@Value("${refer.base-host:null}")
	private String BASE_HOST_FRONTEND;

	@Autowired
	private IExecutionApi executionApi;
	@Autowired
	private ICostDetailApi costDetailApi;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//结算单  根据 合同状态校验
		RentMachineSettlementEntity entity = service.selectById(billId);
		if (entity.getSettleType()==null){
			return CommonResponse.success();
		}
		if(entity.getContractId()!=null){
			RentContractEntity contractEntity = contractService.selectById(entity.getContractId());
			if(ContractStatusEnum.已冻结.getCode().equals(contractEntity.getContractState()) || ContractStatusEnum.已作废.getCode().equals(contractEntity.getContractState())){
				throw new BusinessException("合同{"+contractEntity.getContractName()+"},状态为："+ContractStatusEnum.getEnumByCode(contractEntity.getContractState()).getDescription()+"不可进行此操作！");
			}
		}
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		//结算单  根据 合同状态校验
		RentMachineSettlementEntity entity = service.selectById(billId);
		if (entity.getSettleType()==null){
			return CommonResponse.success();
		}
		if(entity.getContractId()!=null){
			RentContractEntity contractEntity = contractService.selectById(entity.getContractId());
			if(ContractStatusEnum.已冻结.getCode().equals(contractEntity.getContractState()) || ContractStatusEnum.已作废.getCode().equals(contractEntity.getContractState())){
				throw new BusinessException("合同{"+contractEntity.getContractName()+"},状态为："+ContractStatusEnum.getEnumByCode(contractEntity.getContractState()).getDescription()+"不可进行此操作！");
			}
		}
		return bpmBackCheck(billId, state, billTypeCode);
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		//最终结算撤回删除结算单推过的数据
		RentMachineSettlementEntity settleEntity = service.selectById(billId);
		//最终结算撤回时 已提交撤回才删除，中途撤回操作，结算单未生效，还未推送成本科目
//		if (settleEntity.getSettleType() == 1 && (settleEntity.getBillState() == 1 || settleEntity.getBillState() == 3)) {
//			//推送目标成本
//			List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
//			//  List<ContractEntity>  contractEntityList = new ArrayList<>();
//			ExecutionVO executionVO = service.targetCost(BeanMapper.map(settleEntity, RentMachineSettlementVO.class), "");
//			totalExecutionVOList.add(executionVO.getTotalVO());
//			logger.info("目标成本删除数据" + JSON.toJSONString(totalExecutionVOList));
//			CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
//			if (!response.isSuccess()) {
//				throw new BusinessException("目标成本推送失败," + response.getMsg());
//			}
//		}
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		//结算单  根据 合同状态校验
		RentMachineSettlementEntity entity = service.selectById(billId);
		if (entity.getSettleType()==null){
			return CommonResponse.success();
		}
		if(entity.getContractId()!=null){
			RentContractEntity contractEntity = contractService.selectById(entity.getContractId());
			if(ContractStatusEnum.已冻结.getCode().equals(contractEntity.getContractState()) || ContractStatusEnum.已作废.getCode().equals(contractEntity.getContractState())){
				throw new BusinessException("合同{"+contractEntity.getContractName()+"},状态为："+ContractStatusEnum.getEnumByCode(contractEntity.getContractState()).getDescription()+"不可进行此操作！");
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//结算单  根据 合同状态校验
		RentMachineSettlementEntity entity = service.selectById(billId);
		if (entity.getSettleType()==null){
			return CommonResponse.success();
		}
		logger.info("beforeApprovalProcessor: entity {}",JSONObject.toJSONString(entity));
		if(entity.getContractId()!=null){
			logger.info("beforeApprovalProcessor: entity.getContractId() {}",entity.getContractId());
			RentContractEntity contractEntity = contractService.selectById(entity.getContractId());
			logger.info("beforeApprovalProcessor: contractEntity {}",contractEntity);
			if(ContractStatusEnum.已冻结.getCode().equals(contractEntity.getContractState()) || ContractStatusEnum.已作废.getCode().equals(contractEntity.getContractState())){
				throw new BusinessException("合同{"+contractEntity.getContractName()+"},状态为："+ContractStatusEnum.getEnumByCode(contractEntity.getContractState()).getDescription()+"不可进行此操作！");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		RentMachineSettlementEntity settleEntity = service.selectById(billId);
		if (settleEntity.getSettleType()==null){
			return CommonResponse.success();
		}
		if (settleEntity != null) {
			settleEntity.setEffectiveDate(new Date());
		}
		if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			//直审时添加单据提交人等信息
			UserContext userContext = sessionManager.getUserContext();
			settleEntity.setCommitDate(new Date());
			settleEntity.setCommitUserCode(userContext.getUserCode());
			settleEntity.setCommitUserName(userContext.getUserName());
		}
		//推送结算池
//		boolean poolRes = service.pushSettleToPool(BeanMapper.map(settleEntity, RentMachineSettlementVO.class));
//		settleEntity.setPushPoolFlag(poolRes ? BillPushStatusEnum.推送成功.getStatus() : BillPushStatusEnum.未成功推送.getStatus());

		service.saveOrUpdate(settleEntity, false);
		//推送实际成本
		service.costPush(settleEntity);
		//推送合同池
		service.updateContractPoolSettle(BeanMapper.map(settleEntity,RentMachineSettlementVO.class), true);
		if (settleEntity.getSettleType() == 1) {
			// 完工结算修改合同状态为已封账
			QueryParam param = new QueryParam();
			param.getParams().put("id", new Parameter(QueryParam.EQ, settleEntity.getContractId()));
			List<RentContractEntity> contractEntities = contractService.queryList(param, false);
			contractEntities.get(0).setContractState(ContractStatusEnum.已终止.getCode());
			logger.info("======完工结算终审审核完回调,已终止======,{}", JSONObject.toJSONString(contractEntities.get(0)));
			contractService.saveOrUpdate(contractEntities.get(0), false);
			//最终结算单生效推送目标成本
			String linkUrl;
			String frontendBaseHost="";
			if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
				frontendBaseHost = BASE_HOST_FRONTEND;
			}else{
				frontendBaseHost = BaseHost;
			}
			linkUrl = frontendBaseHost + "ejc-proequipment-frontend/#/rentMachineSettlement/card?id=" + settleEntity.getId();
			ExecutionVO executionVO = service.targetCost(BeanMapper.map(settleEntity, RentMachineSettlementVO.class), linkUrl);
			logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
			CommonResponse<String> response = executionApi.aggPush(executionVO);
			if (!response.isSuccess()) {
				throw new BusinessException("目标成本推送失败," + response.getMsg());
			}

			return CommonResponse.success("完工结算终审回调成功！");
		}
		else {
			return CommonResponse.success("过程结算终审回调成功！");
		}
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//最终结算撤回删除结算单推过的数据
		RentMachineSettlementEntity settleEntity = service.selectById(billId);
		if (settleEntity.getSettleType()==null){
			return CommonResponse.success();
		}
		//最终结算撤回时 已提交撤回才删除，中途撤回操作，结算单未生效，还未推送成本科目
		if (settleEntity.getSettleType() == 1 && (settleEntity.getBillState() == 1 || settleEntity.getBillState() == 3)) {
			//推送目标成本
			List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
			//  List<ContractEntity>  contractEntityList = new ArrayList<>();
			ExecutionVO executionVO = service.targetCost(BeanMapper.map(settleEntity, RentMachineSettlementVO.class), "");
			totalExecutionVOList.add(executionVO.getTotalVO());
			logger.info("最终结算弃审后目标成本删除数据" + JSON.toJSONString(totalExecutionVOList));
			CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
			if (!response.isSuccess()) {
				throw new BusinessException("目标成本推送失败," + response.getMsg());
			}
			//修改合同状态  结算类型，0-过程,1-最终
			RentContractEntity contractEntity = contractService.selectById(settleEntity.getContractId());
			contractEntity.setContractState(ContractStatusEnum.履约中.getCode());
			contractService.saveOrUpdate(contractEntity);
			RentContractVO vo = BeanMapper.map(contractEntity, RentContractVO.class);
			vo.setFinishSettleDate(null);
			contractService.pushContract(vo);//修改了合同 从新推送合同池
			logger.info("修改合同状态！" + JSONObject.toJSONString(contractEntity));
		}
		logger.info("弃审推送成本---");
		logger.info("删除成本中心之前的数据-结算Id---{}",settleEntity.getId());
		CommonResponse<String> stringCommonResponse = costDetailApi.updateCostDetail(settleEntity.getId(),0);
		logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
		if(!stringCommonResponse.isSuccess()){
			throw new BusinessException(stringCommonResponse.getMsg());
		}
		//更新是否关联
		LambdaUpdateWrapper<RentMachineSettlementEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(RentMachineSettlementEntity::getId, settleEntity.getId());
		updateWrapper.set(RentMachineSettlementEntity::getRelationFlag, "0");//(1:是，0：否)
		updateWrapper.set(RentMachineSettlementEntity::getBillPushFlag, BillPushStatusEnum.未成功推送.getStatus());
		service.update(updateWrapper);
		return CommonResponse.success();
	}

	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {

		logger.info("完工单据billId-{}, state-{}, billTypeCode-{}撤回前校验", billId, state, billTypeCode);
		// 签章流程校验
		RentMachineSettlementEntity settleEntity = service.selectById(billId);
		if (settleEntity.getSettleType()==null){
			return CommonResponse.success();
		}
		if (settleEntity == null) {
			return CommonResponse.error("查询不到该单据信息！");
		}
		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审/撤回！");
		}
		//若当前合同有其他结算的自由态的结算单，也不能弃审/撤回！
		LambdaQueryWrapper<RentMachineSettlementEntity> settleLambda = new LambdaQueryWrapper<>();
		settleLambda.eq(RentMachineSettlementEntity::getContractId, settleEntity.getContractId());
		settleLambda.ne(RentMachineSettlementEntity::getId, billId);
		settleLambda.and(c -> c.notIn(RentMachineSettlementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));

		List<RentMachineSettlementEntity> resultList = service.list(settleLambda);
		if (resultList.size() > 0 && null != resultList.get(0)) {
			String settleTypeName = (null != resultList.get(0).getSettleType()) ? SettleTypeEnum.getDescriptionByCode(resultList.get(0).getSettleType()).getDescription() : "";
			return CommonResponse.error("当前合同有未审批的" + settleTypeName + "结算单，不能弃审/撤回!");
		}

		//若当前结算单不是最新的，则不能弃审/撤回
		QueryParam param = new QueryParam();
		param.getParams().put("contract_id", new Parameter(QueryParam.EQ, settleEntity.getContractId()));
		param.getOrderMap().put("create_time", QueryParam.DESC);
		List<RentMachineSettlementEntity> settleList = service.queryList(param);
		logger.info("查询过程结算信息：contractId-" + settleEntity.getContractId());
		if (CollectionUtils.isNotEmpty(settleList) && null != settleList.get(0)) {
			logger.info("查询最新的过程结算结果：{}", JSONObject.toJSONString(settleList.get(0), SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
			RentMachineSettlementEntity processSettle = settleList.get(0);
			logger.info("nodeSettle.id-" + processSettle.getId());
			logger.info("billId-" + billId);
			if (!processSettle.getId().equals(billId)) {
				return CommonResponse.error("当前单据已有新的结算单，不能弃审/撤回！");
			}
		}
		// 从结算池中删除数据
		boolean unPushRes = service.delSettleFromPool(settleEntity.getId());
		if (unPushRes) {
			settleEntity.setPushPoolFlag(BillPushStatusEnum.未成功推送.getStatus());
		}
		else {
			logger.error("将过程结算单-{}从结算池删除失败！", settleEntity);
		}
		//推送合同池
		service.updateContractPoolSettle(BeanMapper.map(settleEntity, RentMachineSettlementVO.class), false);
		//如果是完工结算 就去修改合同状态
		if (settleEntity.getSettleType() == 1) {
			logger.info("完工结算弃审/撤回前回调结算实体信息为：{}", JSONObject.toJSONString(settleEntity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
			// 完工结算撤回修改合同状态为履约中
			QueryParam qq = new QueryParam();
			qq.getParams().put("id", new Parameter(QueryParam.EQ, settleEntity.getContractId()));
			List<RentContractEntity> contractEntities = contractService.queryList(qq, false);
			contractEntities.get(0).setContractState(ContractStatusEnum.履约中.getCode());
			logger.info("======完工结算弃审前回调,修改合同状态为履约中======,{}", JSONObject.toJSONString(contractEntities.get(0)));
			contractService.saveOrUpdate(contractEntities.get(0), false);
		}
		else {
			//当前合同是否有最终结算
			LambdaQueryWrapper<RentMachineSettlementEntity> lambda = new LambdaQueryWrapper<>();
			lambda.eq(RentMachineSettlementEntity::getContractId, settleEntity.getContractId());
			lambda.eq(RentMachineSettlementEntity::getSettleType, SettleTypeEnum.完工.getCode());
			int resultCount = service.count(lambda);
			logger.info("查询最终结算信息：contractId-" + settleEntity.getContractId());
			logger.info("查询最终结算结果：resultCount-" + resultCount);
			if (resultCount > 0) {
				return CommonResponse.error("当前单据所用合同已被完工结算引用，不能弃审/撤回！");
			}
		}
		service.saveOrUpdate(settleEntity, false);
		logger.info("弃审推送成本---");
		logger.info("删除成本中心之前的数据-Id---{}",settleEntity.getId());
		CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(settleEntity.getId());
		logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
		if(!stringCommonResponse.isSuccess()){
			throw new BusinessException(stringCommonResponse.getMsg());
		}
		//更新是否关联
		LambdaUpdateWrapper<RentMachineSettlementEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(RentMachineSettlementEntity::getId, settleEntity.getId());
		updateWrapper.set(RentMachineSettlementEntity::getRelationFlag, "0");//(1:是，0：否)
		updateWrapper.set(RentMachineSettlementEntity::getBillPushFlag, BillPushStatusEnum.未成功推送.getStatus());
		service.update(updateWrapper);
		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}

}
