package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.rent.bean.*;
import com.ejianc.business.rent.enums.ContractStatusEnum;
import com.ejianc.business.rent.mapper.RentTotalPlanSubMapper;
import com.ejianc.business.rent.service.IRentChangeTotalPlanService;
import com.ejianc.business.rent.service.IRentTotalPlanHistoryService;
import com.ejianc.business.rent.service.IRentTotalPlanSubService;
import com.ejianc.business.rent.vo.*;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.rent.mapper.RentTotalPlanMapper;
import com.ejianc.business.rent.service.IRentTotalPlanService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 租赁设备总计划
 * 
 * @author generator
 * 
 */
@Service("rentTotalPlanService")
public class RentTotalPlanServiceImpl extends BaseServiceImpl<RentTotalPlanMapper, RentTotalPlanEntity> implements IRentTotalPlanService{
    @Autowired
    private IRentTotalPlanSubService rentTotalPlanSubService;
    @Autowired
    private IRentTotalPlanHistoryService rentTotalPlanHistoryService;
    @Autowired
    private RentTotalPlanMapper rentTotalPlanMapper;
    @Autowired
    private IShareMaterialApi materialApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentChangeTotalPlanService changeService;
    @Autowired
    private IRentTotalPlanService planService;
    @Value("${common.env.base-host}")
    private String baseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    private static final String BILL_CODE = "RENT_TOTAL_PLAN";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentTotalPlanService service;
    private static final String BILL_TYPE = "BT220214000000002";






    @Override
    public RentTotalPlanVO insertOrUpdate(RentTotalPlanVO saveOrUpdateVO, Boolean isControl) {
        RentTotalPlanEntity entity = BeanMapper.map(saveOrUpdateVO, RentTotalPlanEntity.class);
        if (!isControl){
            if((entity.getId() == null || entity.getId() == 0) && saveOrUpdateVO.getCode() == null){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
        }
        QueryParam param = new QueryParam();
        param.getParams().put("projectId",new Parameter(QueryParam.EQ,entity.getProjectId()));
        List<RentTotalPlanEntity> list = service.queryList(param);
        if(ListUtil.isNotEmpty(list) && list.get(0).getId()!=null && !list.get(0).getId().equals(entity.getId())){
            throw new BusinessException("项目【"+entity.getProjectName()+"】该项目已存在计划！");
        }
        if (!isControl){
            service.saveOrUpdates(entity);
        }

        RentTotalPlanVO vo = BeanMapper.map(entity, RentTotalPlanVO.class);
        if (!isControl){
            vo.setTotalPlanSubList(TreeNodeBUtil.buildTree(vo.getTotalPlanSubList()));
        }
        if (null ==vo.getId() && isControl) {
            vo.setId(IdWorker.getId());
            List<RentTotalPlanSubVO> totalPlanSubList = vo.getTotalPlanSubList();
            for (RentTotalPlanSubVO rentTotalPlanSubVO : totalPlanSubList){
                if(rentTotalPlanSubVO.getId() == null){
                    rentTotalPlanSubVO.setId(IdWorker.getId());
                }
            }
        }

        return vo;
    }

    @Transactional
    @Override
    public void saveOrUpdates(RentTotalPlanEntity entity) {
        entity.setChangeStatus(1);//未变更
        RentTotalPlanEntity planEntity =this.selectCode(entity.getCode());
        if(planEntity != null){
            if(entity.getId() == null){
                throw new BusinessException("计划编码重复:"+entity.getCode());
            }else{
                if(!entity.getId().equals(planEntity.getId())){
                    throw new BusinessException("计划编码重复:"+entity.getCode());
                }
            }
        }
        this.saveOrUpdate(entity,false);
        if(CollectionUtils.isNotEmpty(entity.getTotalPlanSubList())){
            saveOrUpdateChild(entity);
        }

        //目标成本推送
        ExecutionVO executionVO = targetCost(entity);
        logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        if (!response.isSuccess()){
            throw new BusinessException("目标成本推送失败:" + response.getMsg());
        }

    }

    @Override
    public void delByPlanId(Long pid) {
        rentTotalPlanMapper.delByPlanId(pid);
    }

    @Override
    public void test() {
        //TODO
        //TODO
        //1是直审，2是有审批流
        logger.info("--------------总计划变更审批通过，处理业务");
        //变更表
        Long id =557254573766099013L;
        RentChangeTotalPlanEntity entity = changeService.selectById(id);
        List<RentChangeTotalPlanSubEntity> subEntityList = entity.getTotalPlanSubList();
        //合同主表
        RentTotalPlanEntity contractEntity = planService.selectById(entity.getTotalId());

        //同步原合同到记录表
        logger.info("--------------同步原始总计划到记录表");
		/*TotalPlanHistoryEntity historyEntity = BeanMapper.map(contractEntity, TotalPlanHistoryEntity.class);
		historyEntity.setTotalId(entity.getTotalId());//原合同主键
		historyEntity.setId(null);
		historyEntity.setCreateTime(new Date());
		historyEntity.setDetailList(null);
		historyService.saveOrUpdate(historyEntity, false);*/

        //同步原清单到记录表
        logger.info("--------------同步原始总计划清单到记录表");
        List<RentTotalPlanSubEntity> checkList = contractEntity.getTotalPlanSubList();
        if (null != checkList && checkList.size() > 0) {
			/*List<TotalPlanDetailHistoryEntity> historyDetails = BeanMapper.mapList(checkList, TotalPlanDetailHistoryEntity.class);
			for (TotalPlanDetailHistoryEntity hde : historyDetails) {
				hde.setHistoryId(historyEntity.getId());//记录表主键
				hde.setTotalId(entity.getTotalId());//原合同主键
				hde.setTotalBid(hde.getId());//原子表id
				hde.setId(null);
			}
			historyDetailService.saveOrUpdateBatch(historyDetails, historyDetails.size(), false);*/
        }

        //回写合同主表
        RentTotalPlanEntity newEntity = BeanMapper.map(entity, RentTotalPlanEntity.class);
        newEntity.setId(contractEntity.getId());
        newEntity.setBaseMny(contractEntity.getBaseMny());
        newEntity.setChangingMny(null);
        newEntity.setChangeStatus(3);//状态改为已变更
        newEntity.setChangeCode(contractEntity.getChangeCode());
        newEntity.setChangeId(contractEntity.getChangeId());
        newEntity.setBillState(contractEntity.getBillState());
        newEntity.setCreateTime(contractEntity.getCreateTime());
        newEntity.setVersion(contractEntity.getVersion());
        newEntity.setTotalPlanSubList(null);
        logger.info("--------------变更总计划回写到原始总计划");
        planService.saveOrUpdate(newEntity);

        // 回写原合同清单表
        logger.info("--------------变更总计划清单回写到原始总计划清单");
        planService.delByPlanId(contractEntity.getId());

        if (CollectionUtils.isNotEmpty(subEntityList)) {
            List<RentTotalPlanSubEntity> detailEntitys = BeanMapper.mapList(subEntityList, RentTotalPlanSubEntity.class);
            for(RentTotalPlanSubEntity detailEntity : detailEntitys){
                detailEntity.setPid(entity.getTotalId());
            }
            rentTotalPlanSubService.saveOrUpdateBatch(detailEntitys, detailEntitys.size(), false);
        }

        logger.info("--------------处理总计划变更单");
        changeService.saveOrUpdate(entity, false);

        logger.info("--------------处理变更附件");
    }

    @Override
    public void delete(List<RentTotalPlanVO> vos) {
        //目标成本推送
        if(CollectionUtils.isNotEmpty(vos)) {
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            for (RentTotalPlanVO rentTotalPlanVO : vos) {
                RentTotalPlanEntity rentTotalPlanEntity = super.selectById(rentTotalPlanVO.getId());
                ExecutionVO executionVO = targetCost(rentTotalPlanEntity);
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            logger.info("目标成本删除数据"+ JSON.toJSONString(totalExecutionVOList));
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()){
                throw new BusinessException("目标成本推送失败" + response.getMsg());
            }
        }
        super.removeByIds(vos.stream().map(RentTotalPlanVO::getId).collect(Collectors.toList()),true);

    }

    @Transactional
    public void saveOrUpdateChild(RentTotalPlanEntity entity) {
        List<RentTotalPlanSubEntity> listbs = entity.getTotalPlanSubList();
        Map<Long,Long> idMap=new HashMap<>();
        for(RentTotalPlanSubEntity cdEntity:listbs){
            if(cdEntity.getParentId() ==999L){
                idMap.put(cdEntity.getDocCategoryId(),cdEntity.getId());
            }
        }

        for(RentTotalPlanSubEntity cdEntity:listbs){
            if(!cdEntity.getParentId().equals(999L)){
                Long parentId =idMap.get(cdEntity.getDocCategoryId());
                cdEntity.setParentId(parentId != null?parentId:entity.getProjectId());
                cdEntity.setTid(cdEntity.getId());

            }else{
                cdEntity.setTid(cdEntity.getId());
            }
        }
        rentTotalPlanSubService.saveOrUpdateBatch(listbs,listbs.size(),false);
    }

    public RentTotalPlanEntity selectCode(String code){
        QueryWrapper<RentTotalPlanEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("code", code);
        queryWrapper.eq("dr","0");
        List<RentTotalPlanEntity> list =rentTotalPlanMapper.selectList(queryWrapper);
        if(CollectionUtils.isNotEmpty(list)){
            return list.get(0);
        }
        return null;
    }
    @Override
    public ExecutionVO targetCost(RentTotalPlanEntity entity) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getCode());
        totalVO.setBillType("BT220214000000002");
        totalVO.setBussinessType(BussinessTypeEnum.设备总计划.getCode());
        totalVO.setBillCategory(BillCategoryEnum.计划.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }

        totalVO.setLinkUrl(frontendBaseHost + "ejc-proequipment-frontend/#/totalPlan/card?id=" + entity.getId());
        totalVO.setBillDate(entity.getOrganizationDate().toString());
        BigDecimal checkMoney = BigDecimal.ZERO;
        BigDecimal checkTaxMoney = BigDecimal.ZERO;
        for (RentTotalPlanSubEntity rentTotalPlanSubEntity : entity.getTotalPlanSubList()) {
            checkMoney = checkMoney.add(rentTotalPlanSubEntity.getTemporaryAmount());
            checkTaxMoney = checkTaxMoney.add(rentTotalPlanSubEntity.getTemporaryAmount());
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(rentTotalPlanSubEntity.getId());
            detailExecutionVO.setSourceBillId(entity.getId());
            detailExecutionVO.setCategoryId(rentTotalPlanSubEntity.getEquipmentTypeId());
            detailExecutionVO.setCategoryName(rentTotalPlanSubEntity.getEquipmentTypeName());
            detailExecutionVO.setCode(rentTotalPlanSubEntity.getEquipmentCode());
            detailExecutionVO.setCategoryContainFlag(false);

            //判断是否是分类
            if (rentTotalPlanSubEntity.getEquipmentId()==null){
                detailExecutionVO.setCategoryFlag(true);
                detailExecutionVO.setDocId(rentTotalPlanSubEntity.getEquipmentTypeId());
            }else {
                detailExecutionVO.setCategoryFlag(false);
                detailExecutionVO.setDocId(rentTotalPlanSubEntity.getEquipmentId());
            }

            detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());
            detailExecutionVO.setName(rentTotalPlanSubEntity.getEquipmentName());
//            detailExecutionVO.setUnitId(rentTotalPlanSubEntity.getMeteringUnit());
            detailExecutionVO.setUnitName(rentTotalPlanSubEntity.getMeteringUnit());
            detailExecutionVO.setSpec(rentTotalPlanSubEntity.getSpecs());
            detailExecutionVO.setNum(rentTotalPlanSubEntity.getPlanTotal());
            detailExecutionVO.setMoney(rentTotalPlanSubEntity.getTemporaryAmount());
            detailExecutionVO.setTaxMoney(rentTotalPlanSubEntity.getTemporaryAmount());
            detailList.add(detailExecutionVO);
        }
        totalVO.setMoney(checkMoney);
        totalVO.setTaxMoney(checkTaxMoney);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }
    @Override
    public ParamsCheckVO targetCostCtrl(RentTotalPlanVO totalPlanVO) {
        RentTotalPlanVO contractVO1 = insertOrUpdate(totalPlanVO, true);
        ExecutionVO executionVO = targetCost(BeanMapper.map(contractVO1, RentTotalPlanEntity.class));
        logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO data = response.getData();
        if(CollectionUtils.isEmpty(data.getDataSource())){
            data.setWarnType("none");
        }
        return data;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        RentTotalPlanVO contractVO =queryDetail(id);
        ExecutionVO executionVO = targetCost(BeanMapper.map(contractVO,RentTotalPlanEntity.class));
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO data = response.getData();
        if(CollectionUtils.isEmpty(data.getDataSource())){
            data.setWarnType("none");
        }
        return data;
    }

    @Override
    public RentTotalPlanVO queryDetail(Long id) {
        RentTotalPlanEntity entity = service.selectById(id);
        RentTotalPlanVO vo = BeanMapper.map(entity, RentTotalPlanVO.class);
        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entity.getTotalPlanSubList())){
            vo.setTotalPlanSubList(TreeNodeBUtil.buildTree(vo.getTotalPlanSubList()));
        }
        return vo;
    }

    @Override
    public void syncCost(Long id) {
        //有变更单推送变更单数据,否则推送总计划数据
        QueryWrapper<RentChangeTotalPlanEntity> rentPlanChangeQueryWrapper = new QueryWrapper<RentChangeTotalPlanEntity>();
        rentPlanChangeQueryWrapper.eq("total_id", id).orderByDesc("create_time");
        List<RentChangeTotalPlanEntity> changeEntityList = changeService.list(rentPlanChangeQueryWrapper);
        ExecutionVO executionVO = new ExecutionVO();
        if (changeEntityList.size() > 0) {
            RentChangeTotalPlanEntity rentChangeTotalPlanEntity = changeService.selectById(changeEntityList.get(0).getId());
            executionVO = changeService.targetCost(rentChangeTotalPlanEntity, null);
        } else {
            //目标成本推送
            RentTotalPlanEntity rentTotalPlanEntity = service.selectById(id);
            executionVO = service.targetCost(rentTotalPlanEntity);
        }

        logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        if (!response.isSuccess()){
            throw new BusinessException("目标成本推送失败:" + response.getMsg());
        }
    }

    @Override
    public List<RentChangeTotalPlanSubVO> queryChangeCompare(Long id) {
        RentChangeTotalPlanEntity rentChangeTotalPlanEntity = changeService.selectById(id);
        List<RentChangeTotalPlanSubEntity> totalPlanSubList = rentChangeTotalPlanEntity.getTotalPlanSubList();
        List<RentChangeTotalPlanSubVO> rentChangeTotalPlanSubVOS = BeanMapper.mapList(totalPlanSubList, RentChangeTotalPlanSubVO.class);
        //change_id his
        LambdaQueryWrapper<RentTotalPlanHistoryEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(RentTotalPlanHistoryEntity::getChangeId, id);
        RentTotalPlanHistoryEntity rentTotalPlanHistory = rentTotalPlanHistoryService.getOne(lambda);
        RentTotalPlanHistoryEntity rentTotalPlanHistoryEntity = rentTotalPlanHistoryService.selectById(rentTotalPlanHistory.getId());
        List<RentTotalPlanHistorySubEntity> rentTotalPlanHistorySubList = rentTotalPlanHistoryEntity.getRentTotalPlanHistorySubList();
        Map<Long, RentTotalPlanHistorySubEntity> hisMap = rentTotalPlanHistorySubList.stream().collect(Collectors.toMap(RentTotalPlanHistorySubEntity::getTotalBid, Function.identity()));
        for (RentChangeTotalPlanSubVO rentChangeTotalPlanSubVO : rentChangeTotalPlanSubVOS){
            RentTotalPlanHistorySubEntity rentTotalPlanHistorySubEntity = hisMap.get(rentChangeTotalPlanSubVO.getSubDetailId());
            if (rentTotalPlanHistorySubEntity != null){
                rentChangeTotalPlanSubVO.setBcPlanTotal(rentTotalPlanHistorySubEntity.getPlanTotal());
                rentChangeTotalPlanSubVO.setBcTemporaryAmount(rentTotalPlanHistorySubEntity.getTemporaryAmount());
            }

        }

        List<RentChangeTotalPlanSubVO> rentChangeTotalPlanSubVOS1 = TreeNodeBUtil.buildTree(rentChangeTotalPlanSubVOS);
        return rentChangeTotalPlanSubVOS1;
    }
}
