package com.ejianc.business.temporary.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.rent.bean.*;
import com.ejianc.business.rent.enums.ChangeStatusEnum;
import com.ejianc.business.rent.enums.DraftTypeEnum;
import com.ejianc.business.rent.enums.SignatureStatusEnum;
import com.ejianc.business.rent.vo.*;
import com.ejianc.business.temporary.contract.bean.*;
import com.ejianc.business.temporary.contract.service.*;
import com.ejianc.business.temporary.contract.vo.*;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.temporary.contract.mapper.TemporaryContractChangeMapper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 临时设备租赁合同-合同变更表
 * 
 * @author generator
 * 
 */
@Service("temporaryContractChangeService")
public class TemporaryContractChangeServiceImpl extends BaseServiceImpl<TemporaryContractChangeMapper, TemporaryContractChangeEntity> implements ITemporaryContractChangeService{
    @Autowired
    private ITemporaryContractService contractService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ITemporaryContractRecordService recordContractService;

    @Autowired
    private ITemporaryClauseService contractClauseService;

    @Autowired
    private ITemporaryPaymentClauseService contractPaymentService;

    @Autowired
    private ITemporaryContractChangeService changeService;

    /**
     * 添加或者修改
     * @param temporaryContractChangeVO
     */
    public TemporaryContractChangeVO saveOrUpdates(TemporaryContractChangeVO temporaryContractChangeVO) {
        TemporaryContractEntity temporaryContractEntity =contractService.getById(temporaryContractChangeVO.getContractId());
        QueryParam param = new QueryParam();
        param.getParams().put("contractId",new Parameter(QueryParam.EQ,temporaryContractChangeVO.getContractId()));
        List<TemporaryContractChangeEntity> contractList = this.queryList(param);
        if(CollectionUtils.isNotEmpty(contractList)){
            TemporaryContractChangeEntity entity = contractList.get(0);
            if(!entity.getId().equals(temporaryContractChangeVO.getId())){
                throw new BusinessException("该合同已存在未生效的变更单!");
            }
        }

        if(CollectionUtils.isNotEmpty(temporaryContractChangeVO.getAttachIds()) &&  null != temporaryContractEntity.getContractFileId()) {
            temporaryContractChangeVO.getAttachIds().remove(temporaryContractChangeVO.getContractFileId());
        }

        TemporaryContractChangeEntity changeEntity = BeanMapper.map(temporaryContractChangeVO, TemporaryContractChangeEntity.class);
        if (changeEntity.getId() == null){
            changeEntity.setSignatureState(SignatureStatusEnum.未签章.getCode());
            changeEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            changeEntity.setContractPerformanceState(ContractPerformanceStateEnum.未签订.getStateCode());
            if(changeEntity.getChangeVersion() < 10){
                changeEntity.setCode(changeEntity.getCode() + "10" + changeEntity.getChangeVersion());
            }else{
                changeEntity.setCode(changeEntity.getCode() + "1" + changeEntity.getChangeVersion());
            }
        }

        super.saveOrUpdate(changeEntity,false);//保存
        saveOrUpdateContract(changeEntity);//回写主表
        TemporaryContractChangeVO changeVO = BeanMapper.map(changeEntity, TemporaryContractChangeVO.class);
        return changeVO;
    }

    /**
     * 回写主表
     * @param changeEntity
     */
    public void saveOrUpdateContract(TemporaryContractChangeEntity changeEntity) {
        TemporaryContractEntity temporaryContractEntity =contractService.getById(changeEntity.getContractId());
        temporaryContractEntity.setChangeCode(changeEntity.getCode());
        temporaryContractEntity.setChangeDate(new Date());
        temporaryContractEntity.setChangeId(changeEntity.getId());
        temporaryContractEntity.setChangeStatus(2);//改成变更中
        temporaryContractEntity.setChangeDraftType(changeEntity.getChangeDraftType());
        temporaryContractEntity.setChangeFile(changeEntity.getChangeFile());
        temporaryContractEntity.setBeforeChangeMny(temporaryContractEntity.getContractMny());
        temporaryContractEntity.setAfterChangeMny(changeEntity.getChangeMny());
        temporaryContractEntity.setChangingMny((changeEntity.getChangeMny()!= null?changeEntity.getChangeMny():BigDecimal.ZERO).subtract(changeEntity.getChangeTax()!= null?changeEntity.getChangeTax():BigDecimal.ZERO));
        temporaryContractEntity.setChangeContractSignatureStatus(Integer.valueOf(changeEntity.getSignatureState()));
        temporaryContractEntity.setChangeFile(changeEntity.getChangeFile());
        temporaryContractEntity.setChangeVersion(changeEntity.getChangeVersion());
        contractService.saveOrUpdate(temporaryContractEntity);
    }

    @Override
    public TemporaryContractChangeVO addConvertByConId(Long contractId, Long changeId) {
        TemporaryContractEntity contractEntity = contractService.selectById(contractId);
        if(ChangeStatusEnum.变更中.getCode().equals(contractEntity.getChangeStatus()) && null == changeId) {
            TemporaryContractChangeEntity change = this.selectById(contractEntity.getChangeId());
            TemporaryContractChangeVO vo = BeanMapper.map(change, TemporaryContractChangeVO.class);
            return vo;
        }
        TemporaryContractChangeVO changeVO = BeanMapper.map(contractEntity, TemporaryContractChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeChangeMny(contractEntity.getContractMny());
        changeVO.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        changeVO.setBeforeContractName(contractEntity.getContractName());
        changeVO.setChangeDraftType(DraftTypeEnum.上传合同.getCode().toString());
        changeVO.setContractId(contractId);
        changeVO.setChangeVersion(contractEntity.getChangeVersion() == null ? 1 : contractEntity.getChangeVersion()+ 1);
        changeVO.setSignatureState(SignatureStatusEnum.未签章.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setCommitDate(null);
        changeVO.setCommitUserCode(null);
        changeVO.setCommitUserName(null);
        changeVO.setEffectiveDate(null);
        changeVO.setChangeFileId(null);
        changeVO.setChangeFilePath(null);
        resetSub(changeVO);
        return changeVO;
    }

    /**
     * 子表负责
     * @param changeVO
     */
    public void resetSub(TemporaryContractChangeVO changeVO) {
        //设备明细
        List<TemporaryEquipmentChangeVO> equipmentList = changeVO.getTemporaryEquipmentDetailedList();
        if(CollectionUtils.isNotEmpty(equipmentList)){
            equipmentList.forEach(equipment ->{
                equipment.setSrcTblId(equipment.getId());
                equipment.setRowState("edit");
            });
        }
        //月租明细
        List<TemporaryChangeOtherVO> otherList = changeVO.getTemporaryOtherList();
        if(CollectionUtils.isNotEmpty(otherList)){
            otherList.forEach(monthDetailed ->{
                monthDetailed.setId(null);
                monthDetailed.setChangeId(monthDetailed.getId());
                monthDetailed.setSrcTblId(monthDetailed.getId());
                monthDetailed.setRowState("add");
            });
        }


        //合同条款
        List<TemporaryChangeClauseVO> contractList = changeVO.getTemporaryClauseList();
        if(CollectionUtils.isNotEmpty(contractList)){
            contractList.forEach(item ->{
                item.setRowState("add");
            });
        }

        //合同支付条款
        List<TemporaryChangePaymentVO> paymentList = changeVO.getTemporaryPaymentClauseList();
        if(CollectionUtils.isNotEmpty(paymentList)){
            paymentList.forEach(item ->{
                item.setRowState("add");
            });
        }
    }

    @Override
    public TemporaryContractChangeVO queryDetailRecord(Long id) {
        TemporaryContractEntity contractEntity = contractService.selectById(id);
        TemporaryContractChangeVO changeVO = new TemporaryContractChangeVO();
        changeVO.setId(id);
        changeVO.setBaseTaxMny(contractEntity.getBaseTaxMny() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMny());
        //现合同金额（含税）
        changeVO.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());

        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, id));
        param.getParams().put("contract_performance_state", new Parameter(QueryParam.EQ, ContractPerformanceStateEnum.履约中.getStateCode()));
        param.getOrderMap().put("change_date", QueryParam.DESC);
        param.getOrderMap().put("create_time", QueryParam.DESC);
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(change_mny) as sumChangeMoney, count(*) as changeNum");
        resp = super.getMap(wrapper);

        //设置变更详情
        changeVO.setChangeList(BeanMapper.mapList(queryList(param), TemporaryContractChangeVO.class));

        BigDecimal sumChangeMoney = null != resp.get("sumChangeMoney") ? new BigDecimal(resp.get("sumChangeMoney").toString()) : BigDecimal.ZERO;
        BigDecimal changeAmtRate = BigDecimal.ZERO;
        if (null != contractEntity.getBaseTaxMny() && contractEntity.getBaseTaxMny().compareTo(BigDecimal.ZERO) > 0 ){
            changeAmtRate = (sumChangeMoney.divide(contractEntity.getBaseTaxMny(),8, ROUND_HALF_DOWN)).multiply(new BigDecimal(100));
        }

        changeVO.setAllChangeMny(sumChangeMoney);
        Long changeNum = (Long) resp.get("changeNum");
        changeVO.setChangeNum(changeNum != null ? Integer.valueOf(String.valueOf(changeNum)) : 0);
        changeVO.setChangeMnyRate(changeAmtRate);
        //区分是否主合同的变更合同
        changeVO.setSupplementFlag(contractEntity.getSupplementFlag());
        changeVO.setAddType(contractEntity.getAddType());

        //判断能否新增变更
        if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureState())
                && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState())
                || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))
                && (!(ContractPerformanceStateEnum.已作废.getStateCode().equals(contractEntity.getContractPerformanceState()) || ContractPerformanceStateEnum.已冻结.getStateCode().equals(contractEntity.getContractPerformanceState())))){
            changeVO.setEditFlag(this.editChangeFlag(id));
        }

        return changeVO;
    }

    /**
     * 查询能否变更
     * @param contractId
     * @return
     */
    public Boolean editChangeFlag(Long contractId) {
        /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
            自由态也不能新增
         */
        LambdaQueryWrapper<TemporaryContractChangeEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(TemporaryContractChangeEntity::getContractId, contractId);
        lambda.and(l -> l.ne(TemporaryContractChangeEntity::getSignatureState, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(TemporaryContractChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        List<TemporaryContractChangeEntity> changeList = super.list(lambda);
        if (changeList.size() > 0){
            return false;
        }
        return true;
    }
    /**
     * 审批通过后调用
     * @param changeBillId
     * @param billTypeCode
     * @param commitState
     * @return
     */
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState) {
        CommonResponse<String> resp = null;
        /**更新变更的审批时间  begin */
        TemporaryContractChangeEntity changeEntity = this.selectById(changeBillId);
        if (commitState){
            changeEntity.setCommitDate(new Date());
            changeEntity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
            changeEntity.setCommitUserName(sessionManager.getUserContext().getUserName());
        }

        logger.info("进入变更终审！变更表数据------------->: {}", JSONObject.toJSONString(changeEntity));

        /**复制合同表数据到记录表 begin */
        TemporaryContractEntity contract = contractService.selectById(changeEntity.getContractId());
        TemporaryContractVO contractVO = BeanMapper.map(contract, TemporaryContractVO.class);

        //获取当前合同记录数
        QueryWrapper<TemporaryContractRecordEntity> countQuery = new QueryWrapper<>();
        countQuery.eq("contract_id", contractVO.getId());
        countQuery.eq("dr", BaseVO.DR_UNDELETE);
        int curRecordVersion = recordContractService.count(countQuery);

        Map<Long, Integer> contIdVersionMap =  new HashMap<>();
        TemporaryContractRecordEntity recordEntity = BeanMapper.map(contractVO, TemporaryContractRecordEntity.class);
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setChangeVersion(curRecordVersion+1);
        recordEntity.setId(null);
        logger.info("变更前主合同数据: {}", JSONObject.toJSONString(contractVO));
        logger.info("变更前主合同子表detail数据: {}", JSONObject.toJSONString(contractVO.getTemporaryEquipmentDetailedList()));
        logger.info("记录表从主合同表复制的数据: {}", JSONObject.toJSONString(recordEntity));
        logger.info("记录表从主合同表复制的数据的子表detail数据: {}", JSONObject.toJSONString(recordEntity.getTemporaryEquipmentDetailedList()));

        if(CollectionUtils.isNotEmpty(recordEntity.getTemporaryEquipmentDetailedList())){
            recordEntity.getTemporaryEquipmentDetailedList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getTemporaryOtherList())){
            recordEntity.getTemporaryOtherList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getTemporaryClauseList())){
            recordEntity.getTemporaryClauseList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getTemporaryPaymentClauseList())){
            recordEntity.getTemporaryPaymentClauseList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }

        logger.info("记录表从主合同表复制的子表detail数据，设置id后的值: {}", JSONObject.toJSONString(recordEntity.getTemporaryEquipmentDetailedList()));
        recordContractService.saveOrUpdate(recordEntity, false);
        logger.info("审批-变更记录表保存主合同数据成功！");
        /*//根据实体RefCode查询实体单据类型
        CommonResponse<BillTypeVO> contractBillTypeResp = billTypeApi.getByRefCode(CONTRACT_REFCODE);
        if(!contractBillTypeResp.isSuccess()) {
            logger.error("根据refCode-{}查询对应元数据失败, 原因：{}", CONTRACT_REFCODE, contractBillTypeResp.getMsg());
        }
        CommonResponse<BillTypeVO> contractRBillTypeResp = billTypeApi.getByRefCode(CONTRACT_RECORD_REFCODE);
        if(!contractRBillTypeResp.isSuccess()) {
            logger.error("根据refCode-{}查询对应元数据失败, 原因：{}", CONTRACT_RECORD_REFCODE, contractRBillTypeResp.getMsg());
        }*/
        //原合同附件、起草附件同步到记录单据中
       /* resp = copyFile(contractVO.getId().toString(), contractBillTypeResp.getData().getBillCode(),
                recordEntity.getId().toString(), contractRBillTypeResp.getData().getBillCode(), CONTRACT_ATTACH_SOURCE_TYPE, true);*/
        if(resp != null) {
            logger.error("同步原合同附件到记录单据失败，失败原因：{}", JSONObject.toJSONString(resp));
        }
        /**复制合同表数据到记录表 end */

        /**更新变更表主表数据到原合同 begin */
        logger.info("更新变更数据到主合同表,contractVO---------------->: {}", JSONObject.toJSONString(contractVO));
        TemporaryContractEntity contractEntity = BeanMapper.map(contractVO, TemporaryContractEntity.class);
        //基本信息
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setPartyId(changeEntity.getPartyId());
        contractEntity.setPartyName(changeEntity.getPartyName());
        contractEntity.setPartyPhone(changeEntity.getPartyPhone());
        contractEntity.setPartyHandleUser(changeEntity.getPartyHandleUser());
        contractEntity.setPartyHandleUserName(changeEntity.getPartyHandleUserName());
        contractEntity.setPartyUser(changeEntity.getPartyUser());
        contractEntity.setPartyUserName(changeEntity.getPartyUserName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSupplierHandleUser(changeEntity.getSupplierHandleUser());
        contractEntity.setSupplierHandleUserName(changeEntity.getSupplierHandleUserName());
        contractEntity.setSupplierPhone(changeEntity.getSupplierPhone());
        contractEntity.setSupplementCode(changeEntity.getSupplementCode());

        contractEntity.setSignedDate(changeEntity.getSignedDate());
        //contractEntity.setSignPlace(changeEntity.getSignPlace());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setDraftType(changeEntity.getDraftType());
        contractEntity.setContractFile(changeEntity.getContractFile());
        contractEntity.setContractFileId(changeEntity.getContractFileId());
       /* contractEntity.setContractTemplateId(changeEntity.getContractTemplateId());
        contractEntity.setContractTemplateName(changeEntity.getContractTemplateName());
        contractEntity.setContractFileVersionId(changeEntity.getContractFileVersionId());
        contractEntity.setContractFileVersion(changeEntity.getContractFileVersion());*/
        contractEntity.setProjectAddress(changeEntity.getProjectAddress());
        contractEntity.setSupplierAddress(changeEntity.getSupplierAddress());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTax(changeEntity.getContractTax());

		/*
			起草方式为线下签订，则变更合同为已签章，直接生效。主合同状态改为已变更
			起草方式为线上起草、上传合同，则主合同状态改为变更单据已生效
		 */
        contractEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
        //清空变更单信息
        contractEntity.setChangingMny(null);
        contractEntity.setChangingTaxMny(null);

        logger.info("1212-进入变更终审审核完回调------>合同提交，线下签订直接修改签章状态");
        //设置变更合同生效状态
        changeEntity.setChangeContractSignatureStatus(Integer.valueOf(SignatureStatusEnum.已签章.getCode()));
        changeEntity.setSignatureState(SignatureStatusEnum.已签章.getCode());
        changeEntity.setContractPerformanceState(ContractPerformanceStateEnum.履约中.getStateCode());
        //合同已生效，添加生效时间
        changeEntity.setEffectiveDate(new Date());

        //同步变更单附件（不包含变更变更附件）到原合同
        /*resp = copyFile(changeBillId.toString(), billTypeCode, contractEntity.getId().toString(), contractBillTypeResp.getData().getBillCode(), "subChangeContractFile", false);
        if(resp != null) {
            logger.error("同步变更附件到原合同失败，失败原因：{}", JSONObject.toJSONString(resp));
        }*/


        //变更单更新
        changeService.saveOrUpdate(changeEntity,false);
        logger.info("更新变更表合同状态和数据,changeEntity---------->： {}", JSONObject.toJSONString(changeEntity));

        /**更新变更子表数据到原合同子表 begin */
        logger.info("更新变更表数据到主合同开始----------->" + contractEntity.getChangeStatus());
        TemporaryContractEntity contractChangeEntity = BeanMapper.map(changeEntity, TemporaryContractEntity.class);
        List<TemporaryEquipmentChangeEntity> equipmentDetailedList = changeEntity.getTemporaryEquipmentDetailedList();
        Map<Long,Long> changDayIdMap = new HashMap<>();
		/*
			变更详情表和合同详情表有一个字段不一样
			变更详情表里 来源子表主键 srcTblId
			合同详情表里 变更子表主键 changeBid
		 */
        if (CollectionUtils.isNotEmpty(equipmentDetailedList)){
            equipmentDetailedList.forEach(changEuipmentDetailed -> {
                //设置id和来源子表主键对应map
                changDayIdMap.put(changEuipmentDetailed.getId(), changEuipmentDetailed.getSrcTblId());
            });
        }

        List<TemporaryEquipmentDetailedEntity> contractDayList = contractChangeEntity.getTemporaryEquipmentDetailedList();
        if(CollectionUtils.isNotEmpty(contractDayList)){
            Long contractBid = null;
            for(TemporaryEquipmentDetailedEntity contractDetailEntity : contractDayList) {
                contractBid = changDayIdMap.get(contractDetailEntity.getId());

                contractDetailEntity.setPid(changeEntity.getContractId());
                //设置变更子表主键
                contractDetailEntity.setChangeBid(contractDetailEntity.getId());

                //合同子表对应变更子表主键
                contractDetailEntity.setId(contractBid);
                contractDetailEntity.setVersion(contIdVersionMap.get(contractBid));
                //contractDetailEntity.setChangeType(null);
            }
        }

        contractEntity.setTemporaryEquipmentDetailedList(contractDayList);

        //月租明细
        List<TemporaryChangeOtherEntity> changeOtherList = changeEntity.getTemporaryOtherList();
        Map<Long,Long> changOtherIdMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(changeOtherList)){
            changeOtherList.forEach(changeOtherCostEntity -> {
                //设置id和来源子表主键对应map
                changOtherIdMap.put(changeOtherCostEntity.getId(), changeOtherCostEntity.getSrcTblId());
            });
        }
        List<TemporaryOtherEntity> contractOtherList = contractChangeEntity.getTemporaryOtherList();
        if(CollectionUtils.isNotEmpty(contractOtherList)){
            Long contractBid = null;
            for(TemporaryOtherEntity contractOtherCostEntity : contractOtherList) {
                contractBid = changOtherIdMap.get(contractOtherCostEntity.getId());
                //设置变更子表主键
                contractOtherCostEntity.setChangeBid(contractOtherCostEntity.getId());
                //合同子表对应变更子表主键
                contractOtherCostEntity.setId(contractBid);
                contractOtherCostEntity.setVersion(contIdVersionMap.get(contractBid));
                contractOtherCostEntity.setPid(contractEntity.getId());
            }
        }
        contractEntity.setTemporaryOtherList(contractOtherList);


        //先删除合同条款表
        List<TemporaryClauseEntity> contractClauseList = contractEntity.getTemporaryClauseList();
        List<TemporaryClauseEntity> contractChangeClauseList = contractChangeEntity.getTemporaryClauseList();
        if(CollectionUtils.isNotEmpty(contractClauseList)){
            logger.info("删除合同条款子表数据: {}", JSONObject.toJSONString(contractClauseList));
            contractClauseService.deleteByIds(contractClauseList.stream().map(TemporaryClauseEntity::getId).collect(Collectors.toList()));

            contractChangeClauseList.forEach(clauseEntity -> {
                clauseEntity.setChangeBid(clauseEntity.getId());
                clauseEntity.setId(null);
                clauseEntity.setRowState("add");
                clauseEntity.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setTemporaryClauseList(contractChangeClauseList);

        //合同付款阶段
        List<TemporaryPaymentClauseEntity> contractPayList = contractEntity.getTemporaryPaymentClauseList();
        List<TemporaryPaymentClauseEntity> pList = contractChangeEntity.getTemporaryPaymentClauseList();
        if(CollectionUtils.isNotEmpty(contractPayList)){
            logger.info("删除合同付款阶段子表数据: {}", JSONObject.toJSONString(contractPayList));
            contractPaymentService.deleteByIds(contractPayList.stream().map(TemporaryPaymentClauseEntity::getId).collect(Collectors.toList()));

            pList.forEach(item -> {
                item.setChangeBid(item.getId());
                item.setId(null);
                item.setRowState("add");
                item.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setTemporaryPaymentClauseList(pList);

        contractService.saveOrUpdate(contractEntity, false);
        logger.info("更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));

        /**更新变更子表数据到原合同子表 end */
        return CommonResponse.success("变更单生效，回写合同成功！");
    }

    @Override
    public CommonResponse<String> deleteById(Long id) {
        TemporaryContractChangeEntity entity = super.selectById(id);
        //合同变更只有详情页有删除
        TemporaryContractEntity contractEntity = contractService.selectById(entity.getContractId());

        QueryWrapper<TemporaryContractChangeEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractEntity.getId());
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.ne("id", id);
        int count = super.count(query);

        contractEntity.setChangeVersion(contractEntity.getChangeVersion()!= null?contractEntity.getChangeVersion()-1:0);
        contractEntity.setChangeStatus(count > 0 ? ChangeStatusEnum.已变更.getCode() : ChangeStatusEnum.未变更.getCode());
        //修改变更中金额
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        contractEntity.setChangeCode(null);
        contractEntity.setChangeId(null);
        contractEntity.setChangeDate(null);
        contractEntity.setChangeDraftType(null);
        contractEntity.setChangeContractSignatureStatus(null);
        contractEntity.setChangeFile(null);
        //contractEntity.setChangeContractName(null);
        contractService.update(contractEntity, new QueryWrapper<TemporaryContractEntity>().eq("id",contractEntity.getId()),false);
        super.removeById(id,false);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public void queryBpm(Long billId) {

        TemporaryContractEntity contractEntity = contractService.selectById(billId);
        if (contractEntity != null){

            if((DraftTypeEnum.线下签订.getCode().toString()).equals(contractEntity.getDraftType())) {
                //线下签订合同无需进行签章操作，则审批通过后直接置为已生效状态
                logger.info("合同id-{}为线下签订直接修改为签章状态并设置为履约中", billId);
                contractEntity.setSignatureState(SignatureStatusEnum.已签章.getCode());
                contractEntity.setContractPerformanceState(ContractPerformanceStateEnum.履约中.getStateCode());
                //合同已生效，添加生效时间
                contractEntity.setEffectiveDate(new Date());
            } else if(null == contractEntity.getContractFileId()) {
                //确保线上起草方式时，用户已编辑合同文件
            }
        }
        //直审时添加单据提交人等信息
        contractEntity.setCommitDate(new Date());
        contractEntity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
        contractEntity.setCommitUserName(sessionManager.getUserContext().getUserName());
        contractService.saveOrUpdate(contractEntity);
    }

}
