package com.ejianc.business.temporary.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.rent.enums.SignatureStatusEnum;
import com.ejianc.business.temporary.contract.bean.TemporaryContractChangeEntity;
import com.ejianc.business.temporary.contract.bean.TemporaryContractEntity;
import com.ejianc.business.temporary.contract.service.ITemporaryContractChangeService;
import com.ejianc.business.temporary.contract.service.ITemporaryContractService;
import com.ejianc.business.temporary.contract.service.ITemporarySignatureService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service("temporarySignatureService")
public class TemporarySignatureServiceImpl implements ITemporarySignatureService {
    @Autowired
    private ITemporaryContractService contractService;

    @Autowired
    private ITemporaryContractChangeService changeService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAttachmentApi attachmentApi;

//    @Value("${temporaryContract.mainContract}")
    private String mainContarct;

//    @Value("${temporaryContract.changeContract}")
    private String changeContract;


    /**
     * 签章流程
     * 单据签章状态修改逻辑
     * 1.主合同若签章状态为已签章，则修改主合同签章状态和合同状态以及生效时间，否则只修改签章状态
     * 2.变更合同
     *      若签章状态为已签章则将变更信息回写主合同，生成变更记录，改变变更合同签章状态
     *      否则改变变更合同签章状态，修改主合同的变更合同签章状态
     * @param id
     * @param signatureStatus
     * @param
     * @return
     */
    public CommonResponse<String> changeStatus(Long id, int signatureStatus, String refCode) {
        logger.info("进入签章状态修改流程------------->{}",refCode);
        if (mainContarct.equals(refCode)) {//主合同
            TemporaryContractEntity contractEntity = contractService.selectById(id);
            if (contractEntity != null) {
                if (signatureStatus == Integer.valueOf(SignatureStatusEnum.已签章.getCode())) {
                    contractEntity.setSignatureState(SignatureStatusEnum.已签章.getCode());
                    contractEntity.setContractPerformanceState(ContractPerformanceStateEnum.履约中.getStateCode());
                    contractEntity.setEffectiveDate(new Date());
                } else {
                    contractEntity.setSignatureState(String.valueOf(signatureStatus));
                }
                contractService.saveOrUpdate(contractEntity, false);
                logger.info("主合同签章状态已修改---------------->");
            } else {
                return CommonResponse.error("找不到合同，请检查合同主键！");
            }
        } else if (changeContract.equals(refCode)) {//变更合同
            TemporaryContractChangeEntity changeEntity = changeService.selectById(id);
            if (changeEntity != null) {
                if (signatureStatus == Integer.valueOf(SignatureStatusEnum.已签章.getCode())) {
                    return changeService.effectiveSaveWriteContract(id, changeEntity.getCode(), false);
                }else {
                    changeEntity.setSignatureState(String.valueOf(signatureStatus));
                    changeService.saveOrUpdate(changeEntity);
                    logger.info("变更合同签章状态已修改---------------->");
                    //回写主合同（变更合同签章状态，主合同变更状态）
                    LambdaUpdateWrapper<TemporaryContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.eq(TemporaryContractEntity::getId, changeEntity.getContractId());
                    updateWrapper.set(TemporaryContractEntity::getChangeContractSignatureStatus, Integer.valueOf(changeEntity.getSignatureState()));
                    contractService.update(contractService.selectById(changeEntity.getContractId()), updateWrapper, false);
                    logger.info("签章状态为已签章，回写主合同签章状态---------------->");
                }
            }else {
                return CommonResponse.error("找不到合同，请检查合同主键！");
            }
        }else {
            return CommonResponse.error("请检查refCode值是否正确！");
        }
        return CommonResponse.success("签章状态修改成功！");
    }
}
