package com.ejianc.business.temporary.settlement.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.profinance.odd.vo.OddAllocationDetailVO;
import com.ejianc.business.promaterial.settlement.api.IProMaterialSettleApi;
import com.ejianc.business.promaterial.settlement.vo.SettlementFeeVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.business.temporary.contract.bean.TemporaryContractEntity;
import com.ejianc.business.temporary.contract.service.ITemporaryContractService;
import com.ejianc.business.temporary.contract.vo.TemporaryContractVO;
import com.ejianc.business.temporary.settlement.bean.TemporarySettlementDetailEntity;
import com.ejianc.business.temporary.settlement.bean.TemporarySettlementFeeEntity;
import com.ejianc.business.temporary.settlement.service.ITemporarySettlementDetailService;
import com.ejianc.business.temporary.settlement.vo.*;
import com.ejianc.business.temporary.userecord.bean.TemporaryUseRecordEntity;
import com.ejianc.business.temporary.userecord.service.ITemporaryUseRecordSubService;
import com.ejianc.business.temporary.userecord.vo.TemporaryUseRecordVO;
import com.ejianc.business.userecord.vo.SupUseRecordSubVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.temporary.settlement.mapper.TemporarySettlementMapper;
import com.ejianc.business.temporary.settlement.bean.TemporarySettlementEntity;
import com.ejianc.business.temporary.settlement.service.ITemporarySettlementService;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 临时设备结算主表
 *
 * @author generator
 *
 */
@Service("temporarySettlementService")
public class TemporarySettlementServiceImpl extends BaseServiceImpl<TemporarySettlementMapper, TemporarySettlementEntity> implements ITemporarySettlementService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICostDetailApi costDetailApi;

    private static final String BILL_CODE = "TP_EQUIPMENT_SETTLE";//此处需要根据实际修改
    private static final String BILL_TYPE = "EJCBT202204000005";//

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ITemporaryUseRecordSubService temporaryUseRecordSubService;//临时设备记录子表
    @Autowired
    private ITemporarySettlementDetailService detailService;//明细

    @Autowired
    private ITemporaryContractService temporaryContractService;//临时设备合同

    @Autowired
    private ISettlePoolApi settlePoolApi;

    @Autowired
    private JedisPool jedisPool;
    private final String  OPERATE= "TEMPORARY_SETTLE";
    //TODO  待修改
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/temporarySettlement/saveTemporarySettlement";
    private final String DELPUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/temporarySettlement/deleteTemporarySettlement";
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IProMaterialSettleApi proMaterialSettleApi;
    @Autowired
    private IProincomeContractApi proincomeContrantApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Value("${common.env.base-host}")
    private String BaseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;


    //参数控制编码
    private static final String CHECK_MNY_CODE = "P-pK8E6C0137";//单次临时设备租赁结算金额控制
    private static final String CHECK_MNY_SUP_CODE = "P-70aP6H0138";//单个供应商临时设备租赁结算金额控制
    private static final String CHECK_MNY_CON_CODE = "P-9236fn0143";//【施工合同金额】控【无合同结算、零星机械金额】

    private String getBaseHost(){
        return StringUtils.isNotBlank(BASE_HOST_FRONTEND) && !("null").equals(BASE_HOST_FRONTEND) ? BASE_HOST_FRONTEND : BaseHost;
    }

    @Override
    public TemporarySettlementVO saveOrUpdate(TemporarySettlementVO saveOrUpdateVO) {
        TemporarySettlementEntity entity = BeanMapper.map(saveOrUpdateVO, TemporarySettlementEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            if (entity.getContractId()!=null && this.queryExist(entity.getContractId())){
                throw new BusinessException("该合同下有未生效的结算单！");
            }
            //关联初始化
            entity.setProportionFlag("0");
            entity.setRelationFlag("0");
            //保存初始化签章，签字状态
            entity.setSignStatus(0);
            entity.setSignatureStatus(0);
        }
        List<TemporarySettlementDetailEntity> detailList = entity.getTemporarySettlementDetailList();
        List<TemporarySettlementDetailEntity> detailListAdd = new ArrayList<>();//新增
        List<TemporarySettlementDetailEntity> detailListDel = new ArrayList<>();//删除
        if(CollectionUtils.isNotEmpty(detailList)){
            for (TemporarySettlementDetailEntity detailEntity : detailList) {
                if(detailEntity.getId()==null){//新增
                    detailListAdd.add(detailEntity);
                }else if("del".equals(detailEntity.getRowState())){//删除
                    detailListDel.add(detailEntity);
                }
            }
        }
        updateSettle(detailListAdd,1);//新增
        updateSettle(detailListDel,0);//删除
        super.saveOrUpdate(entity, false);
        // 推送 实际成本
        saveCost(entity,0);
        TemporarySettlementVO vo = BeanMapper.map(entity, TemporarySettlementVO.class);
        this.pushSettleToCost(vo);
        return vo;
    }
/*删除*/
    @Override
    public void delete(List<TemporarySettlementVO> vos) {
        List<Long> ids = vos.stream().map(TemporarySettlementVO::getId).collect(Collectors.toList());
        List<TemporarySettlementEntity> temporarySettlementEntities = this.list(new QueryWrapper<TemporarySettlementEntity>().in("id",ids));
        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
        for (TemporarySettlementEntity entity : temporarySettlementEntities) {
            TemporarySettlementVO temporarySettlementVO = BeanMapper.map(this.selectById(entity.getId()), TemporarySettlementVO.class);
            ExecutionVO executionVO = this.settleCost(temporarySettlementVO,"");
            totalExecutionVOList.add(executionVO.getTotalVO());
            logger.info("目标成本删除数据" + JSON.toJSONString(executionVO));
            //删除实际成本
            CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(entity.getId());
            logger.info("删除实际成本结果"+ JSONObject.toJSONString(stringCommonResponse));
            if(!stringCommonResponse.isSuccess()){
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
        if (ListUtil.isNotEmpty(totalExecutionVOList)) {
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            logger.info("目标成本删除数据结果---:{}", JSONObject.toJSONString(response));
            if (!response.isSuccess()){
                throw new BusinessException("目标成本删除失败,"+response.getMsg());
            }
        }
        if(CollectionUtils.isNotEmpty(ids)){
            LambdaQueryWrapper<TemporarySettlementDetailEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.in(TemporarySettlementDetailEntity::getSettlementId,ids);
            wrapper.eq(TemporarySettlementDetailEntity::getDr,0);
            List<TemporarySettlementDetailEntity> detailList = detailService.list(wrapper);
            updateSettle(detailList,0);
        }

        super.removeByIds(vos.stream().map(TemporarySettlementVO::getId).collect(Collectors.toList()),true);
    }

    /*是否有为生效的结算单*/
    public boolean queryExist(Long contractId){
        LambdaQueryWrapper<TemporarySettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(TemporarySettlementEntity::getContractId, contractId);
        wrapper.notIn(TemporarySettlementEntity::getBillState, 1,3);//未生效条件
        List<TemporarySettlementEntity> list = super.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){//有数据表示有未生效的结算单
            return true;
        }
        return false;
    }
    //新增修改---改变结算状态
    public void updateSettle(List<TemporarySettlementDetailEntity> list,Integer settleFlag){
        if(CollectionUtils.isNotEmpty(list)){
            ArrayList<Long> recordIds = new ArrayList<>();//记录子表id集合
            ArrayList<Long> controllerIds = new ArrayList<>();//合同子表id集合
            for (TemporarySettlementDetailEntity detailEntity : list) {
                switch (detailEntity.getSourceType()){//来源类型（0-记录，1-合同）
                    case 0: recordIds.add(detailEntity.getSourceDetailId());break;
                    case 1: controllerIds.add(detailEntity.getSourceDetailId());break;
                }
            }
            temporaryUseRecordSubService.updateSettleFlag(recordIds,settleFlag);//settleFlag 是否被结算(0-否，1-是)
        }
    }

    /*获取最近一次含本期结算金额和结算日期 结算次数*/
    @Override
    public CommonResponse<Map> getDateMny(Long contractId) {
        Map<String, Object> map = new HashMap<>();
        BigDecimal currentTaxMny = BigDecimal.ZERO; // 结算金额
        BigDecimal currentMny = BigDecimal.ZERO; // 结算金额(无税)
        String sTDate  = null;
        LambdaQueryWrapper<TemporarySettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.orderByDesc(TemporarySettlementEntity::getCreateTime);
        wrapper.in(TemporarySettlementEntity::getBillState, 1,3);//防止修改时获取本单据的数据
        wrapper.eq(TemporarySettlementEntity::getDr, 0);
        wrapper.eq(TemporarySettlementEntity::getContractId, contractId);
        List<TemporarySettlementEntity> list = super.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            sTDate = DateFormatUtil.formatDate("yyyy-MM-dd", list.get(0).getSettlementDate());
            currentTaxMny = list.stream().filter(e -> null != e.getSettlementTaxMny()).map(TemporarySettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentMny = list.stream().filter(e -> null != e.getSettlementMny()).map(TemporarySettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        map.put("currentTaxMny",currentTaxMny);
        map.put("currentMny",currentMny);
        map.put("sTDate",sTDate);
        map.put("settlementNum",list.size());
        return CommonResponse.success("获取金额和时间成功！",map);
    }


    /*提交推送结算池*/
    @Override
    public boolean pushSettleToPool(TemporarySettlementVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始-----"+ JSONObject.toJSONString(vo));
            // 对象自动转换
            BeanConvertorUtil.convert(vo, spv);
            logger.info("结算单对象 -> 结算池对象自动转换结束，下面开始手动转换");

            // 个别字段需要手动封装
            convertSettleVOToSettlePoolVO(vo, spv);
            if(vo.getContractId()==null){
                spv.setBillCodeUrl("/ejc-proequipment-frontend/#/temporarySettleList/temporarySettleNoCard?id=" + vo.getId());
            }else {
                //TODO  有合同地址待修改
                spv.setBillCodeUrl("/ejc-proequipment-frontend/#/temporarySettleList/temporarySettleNoCard?id=" + vo.getId());
            }
            logger.info("推送参数----"+JSONObject.toJSONString(spv));
            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(spv);
            logger.info("结算单推送结算池结束---"+JSONObject.toJSONString(res));
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单推送结算池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送结算池失败！结算单id-{}，{}",vo.getId(), res.getMsg());
                throw new BusinessException("结算单弃审推送结算池失败!");
            }
        } catch (Exception e) {
            logger.error("结算单推送结算池失败！结算单id-{}", vo.getId(), e);
            throw new BusinessException("结算单推送结算池异常!");
        }
        return flag;
    }

    /*弃审删除结算池*/
// 从结算池中删除数据
    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            logger.info("结算单弃审推送结算池开始,结算单id-{}",id);
            CommonResponse<SettlePoolVO> res = settlePoolApi.deleteSettle(spv);
            logger.info("结算单推送结算池结束---"+JSONObject.toJSONString(res));
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单弃审推送结算池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送结算池失败！结算单id-{}，{}",id, res.getMsg());
                throw new BusinessException("结算单弃审推送结算池失败!");
            }
        }catch (Exception e){
            logger.error("结算单弃审推送结算池失败！结算单id-{}", id, e);
            throw new BusinessException("结算单弃审推送结算池异常!");
        }
        return flag;
    }


    // 将TemporarySettlementVO转换成settlePoolVO
    private void convertSettleVOToSettlePoolVO(TemporarySettlementVO vo, SettlePoolVO spv) {
        if (null == vo || null == spv) {
            logger.error("将结算单推送至结算池失败！原因：结算单对象为空或结算池对象为空，结算单对象 -> 结算池对象无法转换！");
            return;
        }
        logger.info("结算单对象 -> 结算池对象手动转换开始");
        //单据类似  单据状态
        spv.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        spv.setId(vo.getId());
        spv.setSourceType(SettleSourceTypeEnum.临时设备结算.getCode());
        spv.setSettlePropertyName("支出");
        spv.setSettleProperty(0);//属性类别，0支出，1收入
        spv.setSourceId(vo.getId());//结算单id
        spv.setHandleType(0);
        spv.setCreateUserCode(vo.getCreateUserCode());//结算创建者账号
        spv.setCreateTime(vo.getCreateTime());//结算创建时间
        spv.setUpdateUserCode(vo.getUpdateUserCode());//结算修改者账号
        spv.setUpdateTime(vo.getUpdateTime());//结算修改时间
        spv.setContractFlag(0);// 是否有合同：1-是，0-否
        if(vo.getContractId()!=null){//有合同需要推送的字段
            spv.setContractFlag(1);// 是否有合同：1-是，0-否
            //查询合同
            TemporaryContractEntity contractEntity = temporaryContractService.selectById(vo.getContractId());
            spv.setContractType(ContractTypeEnum.临时设备.getTypeCode());
            spv.setSupplementFlag(contractEntity.getSupplementFlag());//是否补充写协议
            spv.setMaiContractId(contractEntity.getMainContractId());//原合同id
            spv.setMaiContractName(contractEntity.getMainContractName());//原合同name
            spv.setMaiContractCode(contractEntity.getMainContractCode());//原合同code
            spv.setContractCode(contractEntity.getCode());//合同编码
            spv.setPartyaId(contractEntity.getPartyId());//甲方id
            spv.setPartyaName(contractEntity.getPartyName());//甲方name
            spv.setSignDate(contractEntity.getSignedDate());//签订日期
            spv.setLastTaxMny(ComputeUtil.safeSub(vo.getCurrentSettlementTaxMny(),vo.getSettlementTaxMny()));//截止本期已结算金额（含税，不含本期）
            spv.setLastMny(ComputeUtil.safeSub(vo.getCurrentSettlementMny(),vo.getSettlementMny()));//截止本期已结算金额(无税，不含本期)
            spv.setLastTax(ComputeUtil.safeSub(spv.getLastTaxMny(),spv.getLastMny()));//截止本期税额（不含本期）
        }
        logger.info("结算单对象 -> 结算池对象手动转换完成，下面开始推送至结算池");
    }
    /**
     * 计算差值
     * @param a 变量a
     * @param b 变量b
     * @return 差值的绝对值，当其中一个变量为null时 或 计算出来的差值为null时 返回null
     */
    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }
    /**
     * 转换目标成本VO
     * @param entity
     * @return
     */
    @Override
    public ExecutionVO targetCost(TemporarySettlementEntity entity) {
        // 查询结算单
        LambdaQueryWrapper<TemporarySettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(TemporarySettlementEntity::getContractId, entity.getContractId());
        wrapper.in(TemporarySettlementEntity::getBillState, Arrays.asList(1,3));
        List<TemporarySettlementEntity> list = this.list(wrapper);
        // 计算所有结算累计结算金额
        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(TemporarySettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettlementMny() != null).map(TemporarySettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 查询合同

        TemporaryContractEntity contractEntity = temporaryContractService.getById(entity.getContractId());

        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getBillCode());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.临时设备租赁合同.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        totalVO.setMoney(ComputeUtil.safeSub(totalSettleMny, contractEntity.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub(totalSettleTaxMny, contractEntity.getContractTaxMny()));
        totalVO.setLinkUrl(getBaseHost() + "ejc-proequipment-frontend/#/temporarySettleList/temporarySettleNoCard?id=" + entity.getId());
        executionVO.setTotalVO(totalVO);
        return executionVO;

    }
    //关联保存
    @Override
    public CommonResponse<TemporarySettlementVO> pushCost(TemporarySettlementVO temporarySettlementVO) {
        TemporarySettlementEntity entity = baseMapper.selectById(temporarySettlementVO.getId());
        if (CollectionUtils.isNotEmpty(temporarySettlementVO.getTemporarySettlementDetailList())) {
            List<TemporarySettlementDetailEntity> detailEntityList = BeanMapper.mapList(temporarySettlementVO.getTemporarySettlementDetailList(), TemporarySettlementDetailEntity.class);
            entity.setTemporarySettlementDetailList(detailEntityList);
        }
        if (CollectionUtils.isNotEmpty(temporarySettlementVO.getTemporarySettlementFeeList())) {
            List<TemporarySettlementFeeEntity> feeEntityList = BeanMapper.mapList(temporarySettlementVO.getTemporarySettlementFeeList(), TemporarySettlementFeeEntity.class);
            entity.setTemporarySettlementFeeList(feeEntityList);
        }
        super.saveOrUpdate(entity, false);
        //推送数据
        this.costPush(entity);
        return CommonResponse.success(BeanMapper.map(entity, TemporarySettlementVO.class));
    }
    @Override
    public void costPush(TemporarySettlementEntity temporarySettlementEntity) {
        logger.info("开始costPush");
        List<TemporarySettlementDetailEntity> detailList = temporarySettlementEntity.getTemporarySettlementDetailList();
        List<TemporarySettlementFeeEntity> feeList = temporarySettlementEntity.getTemporarySettlementFeeList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
            for (TemporarySettlementDetailEntity detailEntity : detailList) {
                if (null == detailEntity.getSubjectId() || null == detailEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeList)) {
            for (TemporarySettlementFeeEntity feeEntity : feeList) {
                if (null == feeEntity.getSubjectId() || null == feeEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(detailList) && ListUtil.isEmpty(feeList)) {
            newRelationFlag = "0";
        }
        //判断之前的单据是否关联
        String oldRelationFlag = temporarySettlementEntity.getRelationFlag();
        //先删后增
        saveCost(temporarySettlementEntity,1);//生效状态 0-未生效，1-生效
        //更新是否关联
        temporarySettlementEntity.setRelationFlag(newRelationFlag);
        LambdaUpdateWrapper<TemporarySettlementEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(TemporarySettlementEntity::getId, temporarySettlementEntity.getId());
        updateWrapper.set(TemporarySettlementEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);
    }

    private void saveCost(TemporarySettlementEntity temporarySettlementEntity,Integer effectiveStatus) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<TemporarySettlementDetailEntity> detailList = temporarySettlementEntity.getTemporarySettlementDetailList();
        List<TemporarySettlementFeeEntity> feeList = temporarySettlementEntity.getTemporarySettlementFeeList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
            for (TemporarySettlementDetailEntity detailEntity : detailList) {
                CostDetailVO costDetailVO = BeanMapper.map(detailEntity, CostDetailVO.class);
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getTaxMny());
                costDetailVO.setHappenMny(detailEntity.getMny());
                costDetailVO.setSourceTabType("TEMP_EQ_JS_DETAIL");
                costDetailVO.setProjectId(temporarySettlementEntity.getProjectId());
                costDetailVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeList)) {
            for (TemporarySettlementFeeEntity FeeEntity : feeList) {
                CostDetailVO costDetailVO = BeanMapper.map(FeeEntity, CostDetailVO.class);
                costDetailVO.setSourceDetailId(FeeEntity.getId());
                costDetailVO.setHappenTaxMny(FeeEntity.getFeeTaxMny());
                costDetailVO.setHappenMny(FeeEntity.getFeeMny());
                costDetailVO.setSourceTabType("TEMP_EQ_JS_FEE");
                costDetailVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(costDetailVOList)) {
            for (CostDetailVO costDetailVO : costDetailVOList) {
                costDetailVO.setSourceBillCode(temporarySettlementEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.临时机械设备结算单.getTypeName());
                costDetailVO.setSourceBillUrl(getBaseHost() + "ejc-proequipment-frontend/#/temporarySettleList/temporarySettleNoCard?id=" + temporarySettlementEntity.getId());
                costDetailVO.setSourceId(temporarySettlementEntity.getId());
                costDetailVO.setHappenDate(temporarySettlementEntity.getSettlementDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setId(null);
                costDetailVO.setSourceType("TEMP_EQ_JS");
                costDetailVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                costDetailVO.setProjectId(temporarySettlementEntity.getProjectId());
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
    @Override
    public boolean pushBillToSupCenter(TemporarySettlementEntity entity, String billTypeCode) {
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送计量单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        entity.setSystemId(ejcCloudSystemCode.getData());

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            SupTemporarySettlementVO supVO = BeanMapper.map(entity, SupTemporarySettlementVO.class);
            List<SupTemporarySettlementDetailVO> supDetailVOS = BeanMapper.mapList(entity.getTemporarySettlementDetailList(), SupTemporarySettlementDetailVO.class);
            List<SupTemporarySettlementFeeVO> supFeeVOS = BeanMapper.mapList(entity.getTemporarySettlementFeeList(), SupTemporarySettlementFeeVO.class);
            supVO.setTemporarySettlementDetailList(supDetailVOS);
            supVO.setTemporarySettlementFeeList(supFeeVOS);
            paramMap.put("transData", JSONObject.toJSONString(supVO));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(entity.getId(), billTypeCode, "projectMangerSign", null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
                List<Long> fileIds = new ArrayList<>();
                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                //当前单据携带有附件信息
                if (CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                logger.info("向供应商-{}推送附件参数-{}", entity.getSupplierId(), JSONObject.toJSONString(files));
                logger.info("向供应商-{}推送计量单据参数-{}", entity.getSupplierId(), JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        entity.getSupplierId().toString(),
                        files);
//                syncFlag = CommonUtils.checkCommonResponse(syncReqResp, logger);
                if (syncReqResp.isSuccess()) {
                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        logger.error("供方id-{}处理推送单据id-{}失败, {}", entity.getSupplierId(), entity.getId(), billPushResp.getMsg());
                    }
                } else {
                    logger.error("发送请求推送单据id-{}给供方id-{}失败, {}", entity.getId(), entity.getSupplierId(), syncReqResp.getMsg());
                }
            } else {
                logger.error("获取单据id-{}对应附件信息失败, {}", entity.getId(), fileResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("推送单据id-{}给供方id-{} 异常，", entity.getId(), entity.getSupplierId(), e);
//            throw e;
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }

    /*
     * 撤回推送供方
     *  */
    @Override
    public CommonResponse<String> updatePushBill(TemporarySettlementEntity entity, String billTypeCode) {
        boolean locked = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();
        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return CommonResponse.error("推送供方异常!");
        }
        //设置当前系统ID
        entity.setSystemId(ejcCloudSystemCode.getData());
        entity.setSignStatus(0);
        baseMapper.updateById(entity);
        logger.info("修改签字信息：{}", JSONObject.toJSONString(entity));
        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return CommonResponse.error("单据作废失败，单据锁获取失败!");
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("id", entity.getId().toString());
            paramMap.put("systemId", entity.getSystemId());
            logger.info("单据id-{}弃审，通知供方-{}单据作废!", entity.getSupplierId(), entity.getId());
            //推送单据到指定的供方
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(DELPUSH_BILL_SERVER_URL,
                    RequestMethod.POST,
                    JSONObject.toJSONString(paramMap),
                    entity.getSupplierId().toString());

            if (syncReqResp.isSuccess()) {
                CommonResponse<String> supHandleResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    return supHandleResp;
                } else {
                    logger.error("供方-{}处理作废单据id-{}作废失败, {}", entity.getSupplierId(), entity.getId(), supHandleResp.getMsg());
                    throw new BusinessException(supHandleResp.getMsg());
                }
            } else {
                logger.error("发送请求通知供方-{} 单据id-{}作废失败, {}", entity.getSupplierId(), entity.getId(), syncReqResp.getMsg());
                throw new BusinessException(syncReqResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("通知供方单据id-{}作废异常，", entity.getId(), e);
            throw new BusinessException("推送供方异常!");
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
    }
    /*供方签字确认*/
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;

        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        TemporarySettlementEntity entity = super.selectById(billId);
        //设置供方签字信息
        entity.setSupOperateTime(supOperateTime);
        entity.setSupOperatorName(supOperatorName);
        entity.setSupOperatorPhone(supOperatorPhone);
        entity.setSupOperatorUserCode(supOperatorUserCode);

        String key = BILL_TYPE + "::" + entity.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据id-{}签字信息回写加锁失败！", entity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字信息回写加锁失败";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, BILL_TYPE, authority, entity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            entity.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态 签字状态：0-未签字 1-已签字
            entity.setSignStatus(1);
            //更新单据
            super.saveOrUpdate(entity, false);

//            //向单据制单人和经办人推送该消息
//            String msgSendResult = sendMsg(checkEntity, "供方已签字提醒", "结算单据[" + settleEntity.getBillCode() + "]供方已签字完成");
//            if (null != msgSendResult) {
//                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(settleEntity.getCreateUserId(), settleEntity.getEmployeeId()),
//                        settleEntity.getId(), msgSendResult);
//            }

        } catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", entity.getId(), e);
            msg = "单据签字信息回写失败！";
            throw e;
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        TemporarySettlementEntity entity = selectById(id);
        // 最终结算推送目标成本
        if (entity.getSettlementType()!=null&&entity.getSettlementType()==1){
            logger.info("推送目标成本开始");
            CommonResponse<String> response = executionApi.aggPush(targetCost(entity));
            logger.info("推送目标成本入参：" + JSONObject.toJSONString(targetCost(entity)));
            if (!response.isSuccess()){
                logger.error("推送目标成本失败: , {}", response.getMsg());
                throw new BusinessException(response.getMsg());
            }
        }
        return CommonResponse.success("目标成本推送成功");
    }

    //单据参数控制
    @Override
    public ParamsCheckVO checkParams(TemporarySettlementVO vo){
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*参数控制区域*/
        if(CollectionUtils.isNotEmpty(this.checkParamsMny(vo))){//单次临时租赁结算金额控制*/
            paramsCheckVOS.addAll(this.checkParamsMny(vo));
        }
        if(CollectionUtils.isNotEmpty(this.checkParamsSupplierMny(vo))){//单个供应商临时租赁结算金额控制*/
            paramsCheckVOS.addAll(this.checkParamsSupplierMny(vo));
        }
        if(CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))){//【施工合同金额】控【无合同结算、零星机械金额】*/
            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));
        }
        /*--end---参数控制区域*/

        /*--start---目标成本控制*/
        if (null == vo.getId()) {
            vo.setId(IdWorker.getId());
        }
        List<TemporarySettlementDetailVO> temporarySettlementDetailList = vo.getTemporarySettlementDetailList();
        List<TemporarySettlementDetailVO> temporarySettlementDetailListNew = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(temporarySettlementDetailList)) {
            for (TemporarySettlementDetailVO detailVO : temporarySettlementDetailList) {
                if (detailVO.getId() == null) {
                    detailVO.setId(IdWorker.getId());
                    detailVO.setSettlementId(vo.getId());
                }
                if (!"del".equals(detailVO.getRowState())) {
                    temporarySettlementDetailListNew.add(detailVO);
                }
            }
            vo.setTemporarySettlementDetailList(temporarySettlementDetailListNew);
        }
        String linkUrl = getBaseHost() + "ejc-proequipment-frontend/#/temporarySettlement/settlementNoCard?id=" + vo.getId();
        ExecutionVO executionVO = this.settleCost(vo,linkUrl);
        logger.error("目标成本控制推送传参：" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("目标成本控制失败," + response.getMsg());
        }
        ParamsCheckVO tarRes = response.getData();
        if(null!=tarRes){
            paramsCheckVOS.add(tarRes);
        }
        /*--end---目标成本控制*/

        /*--start---成本科目控制*/
        CostCtrlVO costCtrlVO = this.sjCost(vo);
        if(null!=costCtrlVO){
            CommonResponse<ParamsCheckVO> costResponse = executionApi.ctrlCost(costCtrlVO);
            if (!costResponse.isSuccess()) {
                throw new BusinessException("成本科目控制失败," + costResponse.getMsg());
            }
            ParamsCheckVO costRes = costResponse.getData();
            if(null!=costRes){
                paramsCheckVOS.add(costRes);
            }
        }
        /*--end---成本科目控制*/

        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
    public CostCtrlVO sjCost(TemporarySettlementVO vo){
        List<TemporarySettlementDetailVO> detailList = vo.getTemporarySettlementDetailList();
        List<TemporarySettlementFeeVO> feeList = vo.getTemporarySettlementFeeList();
        Map<Long,CostCtrlDetailVO> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(detailList)){
            for(TemporarySettlementDetailVO detailVO:detailList){
                if(null!=detailVO.getSubjectId() && !"del".equals(detailVO.getRowState())) {
                    BigDecimal mny = detailVO.getMny()==null?BigDecimal.ZERO:detailVO.getMny();
                    BigDecimal taxMny = detailVO.getTaxMny()==null?BigDecimal.ZERO:detailVO.getTaxMny();
                    if(map.containsKey(detailVO.getSubjectId())){
                        CostCtrlDetailVO costCtrlDetailVO = map.get(detailVO.getSubjectId());
                        costCtrlDetailVO.setMny(ComputeUtil.safeAdd(costCtrlDetailVO.getMny(),mny));
                        costCtrlDetailVO.setTaxMny(ComputeUtil.safeAdd(costCtrlDetailVO.getTaxMny(),taxMny));
                    }else{
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(detailVO.getSubjectId());
                        costCtrlDetailVO.setMny(mny);
                        costCtrlDetailVO.setTaxMny(taxMny);
                        map.put(detailVO.getSubjectId(), costCtrlDetailVO);
                    }
                }
            }
        }
        if(CollectionUtils.isNotEmpty(feeList)){
            for(TemporarySettlementFeeVO feeVO:feeList){
                if(null!=feeVO.getSubjectId() && !"del".equals(feeVO.getRowState())) {
                    BigDecimal mny = feeVO.getFeeMny()==null?BigDecimal.ZERO:feeVO.getFeeMny();
                    BigDecimal taxMny = feeVO.getFeeTaxMny()==null?BigDecimal.ZERO:feeVO.getFeeTaxMny();
                    if(map.containsKey(feeVO.getSubjectId())){
                        CostCtrlDetailVO costCtrlDetailVO = map.get(feeVO.getSubjectId());
                        costCtrlDetailVO.setMny(ComputeUtil.safeAdd(costCtrlDetailVO.getMny(),mny));
                        costCtrlDetailVO.setTaxMny(ComputeUtil.safeAdd(costCtrlDetailVO.getTaxMny(),taxMny));
                    }else{
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(feeVO.getSubjectId());
                        costCtrlDetailVO.setMny(mny);
                        costCtrlDetailVO.setTaxMny(taxMny);
                        map.put(feeVO.getSubjectId(), costCtrlDetailVO);
                    }
                }
            }
        }
        if( null != map && !map.isEmpty()){
            CostCtrlVO ctrlVO = new CostCtrlVO();
            if (vo.getId() != null) {
                ctrlVO.setSourceId(vo.getId());
            }
            ctrlVO.setOrgId(vo.getOrgId());
            ctrlVO.setProjectId(vo.getProjectId());
            ctrlVO.setDetailList(new ArrayList<>(map.values()));
            return ctrlVO;
        }else{
            return null;
        }
    }

    /*
     * 单次临时租赁结算金额控制*/
    @Override
    public  List<ParamsCheckVO> checkParamsMny(TemporarySettlementVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("单次临时租赁结算金额控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    BigDecimal mny = null==vo.getSettlementTaxMny()?BigDecimal.ZERO:vo.getSettlementTaxMny();//本次结算金额
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (mny.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("本次结算金额超过限定金额");
                        paramsCheckDsVO.setWarnName("单次临时设备结算金额超限定金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次结算金额：").append(mny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，限定金额：").append(roleValue.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(mny, roleValue).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }
    /*
     * 单个供应商临时租赁结算金额控制*/
    @Override
    public  List<ParamsCheckVO> checkParamsSupplierMny(TemporarySettlementVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        BigDecimal mny = null==vo.getSettlementTaxMny()?BigDecimal.ZERO:vo.getSettlementTaxMny();//本次结算金额
        LambdaQueryWrapper<TemporarySettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(TemporarySettlementEntity::getSupplierId, vo.getSupplierId());
        wrapper.eq(TemporarySettlementEntity::getProjectId, vo.getProjectId());
        if(null!=vo.getId()){
            wrapper.ne(TemporarySettlementEntity::getId, vo.getId());
        }
        List<TemporarySettlementEntity> list = super.list(wrapper);
        //根据供应商和项目汇总所有金额
        BigDecimal totalMny = list.stream().filter(e -> null!=e.getSettlementTaxMny()).map(TemporarySettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        totalMny = ComputeUtil.safeAdd(totalMny,mny);//相加本次
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_SUP_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("单个供应商临时租赁结算金额控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值

                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("供应商零星机械费用超过限定金额");
                        paramsCheckDsVO.setWarnName("供应商零星机械费用超过限定金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次金额：").append(mny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计金额：").append(totalMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，限定金额：").append(roleValue.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalMny, roleValue).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVOList;
    }

    /*
     * 【施工合同金额】控【无合同结算、零星机械金额】*/
    @Override
    public List<ParamsCheckVO> checkParamsConstruction(TemporarySettlementVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        BigDecimal contractTaxMny = BigDecimal.ZERO;//施工合同金额
        BigDecimal mny = null==vo.getSettlementTaxMny()?BigDecimal.ZERO:vo.getSettlementTaxMny();//本次结算金额
        BigDecimal totalMny = mny;//无合同结算金额+临时设备金额   默认赋值本次结算金额
        //根据项目查询该项目下所有状态的 临时设备结算金额累计
        LambdaQueryWrapper<TemporarySettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(TemporarySettlementEntity::getProjectId, vo.getProjectId());
        if(null!=vo.getId()){
            wrapper.ne(TemporarySettlementEntity::getId, vo.getId());
        }
        List<TemporarySettlementEntity> list = super.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            BigDecimal totalSettleMny = list.stream().filter(e -> null!=e.getSettlementTaxMny()).map(TemporarySettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalMny = ComputeUtil.safeAdd(totalMny,totalSettleMny);//累加临时设备结算金额
        }
        //根据项目查询该项目下所有状态的【无合同材料结算+无合同混凝土结算】
        CommonResponse<JSONObject> response = proMaterialSettleApi.querySettleMnyProjectId(vo.getProjectId());
        logger.info("该项目：{}-下所有状态的【无合同材料结算+无合同混凝土结算】金额结果:{}",vo.getProjectId(),JSONObject.toJSONString(response));
        if(response.isSuccess() && null!=response.getData()){
            BigDecimal settleTaxMny = response.getData().getBigDecimal("settleTaxMny");
            totalMny = ComputeUtil.safeAdd(totalMny,settleTaxMny);//累加 无合同材料结算+无合同混凝土结算金额
        }
        //根据项目查询施工合同金额
        CommonResponse<ContractRegisterVO> commonResponse = proincomeContrantApi.queryContranctMny(vo.getProjectId());
        logger.info("该项目:{}-下生效的最新正式施工合同:{}",vo.getProjectId(),JSONObject.toJSONString(commonResponse));
        if(commonResponse.isSuccess() && null!=commonResponse.getData()){
           contractTaxMny = null==commonResponse.getData().getContractTaxMny() ? BigDecimal.ZERO : commonResponse.getData().getContractTaxMny();
        }
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CON_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("【施工合同金额】控【无合同结算、零星机械金额】信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    //施工合同百分比 后的金额
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100"));
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("无合同结算、临机费用超施工合同额");
                        paramsCheckDsVO.setWarnName("无合同结算、临机费用累计金额超施工合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次金额：").append(mny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次零材、零机发生金额：").append(totalMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalMny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVOList;
    }

    @Override
    public CommonResponse<String> pushSettleToCost(TemporarySettlementVO temporarySettlementVO) {
        TemporarySettlementEntity temporarySettlementEntity = selectById(temporarySettlementVO.getId());
        TemporarySettlementVO vo = BeanMapper.map(temporarySettlementEntity, TemporarySettlementVO.class);
        String linkUrl = getBaseHost() + "ejc-proequipment-frontend/#/temporarySettlement/settlementNoCard?id=" + vo.getId();
        ExecutionVO executionVO = this.settleCost(vo,linkUrl);
        logger.info("手动推送 临时设备结算目标成本推送数据" + JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        logger.info("手动推送 临时设备结算目标成本推送结果---:{}", JSONObject.toJSONString(response));
        return response;
    }
    @Override
    public ExecutionVO settleCost(TemporarySettlementVO temporarySettlementVO, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();

        totalVO.setSourceId(temporarySettlementVO.getId());
        totalVO.setTenantId(temporarySettlementVO.getTenantId());
        totalVO.setBillCode(temporarySettlementVO.getBillCode());
        totalVO.setOrgId(temporarySettlementVO.getOrgId());
        totalVO.setProjectId(temporarySettlementVO.getProjectId());
        totalVO.setContractId(temporarySettlementVO.getContractId());
        totalVO.setBillDate(DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE,temporarySettlementVO.getSettlementDate()));
        totalVO.setMoney(temporarySettlementVO.getSettlementMny());
        totalVO.setTaxMoney(temporarySettlementVO.getSettlementTaxMny());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setBussinessType(BussinessTypeEnum.临时设备租赁结算单.getCode());
        totalVO.setBillCategory(BillCategoryEnum.结算.getCode());

        List<TemporarySettlementDetailVO> detailVOList = temporarySettlementVO.getTemporarySettlementDetailList();
        if (CollectionUtils.isNotEmpty(detailVOList)) {
            for (TemporarySettlementDetailVO detailVO : detailVOList) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(detailVO.getId() == null ? IdWorker.getId() : detailVO.getId());
                detailExecutionVO.setSourceBillId(detailVO.getSettlementId());
                detailExecutionVO.setContractId(temporarySettlementVO.getContractId());
                detailExecutionVO.setContractDetailId(detailVO.getId());
                detailExecutionVO.setCategoryId(detailVO.getEquipmentTypeId());
                CommonResponse<MaterialCategoryVO> categoryResp = materialApi.queryCategoryById(detailVO.getEquipmentTypeId());
                detailExecutionVO.setCategoryCode(categoryResp.getData().getCode());
                detailExecutionVO.setCategoryName(detailVO.getEquipmentTypeName());
                detailExecutionVO.setCategoryFlag(false);
                detailExecutionVO.setDocId(detailVO.getEquipmentId());
                detailExecutionVO.setCode(detailVO.getEquipmentCode());
                detailExecutionVO.setName(detailVO.getEquipmentName());
                detailExecutionVO.setUnitId(detailVO.getUnitId());
                detailExecutionVO.setUnitName(detailVO.getUnit());
                detailExecutionVO.setNum(detailVO.getNum());
                detailExecutionVO.setMoney(detailVO.getMny());
                detailExecutionVO.setTaxMoney(detailVO.getTaxMny());
                detailExecutionVO.setCategoryContainFlag(false);
                detailList.add(detailExecutionVO);
            }
        }

        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }


}
