package com.ejianc.business.temporary.userecord.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.temporary.userecord.bean.TemporaryUseRecordSubEntity;
/**
 * 临时设备使用记录表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipment_temporary_use_record")
public class TemporaryUseRecordEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_org")
    private String projectOrg; // 所属单位
    @TableField(value="project_org_id")
    private Long projectOrgId; // 所属单位id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="start_date")
    private Date startDate; // 开始日期
    @TableField(value="end_date")
    private Date endDate; // 结束日期
    @TableField(value="use_mny")
    private BigDecimal useMny; // 使用金额
    @TableField(value="employee")
    private String employee; // 经办人
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="no_contract")
    private Boolean noContract; // 有无合同

    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部ID
    @TableField(value="project_department_name")
    private String projectDepartmentName; // 项目部名称
    //----移动端提交审批流必须字段
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="not_signature")
    private Integer notSignature;//是否签字(1-是 0-否)
//----
    @TableField(value="bill_push_flag")
    private String billPushFlag; // 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    @TableField(value="sup_operator_user_code")
    private String supOperatorUserCode; //
    @TableField(value="sup_operator_phone")
    private String supOperatorPhone; //
    @TableField(value="sup_operator_name")
    private String supOperatorName; //
    @TableField(value="sup_operate_time")
    private Date supOperateTime; //
    @TableField(exist = false)
    private String systemId;
    @TableField(value="party_id")
    private Long partyId; // 甲方id
    @TableField(value="party_name")
    private String partyName; // 甲方
    @TableField(value="apply_id")
    private Long applyId; // 使用申请id

    
    @TableField(exist=false)
    @SubEntity(serviceName="temporaryUseRecordSubService")
    private List<TemporaryUseRecordSubEntity> temporaryUseRecordSubList = new ArrayList<>(); // 临时设备使用记录-设备明细

    public Long getApplyId() {
        return applyId;
    }

    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }

    public Long getPartyId() {
        return partyId;
    }

    public void setPartyId(Long partyId) {
        this.partyId = partyId;
    }

    public String getPartyName() {
        return partyName;
    }

    public void setPartyName(String partyName) {
        this.partyName = partyName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getNotSignature() {
        return notSignature;
    }

    public void setNotSignature(Integer notSignature) {
        this.notSignature = notSignature;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectOrg() {
        return projectOrg;
    }

    public void setProjectOrg(String projectOrg) {
        this.projectOrg = projectOrg;
    }
    public Long getProjectOrgId() {
        return projectOrgId;
    }

    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public BigDecimal getUseMny() {
        return useMny;
    }

    public void setUseMny(BigDecimal useMny) {
        this.useMny = useMny;
    }

    public String getEmployee() {
        return employee;
    }

    public void setEmployee(String employee) {
        this.employee = employee;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getProjectDepartmentName() {
        return projectDepartmentName;
    }

    public void setProjectDepartmentName(String projectDepartmentName) {
        this.projectDepartmentName = projectDepartmentName;
    }

    public Boolean getNoContract() {
        return noContract;
    }

    public void setNoContract(Boolean noContract) {
        this.noContract = noContract;
    }

    public List<TemporaryUseRecordSubEntity> getTemporaryUseRecordSubList() {
        return temporaryUseRecordSubList;
    }

    public void setTemporaryUseRecordSubList(List<TemporaryUseRecordSubEntity> temporaryUseRecordSubList) {
        this.temporaryUseRecordSubList = temporaryUseRecordSubList;
    }
}
