package com.ejianc.business.temporary.userecord.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.additional.update.impl.UpdateChainWrapper;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.temporary.useapply.bean.TemporaryUseApplyEntity;
import com.ejianc.business.temporary.useapply.service.ITemporaryUseApplyService;
import com.ejianc.business.temporary.userecord.bean.TemporaryUseRecordSubEntity;
import com.ejianc.business.temporary.userecord.service.ITemporaryUseRecordSubService;
import com.ejianc.business.temporary.userecord.vo.TemporaryUseRecordSubVO;
import com.ejianc.business.userecord.bean.UseRecordEntity;
import com.ejianc.business.userecord.vo.UseRecordVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.temporary.userecord.bean.TemporaryUseRecordEntity;
import com.ejianc.business.temporary.userecord.service.ITemporaryUseRecordService;
import com.ejianc.business.temporary.userecord.vo.TemporaryUseRecordVO;

/**
 * 临时设备使用记录表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("temporaryUseRecord")
public class TemporaryUseRecordController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "LS_RECORD";//此处需要根据实际修改

    @Autowired
    private ITemporaryUseRecordService service;
    @Autowired
    private ITemporaryUseApplyService temporaryUseApplyService;

    @Autowired
    private IRentContractService rentContractService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ITemporaryUseRecordSubService temporaryUseRecordSubService;
    @Autowired
    private IShareCooperateApi shareCooperateApi;

    @Autowired
    private IProSupplierApi proSupplierApi;
    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proEquipments/temporaryUseRecord/card";

    private final String billTypeCode = "BT220302000000007";


    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }
    @ApiOperation("获取协同链接")
    @RequestMapping(value = "/getBillShareLink", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        TemporaryUseRecordEntity entity = service.selectById(id);

        CommonResponse<Boolean> supplierResp = proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            logger.error("根据供应商主键-{}查询失败，{}", entity.getSupplierId(), supplierResp.getMsg());
            return CommonResponse.error("单据获取供方信息失败，生成分享连接失败！");
        }
        Boolean flag = supplierResp.getData();
        if(!flag){
            return CommonResponse.error("该供应商未开通协同权限，无法协同分享。");
        }
        if(BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", billTypeCode, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            } else {
                //未曾成功推送单据，则先向供方推送单据
                boolean pushResult = service.pushBillToSupCenter(entity,billTypeCode);
                logger.info("获取推送供方结果--"+pushResult);
                if(!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                } else {
                    entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(entity, false);
                }
            }
        }
        return shareCooperateApi.getShareLink(id, billTypeCode, entity.getSupplierId().toString(), mobileBillShareFrontUrl,null);

    }
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TemporaryUseRecordVO> saveOrUpdate(@RequestBody TemporaryUseRecordVO saveOrUpdateVO) {
    	TemporaryUseRecordEntity entity = BeanMapper.map(saveOrUpdateVO, TemporaryUseRecordEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //初始化状态
        entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        entity.setNotSignature(0);
        if(CollectionUtils.isNotEmpty(entity.getTemporaryUseRecordSubList())){//初始化子表结算状态
            for (TemporaryUseRecordSubEntity subEntity : entity.getTemporaryUseRecordSubList()) {
                subEntity.setSettleFlag(0);
            }
        }
        if(null!=entity.getApplyId()){//来源申请，回显引用状态
            LambdaUpdateWrapper<TemporaryUseApplyEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(TemporaryUseApplyEntity::getId, entity.getApplyId());
            wrapper.set(TemporaryUseApplyEntity::getRecordFlag, 1);
            temporaryUseApplyService.update(wrapper);
        }
        service.saveOrUpdate(entity, false);
    	TemporaryUseRecordVO vo = BeanMapper.map(entity, TemporaryUseRecordVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TemporaryUseRecordVO> queryDetail(Long id) {
    	TemporaryUseRecordEntity entity = service.selectById(id);
    	TemporaryUseRecordVO vo = BeanMapper.map(entity, TemporaryUseRecordVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TemporaryUseRecordVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (TemporaryUseRecordVO vo : vos) {
                TemporaryUseRecordEntity temporaryUseRecordEntity = service.selectById(vo.getId());
                if(null!=temporaryUseRecordEntity.getApplyId()){//来源申请，回显引用状态
                    LambdaUpdateWrapper<TemporaryUseApplyEntity> wrapper = new LambdaUpdateWrapper<>();
                    wrapper.eq(TemporaryUseApplyEntity::getId, temporaryUseRecordEntity.getApplyId());
                    wrapper.set(TemporaryUseApplyEntity::getRecordFlag, 2);
                    temporaryUseApplyService.update(wrapper);
                }
            }
        }
        service.removeByIds(vos.stream().map(TemporaryUseRecordVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TemporaryUseRecordVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("projectOrg");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("employee");
        param.getFuzzyFields().add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("create_time", QueryParam.DESC);
        param.setOrderMap(orderMap);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")){//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("projectOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }

        IPage<TemporaryUseRecordEntity> page = service.queryPage(param,false);
        IPage<TemporaryUseRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TemporaryUseRecordVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("projectOrg");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("employee");
        param.getFuzzyFields().add("supplierName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("projectDepartmentId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TemporaryUseRecordEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<TemporaryUseRecordVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (TemporaryUseRecordEntity temporaryUseRecordEntity : list) {
                TemporaryUseRecordVO temporaryUseRecordVO = BeanMapper.map(temporaryUseRecordEntity, TemporaryUseRecordVO.class);
                temporaryUseRecordVO.setBillStateName(BillStateEnum.getEnumByStateCode(temporaryUseRecordVO.getBillState()).getDescription());
                voList.add(temporaryUseRecordVO);
            }
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("TemporaryUseRecord-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refTemporaryUseRecordData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TemporaryUseRecordVO>> refTemporaryUseRecordData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("supplierName");
        /** 租户隔离 */
        BigDecimal taxRate = null;
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            Map<String,Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                RentContractEntity rentContractEntity = rentContractService.selectById(contractId);
                if(null!=rentContractEntity){
                    taxRate =rentContractEntity.getContractTax();
                }
                param.getParams().put("contractId", new Parameter(QueryParam.SQL, "contract_id ="+contractId));
            }else {
                param.getParams().put("contractId", new Parameter(QueryParam.SQL, "contract_id is null"));
            }
            if (null != conditionMap.get("supplierId")) {
                Long supplierId = Long.valueOf(conditionMap.get("supplierId").toString());
                param.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierId));
            }
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("settlementDate")) {
                String settlementDate = conditionMap.get("settlementDate").toString();
                param.getParams().put("endDate", new Parameter(QueryParam.SQL, "end_date <="+'"'+settlementDate+'"'));
            }
        }
        IPage<TemporaryUseRecordVO> page = service.queryData(param);
//        IPage<TemporaryUseRecordEntity> page = service.queryPage(param,false);
        IPage<TemporaryUseRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<TemporaryUseRecordVO> vos = BeanMapper.mapList(page.getRecords(), TemporaryUseRecordVO.class);
        if(CollectionUtils.isNotEmpty(vos)){
            for (TemporaryUseRecordVO vo : vos) {
                if(null==taxRate){
                    vo.setUseMnyNoTax(vo.getUseMny());
                }else {
                    BigDecimal noTaxMny = ComputeUtil.safeDiv(vo.getUseMny(),ComputeUtil.safeAdd(ComputeUtil.safeDiv(taxRate, BigDecimal.valueOf(100)), BigDecimal.valueOf(1)));
                    vo.setUseMnyNoTax(noTaxMny);
                    vo.setUseTax(ComputeUtil.safeSub(vo.getUseMny(), noTaxMny));
                    vo.setUseTaxRate(taxRate);
                }
                LambdaQueryWrapper<TemporaryUseRecordSubEntity> lambd = new LambdaQueryWrapper<>();
                lambd.eq(TemporaryUseRecordSubEntity::getDr, 0);
                lambd.ne(TemporaryUseRecordSubEntity::getSettleFlag, 1);
                lambd.eq(TemporaryUseRecordSubEntity::getPid, vo.getId());
                List<TemporaryUseRecordSubEntity> list = temporaryUseRecordSubService.list(lambd);
                List<TemporaryUseRecordSubVO> temporaryUseRecordSubVOS = BeanMapper.mapList(list, TemporaryUseRecordSubVO.class);
                vo.setTemporaryUseRecordSubList(temporaryUseRecordSubVOS);
            }
        }
        pageData.setRecords(vos);
        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * 单据管控-
     * @return
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody TemporaryUseRecordVO vo) {
        return CommonResponse.success("参数校验成功！", service.checkParams(vo));
    }
}
