package com.ejianc.business.ac.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.ac.bean.ContractEntity;
import com.ejianc.business.ac.enums.PerformanceStatusEnum;
import com.ejianc.business.ac.enums.SignatureStatusEnum;
import com.ejianc.business.ac.service.IContractService;
import com.ejianc.business.ac.vo.ContractRelieveVO;
import com.ejianc.business.ac.vo.ContractVO;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.ac.mapper.ContractRelieveMapper;
import com.ejianc.business.ac.bean.ContractRelieveEntity;
import com.ejianc.business.ac.service.IContractRelieveService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 安拆合同解除实体
 * 
 * @author generator
 * 
 */
@Service("contractRelieveService")
public class ContractRelieveServiceImpl extends BaseServiceImpl<ContractRelieveMapper, ContractRelieveEntity> implements IContractRelieveService{

    @Autowired
    private IContractRelieveService service;

    @Autowired
    private ISettleService settleService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IExecutionApi executionApi;
    @Value("${common.env.base-host}")
    private String BaseHost;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    /**
     * 根据合同编号查询是否可以新增合同解除单据
     *
     * @param contractId 合同id
     * @return Boolean 是否可以新增
     */
    @Override
    public Boolean isCanRelieve(Long contractId) {
        // 添加校验
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
        List<ContractRelieveEntity> list = service.queryList(param);
        return list.isEmpty();
    }

    @Override
    public ExecutionVO targetCost( ContractRelieveVO contractRelieveVO, String linkUrl, Integer contractType){
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(contractRelieveVO.getId());
        totalVO.setTenantId(contractRelieveVO.getTenantId());
        totalVO.setBillCode(contractRelieveVO.getBillCode());
        totalVO.setOrgId(contractRelieveVO.getOrgId());
        totalVO.setBillType("EJCBT202204000013");
//        totalVO.setBussinessType(BussinessTypeEnum.大型设备安拆合同 .getCode());
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        if (contractRelieveVO.getProjectId()==null){
            throw new BusinessException("策划成本推送失败,请更换项目");
        }else {
            totalVO.setProjectId(contractRelieveVO.getProjectId());
        }
        if (contractRelieveVO.getOrgId()==null){
            throw new BusinessException("策划成本推送失败,请更换项目");
        }else {
            totalVO.setOrgId(contractRelieveVO.getOrgId());
        }
        ContractEntity contractEntity = contractService.selectById(contractRelieveVO.getContractId());
        LambdaQueryWrapper<SettleEntity> query = new LambdaQueryWrapper<>();
        query.eq(SettleEntity::getContractId, contractEntity.getId());
        query.in(SettleEntity::getBillState, 1,3);
        query.eq(SettleEntity::getDr,0);
        query.eq(SettleEntity::getSettleType,0);
        List<SettleEntity> entity = settleService.list(query); // 过程结算
        BigDecimal sumMny = BigDecimal.ZERO;//本期结算金额(无税)
        BigDecimal sumTaxMny = BigDecimal.ZERO;//本期结算金额
        for (SettleEntity monthVo : entity){
            sumMny = ComputeUtil.safeAdd(sumMny, monthVo.getMny());
            sumTaxMny = ComputeUtil.safeAdd(sumTaxMny, monthVo.getTaxMny());
        }
        totalVO.setMoney(ComputeUtil.safeSub(sumMny,contractEntity.getContractMny())); //总计划金额无税
        totalVO.setTaxMoney(ComputeUtil.safeSub(sumTaxMny,contractEntity.getContractTaxMny())); //总计划金额
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    /**
     * 更新合同解除单据签章状态和合同状态
     *
     * @param billId  合同解除单据id
     * @param status  签章状态
     * @param refCode 唯一标识
     * @return 结果数据
     */
    @Override
    public CommonResponse<String> relieveContract(String billId, String status, String refCode) {
        logger.info("更新合同解除单据签章状态和合同状态，入参：id:{}，signatureStatus：{}，refCode：{}", billId, status, refCode);
        Long id = Long.valueOf(billId);
        ContractRelieveEntity entity = super.selectById(id);
//        entity.setSignatureStatus(status);
        logger.info("解除单据{}",JSONObject.toJSONString(entity));
        if (entity != null) {
            // 已签章
            if (status.equals(SignatureStatusEnum.已签章.getCode()) && entity.getDraftType()==2) {
                entity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
                entity.setPerformanceStatus(Integer.valueOf(PerformanceStatusEnum.已作废.getCode()));
                entity.setEffectiveDate(new Date());
                service.saveOrUpdate(entity, false);
                QueryParam param = new QueryParam();
                param.getParams().put("id", new Parameter(QueryParam.EQ, entity.getContractId()));
                List<ContractEntity> contractEntities = contractService.queryList(param, false);
                contractEntities.get(0).setPerformanceStatus(PerformanceStatusEnum.已作废.getCode());
                logger.info("======终审审核完回调,已签章======,{}", JSONObject.toJSONString(contractEntities.get(0)));
                contractService.saveOrUpdate(contractEntities.get(0), false);
                // 推送合同池
                logger.info("推送合同池，入参：{}",JSONObject.toJSONString(contractEntities.get(0)));
                contractService.pushContract(BeanMapper.map(contractEntities.get(0), ContractVO.class));
            } else if (entity.getDraftType() == 1) {
                // 初始化成未签章
                entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
                logger.info("======终审审核完回调,初始化成未签章======,{}", JSONObject.toJSONString(entity));
                service.saveOrUpdate(entity, false);
            }
        }else {
            throw new BusinessException("查询解除单失败！");
        }
//        //策划成本推送
//        String linkUrl;
//        ContractEntity contractEntity = contractService.selectById(entity.getContractId());
//        linkUrl = BaseHost+"ejc-proequipment-frontend/#/contractRelieve/card?id="+entity.getId();
//        ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, ContractRelieveVO.class),linkUrl,contractEntity.getContractType());
//        logger.info("策划成本推送数据"+ JSON.toJSONString(executionVO));
//        CommonResponse<String> response = executionApi.aggPush(executionVO);
//        if (!response.isSuccess()){
//            throw new BusinessException("策划成本推送失败,"+response.getMsg());
//        }
        logger.info("合同已解除！");
        return CommonResponse.success("合同解除单据签章状态更新成功！");
    }
}
