package com.ejianc.business.rent.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 租金计算月租明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipment_rent_rental_month")
public class RentRentalMonthEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="quuipment_name")
    private String equipmentName; // 设备名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="month_factory_code")
    private String monthFactoryCode; // 设备出厂编号
    @TableField(value="category_id")
    private Long categoryId; // 设备类别id
    @TableField(value="category_name")
    private String categoryName; // 设备类别名称
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="unit_name")
    private String unitName; // 单位
    @TableField(value="month_rent_price")
    private BigDecimal monthRentPrice; // 月租单价
    @TableField(value="insufficient_month_day_rent_price")
    private BigDecimal insufficientMonthDayRentPrice; // 不足月日租单价
    @TableField(value="stop_rent_price")
    private BigDecimal stopRentPrice; // 停租单价
    @TableField(value="rent_num")
    private Integer rentNum; // 租赁数量
    @TableField(value="tax")
    private BigDecimal tax; // 税率
    @TableField(value="month_rent_not_tax_price")
    private BigDecimal monthRentNotTaxPrice; // 月租单价无税
    @TableField(value="insufficient_month_not_tax_rent_price")
    private BigDecimal insufficientMonthNotTaxRentPrice; // 不足月日租单价(无税)
    @TableField(value="plan_into_date")
    private Date planIntoDate; // 计划进程日期
    @TableField(value="plan_out_date")
    private Date planOutDate; // 计划出场日期
    @TableField(value="production_manufactor")
    private String productionManufactor; // 生产厂家
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="rental_id")
    private Long rentalId; // 主表id
    @TableField(value="equipment_code")
    private String equipmentCode; // 设备编号
    @TableField(value="equipment_id")
    private Long equipmentId; // 设备id
    @TableField(value="day_tax_price")
    private BigDecimal dayTaxPrice; // 含税日租单价
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 
    @TableField(value="not_tax_month_price")
    private BigDecimal notTaxMonthPrice; // 
    @TableField(value="day_rent_not_tax_price")
    private BigDecimal dayRentNotTaxPrice; // 无税日租单价
    @TableField(value="not_tax_stop_price")
    private BigDecimal notTaxStopPrice; // 无税停租单价
    @TableField(value="source_id")
    private Long sourceId; // 来源id
    @TableField(value="rent_month_mny")
    private BigDecimal rentMonthMny; // 租赁金额(无税)
    @TableField(value="rent_month_tax_mny")
    private BigDecimal rentMonthTaxMny; // 租赁金额
    @TableField(value="rent_month_tax")
    private BigDecimal rentMonthTax; // 租赁税额
    @TableField(value="charging_start_date")
    private Date chargingStartDate; // 计费开始日期
    @TableField(value="charging_end_date")
    private Date chargingEndDate; // 计费结束日期
    @TableField(value="source_detail_id")
    private Long sourceDetailId; // 来源明细主键ID
    @TableField(value="source_name")
    private String sourceName; // 来源类型名称(记录—100231)
    @TableField(value="source_type")
    private Integer sourceType; // 来源类型
    @TableField(value="source_code")
    private String sourceCode; // 来源编码

    @TableField(value="wbs_id")
    private Long wbsId; // 核算对象主键
    @TableField(value="wbs_code")
    private String wbsCode; // 核算对象编码
    @TableField(value="wbs_name")
    private String wbsName; // 核算对象名称
    @TableField(value="subject_id")
    private Long subjectId; // 成本科目主键
    @TableField(value="subject_code")
    private String subjectCode; // 成本科目编码
    @TableField(value="subject_name")
    private String subjectName; // 成本科目名称

    @TableField(value="equipment_state")
    private Integer equipmentState;
    @TableField(value="rent_day_date")
    private Integer rentDayDate;
    @TableField(value="rent_month_date")
    private Integer rentMonthDate;

    public Integer getEquipmentState() {
        return equipmentState;
    }

    public void setEquipmentState(Integer equipmentState) {
        this.equipmentState = equipmentState;
    }

    public Integer getRentDayDate() {
        return rentDayDate;
    }

    public void setRentDayDate(Integer rentDayDate) {
        this.rentDayDate = rentDayDate;
    }

    public Integer getRentMonthDate() {
        return rentMonthDate;
    }

    public void setRentMonthDate(Integer rentMonthDate) {
        this.rentMonthDate = rentMonthDate;
    }

    public Long getWbsId() {
        return wbsId;
    }

    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getEquipmentName() {
        return equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMonthFactoryCode() {
        return monthFactoryCode;
    }

    public void setMonthFactoryCode(String monthFactoryCode) {
        this.monthFactoryCode = monthFactoryCode;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getMonthRentPrice() {
        return monthRentPrice;
    }

    public void setMonthRentPrice(BigDecimal monthRentPrice) {
        this.monthRentPrice = monthRentPrice;
    }
    public BigDecimal getInsufficientMonthDayRentPrice() {
        return insufficientMonthDayRentPrice;
    }

    public void setInsufficientMonthDayRentPrice(BigDecimal insufficientMonthDayRentPrice) {
        this.insufficientMonthDayRentPrice = insufficientMonthDayRentPrice;
    }
    public BigDecimal getStopRentPrice() {
        return stopRentPrice;
    }

    public void setStopRentPrice(BigDecimal stopRentPrice) {
        this.stopRentPrice = stopRentPrice;
    }
    public Integer getRentNum() {
        return rentNum;
    }

    public void setRentNum(Integer rentNum) {
        this.rentNum = rentNum;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public BigDecimal getMonthRentNotTaxPrice() {
        return monthRentNotTaxPrice;
    }

    public void setMonthRentNotTaxPrice(BigDecimal monthRentNotTaxPrice) {
        this.monthRentNotTaxPrice = monthRentNotTaxPrice;
    }
    public BigDecimal getInsufficientMonthNotTaxRentPrice() {
        return insufficientMonthNotTaxRentPrice;
    }

    public void setInsufficientMonthNotTaxRentPrice(BigDecimal insufficientMonthNotTaxRentPrice) {
        this.insufficientMonthNotTaxRentPrice = insufficientMonthNotTaxRentPrice;
    }
    public Date getPlanIntoDate() {
        return planIntoDate;
    }

    public void setPlanIntoDate(Date planIntoDate) {
        this.planIntoDate = planIntoDate;
    }
    public Date getPlanOutDate() {
        return planOutDate;
    }

    public void setPlanOutDate(Date planOutDate) {
        this.planOutDate = planOutDate;
    }
    public String getProductionManufactor() {
        return productionManufactor;
    }

    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getRentalId() {
        return rentalId;
    }

    public void setRentalId(Long rentalId) {
        this.rentalId = rentalId;
    }
    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    public BigDecimal getDayTaxPrice() {
        return dayTaxPrice;
    }

    public void setDayTaxPrice(BigDecimal dayTaxPrice) {
        this.dayTaxPrice = dayTaxPrice;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getNotTaxMonthPrice() {
        return notTaxMonthPrice;
    }

    public void setNotTaxMonthPrice(BigDecimal notTaxMonthPrice) {
        this.notTaxMonthPrice = notTaxMonthPrice;
    }
    public BigDecimal getDayRentNotTaxPrice() {
        return dayRentNotTaxPrice;
    }

    public void setDayRentNotTaxPrice(BigDecimal dayRentNotTaxPrice) {
        this.dayRentNotTaxPrice = dayRentNotTaxPrice;
    }
    public BigDecimal getNotTaxStopPrice() {
        return notTaxStopPrice;
    }

    public void setNotTaxStopPrice(BigDecimal notTaxStopPrice) {
        this.notTaxStopPrice = notTaxStopPrice;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public BigDecimal getRentMonthMny() {
        return rentMonthMny;
    }

    public void setRentMonthMny(BigDecimal rentMonthMny) {
        this.rentMonthMny = rentMonthMny;
    }
    public BigDecimal getRentMonthTaxMny() {
        return rentMonthTaxMny;
    }

    public void setRentMonthTaxMny(BigDecimal rentMonthTaxMny) {
        this.rentMonthTaxMny = rentMonthTaxMny;
    }
    public BigDecimal getRentMonthTax() {
        return rentMonthTax;
    }

    public void setRentMonthTax(BigDecimal rentMonthTax) {
        this.rentMonthTax = rentMonthTax;
    }
    public Date getChargingStartDate() {
        return chargingStartDate;
    }

    public void setChargingStartDate(Date chargingStartDate) {
        this.chargingStartDate = chargingStartDate;
    }
    public Date getChargingEndDate() {
        return chargingEndDate;
    }

    public void setChargingEndDate(Date chargingEndDate) {
        this.chargingEndDate = chargingEndDate;
    }
    
}
