package com.ejianc.business.rent.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.rent.bean.RentTotalPlanHistorySubEntity;
/**
 * 租赁设备总计划-历史记录主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipment_rent_total_plan_history")
public class RentTotalPlanHistoryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 费用项目名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="company_id")
    private Long companyId; // 所属单位
    @TableField(value="company_name")
    private String companyName; // 所属单位名称
    @TableField(value="plan_code")
    private String planCode; // 计划编号
    @TableField(value="temporary_amount")
    private BigDecimal temporaryAmount; // 暂估金额
    @TableField(value="edition_code")
    private Integer editionCode; // 版本编号
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="organization_user_id")
    private Long organizationUserId; // 
    @TableField(value="organization_user_name")
    private String organizationUserName; // 编制人名称
    @TableField(value="organization_date")
    private Date organizationDate; // 编制日期
    @TableField(value="base_mny")
    private BigDecimal baseMny; // 初始版本金额
    @TableField(value="before_change_mny")
    private BigDecimal beforeChangeMny; // 变更前金额
    @TableField(value="changing_mny")
    private BigDecimal changingMny; // 变更中金额
    @TableField(value="change_version")
    private Integer changeVersion; // 
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="change_code")
    private String changeCode; // 变更编号
    @TableField(value="change_id")
    private Long changeId; // 变更主键id
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="change_date")
    private Date changeDate; // 变更日期
    @TableField(value="change_user_name")
    private String changeUserName; // 变更人
    @TableField(value="the_temporary_amount")
    private BigDecimal theTemporaryAmount; // 本次预估金额
    @TableField(value="the_change_amount")
    private BigDecimal theChangeAmount; // 本次变更金额
    @TableField(value="equipment_code")
    private String equipmentCode; // 设备编号
    @TableField(value="org_id")
    private Long orgId; // 
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="total_id")
    private Long totalId; // 总计划主键
    @TableField(value="org_code")
    private String orgCode; // 组织code
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="rentTotalPlanHistorySubService", pidName = "historyId")
    private List<RentTotalPlanHistorySubEntity> rentTotalPlanHistorySubList = new ArrayList<>(); // 租赁设备总计划-历史记录子表明细
    

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }
    public BigDecimal getTemporaryAmount() {
        return temporaryAmount;
    }

    public void setTemporaryAmount(BigDecimal temporaryAmount) {
        this.temporaryAmount = temporaryAmount;
    }
    public Integer getEditionCode() {
        return editionCode;
    }

    public void setEditionCode(Integer editionCode) {
        this.editionCode = editionCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getOrganizationUserId() {
        return organizationUserId;
    }

    public void setOrganizationUserId(Long organizationUserId) {
        this.organizationUserId = organizationUserId;
    }
    public String getOrganizationUserName() {
        return organizationUserName;
    }

    public void setOrganizationUserName(String organizationUserName) {
        this.organizationUserName = organizationUserName;
    }
    public Date getOrganizationDate() {
        return organizationDate;
    }

    public void setOrganizationDate(Date organizationDate) {
        this.organizationDate = organizationDate;
    }
    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public String getChangeUserName() {
        return changeUserName;
    }

    public void setChangeUserName(String changeUserName) {
        this.changeUserName = changeUserName;
    }
    public BigDecimal getTheTemporaryAmount() {
        return theTemporaryAmount;
    }

    public void setTheTemporaryAmount(BigDecimal theTemporaryAmount) {
        this.theTemporaryAmount = theTemporaryAmount;
    }
    public BigDecimal getTheChangeAmount() {
        return theChangeAmount;
    }

    public void setTheChangeAmount(BigDecimal theChangeAmount) {
        this.theChangeAmount = theChangeAmount;
    }
    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getTotalId() {
        return totalId;
    }

    public void setTotalId(Long totalId) {
        this.totalId = totalId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    

    public List<RentTotalPlanHistorySubEntity> getRentTotalPlanHistorySubList() {
        return rentTotalPlanHistorySubList;
    }

    public void setRentTotalPlanHistorySubList(List<RentTotalPlanHistorySubEntity> rentTotalPlanHistorySubList) {
        this.rentTotalPlanHistorySubList = rentTotalPlanHistorySubList;
    }
}
