package com.ejianc.business.rent.controller.api;

import com.ejianc.business.rent.service.IRentEquipmentPlanService;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/rentPlanApi/")
public class RentPlanApi {
    @Autowired
    private IRentEquipmentPlanService service;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ApiOperation("引用/释放/引用完成采购计划")
    @RequestMapping(value = "/updateBatPlanQuote", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateBatPlanQuote(@RequestParam("idList") List<String> idList,
                                                     @RequestParam("planState") Integer planState) {
        logger.info("修改采购计划【{}】状态为：[{}](计划状态（1-待采购；2-采购中；3-采购完成）)", idList == null ? null :
                idList.toString(), planState);
        service.updateBatPlanByQuoteType(idList, planState);
        return CommonResponse.success("操作成功！");
    }
}
