package com.ejianc.business.tool.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.tool.bean.ScrapEntity;
import com.ejianc.business.tool.bean.TempscrapEntity;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Map;


@Service("tempscrapContent")
public class TempscrapContentBpmServiceImpl implements ICommonBusinessService {


	private final TempscrapServiceImpl scrapService;
	private final IStoreManageApi iStoreManageApi;
	private final IBillTypeApi iBillTypeApi;
	private final TempscrapBpmServiceImpl scrap;
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	public TempscrapContentBpmServiceImpl(TempscrapServiceImpl scrapService, @Qualifier("com.ejianc.business.store.api.IStoreManageApi") IStoreManageApi iStoreManageApi, @Qualifier("com.ejianc.foundation.support.api.IBillTypeApi") IBillTypeApi iBillTypeApi, TempscrapBpmServiceImpl scrap) {
		this.scrapService = scrapService;
		this.iStoreManageApi = iStoreManageApi;
		this.iBillTypeApi = iBillTypeApi;
		this.scrap = scrap;
	}

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	;

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	;

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	}

	;

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId       //单据id
	 * @param state        //单据状态
	 * @param billTypeCode //单据类型code
	 * @param taskId       //该流程id
	 * @param isEnd        //该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
		return CommonResponse.success();
	}

	;

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		TempscrapEntity scrapEntity = scrapService.selectById(billId);
		//调用库存逻辑
		StoreManageVO storeManageVO = new StoreManageVO();
		storeManageVO.setStoreId(scrapEntity.getStoreId());
		storeManageVO.setSourceId(scrapEntity.getId());
		storeManageVO.setInOutTypeEnum(InOutTypeEnum.领料出库);
		storeManageVO.setOutEffectiveON(true);
		ArrayList<FlowVO> flowVOS = new ArrayList<>();
		scrapEntity.getDetailList().forEach(t -> {
			FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.领料出库, 0);
			flowVO.setStoreId(scrapEntity.getStoreId());
			flowVO.setStoreName(scrapEntity.getStoreName());
			flowVO.setProjectId(scrapEntity.getProjectId());
			flowVO.setProjectName(scrapEntity.getProjectName());
			flowVO.setOrgId(scrapEntity.getOrgId());
			flowVO.setOrgName(scrapEntity.getOrgName());
			flowVO.setParentOrgId(scrapEntity.getParentOrgId());
			flowVO.setParentOrgName(scrapEntity.getParentOrgName());
			flowVO.setEmployeeId(scrapEntity.getEmployeeId());
			flowVO.setEmployeeName(scrapEntity.getEmployeeName());
			flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
			flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
			flowVO.setMaterialId(t.getToolId());
			flowVO.setMaterialName(t.getToolName());
			flowVO.setMaterialSpec(t.getSpecs());
			flowVO.setMaterialUnitId(t.getUnitId());
			flowVO.setMaterialUnitName(t.getUnit());
			flowVO.setNum(t.getNum());
			flowVO.setSourceBillDetailRemark(t.getMemo());
			flowVO.setSourceId(scrapEntity.getId());
			flowVO.setSourceDetailId(t.getId());
			flowVO.setSourceBillCode(scrapEntity.getBillCode());
			flowVO.setSourceBillDate(scrapEntity.getScrapDate());
			flowVO.setSourceBillTypeCode("BT220215000000004");
			flowVO.setSourceBillTypeName("领料出库");
			flowVO.setSourceType(1);//  0-自制,1-订单
			flowVO.setRowState(t.getRowState());
			flowVO.setSourceBillRemark(scrapEntity.getMemo());
			flowVOS.add(flowVO);
		});
		logger.info("调用库存---");
		storeManageVO.setFlowVOList(flowVOS);
		CommonResponse<StoreManageVO> response = iStoreManageApi.inOutStore(storeManageVO);
		logger.info("库存结果" + JSONObject.toJSONString(response));
		if (!response.isSuccess()) {
			return CommonResponse.error("调用库存管理失败,错误信息：" + response.getMsg());
		}
		scrapService.updateById(scrapEntity);
		return CommonResponse.success("");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
			//TODO
			TempscrapEntity scrapEntity = scrapService.selectById(billId);
			if (scrapEntity.getBillState() == 1) {
				throw new BusinessException("已签字不能撤回！");
			}
			CommonResponse<String> res = iBillTypeApi.checkQuote(billTypeCode, billId);
			logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
			if (!res.isSuccess()) {
				return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
			}
			return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
