/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.rent.service.IRentTotalPlanService;
import com.ejianc.business.rent.service.IRentTotalPlanSubService;
import com.ejianc.business.rent.vo.RentChangeTotalPlanSubVO;
import com.ejianc.business.rent.vo.RentTotalPlanSubRefVO;
import com.ejianc.business.rent.vo.RentTotalPlanVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"rentTotalPlan"})
public class RentTotalPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "RENT_TOTAL_PLAN";
    @Autowired
    private IRentTotalPlanService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRentTotalPlanSubService rentTotalPlanSubService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentTotalPlanVO> saveOrUpdate(@RequestBody RentTotalPlanVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.insertOrUpdate(saveOrUpdateVO, false));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentTotalPlanVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentTotalPlanVO> vos) {
        this.service.delete(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RentTotalPlanVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("companyId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentTotalPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (list.size() > 0) {
            voList = BeanMapper.mapList((Iterable)list, RentTotalPlanVO.class);
            for (RentTotalPlanVO vo : voList) {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                if (vo.getChangeStatus().equals(1)) {
                    vo.setChangeStatusName("\u672a\u53d8\u66f4");
                    continue;
                }
                if (vo.getChangeStatus().equals(2)) {
                    vo.setChangeStatusName("\u53d8\u66f4\u4e2d");
                    continue;
                }
                if (!vo.getChangeStatus().equals(3)) continue;
                vo.setChangeStatusName("\u5df2\u53d8\u66f4");
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("rentTotalPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRentTotalPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RentTotalPlanSubRefVO>> refRentTotalPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, @RequestParam(required=false) String relyCondition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isEmpty((String)relyCondition)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u7533\u8bf7\u5355\uff01");
        }
        param.getParams().put("pid", new Parameter("eq", (Object)relyCondition.split("=")[1]));
        param.getParams().put("leafFlag", new Parameter("eq", (Object)false));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.rentTotalPlanSubService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentTotalPlanSubRefVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refRentTotalPlanSubData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RentTotalPlanSubRefVO>> refRentTotalPlanSubData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Long projectId = null;
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            projectId = _con.getLong("projectId");
        }
        List list = new ArrayList();
        if (projectId == null) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u9879\u76ee");
        }
        QueryParam params = new QueryParam();
        params.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        params.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        list = this.service.queryList(params);
        param.getParams().put("leafFlag", new Parameter("eq", (Object)false));
        param.getParams().put("pid", new Parameter("in", list.stream().map(BaseEntity::getId).collect(Collectors.toList())));
        IPage page = this.rentTotalPlanSubService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentTotalPlanSubRefVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refRentPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<RentTotalPlanVO> refRentPlanData(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        List dataList;
        List list;
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        QueryParam params = new QueryParam();
        params.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        Long projectId = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.getLong("projectId") != null) {
                projectId = _con.getLong("projectId");
            }
            params.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        if (CollectionUtil.isNotEmpty((Collection)(list = BeanMapper.mapList((Iterable)(dataList = this.service.queryList(params)), RentTotalPlanVO.class)))) {
            for (RentTotalPlanVO vo : list) {
                vo.setName(vo.getCode() + "-" + vo.getEmployeeName() + "-" + sDateFormat.format(vo.getCreateTime()));
            }
        }
        return list;
    }

    @RequestMapping(value={"/targetCostCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody RentTotalPlanVO totalPlanVO) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.targetCostCtrl(totalPlanVO));
    }

    @ApiOperation(value="\u540c\u6b65\u7b56\u5212\u6210\u672c\u63a5\u53e3")
    @RequestMapping(value={"/syncCost"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> syncCost(@RequestParam Long id) {
        this.service.syncCost(id);
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f");
    }

    @GetMapping(value={"/viewTargetCostCtrlInfo"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value="id") Long id) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.viewTargetCostCtrlInfo(id));
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public void test() {
        this.service.test();
    }

    @RequestMapping(value={"/queryChangeCompare"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<RentChangeTotalPlanSubVO>> queryChangeCompare(Long id) {
        List<RentChangeTotalPlanSubVO> list = this.service.queryChangeCompare(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", list);
    }
}

